/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.prepare.init;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.anyline.data.prepare.Condition;
import org.anyline.data.prepare.ConditionChain;
import org.anyline.data.prepare.init.AbstractCondition;
import org.anyline.data.run.RunValue;
import org.anyline.util.BasicUtil;

public abstract class AbstractConditionChain
extends AbstractCondition
implements ConditionChain {
    protected List<Condition> conditions = new ArrayList<Condition>();
    protected int joinSize;

    @Override
    public void init() {
        for (Condition condition : this.conditions) {
            if (null == condition) continue;
            condition.init();
        }
    }

    @Override
    public ConditionChain addCondition(Condition condition) {
        this.conditions.add(condition);
        return this;
    }

    protected void addRunValue(RunValue value) {
        if (null == value) {
            return;
        }
        this.runValues.add(value);
    }

    protected void addRunValue(List<RunValue> values) {
        for (RunValue value : values) {
            this.addRunValue(value);
        }
    }

    protected void addRunValue(String key, Object value) {
        if (null == value) {
            return;
        }
        if (null == key) {
            key = "none";
        }
        if (value instanceof RunValue) {
            throw new RuntimeException("run value");
        }
        if (value instanceof Collection) {
            Collection list = (Collection)value;
            for (Object obj : list) {
                RunValue v = new RunValue(key, obj);
                this.addRunValue(v);
            }
        } else {
            RunValue v = new RunValue(key, value);
            this.addRunValue(v);
        }
    }

    @Override
    public List<RunValue> getRunValues() {
        return this.runValues;
    }

    @Override
    public String getJoin() {
        if (BasicUtil.isNotEmpty((Object)this.join)) {
            return this.join;
        }
        return " AND ";
    }

    @Override
    public int getJoinSize() {
        return this.joinSize;
    }

    @Override
    public List<Condition> getConditions() {
        return this.conditions;
    }

    @Override
    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        for (Condition con : this.conditions) {
            if (null == con || con.isValid()) continue;
            return false;
        }
        return true;
    }
}

