/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.param;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.anyline.data.prepare.RunPrepare;
import org.anyline.data.prepare.auto.init.DefaultTablePrepare;
import org.anyline.entity.Join;
import org.anyline.metadata.Column;
import org.anyline.metadata.Table;

public class TableBuilder {
    private Table table;
    private String datasource;
    private LinkedHashMap<String, Column> columns = new LinkedHashMap();
    private List<Join> joins = new ArrayList<Join>();

    public static TableBuilder init() {
        TableBuilder builder = new TableBuilder();
        return builder;
    }

    public static TableBuilder init(String table) {
        TableBuilder builder = new TableBuilder();
        builder.setTable(table);
        return builder;
    }

    public static TableBuilder init(Table table) {
        TableBuilder builder = new TableBuilder();
        builder.setTable(table);
        return builder;
    }

    public static TableBuilder init(String table, String columns) {
        TableBuilder builder = new TableBuilder();
        builder.setTable(table);
        builder.addColumns(columns);
        return builder;
    }

    public TableBuilder setDatasource(String datasoruce) {
        this.datasource = datasoruce;
        return this;
    }

    public TableBuilder setTable(String table) {
        this.table = new Table(table);
        return this;
    }

    public TableBuilder setTable(Table table) {
        this.table = table;
        return this;
    }

    public TableBuilder addColumn(String column) {
        if (!this.columns.containsKey(column.toUpperCase())) {
            this.columns.put(column.toUpperCase(), new Column(column));
        }
        return this;
    }

    public TableBuilder addColumns(String ... columns) {
        if (null != columns) {
            for (String column : columns) {
                this.addColumn(column);
            }
        }
        return this;
    }

    public RunPrepare build() {
        DefaultTablePrepare sql = new DefaultTablePrepare();
        sql.setDest(this.datasource);
        sql.setTable(this.table);
        for (Join join : this.joins) {
            sql.join(join);
        }
        for (Column col : this.columns.values()) {
            sql.addColumn(col);
        }
        return sql;
    }

    public TableBuilder join(Join join) {
        this.joins.add(join);
        return this;
    }

    public TableBuilder join(Join.TYPE type, String table, String condition) {
        return this.join(type, new Table(table), condition);
    }

    public TableBuilder join(Join.TYPE type, Table table, String condition) {
        Join join = new Join();
        join.setTable(table);
        join.setType(type);
        join.setCondition(condition);
        return this.join(join);
    }

    public Table getTable() {
        return this.table;
    }

    public TableBuilder inner(Table table, String condition) {
        return this.join(Join.TYPE.INNER, table.getFullName(), condition);
    }

    public TableBuilder inner(String table, String condition) {
        return this.join(Join.TYPE.INNER, table, condition);
    }

    public TableBuilder left(String table, String condition) {
        return this.join(Join.TYPE.LEFT, table, condition);
    }

    public TableBuilder left(Table table, String condition) {
        return this.join(Join.TYPE.LEFT, table, condition);
    }

    public TableBuilder right(String table, String condition) {
        return this.join(Join.TYPE.RIGHT, table, condition);
    }

    public TableBuilder right(Table table, String condition) {
        return this.join(Join.TYPE.RIGHT, table, condition);
    }

    public TableBuilder full(String table, String condition) {
        return this.join(Join.TYPE.FULL, table, condition);
    }

    public TableBuilder full(Table table, String condition) {
        return this.join(Join.TYPE.FULL, table, condition);
    }
}

