/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.listener.init;

import java.util.HashMap;
import java.util.Map;
import org.anyline.data.datasource.DatasourceHolder;
import org.anyline.data.listener.DatasourceLoader;
import org.anyline.data.runtime.RuntimeHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component(value="anyline.listener.data.environment")
public class EnvironmentListener
implements ApplicationContextAware {
    public static Logger log = LoggerFactory.getLogger(EnvironmentListener.class);
    private static Map<String, DatasourceLoader> loaders = new HashMap<String, DatasourceLoader>();

    @Autowired(required=false)
    public void setAdapters(Map<String, DatasourceLoader> map) {
        loaders = map;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        DefaultListableBeanFactory factory = (DefaultListableBeanFactory)applicationContext.getAutowireCapableBeanFactory();
        DatasourceHolder.init(factory);
        RuntimeHolder.init(factory);
        for (DatasourceLoader loader : loaders.values()) {
            loader.load(applicationContext);
        }
    }
}

