/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.datasource;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.anyline.adapter.init.ConvertAdapter;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.datasource.DataSourceKeyMap;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.data.runtime.RuntimeHolder;
import org.anyline.metadata.type.DatabaseType;
import org.anyline.proxy.DatasourceHolderProxy;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.core.env.Environment;

public abstract class DatasourceHolder {
    public static Logger log = LoggerFactory.getLogger(DatasourceHolder.class);
    protected static DefaultListableBeanFactory factory;
    protected static Map<String, DatabaseType> types;
    public static Map<String, Map<String, Object>> params;

    public static void init(DefaultListableBeanFactory factory) {
        DatasourceHolder.factory = factory;
    }

    public static DefaultListableBeanFactory factory() {
        return factory;
    }

    public static List<String> list() {
        return RuntimeHolder.keys();
    }

    public static DatabaseType dialect(String datasource) {
        return types.get(datasource);
    }

    public static void dialect(String ds, DatabaseType type) {
        types.put(ds, type);
    }

    public static boolean contains(String ds) {
        return RuntimeHolder.contains(ds);
    }

    public static Object value(Environment env, String prefix, String name) {
        return DatasourceHolder.value(env, prefix, name, Object.class, null);
    }

    public static <T> T value(Environment env, String prefix, String key, Class<T> clazz, T def) {
        if (null != env && null != prefix && null != key) {
            String[] ps = prefix.split(",");
            String[] ks = key.split(",");
            for (String p : ps) {
                for (String k : ks) {
                    HashSet<String> alias;
                    String value = BeanUtil.value((String)p, (Environment)env, (String[])new String[]{k});
                    if (null == value && null != (alias = DataSourceKeyMap.alias(k))) {
                        for (String item : alias) {
                            if (null == value) {
                                value = BeanUtil.value((String)p, (Environment)env, (String[])new String[]{item});
                            }
                            if (!BasicUtil.isNotEmpty((Object)value)) continue;
                            break;
                        }
                    }
                    if (!BasicUtil.isNotEmpty((Object)value)) continue;
                    return (T)ConvertAdapter.convert((Object)value, clazz, (boolean)false);
                }
            }
        }
        return def;
    }

    public static Object value(Map map, String keys) {
        return DatasourceHolder.value(map, keys, Object.class, null);
    }

    public static <T> T value(Map map, String keys, Class<T> clazz, T def) {
        Object result = null;
        String[] ks = keys.split(",");
        Object value = null;
        for (String key : ks) {
            HashSet<String> alias;
            value = map.get(key);
            if (null == value && null != (alias = DataSourceKeyMap.alias(key))) {
                for (String item : alias) {
                    if (null == value) {
                        value = map.get(item);
                    }
                    if (null == value) continue;
                    break;
                }
            }
            if (null != value) break;
        }
        if (null != value) {
            result = ConvertAdapter.convert(value, clazz, (boolean)false);
        }
        if (null == result) {
            result = def;
        }
        return (T)result;
    }

    protected static void check(String key, boolean override) throws Exception {
        if (DatasourceHolder.contains(key)) {
            if (!override) {
                throw new Exception("[\u91cd\u590d\u6ce8\u518c][thread:" + Thread.currentThread().getId() + "][key:" + key + "]");
            }
            DatasourceHolder.destroy(key);
        }
    }

    public static DataRuntime temporary(Object datasource, String database, DriverAdapter adapter) throws Exception {
        return DatasourceHolderProxy.temporary(datasource, database, adapter);
    }

    public abstract DataRuntime callTemporary(Object var1, String var2, DriverAdapter var3) throws Exception;

    public static boolean validate(String ds) {
        return DatasourceHolder.validate(RuntimeHolder.runtime(ds));
    }

    public static boolean validate() {
        return DatasourceHolder.validate(RuntimeHolder.runtime());
    }

    public static boolean validate(DataRuntime runtime) {
        return DatasourceHolderProxy.validate(runtime);
    }

    public abstract boolean callValidate(DataRuntime var1);

    public static boolean hit(String ds) throws Exception {
        return DatasourceHolder.hit(RuntimeHolder.runtime(ds));
    }

    public static boolean hit() throws Exception {
        return DatasourceHolder.hit(RuntimeHolder.runtime());
    }

    public static boolean hit(DataRuntime runtime) throws Exception {
        return DatasourceHolderProxy.hit(runtime);
    }

    public abstract boolean callHit(DataRuntime var1) throws Exception;

    public static void destroy(String datasource) {
        DatasourceHolderProxy.destroy(RuntimeHolder.runtime(datasource));
    }

    public abstract void callDestroy(String var1);

    public static List<String> copy(String datasource) {
        return DatasourceHolderProxy.copy(RuntimeHolder.runtime(datasource));
    }

    public static List<String> copy() {
        return DatasourceHolderProxy.copy(RuntimeHolder.runtime());
    }

    public static List<String> copy(DataRuntime runtime) {
        return DatasourceHolderProxy.copy(runtime);
    }

    public abstract List<String> callCopy(DataRuntime var1);

    static {
        types = new HashMap<String, DatabaseType>();
        params = new HashMap<String, Map<String, Object>>();
    }
}

