/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.service.init;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.anyline.cache.CacheElement;
import org.anyline.cache.CacheProvider;
import org.anyline.dao.AnylineDao;
import org.anyline.data.cache.CacheUtil;
import org.anyline.data.cache.PageLazyStore;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.param.init.DefaultConfigStore;
import org.anyline.data.prepare.RunPrepare;
import org.anyline.data.prepare.auto.init.DefaultTablePrepare;
import org.anyline.data.prepare.auto.init.DefaultTextPrepare;
import org.anyline.data.prepare.init.DefaultSQLStore;
import org.anyline.data.util.ClientHolder;
import org.anyline.data.util.DataSourceUtil;
import org.anyline.data.util.ThreadConfig;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.entity.DefaultPageNavi;
import org.anyline.entity.EntitySet;
import org.anyline.entity.PageNavi;
import org.anyline.exception.AnylineException;
import org.anyline.metadata.Column;
import org.anyline.metadata.Constraint;
import org.anyline.metadata.Database;
import org.anyline.metadata.ForeignKey;
import org.anyline.metadata.Function;
import org.anyline.metadata.Index;
import org.anyline.metadata.MasterTable;
import org.anyline.metadata.PartitionTable;
import org.anyline.metadata.PrimaryKey;
import org.anyline.metadata.Procedure;
import org.anyline.metadata.Table;
import org.anyline.metadata.Tag;
import org.anyline.metadata.Trigger;
import org.anyline.metadata.View;
import org.anyline.proxy.CacheProxy;
import org.anyline.proxy.EntityAdapterProxy;
import org.anyline.proxy.ServiceProxy;
import org.anyline.service.AnylineService;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.ClassUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.LogUtil;
import org.anyline.util.regular.RegularUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Primary
@Service(value="anyline.service")
public class DefaultService<E>
implements AnylineService<E> {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired(required=false)
    @Qualifier(value="anyline.dao")
    protected AnylineDao dao;
    protected static CacheProvider cacheProvider;
    public AnylineService.MetaDataService metadata = new AnylineService.MetaDataService(){

        @Override
        public LinkedHashMap<String, Database> databases() {
            return DefaultService.this.dao.databases();
        }

        @Override
        public Database database(String name) {
            return DefaultService.this.dao.database(name);
        }

        @Override
        public boolean exists(boolean greedy, Table table) {
            return null != this.table(greedy, table.getCatalog(), table.getSchema(), table.getName(), false);
        }

        @Override
        public <T extends Table> List<T> tables(boolean greedy, String catalog, String schema, String name, String types) {
            if (null == types) {
                types = "TABLE";
            }
            return DefaultService.this.dao.tables(greedy, catalog, schema, name, types);
        }

        @Override
        public <T extends Table> LinkedHashMap<String, T> tables(String catalog, String schema, String name, String types) {
            if (null == types) {
                types = "TABLE";
            }
            return DefaultService.this.dao.tables(catalog, schema, name, types);
        }

        private void struct(Table table) {
            this.ddl(table);
            LinkedHashMap columns = table.getColumns();
            if (null == columns || columns.size() == 0) {
                columns = this.columns(table);
                table.setColumns(columns);
                table.setTags(this.tags(table));
                PrimaryKey pk = this.primary(table);
                if (null != pk) {
                    for (String col : pk.getColumns().keySet()) {
                        Column column = (Column)columns.get(col.toUpperCase());
                        if (null == column) continue;
                        column.setPrimaryKey(Boolean.valueOf(true));
                    }
                }
                table.setPrimaryKey(pk);
                table.setIndexs(this.indexs(table));
            }
        }

        @Override
        public Table table(boolean greedy, String catalog, String schema, String name, boolean struct) {
            Table table = null;
            List tables = this.tables(greedy, catalog, schema, name, null);
            if (tables.size() > 0 && null != (table = (Table)tables.get(0)) && struct) {
                this.ddl(table);
                LinkedHashMap columns = table.getColumns();
                if (null == columns || columns.size() == 0) {
                    this.struct(table);
                }
            }
            return table;
        }

        @Override
        public Table table(String catalog, String schema, String name, boolean struct) {
            Table table = null;
            LinkedHashMap tables = this.tables(catalog, schema, name, null);
            if (tables.size() > 0 && null != (table = (Table)tables.values().iterator().next()) && struct) {
                this.struct(table);
            }
            return table;
        }

        @Override
        public List<String> ddl(Table table, boolean init) {
            return DefaultService.this.dao.ddl(table, init);
        }

        @Override
        public boolean exists(boolean greedy, View view) {
            return null != this.view(greedy, view.getCatalog(), view.getSchema(), view.getName());
        }

        @Override
        public <T extends View> LinkedHashMap<String, T> views(boolean greedy, String catalog, String schema, String name, String types) {
            return DefaultService.this.dao.views(greedy, catalog, schema, name, types);
        }

        @Override
        public <T extends View> LinkedHashMap<String, T> views(String catalog, String schema, String name, String types) {
            return DefaultService.this.dao.views(false, catalog, schema, name, types);
        }

        @Override
        public View view(boolean greedy, String catalog, String schema, String name) {
            View view = null;
            LinkedHashMap views = this.views(greedy, catalog, schema, name, null);
            if (views.size() > 0) {
                view = (View)views.values().iterator().next();
                view.setColumns(this.columns((Table)view));
                this.ddl(view);
            }
            return view;
        }

        @Override
        public List<String> ddl(View view) {
            return DefaultService.this.dao.ddl(view);
        }

        @Override
        public boolean exists(boolean greedy, MasterTable table) {
            MasterTable tab = this.mtable(greedy, table.getCatalog(), table.getSchema(), table.getName(), false);
            return null != tab;
        }

        @Override
        public <T extends MasterTable> LinkedHashMap<String, T> mtables(boolean greedy, String catalog, String schema, String name, String types) {
            return DefaultService.this.dao.mtables(greedy, catalog, schema, name, types);
        }

        @Override
        public MasterTable mtable(boolean greedy, String catalog, String schema, String name, boolean strut) {
            LinkedHashMap tables = this.mtables(greedy, catalog, schema, name, "STABLE");
            if (tables.size() == 0) {
                return null;
            }
            MasterTable table = (MasterTable)tables.values().iterator().next();
            table.setColumns(this.columns((Table)table));
            table.setTags(this.tags((Table)table));
            table.setIndexs(this.indexs((Table)table));
            return table;
        }

        @Override
        public List<String> ddl(MasterTable table) {
            return DefaultService.this.dao.ddl(table);
        }

        @Override
        public boolean exists(boolean greedy, PartitionTable table) {
            PartitionTable tab = this.ptable(greedy, table.getCatalog(), table.getSchema(), table.getName());
            return null != tab;
        }

        @Override
        public boolean exists(PartitionTable table) {
            return this.exists(false, table);
        }

        @Override
        public <T extends PartitionTable> LinkedHashMap<String, T> ptables(boolean greedy, MasterTable master, Map<String, Object> tags) {
            return DefaultService.this.dao.ptables(greedy, master, tags);
        }

        @Override
        public <T extends PartitionTable> LinkedHashMap<String, T> ptables(boolean greedy, MasterTable master, Map<String, Object> tags, String name) {
            return DefaultService.this.dao.ptables(greedy, master, tags, name);
        }

        @Override
        public <T extends PartitionTable> LinkedHashMap<String, T> ptables(String catalog, String schema, String master, String name) {
            return DefaultService.this.dao.ptables(false, catalog, schema, master, name);
        }

        @Override
        public <T extends PartitionTable> LinkedHashMap<String, T> ptables(String schema, String master, String name) {
            return this.ptables(false, null, schema, master, name);
        }

        @Override
        public <T extends PartitionTable> LinkedHashMap<String, T> ptables(String master, String name) {
            return this.ptables(false, null, null, master, name);
        }

        @Override
        public <T extends PartitionTable> LinkedHashMap<String, T> ptables(String master) {
            return this.ptables(false, null, null, master, null);
        }

        @Override
        public <T extends PartitionTable> LinkedHashMap<String, T> ptables(MasterTable master) {
            return DefaultService.this.dao.ptables(false, master);
        }

        @Override
        public <T extends PartitionTable> LinkedHashMap<String, T> ptables(MasterTable master, Map<String, Object> tags) {
            return DefaultService.this.dao.ptables(false, master, tags);
        }

        @Override
        public <T extends PartitionTable> LinkedHashMap<String, T> ptables(MasterTable master, Map<String, Object> tags, String name) {
            return DefaultService.this.dao.ptables(false, master, tags, name);
        }

        @Override
        public PartitionTable ptable(boolean greedy, MasterTable master, String name) {
            LinkedHashMap tables = this.ptables(greedy, master, name);
            if (tables.size() == 0) {
                return null;
            }
            PartitionTable table = (PartitionTable)tables.values().iterator().next();
            table.setColumns(this.columns((Table)table));
            table.setTags(this.tags((Table)table));
            table.setIndexs(this.indexs((Table)table));
            return table;
        }

        @Override
        public List<String> ddl(PartitionTable table) {
            return DefaultService.this.dao.ddl(table);
        }

        @Override
        public boolean exists(boolean greedy, Table table, Column column) {
            try {
                String name = column.getName().toUpperCase();
                LinkedHashMap columns = null;
                if (null != table) {
                    columns = table.getColumns();
                } else {
                    String tableName;
                    table = column.getTable(true);
                    if (null == table && BasicUtil.isNotEmpty((Object)(tableName = column.getTableName(true)))) {
                        table = new Table(column.getCatalog(), column.getSchema(), tableName);
                    }
                }
                if ((null == columns || columns.isEmpty()) && null != table) {
                    columns = this.columns(greedy, table);
                }
                if (null != columns && columns.containsKey(name)) {
                    return true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return false;
        }

        @Override
        public <T extends Column> LinkedHashMap<String, T> columns(boolean greedy, Table table) {
            LinkedHashMap columns = DefaultService.this.dao.columns(greedy, table);
            return columns;
        }

        @Override
        public Column column(boolean greedy, Table table, String name) {
            Column column = null;
            LinkedHashMap columns = table.getColumns();
            if (null == columns && columns.isEmpty()) {
                columns = this.columns(greedy, table);
            }
            column = (Column)columns.get(name.toUpperCase());
            return column;
        }

        @Override
        public <T extends Tag> LinkedHashMap<String, T> tags(boolean greedy, Table table) {
            return DefaultService.this.dao.tags(greedy, table);
        }

        @Override
        public PrimaryKey primary(boolean greedy, Table table) {
            return DefaultService.this.dao.primary(greedy, table);
        }

        @Override
        public PrimaryKey primary(boolean greedy, String table) {
            return this.primary(greedy, new Table(table));
        }

        @Override
        public PrimaryKey primary(boolean greedy, String catalog, String schema, String table) {
            return this.primary(greedy, new Table(catalog, schema, table));
        }

        @Override
        public PrimaryKey primary(Table table) {
            return DefaultService.this.dao.primary(false, table);
        }

        @Override
        public PrimaryKey primary(String table) {
            return this.primary(false, new Table(table));
        }

        @Override
        public PrimaryKey primary(String catalog, String schema, String table) {
            return this.primary(false, new Table(catalog, schema, table));
        }

        @Override
        public <T extends ForeignKey> LinkedHashMap<String, T> foreigns(boolean greedy, Table table) {
            return DefaultService.this.dao.foreigns(greedy, table);
        }

        @Override
        public ForeignKey foreign(boolean greedy, Table table, List<String> columns) {
            if (null == columns || columns.size() == 0) {
                return null;
            }
            LinkedHashMap foreigns = this.foreigns(greedy, table);
            Collections.sort(columns);
            String id = BeanUtil.concat(columns).toUpperCase();
            for (ForeignKey foreign : foreigns.values()) {
                List fcols = BeanUtil.getMapKeys((Map)foreign.getColumns());
                Collections.sort(fcols);
                if (!id.equals(BeanUtil.concat((Collection)fcols).toUpperCase())) continue;
                return foreign;
            }
            return null;
        }

        @Override
        public <T extends Index> LinkedHashMap<String, T> indexs(boolean greedy, Table table) {
            return DefaultService.this.dao.indexs(greedy, table);
        }

        @Override
        public Index index(boolean greedy, Table table, String name) {
            Index index = null;
            LinkedHashMap all = DefaultService.this.dao.indexs(greedy, table, name);
            if (null != all && null != name) {
                index = (Index)all.get(name.toUpperCase());
            }
            if (null == index && null != (all = DefaultService.this.dao.indexs(greedy, table)) && null != name) {
                index = (Index)all.get(name.toUpperCase());
            }
            return index;
        }

        @Override
        public <T extends Constraint> LinkedHashMap<String, T> constraints(boolean greedy, Table table) {
            return DefaultService.this.dao.constraints(greedy, table);
        }

        @Override
        public Constraint constraint(boolean greedy, Table table, String name) {
            LinkedHashMap constraints = this.constraints(greedy, table);
            if (null != constraints && null != name) {
                return (Constraint)constraints.get(name.toUpperCase());
            }
            return null;
        }

        @Override
        public <T extends Trigger> LinkedHashMap<String, T> triggers(boolean greedy, Table table, List<Trigger.EVENT> events) {
            return DefaultService.this.dao.triggers(greedy, table, events);
        }

        @Override
        public Trigger trigger(boolean greedy, String catalog, String schema, String name) {
            LinkedHashMap triggers = this.triggers(greedy, new Table(catalog, schema, null), null);
            if (null != triggers) {
                return (Trigger)triggers.get(name.toUpperCase());
            }
            return null;
        }

        @Override
        public <T extends Procedure> LinkedHashMap<String, T> procedures(boolean greedy, String catalog, String schema, String name) {
            return DefaultService.this.dao.procedures(greedy, catalog, schema, name);
        }

        @Override
        public Procedure procedure(boolean greedy, String catalog, String schema, String name) {
            LinkedHashMap procedures = this.procedures(greedy, catalog, schema, name);
            if (null != procedures) {
                return (Procedure)procedures.get(name.toUpperCase());
            }
            return null;
        }

        @Override
        public List<String> ddl(Procedure procedure) {
            return DefaultService.this.dao.ddl(procedure);
        }

        @Override
        public <T extends Function> LinkedHashMap<String, T> functions(boolean greedy, String catalog, String schema, String name) {
            return DefaultService.this.dao.functions(greedy, catalog, schema, name);
        }

        @Override
        public Function function(boolean greedy, String catalog, String schema, String name) {
            LinkedHashMap functions = this.functions(greedy, catalog, schema, name);
            if (null != functions) {
                return (Function)functions.get(name.toUpperCase());
            }
            return null;
        }

        @Override
        public List<String> ddl(Function function) {
            return DefaultService.this.dao.ddl(function);
        }
    };
    public AnylineService.DDLService ddl = new AnylineService.DDLService(){

        @Override
        public boolean save(Table table) throws Exception {
            boolean result = false;
            CacheProxy.clear();
            Table otable = DefaultService.this.metadata.table(table.getCatalog(), table.getSchema(), table.getName());
            if (null != otable) {
                otable.setAutoDropColumn(table.isAutoDropColumn());
                Table update = table.getUpdate();
                if (null == update) {
                    update = table;
                }
                otable.setUpdate(update, false, false);
                result = this.alter(otable);
            } else {
                result = this.create(table);
            }
            CacheProxy.clear();
            return result;
        }

        @Override
        public boolean create(Table table) throws Exception {
            boolean result = DefaultService.this.dao.create(table);
            return result;
        }

        @Override
        public boolean alter(Table table) throws Exception {
            CacheProxy.clear();
            Table update = table.getUpdate();
            if (null == update) {
                update = table;
                table = DefaultService.this.metadata().table(table.getCatalog(), table.getSchema(), table.getName());
                table.setUpdate(update, false, false);
            }
            boolean result = DefaultService.this.dao.alter(table);
            CacheProxy.clear();
            return result;
        }

        @Override
        public boolean drop(Table table) throws Exception {
            boolean result = DefaultService.this.dao.drop(table);
            CacheProxy.clear();
            return result;
        }

        @Override
        public boolean rename(Table origin, String name) throws Exception {
            boolean result = DefaultService.this.dao.rename(origin, name);
            CacheProxy.clear();
            return result;
        }

        @Override
        public boolean save(View view) throws Exception {
            boolean result = false;
            CacheProxy.clear();
            View oview = DefaultService.this.metadata.view(view.getCatalog(), view.getSchema(), view.getName());
            if (null != oview) {
                oview.setAutoDropColumn(view.isAutoDropColumn());
                View update = view.getUpdate();
                if (null == update) {
                    update = view;
                }
                oview.setUpdate(update, false, false);
                result = this.alter(oview);
            } else {
                result = this.create(view);
            }
            CacheProxy.clear();
            return result;
        }

        @Override
        public boolean create(View view) throws Exception {
            boolean result = DefaultService.this.dao.create(view);
            return result;
        }

        @Override
        public boolean alter(View view) throws Exception {
            CacheProxy.clear();
            boolean result = DefaultService.this.dao.alter(view);
            CacheProxy.clear();
            return result;
        }

        @Override
        public boolean drop(View view) throws Exception {
            boolean result = DefaultService.this.dao.drop(view);
            CacheProxy.clear();
            return result;
        }

        @Override
        public boolean rename(View origin, String name) throws Exception {
            boolean result = DefaultService.this.dao.rename(origin, name);
            CacheProxy.clear();
            return result;
        }

        @Override
        public boolean save(MasterTable table) throws Exception {
            boolean result = false;
            CacheProxy.clear();
            MasterTable otable = DefaultService.this.metadata.mtable(table.getCatalog(), table.getSchema(), table.getName());
            if (null != otable) {
                otable.setUpdate(table, false, false);
                result = this.alter(otable);
            } else {
                result = this.create(table);
            }
            CacheProxy.clear();
            return result;
        }

        @Override
        public boolean create(MasterTable table) throws Exception {
            boolean result = DefaultService.this.dao.create(table);
            return result;
        }

        @Override
        public boolean alter(MasterTable table) throws Exception {
            CacheProxy.clear();
            boolean result = DefaultService.this.dao.alter(table);
            CacheProxy.clear();
            return result;
        }

        @Override
        public boolean drop(MasterTable table) throws Exception {
            boolean result = DefaultService.this.dao.drop(table);
            CacheProxy.clear();
            return result;
        }

        @Override
        public boolean rename(MasterTable origin, String name) throws Exception {
            boolean result = DefaultService.this.dao.rename(origin, name);
            CacheProxy.clear();
            return result;
        }

        @Override
        public boolean save(PartitionTable table) throws Exception {
            boolean result = false;
            CacheProxy.clear();
            PartitionTable otable = DefaultService.this.metadata.ptable(table.getCatalog(), table.getSchema(), table.getName());
            if (null != otable) {
                otable.setUpdate((Table)table, false, false);
                result = this.alter(otable);
            } else {
                result = this.create(table);
            }
            CacheProxy.clear();
            return result;
        }

        @Override
        public boolean create(PartitionTable table) throws Exception {
            boolean result = DefaultService.this.dao.create(table);
            return result;
        }

        @Override
        public boolean alter(PartitionTable table) throws Exception {
            CacheProxy.clear();
            boolean result = DefaultService.this.dao.alter(table);
            CacheProxy.clear();
            return result;
        }

        @Override
        public boolean drop(PartitionTable table) throws Exception {
            boolean result = DefaultService.this.dao.drop(table);
            CacheProxy.clear();
            return result;
        }

        @Override
        public boolean rename(PartitionTable origin, String name) throws Exception {
            boolean result = DefaultService.this.dao.rename(origin, name);
            CacheProxy.clear();
            return result;
        }

        @Override
        public boolean save(Column column) throws Exception {
            boolean result = false;
            CacheProxy.clear();
            Table table = DefaultService.this.metadata.table(column.getCatalog(), column.getSchema(), column.getTableName(true));
            if (null == table) {
                throw new AnylineException("\u8868\u4e0d\u5b58\u5728:" + column.getTableName(true));
            }
            LinkedHashMap columns = table.getColumns();
            Column original = (Column)columns.get(column.getName().toUpperCase());
            result = null == original ? this.add(columns, column) : this.alter(table, column);
            CacheProxy.clear();
            return result;
        }

        @Override
        public boolean add(Column column) throws Exception {
            CacheProxy.clear();
            LinkedHashMap<String, Column> columns = DefaultService.this.metadata.columns(column.getCatalog(), column.getSchema(), column.getTableName(true));
            boolean result = this.add(columns, column);
            CacheProxy.clear();
            return result;
        }

        @Override
        public boolean alter(Column column) throws Exception {
            CacheProxy.clear();
            Table table = DefaultService.this.metadata.table(column.getCatalog(), column.getSchema(), column.getTableName(true));
            boolean result = this.alter(table, column);
            CacheProxy.clear();
            return result;
        }

        @Override
        public boolean drop(Column column) throws Exception {
            boolean result = DefaultService.this.dao.drop(column);
            CacheProxy.clear();
            return result;
        }

        private boolean add(LinkedHashMap<String, Column> columns, Column column) throws Exception {
            CacheProxy.clear();
            boolean result = DefaultService.this.dao.add(column);
            if (result) {
                columns.put(column.getName(), column);
            }
            CacheProxy.clear();
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean alter(Table table, Column column) throws Exception {
            boolean result = false;
            CacheProxy.clear();
            LinkedHashMap columns = table.getColumns();
            Column original = (Column)columns.get(column.getName().toUpperCase());
            Column update = column.getUpdate();
            if (null == update) {
                update = column.clone();
            }
            original.setUpdate(update, false, false);
            String name = original.getName();
            try {
                result = DefaultService.this.dao.alter(table, original);
            }
            finally {
                original.setName(name);
            }
            if (result) {
                columns.remove(original.getName());
                BeanUtil.copyFieldValueWithoutNull((Object)original, (Object)update);
                original.setUpdate(update, false, false);
                BeanUtil.copyFieldValue((Object)column, (Object)original);
                columns.put(original.getName(), original);
            }
            column.setTable(table);
            CacheProxy.clear();
            return result;
        }

        @Override
        public boolean rename(Column origin, String name) throws Exception {
            origin.setNewName(name);
            boolean result = this.alter(origin);
            CacheProxy.clear();
            return result;
        }

        @Override
        public boolean save(Tag tag) throws Exception {
            boolean result = false;
            CacheProxy.clear();
            Table table = DefaultService.this.metadata.table(tag.getCatalog(), tag.getSchema(), tag.getTableName(true));
            if (null == table) {
                throw new AnylineException("\u8868\u4e0d\u5b58\u5728:" + tag.getTableName(true));
            }
            LinkedHashMap tags = table.getTags();
            Tag original = (Tag)tags.get(tag.getName().toUpperCase());
            result = null == original ? this.add(tags, tag) : this.alter(table, tag);
            CacheProxy.clear();
            return result;
        }

        @Override
        public boolean add(Tag tag) throws Exception {
            CacheProxy.clear();
            LinkedHashMap<String, Tag> tags = DefaultService.this.metadata.tags(tag.getCatalog(), tag.getSchema(), tag.getTableName(true));
            boolean result = this.add(tags, tag);
            CacheProxy.clear();
            return result;
        }

        @Override
        public boolean alter(Tag tag) throws Exception {
            CacheProxy.clear();
            Table table = DefaultService.this.metadata.table(tag.getCatalog(), tag.getSchema(), tag.getTableName(true));
            boolean result = this.alter(table, tag);
            CacheProxy.clear();
            return result;
        }

        @Override
        public boolean drop(Tag tag) throws Exception {
            boolean result = DefaultService.this.dao.drop(tag);
            CacheProxy.clear();
            return result;
        }

        private boolean add(LinkedHashMap<String, Tag> tags, Tag tag) throws Exception {
            CacheProxy.clear();
            boolean result = DefaultService.this.dao.add(tag);
            if (result) {
                tags.put(tag.getName(), tag);
            }
            CacheProxy.clear();
            return result;
        }

        private boolean alter(Table table, Tag tag) throws Exception {
            boolean result = false;
            CacheProxy.clear();
            LinkedHashMap tags = table.getTags();
            Tag original = (Tag)tags.get(tag.getName().toUpperCase());
            Tag update = tag.getUpdate();
            if (null == update) {
                update = tag.clone();
            }
            original.setUpdate(update, false, false);
            result = DefaultService.this.dao.alter(table, original);
            if (result) {
                tags.remove(original.getName());
                BeanUtil.copyFieldValueWithoutNull((Object)original, (Object)update);
                original.setUpdate(update, false, false);
                BeanUtil.copyFieldValue((Object)tag, (Object)original);
                tags.put(original.getName(), original);
            }
            CacheProxy.clear();
            return result;
        }

        @Override
        public boolean rename(Tag origin, String name) throws Exception {
            boolean result = DefaultService.this.dao.rename(origin, name);
            CacheProxy.clear();
            return result;
        }

        @Override
        public boolean add(PrimaryKey primary) throws Exception {
            CacheProxy.clear();
            return DefaultService.this.dao.add(primary);
        }

        @Override
        public boolean alter(PrimaryKey primary) throws Exception {
            CacheProxy.clear();
            return false;
        }

        @Override
        public boolean drop(PrimaryKey primary) throws Exception {
            boolean result = DefaultService.this.dao.drop(primary);
            CacheProxy.clear();
            return result;
        }

        @Override
        public boolean rename(PrimaryKey origin, String name) throws Exception {
            boolean result = DefaultService.this.dao.rename(origin, name);
            CacheProxy.clear();
            return result;
        }

        @Override
        public boolean add(ForeignKey foreign) throws Exception {
            CacheProxy.clear();
            boolean result = DefaultService.this.dao.add(foreign);
            CacheProxy.clear();
            return result;
        }

        @Override
        public boolean alter(ForeignKey foreign) throws Exception {
            CacheProxy.clear();
            boolean result = DefaultService.this.dao.alter(foreign);
            CacheProxy.clear();
            return result;
        }

        @Override
        public boolean drop(ForeignKey foreign) throws Exception {
            if (BasicUtil.isEmpty((Object)foreign.getName())) {
                List names = Column.names((LinkedHashMap)foreign.getColumns());
                foreign = DefaultService.this.metadata.foreign(foreign.getTable(true), (List<String>)names);
            }
            boolean result = DefaultService.this.dao.drop(foreign);
            CacheProxy.clear();
            return result;
        }

        @Override
        public boolean rename(ForeignKey origin, String name) throws Exception {
            boolean result = DefaultService.this.dao.rename(origin, name);
            CacheProxy.clear();
            return result;
        }

        @Override
        public boolean add(Index index) throws Exception {
            CacheProxy.clear();
            boolean result = DefaultService.this.dao.add(index);
            CacheProxy.clear();
            return result;
        }

        @Override
        public boolean alter(Index index) throws Exception {
            CacheProxy.clear();
            return false;
        }

        @Override
        public boolean drop(Index index) throws Exception {
            boolean result = DefaultService.this.dao.drop(index);
            CacheProxy.clear();
            return result;
        }

        @Override
        public boolean rename(Index origin, String name) throws Exception {
            boolean result = DefaultService.this.dao.rename(origin, name);
            CacheProxy.clear();
            return result;
        }

        @Override
        public boolean add(Constraint constraint) throws Exception {
            CacheProxy.clear();
            boolean result = DefaultService.this.dao.add(constraint);
            CacheProxy.clear();
            return result;
        }

        @Override
        public boolean alter(Constraint constraint) throws Exception {
            CacheProxy.clear();
            return false;
        }

        @Override
        public boolean drop(Constraint constraint) throws Exception {
            boolean result = DefaultService.this.dao.drop(constraint);
            CacheProxy.clear();
            return result;
        }

        @Override
        public boolean rename(Constraint origin, String name) throws Exception {
            boolean result = DefaultService.this.dao.rename(origin, name);
            CacheProxy.clear();
            return result;
        }

        @Override
        public boolean create(Trigger trigger) throws Exception {
            boolean result = DefaultService.this.dao.add(trigger);
            return result;
        }

        @Override
        public boolean alter(Trigger trigger) throws Exception {
            CacheProxy.clear();
            boolean result = DefaultService.this.dao.alter(trigger);
            CacheProxy.clear();
            return result;
        }

        @Override
        public boolean drop(Trigger trigger) throws Exception {
            boolean result = DefaultService.this.dao.drop(trigger);
            CacheProxy.clear();
            return result;
        }

        @Override
        public boolean rename(Trigger origin, String name) throws Exception {
            boolean result = DefaultService.this.dao.rename(origin, name);
            CacheProxy.clear();
            return result;
        }

        @Override
        public boolean create(Procedure procedure) throws Exception {
            return DefaultService.this.dao.create(procedure);
        }

        @Override
        public boolean alter(Procedure procedure) throws Exception {
            boolean result = DefaultService.this.dao.alter(procedure);
            return result;
        }

        @Override
        public boolean drop(Procedure procedure) throws Exception {
            boolean result = DefaultService.this.dao.drop(procedure);
            return result;
        }

        @Override
        public boolean rename(Procedure origin, String name) throws Exception {
            boolean result = DefaultService.this.dao.rename(origin, name);
            return result;
        }

        @Override
        public boolean create(Function function) throws Exception {
            boolean result = DefaultService.this.dao.create(function);
            return result;
        }

        @Override
        public boolean alter(Function function) throws Exception {
            boolean result = DefaultService.this.dao.alter(function);
            return result;
        }

        @Override
        public boolean drop(Function function) throws Exception {
            boolean result = DefaultService.this.dao.drop(function);
            return result;
        }

        @Override
        public boolean rename(Function origin, String name) throws Exception {
            boolean result = DefaultService.this.dao.rename(origin, name);
            return result;
        }
    };

    public CacheProvider getCacheProvider() {
        return cacheProvider;
    }

    @Autowired(required=false)
    public void setCacheProvider(CacheProvider cacheProvider) {
        DefaultService.cacheProvider = cacheProvider;
    }

    @Override
    public AnylineDao getDao() {
        return this.dao;
    }

    @Override
    public AnylineService setDao(AnylineDao dao) {
        this.dao = dao;
        return this;
    }

    @Override
    public AnylineService datasource(String datasource) {
        ClientHolder.setDataSource(datasource);
        return this;
    }

    @Override
    public AnylineService datasource() {
        ClientHolder.setDefaultDataSource();
        return this;
    }

    @Override
    public AnylineService setDataSource(String datasource) {
        ClientHolder.setDataSource(datasource);
        return this;
    }

    @Override
    public AnylineService setDataSource(String datasource, boolean auto) {
        ClientHolder.setDataSource(datasource, auto);
        return this;
    }

    @Override
    public AnylineService setDefaultDataSource() {
        ClientHolder.setDefaultDataSource();
        return this;
    }

    @Override
    public AnylineService recoverDataSource() {
        ClientHolder.recoverDataSource();
        return this;
    }

    @Override
    public String getDataSource() {
        return ClientHolder.curDataSource();
    }

    @Override
    public DataSet querys(String src, ConfigStore configs, Object obj, String ... conditions) {
        String[] ps = DataSourceUtil.parseRuntime(src);
        if (null != ps[0]) {
            return ServiceProxy.service(ps[0]).querys(ps[1], configs, obj, conditions);
        }
        src = BasicUtil.compress((String)src);
        conditions = BasicUtil.compress((String[])conditions);
        configs = this.append(configs, obj);
        return this.queryFromDao(src, configs, conditions);
    }

    @Override
    public List<String> column2param(String table) {
        List<String> columns = this.columns(table);
        return EntityAdapterProxy.column2param(columns);
    }

    @Override
    public List<Map<String, Object>> maps(String src, ConfigStore configs, Object obj, String ... conditions) {
        List<Object> maps;
        block4: {
            String[] ps = DataSourceUtil.parseRuntime(src);
            if (null != ps[0]) {
                return ServiceProxy.service(ps[0]).maps(ps[1], configs, obj, conditions);
            }
            maps = null;
            src = BasicUtil.compress((String)src);
            conditions = BasicUtil.compress((String[])conditions);
            try {
                RunPrepare prepare = this.createRunPrepare(src);
                configs = this.append(configs, obj);
                maps = null != prepare.getRuntime() ? ServiceProxy.service(prepare.getRuntime()).getDao().maps(prepare, configs, conditions) : this.dao.maps(prepare, configs, conditions);
            }
            catch (Exception e) {
                maps = new ArrayList();
                if (this.log.isWarnEnabled()) {
                    e.printStackTrace();
                }
                this.log.error("QUERY ERROR:" + e);
                if (!ConfigTable.IS_THROW_SQL_QUERY_EXCEPTION) break block4;
                throw e;
            }
        }
        return maps;
    }

    @Override
    public DataSet caches(String cache, String src, ConfigStore configs, Object obj, String ... conditions) {
        String[] ps = DataSourceUtil.parseRuntime(src);
        if (null != ps[0]) {
            return ServiceProxy.service(ps[0]).caches(cache, ps[1], configs, obj, conditions);
        }
        DataSet set = null;
        src = BasicUtil.compress((String)src);
        conditions = BasicUtil.compress((String[])conditions);
        set = null == cache || ConfigTable.IS_CACHE_DISABLED ? this.querys(src, this.append(configs, obj), conditions) : (null != cacheProvider ? this.queryFromCache(cache, src, configs, conditions) : this.querys(src, configs, conditions));
        return set;
    }

    @Override
    public DataRow query(String src, ConfigStore store, Object obj, String ... conditions) {
        DefaultPageNavi navi = new DefaultPageNavi();
        navi.setFirstRow(0L);
        navi.setLastRow(0L);
        navi.setCalType(1);
        if (null == store) {
            store = new DefaultConfigStore(new String[0]);
        }
        store.setPageNavi((PageNavi)navi);
        DataSet set = this.querys(src, store, obj, conditions);
        if (null != set && set.size() > 0) {
            DataRow row = set.getRow(0);
            return row;
        }
        if (ThreadConfig.check(ClientHolder.curDataSource()).IS_RETURN_EMPTY_INSTANCE_REPLACE_NULL()) {
            return new DataRow();
        }
        return null;
    }

    @Override
    public BigDecimal sequence(boolean next, String name) {
        DataRow row = this.sequences(next, name);
        if (null != row) {
            return row.getDecimal(name, (BigDecimal)null);
        }
        return null;
    }

    @Override
    public DataRow sequences(boolean next, String ... names) {
        return this.dao.sequence(next, names);
    }

    @Override
    public DataRow cache(String cache, String src, ConfigStore configs, Object obj, String ... conditions) {
        CacheElement cacheElement;
        if (null == cache || null == cacheProvider || ThreadConfig.check(ClientHolder.curDataSource()).IS_CACHE_DISABLED()) {
            return this.query(src, configs, obj, conditions);
        }
        DefaultPageNavi navi = new DefaultPageNavi();
        navi.setFirstRow(0L);
        navi.setLastRow(0L);
        navi.setCalType(1);
        if (null == configs) {
            configs = new DefaultConfigStore(new String[0]);
        }
        configs = this.append(configs, obj);
        configs.setPageNavi((PageNavi)navi);
        DataRow row = null;
        String key = "ROW:";
        if (cache.contains(":")) {
            String[] ks = BeanUtil.parseKeyValue((String)cache);
            cache = ks[0];
            key = key + ks[1] + ":";
        }
        key = key + CacheUtil.createCacheElementKey(true, true, src, configs, conditions);
        if (null != cacheProvider && null != (cacheElement = cacheProvider.get(cache, key)) && null != cacheElement.getValue()) {
            Object cacheValue = cacheElement.getValue();
            if (cacheValue instanceof DataRow) {
                row = (DataRow)cacheValue;
                row.setIsFromCache(true);
                return row;
            }
            this.log.error("[\u7f13\u5b58\u8bbe\u7f6e\u9519\u8bef,\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6\u662f\u5426\u6709\u91cd\u590dcache.name \u6216Java\u4ee3\u7801\u8c03\u7528\u4e2dcache.name\u6df7\u6dc6][channel:{}]", (Object)cache);
        }
        if (null != (row = this.query(src, configs, obj, conditions)) && null != cacheProvider) {
            cacheProvider.put(cache, key, (Object)row);
        }
        if (null == row && ThreadConfig.check(ClientHolder.curDataSource()).IS_RETURN_EMPTY_INSTANCE_REPLACE_NULL()) {
            row = new DataRow();
        }
        return row;
    }

    @Override
    public <T> EntitySet<T> selects(Class<T> clazz, ConfigStore configs, T entity, String ... conditions) {
        return this.selectFromDao(clazz, this.append(configs, entity), conditions);
    }

    @Override
    public <T> T select(Class<T> clazz, ConfigStore configs, T entity, String ... conditions) {
        DefaultPageNavi navi = new DefaultPageNavi();
        navi.setFirstRow(0L);
        navi.setLastRow(0L);
        navi.setCalType(1);
        if (null == configs) {
            configs = new DefaultConfigStore(new String[0]);
        }
        configs.setPageNavi((PageNavi)navi);
        EntitySet<T> list = this.selects(clazz, configs, entity, conditions);
        if (null != list && list.size() > 0) {
            return (T)list.get(0);
        }
        if (ThreadConfig.check(ClientHolder.curDataSource()).IS_RETURN_EMPTY_INSTANCE_REPLACE_NULL()) {
            try {
                return clazz.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public <T> EntitySet<T> selects(String src, Class<T> clazz, ConfigStore configs, T entity, String ... conditions) {
        String[] ps = DataSourceUtil.parseRuntime(src);
        if (null != ps[0]) {
            return ServiceProxy.service(ps[0]).selects(ps[1], clazz, configs, entity, conditions);
        }
        return this.queryFromDao(src, clazz, this.append(configs, entity), conditions);
    }

    @Override
    public <T> T select(String src, Class<T> clazz, ConfigStore configs, T entity, String ... conditions) {
        DefaultPageNavi navi = new DefaultPageNavi();
        navi.setFirstRow(0L);
        navi.setLastRow(0L);
        navi.setCalType(1);
        if (null == configs) {
            configs = new DefaultConfigStore(new String[0]);
        }
        configs.setPageNavi((PageNavi)navi);
        EntitySet<T> list = this.selects(src, clazz, configs, entity, conditions);
        if (null != list && list.size() > 0) {
            return (T)list.get(0);
        }
        if (ThreadConfig.check(ClientHolder.curDataSource()).IS_RETURN_EMPTY_INSTANCE_REPLACE_NULL()) {
            try {
                return clazz.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    protected Class<E> parseGenericClass() {
        Type type = null;
        Class clazz = null;
        Type superClass = this.getClass().getGenericSuperclass();
        if (superClass instanceof ParameterizedType) {
            type = ((ParameterizedType)superClass).getActualTypeArguments()[0];
        }
        clazz = type instanceof ParameterizedType ? (Class)((ParameterizedType)type).getRawType() : (Class)type;
        return clazz;
    }

    @Override
    public EntitySet<E> gets(ConfigStore configs, String ... conditions) {
        Class<E> clazz = this.parseGenericClass();
        return this.selects(clazz, configs, conditions);
    }

    @Override
    public E get(ConfigStore configs, String ... conditions) {
        Class<E> clazz = this.parseGenericClass();
        return this.select(clazz, configs, conditions);
    }

    @Override
    public DataSet querys(RunPrepare prepare, ConfigStore configs, Object obj, String ... conditions) {
        conditions = BasicUtil.compress((String[])conditions);
        DataSet set = this.queryFromDao(prepare, this.append(configs, obj), conditions);
        return set;
    }

    @Override
    public DataSet caches(String cache, RunPrepare table, ConfigStore configs, Object obj, String ... conditions) {
        DataSet set = null;
        conditions = BasicUtil.compress((String[])conditions);
        if (null == cache) {
            set = this.querys(table, configs, obj, conditions);
        } else if (null == cacheProvider) {
            set = this.querys(table, configs, obj, conditions);
        }
        return set;
    }

    @Override
    public DataRow query(RunPrepare table, ConfigStore store, Object obj, String ... conditions) {
        DefaultPageNavi navi = new DefaultPageNavi();
        navi.setFirstRow(0L);
        navi.setLastRow(0L);
        navi.setCalType(1);
        if (null == store) {
            store = new DefaultConfigStore(new String[0]);
        }
        store.setPageNavi((PageNavi)navi);
        DataSet set = this.querys(table, store, obj, conditions);
        if (null != set && set.size() > 0) {
            DataRow row = set.getRow(0);
            return row;
        }
        if (ThreadConfig.check(ClientHolder.curDataSource()).IS_RETURN_EMPTY_INSTANCE_REPLACE_NULL()) {
            return new DataRow();
        }
        return null;
    }

    @Override
    public DataRow cache(String cache, RunPrepare table, ConfigStore configs, Object obj, String ... conditions) {
        CacheElement cacheElement;
        if (null == cache) {
            return this.query(table, configs, obj, conditions);
        }
        DefaultPageNavi navi = new DefaultPageNavi();
        navi.setFirstRow(0L);
        navi.setLastRow(0L);
        navi.setCalType(1);
        if (null == configs) {
            configs = new DefaultConfigStore(new String[0]);
        }
        configs.setPageNavi((PageNavi)navi);
        configs = this.append(configs, obj);
        DataRow row = null;
        String key = "ROW:";
        if (cache.contains(":")) {
            String[] ks = BeanUtil.parseKeyValue((String)cache);
            cache = ks[0];
            key = key + ks[1] + ":";
        }
        key = key + CacheUtil.createCacheElementKey(true, true, table.getTable(), configs, conditions);
        if (null != cacheProvider && null != (cacheElement = cacheProvider.get(cache, key)) && null != cacheElement.getValue()) {
            Object cacheValue = cacheElement.getValue();
            if (cacheValue instanceof DataRow) {
                row = (DataRow)cacheValue;
                row.setIsFromCache(true);
                return row;
            }
            this.log.error("[\u7f13\u5b58\u8bbe\u7f6e\u9519\u8bef,\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6\u662f\u5426\u6709\u91cd\u590dcache.name \u6216Java\u4ee3\u7801\u8c03\u7528\u4e2dcache.name\u6df7\u6dc6][channel:{}]", (Object)cache);
        }
        if (null != (row = this.query(table, configs, conditions)) && null != cacheProvider) {
            cacheProvider.put(cache, key, (Object)row);
        }
        if (null == row && ThreadConfig.check(ClientHolder.curDataSource()).IS_RETURN_EMPTY_INSTANCE_REPLACE_NULL()) {
            row = new DataRow();
        }
        return row;
    }

    @Override
    public boolean removeCache(String channel, String src, ConfigStore configs, String ... conditions) {
        if (null != cacheProvider) {
            src = BasicUtil.compress((String)src);
            conditions = BasicUtil.compress((String[])conditions);
            String key = CacheUtil.createCacheElementKey(true, true, src, configs, conditions);
            cacheProvider.remove(channel, "SET:" + key);
            cacheProvider.remove(channel, "ROW:" + key);
            DefaultPageNavi navi = new DefaultPageNavi();
            navi.setFirstRow(0L);
            navi.setLastRow(0L);
            navi.setCalType(1);
            if (null == configs) {
                configs = new DefaultConfigStore(new String[0]);
            }
            configs.setPageNavi((PageNavi)navi);
            key = CacheUtil.createCacheElementKey(true, true, src, configs, conditions);
            cacheProvider.remove(channel, "ROW:" + key);
        }
        return true;
    }

    @Override
    public boolean clearCache(String channel) {
        if (null != cacheProvider) {
            return cacheProvider.clear(channel);
        }
        return false;
    }

    @Override
    public boolean exists(String src, ConfigStore configs, Object obj, String ... conditions) {
        String[] ps = DataSourceUtil.parseRuntime(src);
        if (null != ps[0]) {
            return ServiceProxy.service(ps[0]).exists(ps[1], configs, obj, conditions);
        }
        boolean result = false;
        src = BasicUtil.compress((String)src);
        conditions = BasicUtil.compress((String[])conditions);
        RunPrepare prepare = this.createRunPrepare(src);
        result = null != prepare.getRuntime() ? ServiceProxy.service(prepare.getRuntime()).getDao().exists(prepare, this.append(configs, obj), conditions) : this.dao.exists(prepare, this.append(configs, obj), conditions);
        return result;
    }

    @Override
    public boolean exists(String src, DataRow row) {
        if (null != row) {
            List keys = row.getPrimaryKeys();
            if (null != keys) {
                String[] conditions = new String[keys.size()];
                int idx = 0;
                for (String key : keys) {
                    conditions[idx++] = key + ":" + row.getString(key);
                }
                return this.exists(src, (ConfigStore)null, conditions);
            }
            return false;
        }
        return false;
    }

    @Override
    public long count(String src, ConfigStore configs, Object obj, String ... conditions) {
        String[] ps = DataSourceUtil.parseRuntime(src);
        if (null != ps[0]) {
            return ServiceProxy.service(ps[0]).count(ps[1], configs, obj, conditions);
        }
        long count = -1L;
        try {
            src = BasicUtil.compress((String)src);
            conditions = BasicUtil.compress((String[])conditions);
            RunPrepare prepare = this.createRunPrepare(src);
            count = null != prepare.getRuntime() ? ServiceProxy.service(prepare.getRuntime()).getDao().count(prepare, this.append(configs, obj), conditions) : this.dao.count(prepare, this.append(configs, obj), conditions);
        }
        catch (Exception e) {
            this.log.error("COUNT ERROR:" + e);
            if (ConfigTable.IS_THROW_SQL_QUERY_EXCEPTION) {
                throw e;
            }
            e.printStackTrace();
        }
        return count;
    }

    @Override
    public long insert(int batch, String dest, Object data, boolean checkPrimary, List<String> columns) {
        String[] ps = DataSourceUtil.parseRuntime(dest);
        if (null != ps[0]) {
            return ServiceProxy.service(ps[0]).insert(batch, ps[1], data, checkPrimary, columns);
        }
        return this.dao.insert(batch, dest, data, checkPrimary, columns);
    }

    @Override
    public long update(int batch, String dest, Object data, ConfigStore configs, List<String> columns) {
        String[] ps = DataSourceUtil.parseRuntime(dest);
        if (null != ps[0]) {
            return ServiceProxy.service(ps[0]).update(batch, ps[1], data, configs, columns);
        }
        dest = DataSourceUtil.parseDataSource(dest, dest);
        return this.dao.update(batch, dest, data, configs, columns);
    }

    @Override
    public long save(int batch, String dest, Object data, boolean checkPrimary, List<String> columns) {
        if (null == data) {
            return 0L;
        }
        String[] ps = DataSourceUtil.parseRuntime(dest);
        if (null != ps[0]) {
            return ServiceProxy.service(ps[0]).save(ps[1], data, checkPrimary, columns);
        }
        if (data instanceof Collection) {
            Collection datas = (Collection)data;
            long cnt = 0L;
            for (Object obj : datas) {
                cnt += this.save(dest, obj, checkPrimary, columns);
            }
            return cnt;
        }
        return this.saveObject(dest, data, checkPrimary, columns);
    }

    protected long saveObject(String dest, Object data, boolean checkPrimary, List<String> columns) {
        if (BasicUtil.isEmpty((Object)dest)) {
            dest = data instanceof DataRow || data instanceof DataSet ? DataSourceUtil.parseDataSource(dest, data) : EntityAdapterProxy.table(data.getClass(), (boolean)true);
        }
        return this.dao.save(dest, data, checkPrimary, columns);
    }

    protected long saveObject(String dest, Object data, boolean checkPrimary, String ... columns) {
        return this.saveObject(dest, data, checkPrimary, BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    @Override
    public boolean execute(Procedure procedure, String ... inputs) {
        procedure.setName(DataSourceUtil.parseDataSource(procedure.getName(), null));
        if (null != inputs) {
            for (String input : inputs) {
                procedure.addInput(input);
            }
        }
        return this.dao.execute(procedure);
    }

    @Override
    public DataSet querys(Procedure procedure, PageNavi navi, String ... inputs) {
        DataSet set;
        block5: {
            set = null;
            try {
                procedure.setName(DataSourceUtil.parseDataSource(procedure.getName()));
                if (null != inputs) {
                    for (String input : inputs) {
                        procedure.addInput(input);
                    }
                }
                set = this.dao.querys(procedure, navi);
            }
            catch (Exception e) {
                set = new DataSet();
                set.setException(e);
                this.log.error("QUERY ERROR:" + e);
                if (this.log.isWarnEnabled()) {
                    e.printStackTrace();
                }
                if (!ConfigTable.IS_THROW_SQL_QUERY_EXCEPTION) break block5;
                throw e;
            }
        }
        return set;
    }

    @Override
    public DataRow query(Procedure procedure, String ... inputs) {
        DataSet set = this.querys(procedure, 0L, 0L, inputs);
        if (set.size() > 0) {
            return set.getRow(0);
        }
        if (ThreadConfig.check(ClientHolder.curDataSource()).IS_RETURN_EMPTY_INSTANCE_REPLACE_NULL()) {
            return new DataRow();
        }
        return null;
    }

    @Override
    public long execute(int batch, String sql, List<Object> values) {
        this.dao.execute(batch, sql, values);
        return 0L;
    }

    @Override
    public long execute(String src, ConfigStore store, String ... conditions) {
        String[] ps = DataSourceUtil.parseRuntime(src);
        if (null != ps[0]) {
            return ServiceProxy.service(ps[0]).execute(ps[1], store, conditions);
        }
        long result = -1L;
        src = BasicUtil.compress((String)src);
        src = DataSourceUtil.parseDataSource(src);
        conditions = BasicUtil.compress((String[])conditions);
        RunPrepare prepare = this.createRunPrepare(src);
        if (null == prepare) {
            return result;
        }
        result = this.dao.execute(prepare, store, conditions);
        return result;
    }

    @Override
    public long delete(String dest, DataSet set, String ... columns) {
        long cnt = 0L;
        int size = set.size();
        for (int i = 0; i < size; ++i) {
            cnt += this.delete(dest, set.getRow(i), columns);
        }
        this.log.info("[delete DataSet][\u5f71\u54cd\u884c\u6570:{}]", (Object)LogUtil.format((long)cnt, (int)34));
        return cnt;
    }

    @Override
    public long delete(String dest, DataRow row, String ... columns) {
        String[] ps = DataSourceUtil.parseRuntime(dest);
        if (null != ps[0]) {
            return ServiceProxy.service(ps[0]).delete(ps[1], row, columns);
        }
        return this.dao.delete(dest, row, columns);
    }

    @Override
    public long delete(Object obj, String ... columns) {
        if (null == obj) {
            return 0L;
        }
        String dest = null;
        if (obj instanceof DataRow) {
            DataRow row = (DataRow)obj;
            dest = DataSourceUtil.parseDataSource(null, row);
            return this.dao.delete(dest, row, columns);
        }
        if (obj instanceof Collection) {
            Collection list = (Collection)obj;
            if (!list.isEmpty()) {
                Class<?> clazz = list.iterator().next().getClass();
                dest = EntityAdapterProxy.table(clazz, (boolean)true);
            }
        } else {
            dest = EntityAdapterProxy.table(obj.getClass(), (boolean)true);
        }
        if (null != dest) {
            return this.dao.delete(dest, obj, columns);
        }
        return 0L;
    }

    @Override
    public long delete(String table, String ... kvs) {
        String[] ps = DataSourceUtil.parseRuntime(table);
        if (null != ps[0]) {
            return ServiceProxy.service(ps[0]).delete(ps[1], kvs);
        }
        DataRow row = DataRow.parseArray((String[])kvs);
        row.setPrimaryKey((Collection)row.keys());
        return this.dao.delete(table, row, new String[0]);
    }

    @Override
    public <T> long deletes(int batch, String table, String key, Collection<T> values) {
        String[] ps = DataSourceUtil.parseRuntime(table);
        if (null != ps[0]) {
            return ServiceProxy.service(ps[0]).deletes(batch, ps[1], key, values);
        }
        return this.dao.deletes(batch, table, key, values);
    }

    @Override
    public <T> long deletes(int batch, String table, String key, T ... values) {
        String[] ps = DataSourceUtil.parseRuntime(table);
        if (null != ps[0]) {
            return ServiceProxy.service(ps[0]).deletes(batch, ps[1], key, values);
        }
        return this.dao.deletes(batch, table, key, values);
    }

    @Override
    public long delete(String table, ConfigStore configs, String ... conditions) {
        String[] ps = DataSourceUtil.parseRuntime(table);
        if (null != ps[0]) {
            return ServiceProxy.service(ps[0]).delete(ps[1], configs, conditions);
        }
        return this.dao.delete(table, configs, conditions);
    }

    @Override
    public int truncate(String table) {
        String[] ps = DataSourceUtil.parseRuntime(table);
        if (null != ps[0]) {
            return ServiceProxy.service(ps[0]).truncate(ps[1]);
        }
        return this.dao.truncate(table);
    }

    protected PageNavi setPageLazy(String src, ConfigStore configs, String ... conditions) {
        PageNavi navi = null;
        String lazyKey = null;
        if (null != configs && null != (navi = configs.getPageNavi()) && navi.isLazy()) {
            lazyKey = CacheUtil.createCacheElementKey(false, false, src, configs, conditions);
            navi.setLazyKey(lazyKey);
            long total = PageLazyStore.getTotal(lazyKey, navi.getLazyPeriod());
            navi.setTotalRow(total);
        }
        return navi;
    }

    protected DataSet queryFromDao(RunPrepare prepare, ConfigStore configs, String ... conditions) {
        DataSet set;
        block4: {
            set = null;
            if (ConfigTable.isSQLDebug()) {
                this.log.debug("[\u89e3\u6790SQL][src:{}]", (Object)prepare.getText());
            }
            try {
                this.setPageLazy(prepare.getText(), configs, conditions);
                set = this.dao.querys(prepare, configs, conditions);
            }
            catch (Exception e) {
                set = new DataSet();
                set.setException(e);
                if (this.log.isWarnEnabled()) {
                    e.printStackTrace();
                }
                this.log.error("QUERY ERROR:" + e);
                if (!ConfigTable.IS_THROW_SQL_QUERY_EXCEPTION) break block4;
                throw e;
            }
        }
        return set;
    }

    protected DataSet queryFromDao(String src, ConfigStore configs, String ... conditions) {
        DataSet set;
        block4: {
            set = null;
            if (ConfigTable.isSQLDebug()) {
                this.log.debug("[\u89e3\u6790SQL][src:{}]", (Object)src);
            }
            try {
                this.setPageLazy(src, configs, conditions);
                RunPrepare prepare = this.createRunPrepare(src);
                set = this.dao.querys(prepare, configs, conditions);
            }
            catch (Exception e) {
                set = new DataSet();
                set.setException(e);
                if (this.log.isWarnEnabled()) {
                    e.printStackTrace();
                }
                this.log.error("QUERY ERROR:" + e);
                if (!ConfigTable.IS_THROW_SQL_QUERY_EXCEPTION) break block4;
                throw e;
            }
        }
        return set;
    }

    protected <T> EntitySet<T> queryFromDao(String src, Class<T> clazz, ConfigStore configs, String ... conditions) {
        EntitySet<T> list;
        block4: {
            list = null;
            if (ConfigTable.isSQLDebug()) {
                this.log.debug("[\u89e3\u6790SQL][src:{}]", clazz);
            }
            try {
                this.setPageLazy(src, configs, conditions);
                RunPrepare prepare = this.createRunPrepare(src);
                list = this.dao.selects(prepare, clazz, configs, conditions);
            }
            catch (Exception e) {
                list = new EntitySet<T>();
                if (this.log.isWarnEnabled()) {
                    e.printStackTrace();
                }
                this.log.error("QUERY ERROR:" + e);
                if (!ConfigTable.IS_THROW_SQL_QUERY_EXCEPTION) break block4;
                throw e;
            }
        }
        return list;
    }

    protected <T> EntitySet<T> selectFromDao(Class<T> clazz, ConfigStore configs, String ... conditions) {
        EntitySet<T> list;
        block4: {
            list = null;
            if (ConfigTable.isSQLDebug()) {
                this.log.debug("[\u89e3\u6790SQL][src:{}]", clazz);
            }
            try {
                this.setPageLazy(clazz.getName(), configs, conditions);
                list = this.dao.selects(null, clazz, configs, conditions);
            }
            catch (Exception e) {
                list = new EntitySet<T>();
                if (this.log.isWarnEnabled()) {
                    e.printStackTrace();
                }
                this.log.error("QUERY ERROR:" + e);
                if (!ConfigTable.IS_THROW_SQL_QUERY_EXCEPTION) break block4;
                throw e;
            }
        }
        return list;
    }

    @Override
    public ConfigStore condition() {
        return new DefaultConfigStore(new String[0]);
    }

    protected String parsePrimaryKey(String src, List<String> pks) {
        if (src.endsWith(">")) {
            int fr = src.lastIndexOf("<");
            int to = src.lastIndexOf(">");
            if (fr != -1) {
                String[] tmps;
                String pkstr = src.substring(fr + 1, to);
                src = src.substring(0, fr);
                for (String tmp : tmps = pkstr.split(",")) {
                    pks.add(tmp);
                    if (!ConfigTable.isSQLDebug()) continue;
                    this.log.debug("[\u89e3\u6790SQL\u4e3b\u952e] [KEY:{}]", (Object)tmp);
                }
            }
        }
        return src;
    }

    protected RunPrepare createRunPrepare(String src) {
        RunPrepare prepare = null;
        src = src.trim();
        ArrayList<String> pks = new ArrayList<String>();
        if (src.startsWith("${") && src.endsWith("}")) {
            if (ConfigTable.isSQLDebug()) {
                this.log.debug("[\u89e3\u6790SQL\u7c7b\u578b] [\u7c7b\u578b:{JAVA\u5b9a\u4e49}] [src:{}]", (Object)src);
            }
            src = src.substring(2, src.length() - 1);
            src = DataSourceUtil.parseDataSource(src);
            src = this.parsePrimaryKey(src, pks);
            prepare = new DefaultTextPrepare(src);
        } else {
            src = DataSourceUtil.parseDataSource(src);
            if ((src = this.parsePrimaryKey(src, pks)).replace("\n", "").replace("\r", "").trim().matches("^[a-zA-Z]+\\s+.+")) {
                if (ConfigTable.isSQLDebug()) {
                    this.log.debug("[\u89e3\u6790SQL\u7c7b\u578b] [\u7c7b\u578b:JAVA\u5b9a\u4e49] [src:{}]", (Object)src);
                }
                prepare = new DefaultTextPrepare(src);
            } else if (RegularUtil.match((String)src, (String)"(\\.|\\S)*\\S+:\\S+")) {
                if (ConfigTable.isSQLDebug()) {
                    this.log.debug("[\u89e3\u6790SQL\u7c7b\u578b] [\u7c7b\u578b:XML\u5b9a\u4e49] [src:{}]", (Object)src);
                }
                if (null == (prepare = DefaultSQLStore.parseSQL(src))) {
                    this.log.error("[\u89e3\u6790SQL\u7c7b\u578b][XML\u89e3\u6790\u5931\u8d25][src:{}]", (Object)src);
                }
            } else {
                if (ConfigTable.isSQLDebug()) {
                    this.log.debug("[\u89e3\u6790SQL\u7c7b\u578b] [\u7c7b\u578b:auto] [src:{}]", (Object)src);
                }
                prepare = new DefaultTablePrepare();
                prepare.setDataSource(src);
            }
        }
        if (null != prepare && pks.size() > 0) {
            prepare.setPrimaryKey(pks);
        }
        return prepare;
    }

    protected DataSet queryFromCache(String cache, String src, ConfigStore configs, String ... conditions) {
        if (ConfigTable.IS_DEBUG && this.log.isWarnEnabled()) {
            this.log.debug("[cache from][cache:{}][src:{}]", (Object)cache, (Object)src);
        }
        DataSet set = null;
        String key = "SET:";
        if (cache.contains(">")) {
            String[] tmp = cache.split(">");
            cache = tmp[0];
        }
        if (cache.contains(":")) {
            String[] ks = BeanUtil.parseKeyValue((String)cache);
            cache = ks[0];
            key = key + ks[1] + ":";
        }
        key = key + CacheUtil.createCacheElementKey(true, true, src, configs, conditions);
        RunPrepare prepare = this.createRunPrepare(src);
        if (null != cacheProvider) {
            CacheElement cacheElement = cacheProvider.get(cache, key);
            if (null != cacheElement && null != cacheElement.getValue()) {
                Object cacheValue = cacheElement.getValue();
                if (cacheValue instanceof DataSet) {
                    set = (DataSet)cacheValue;
                    set.setIsFromCache(true);
                } else {
                    this.log.error("[\u7f13\u5b58\u8bbe\u7f6e\u9519\u8bef,\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6\u662f\u5426\u6709\u91cd\u590dcache.name \u6216Java\u4ee3\u7801\u8c03\u7528\u4e2dcache.name\u6df7\u6dc6][channel:{}]", (Object)cache);
                }
                long age = (System.currentTimeMillis() - cacheElement.getCreateTime()) / 1000L;
                final int _max = cacheElement.getExpires();
                if ((double)age > (double)_max * 0.9) {
                    if (ConfigTable.IS_DEBUG && this.log.isWarnEnabled()) {
                        this.log.debug("[\u7f13\u5b58\u5373\u5c06\u5230\u671f\u63d0\u524d\u5237\u65b0][src:{}] [\u751f\u5b58:{}/{}]", new Object[]{src, age, _max});
                    }
                    final String _key = key;
                    final String _cache = cache;
                    final RunPrepare _sql = prepare;
                    final ConfigStore _configs = configs;
                    final String[] _conditions = conditions;
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            CacheUtil.start(_key, _max / 10);
                            DataSet newSet = DefaultService.this.dao.querys(_sql, _configs, _conditions);
                            cacheProvider.put(_cache, _key, (Object)newSet);
                            CacheUtil.stop(_key, _max / 10);
                        }
                    }).start();
                }
            } else {
                this.setPageLazy(src, configs, conditions);
                set = this.dao.querys(prepare, configs, conditions);
                cacheProvider.put(cache, key, (Object)set);
            }
        }
        return set;
    }

    private ConfigStore append(ConfigStore configs, Object entity) {
        block7: {
            if (null == configs) {
                configs = new DefaultConfigStore(new String[0]);
            }
            if (null == entity) break block7;
            if (entity instanceof Map) {
                Map map = (Map)entity;
                for (Object key : map.keySet()) {
                    Object value = map.get(key);
                    if (value instanceof Collection) {
                        configs.ands(key.toString(), value);
                        continue;
                    }
                    configs.and(key.toString(), value);
                }
            } else {
                List fields = ClassUtil.getFields(entity.getClass(), (boolean)false, (boolean)false);
                for (Field field : fields) {
                    Object value = BeanUtil.getFieldValue((Object)entity, (Field)field);
                    if (!BasicUtil.isNotEmpty((boolean)true, (Object)value)) continue;
                    String key = field.getName();
                    key = EntityAdapterProxy.column(entity.getClass(), (Field)field, (boolean)true);
                    if (BasicUtil.isEmpty((Object)key)) continue;
                    if (value instanceof Collection) {
                        configs.ands(key, value);
                        continue;
                    }
                    configs.and(key, value);
                }
            }
        }
        return configs;
    }

    @Override
    public List<String> tables(String catalog, String schema, String name, String types) {
        LinkedHashMap tables = this.metadata.tables(catalog, schema, name, types);
        ArrayList<String> list = new ArrayList<String>();
        for (Table table : tables.values()) {
            list.add(table.getName());
        }
        return list;
    }

    @Override
    public List<String> views(boolean greedy, String catalog, String schema, String name, String types) {
        LinkedHashMap views = this.metadata.views(greedy, catalog, schema, name, types);
        ArrayList<String> list = new ArrayList<String>();
        for (View view : views.values()) {
            list.add(view.getName());
        }
        return list;
    }

    @Override
    public List<String> mtables(boolean greedy, String catalog, String schema, String name, String types) {
        LinkedHashMap tables = this.metadata.mtables(greedy, catalog, schema, name, types);
        ArrayList<String> list = new ArrayList<String>();
        for (MasterTable table : tables.values()) {
            list.add(table.getName());
        }
        return list;
    }

    @Override
    public List<String> columns(boolean greedy, Table table) {
        LinkedHashMap columns = this.metadata.columns(greedy, table);
        ArrayList<String> list = new ArrayList<String>();
        for (Column column : columns.values()) {
            list.add(column.getName());
        }
        return list;
    }

    @Override
    public List<String> tags(boolean greedy, Table table) {
        LinkedHashMap tags = this.metadata.tags(greedy, table);
        ArrayList<String> list = new ArrayList<String>();
        for (Tag tag : tags.values()) {
            list.add(tag.getName());
        }
        return list;
    }

    @Override
    public boolean save(Table table) throws Exception {
        return this.ddl.save(table);
    }

    @Override
    public boolean save(Column column) throws Exception {
        return this.ddl.save(column);
    }

    @Override
    public boolean drop(Table table) throws Exception {
        return this.ddl.drop(table);
    }

    @Override
    public boolean drop(Column column) throws Exception {
        return this.ddl.drop(column);
    }

    @Override
    public AnylineService.MetaDataService metadata() {
        return this.metadata;
    }

    @Override
    public AnylineService.DDLService ddl() {
        return this.ddl;
    }
}

