/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.service;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.anyline.dao.AnylineDao;
import org.anyline.data.handler.EntityHandler;
import org.anyline.data.handler.StreamHandler;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.param.init.DefaultConfigStore;
import org.anyline.data.prepare.RunPrepare;
import org.anyline.data.util.DataSourceUtil;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.entity.DefaultPageNavi;
import org.anyline.entity.EntitySet;
import org.anyline.entity.PageNavi;
import org.anyline.metadata.Column;
import org.anyline.metadata.Constraint;
import org.anyline.metadata.Database;
import org.anyline.metadata.ForeignKey;
import org.anyline.metadata.Function;
import org.anyline.metadata.Index;
import org.anyline.metadata.MasterTable;
import org.anyline.metadata.PartitionTable;
import org.anyline.metadata.PrimaryKey;
import org.anyline.metadata.Procedure;
import org.anyline.metadata.Table;
import org.anyline.metadata.Tag;
import org.anyline.metadata.Trigger;
import org.anyline.metadata.View;
import org.anyline.util.BeanUtil;

public interface AnylineService<E> {
    public AnylineService datasource(String var1);

    public AnylineService datasource();

    public AnylineService setDataSource(String var1);

    public AnylineService setDataSource(String var1, boolean var2);

    public AnylineService setDefaultDataSource();

    public AnylineService recoverDataSource();

    public String getDataSource();

    public AnylineService setDao(AnylineDao var1);

    public AnylineDao getDao();

    public long insert(int var1, String var2, Object var3, boolean var4, List<String> var5);

    default public long insert(int batch, Object data, boolean checkPrimary, String ... columns) {
        return this.insert(batch, null, data, checkPrimary, BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long insert(int batch, String dest, Object data, boolean checkPrimary, String ... columns) {
        return this.insert(batch, dest, data, checkPrimary, BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long insert(int batch, Object data, String ... columns) {
        return this.insert(batch, null, data, false, columns);
    }

    default public long insert(int batch, String dest, Object data, String ... columns) {
        return this.insert(batch, dest, data, false, columns);
    }

    default public long insert(String dest, Object data, boolean checkPrimary, List<String> columns) {
        return this.insert(0, dest, data, checkPrimary, columns);
    }

    default public long insert(String dest, Object data, boolean checkPrimary, String ... columns) {
        return this.insert(dest, data, checkPrimary, BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long insert(Object data, boolean checkPrimary, String ... columns) {
        return this.insert(null, data, checkPrimary, BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long insert(Object data, String ... columns) {
        return this.insert(null, data, false, columns);
    }

    default public long insert(String dest, Object data, String ... columns) {
        return this.insert(dest, data, false, columns);
    }

    public long update(int var1, String var2, Object var3, ConfigStore var4, List<String> var5);

    default public long update(int batch, String dest, Object data, String ... columns) {
        return this.update(batch, dest, data, null, BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long update(int batch, String dest, Object data, ConfigStore configs, String ... columns) {
        return this.update(batch, dest, data, configs, BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long update(int batch, Object data, String ... columns) {
        return this.update(batch, null, data, null, BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long update(int batch, Object data, ConfigStore configs, String ... columns) {
        return this.update(batch, null, data, configs, BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long update(String dest, Object data, ConfigStore configs, List<String> columns) {
        return this.update(0, dest, data, configs, columns);
    }

    default public long update(String dest, Object data, String ... columns) {
        return this.update(dest, data, null, BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long update(String dest, Object data, ConfigStore configs, String ... columns) {
        return this.update(dest, data, configs, BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long update(Object data, String ... columns) {
        return this.update(null, data, null, BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long update(Object data, ConfigStore configs, String ... columns) {
        return this.update(null, data, configs, BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    public long save(int var1, String var2, Object var3, boolean var4, List<String> var5);

    default public long save(int batch, String dest, Object data, boolean checkPrimary, String ... columns) {
        return this.save(batch, dest, data, checkPrimary, BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long save(int batch, Object data, boolean checkPrimary, String ... columns) {
        return this.save(batch, null, data, checkPrimary, columns);
    }

    default public long save(int batch, Object data, String ... columns) {
        return this.save(batch, null, data, false, columns);
    }

    default public long save(int batch, String dest, Object data, String ... columns) {
        return this.save(batch, dest, data, false, columns);
    }

    default public long save(String dest, Object data, boolean checkPrimary, List<String> columns) {
        return this.save(0, dest, data, checkPrimary, columns);
    }

    default public long save(String dest, Object data, boolean checkPrimary, String ... columns) {
        return this.save(dest, data, checkPrimary, BeanUtil.array2list((Object[][])new String[][]{columns}));
    }

    default public long save(Object data, boolean checkPrimary, String ... columns) {
        return this.save(null, data, checkPrimary, columns);
    }

    default public long save(Object data, String ... columns) {
        return this.save(null, data, false, columns);
    }

    default public long save(String dest, Object data, String ... columns) {
        return this.save(dest, data, false, columns);
    }

    public DataSet querys(String var1, ConfigStore var2, Object var3, String ... var4);

    default public DataSet querys(String src, long first, long last, ConfigStore configs, Object obj, String ... conditions) {
        DefaultPageNavi navi = new DefaultPageNavi();
        navi.scope(first, last);
        configs.setPageNavi((PageNavi)navi);
        return this.querys(src, configs, obj, conditions);
    }

    default public DataSet querys(String src, Object obj, String ... conditions) {
        return this.querys(src, (ConfigStore)null, obj, conditions);
    }

    default public void querys(String src, StreamHandler handler, Object obj, String ... conditions) {
        DefaultConfigStore configs = new DefaultConfigStore(new String[0]);
        configs.stream(handler);
        this.querys(src, (ConfigStore)configs, obj, conditions);
    }

    default public DataSet querys(String src, PageNavi navi, Object obj, String ... conditions) {
        DefaultConfigStore configs = new DefaultConfigStore(new String[0]);
        configs.setPageNavi(navi);
        return this.querys(src, (ConfigStore)configs, obj, conditions);
    }

    default public DataSet querys(String src, long first, long last, Object obj, String ... conditions) {
        DefaultConfigStore configs = new DefaultConfigStore(first, last);
        return this.querys(src, (ConfigStore)configs, obj, conditions);
    }

    default public DataSet querys(String src, ConfigStore configs, String ... conditions) {
        return this.querys(src, configs, (Object)null, conditions);
    }

    default public DataSet querys(String src, long first, long last, ConfigStore configs, String ... conditions) {
        DefaultPageNavi navi = new DefaultPageNavi();
        if (null == configs) {
            configs = new DefaultConfigStore(new String[0]);
        }
        navi.scope(first, last);
        configs.setPageNavi((PageNavi)navi);
        return this.querys(src, configs, conditions);
    }

    default public DataSet querys(String src, String ... conditions) {
        return this.querys(src, (Object)null, conditions);
    }

    default public void querys(String src, StreamHandler handler, String ... conditions) {
        DefaultConfigStore configs = new DefaultConfigStore(new String[0]);
        configs.stream(handler);
        this.querys(src, (ConfigStore)configs, conditions);
    }

    default public DataSet querys(String src, PageNavi navi, String ... conditions) {
        return this.querys(src, navi, (Object)null, conditions);
    }

    default public DataSet querys(String src, long first, long last, String ... conditions) {
        return this.querys(src, first, last, (ConfigStore)null, conditions);
    }

    public DataRow query(RunPrepare var1, ConfigStore var2, Object var3, String ... var4);

    public DataRow query(String var1, ConfigStore var2, Object var3, String ... var4);

    default public DataRow query(String src, Object obj, String ... conditions) {
        return this.query(src, null, obj, conditions);
    }

    default public DataRow query(String src, ConfigStore configs, String ... conditions) {
        return this.query(src, configs, (Object)null, conditions);
    }

    default public DataRow query(String src, String ... conditions) {
        return this.query(src, (ConfigStore)null, conditions);
    }

    default public DataRow query(RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return this.query(prepare, configs, (Object)null, conditions);
    }

    default public DataRow query(RunPrepare prepare, Object obj, String ... conditions) {
        return this.query(prepare, null, obj, conditions);
    }

    default public DataRow query(RunPrepare prepare, String ... conditions) {
        return this.query(prepare, null, (Object)null, conditions);
    }

    public BigDecimal sequence(boolean var1, String var2);

    default public BigDecimal sequence(String name) {
        return this.sequence(true, name);
    }

    public DataRow sequences(boolean var1, String ... var2);

    default public DataRow sequences(String ... names) {
        return this.sequences(true, names);
    }

    public <T> EntitySet<T> selects(String var1, Class<T> var2, ConfigStore var3, T var4, String ... var5);

    default public <T> EntitySet<T> selects(String src, Class<T> clazz, PageNavi navi, T entity, String ... conditions) {
        DefaultConfigStore configs = new DefaultConfigStore(new String[0]);
        configs.setPageNavi(navi);
        return this.selects(src, clazz, (ConfigStore)configs, entity, conditions);
    }

    default public <T> EntitySet<T> selects(String src, Class<T> clazz, T entity, String ... conditions) {
        return this.selects(src, clazz, (ConfigStore)null, entity, conditions);
    }

    default public <T> EntitySet<T> selects(String src, Class<T> clazz, EntityHandler<T> handler, T entity, String ... conditions) {
        DefaultConfigStore configs = new DefaultConfigStore(new String[0]);
        configs.stream(handler);
        return this.selects(src, clazz, (ConfigStore)configs, entity, conditions);
    }

    default public <T> EntitySet<T> selects(String src, Class<T> clazz, long first, long last, T entity, String ... conditions) {
        DefaultConfigStore configs = new DefaultConfigStore(first, last);
        return this.selects(src, clazz, (ConfigStore)configs, entity, conditions);
    }

    default public <T> EntitySet<T> selects(String src, Class<T> clazz, ConfigStore configs, String ... conditions) {
        return this.selects(src, clazz, configs, (T)null, conditions);
    }

    default public <T> EntitySet<T> selects(String src, Class<T> clazz, PageNavi navi, String ... conditions) {
        return this.selects(src, clazz, navi, (T)null, conditions);
    }

    default public <T> EntitySet<T> selects(String src, Class<T> clazz, String ... conditions) {
        return this.selects(src, clazz, (T)null, conditions);
    }

    default public <T> EntitySet<T> selects(String src, Class<T> clazz, EntityHandler<T> handler, String ... conditions) {
        DefaultConfigStore configs = new DefaultConfigStore(new String[0]);
        configs.stream(handler);
        return this.selects(src, clazz, (ConfigStore)configs, conditions);
    }

    default public <T> EntitySet<T> selects(String src, Class<T> clazz, long first, long last, String ... conditions) {
        return this.selects(src, clazz, first, last, (T)null, conditions);
    }

    public <T> T select(String var1, Class<T> var2, ConfigStore var3, T var4, String ... var5);

    default public <T> T select(String src, Class<T> clazz, T entity, String ... conditions) {
        return this.select(src, clazz, (ConfigStore)null, entity, conditions);
    }

    default public <T> T select(String src, Class<T> clazz, ConfigStore configs, String ... conditions) {
        return this.select(src, clazz, configs, (T)null, conditions);
    }

    default public <T> T select(String src, Class<T> clazz, String ... conditions) {
        return this.select(src, clazz, (T)null, conditions);
    }

    public <T> EntitySet<T> selects(Class<T> var1, ConfigStore var2, T var3, String ... var4);

    default public <T> EntitySet<T> selects(Class<T> clazz, PageNavi navi, T entity, String ... conditions) {
        DefaultConfigStore configs = new DefaultConfigStore(new String[0]);
        configs.setPageNavi(navi);
        return this.selects(clazz, (ConfigStore)configs, entity, conditions);
    }

    default public <T> EntitySet<T> selects(Class<T> clazz, T entity, String ... conditions) {
        return this.selects(clazz, (ConfigStore)null, entity, conditions);
    }

    default public <T> EntitySet<T> selects(Class<T> clazz, EntityHandler<T> handler, T entity, String ... conditions) {
        DefaultConfigStore configs = new DefaultConfigStore(new String[0]);
        configs.stream(handler);
        return this.selects(clazz, (ConfigStore)configs, entity, conditions);
    }

    default public <T> EntitySet<T> selects(Class<T> clazz, long first, long last, T entity, String ... conditions) {
        DefaultConfigStore configs = new DefaultConfigStore(first, last);
        return this.selects(clazz, (ConfigStore)configs, entity, conditions);
    }

    public <T> T select(Class<T> var1, ConfigStore var2, T var3, String ... var4);

    default public <T> T select(Class<T> clazz, T entity, String ... conditions) {
        return this.select(clazz, (ConfigStore)null, entity, conditions);
    }

    default public <T> EntitySet<T> selects(Class<T> clazz, ConfigStore configs, String ... conditions) {
        return this.selects(clazz, configs, (T)null, conditions);
    }

    default public <T> EntitySet<T> selects(Class<T> clazz, PageNavi navi, String ... conditions) {
        return this.selects(clazz, navi, (T)null, conditions);
    }

    default public <T> EntitySet<T> selects(Class<T> clazz, String ... conditions) {
        return this.selects(clazz, (T)null, conditions);
    }

    default public <T> EntitySet<T> selects(Class<T> clazz, EntityHandler<T> handler, String ... conditions) {
        DefaultConfigStore configs = new DefaultConfigStore(new String[0]);
        configs.stream(handler);
        return this.selects(clazz, (ConfigStore)configs, conditions);
    }

    default public <T> EntitySet<T> selects(Class<T> clazz, long first, long last, String ... conditions) {
        return this.selects(clazz, first, last, (T)null, conditions);
    }

    default public <T> T select(Class<T> clazz, ConfigStore configs, String ... conditions) {
        return this.select(clazz, configs, (T)null, conditions);
    }

    default public <T> T select(Class<T> clazz, String ... conditions) {
        return this.select(clazz, (T)null, conditions);
    }

    public EntitySet<E> gets(ConfigStore var1, String ... var2);

    default public EntitySet<E> gets(PageNavi navi, String ... conditions) {
        return this.gets(new DefaultConfigStore(new String[0]).setPageNavi(navi), conditions);
    }

    default public EntitySet<E> gets(String ... conditions) {
        return this.gets((ConfigStore)null, conditions);
    }

    default public EntitySet<E> gets(EntityHandler<E> handler, String ... conditions) {
        DefaultConfigStore configs = new DefaultConfigStore(new String[0]);
        configs.stream(handler);
        return this.gets(configs, conditions);
    }

    default public EntitySet<E> gets(long first, long last, String ... conditions) {
        return this.gets(new DefaultConfigStore(first, last), conditions);
    }

    public E get(ConfigStore var1, String ... var2);

    default public E get(String ... conditions) {
        return this.get((ConfigStore)null, conditions);
    }

    public List<Map<String, Object>> maps(String var1, ConfigStore var2, Object var3, String ... var4);

    default public void maps(String src, StreamHandler handler, Object obj, String ... conditions) {
        DefaultConfigStore configs = new DefaultConfigStore(new String[0]);
        configs.stream(handler);
        this.maps(src, (ConfigStore)configs, obj, conditions);
    }

    default public List<Map<String, Object>> maps(String src, Object obj, String ... conditions) {
        return this.maps(src, (ConfigStore)null, obj, conditions);
    }

    default public List<Map<String, Object>> maps(String src, long first, long last, Object obj, String ... conditions) {
        return this.maps(src, (ConfigStore)new DefaultConfigStore(first, last), obj, conditions);
    }

    default public List<Map<String, Object>> maps(String src, ConfigStore configs, String ... conditions) {
        return this.maps(src, configs, (Object)null, conditions);
    }

    default public List<Map<String, Object>> maps(String src, String ... conditions) {
        return this.maps(src, (ConfigStore)null, (Object)null, conditions);
    }

    default public void maps(String src, StreamHandler handler, String ... conditions) {
        DefaultConfigStore configs = new DefaultConfigStore(new String[0]);
        configs.stream(handler);
        this.maps(src, (ConfigStore)configs, (Object)null, conditions);
    }

    default public List<Map<String, Object>> maps(String src, PageNavi navi, String ... conditions) {
        return this.maps(src, new DefaultConfigStore(new String[0]).setPageNavi(navi), (Object)null, conditions);
    }

    default public List<Map<String, Object>> maps(String src, long first, long last, String ... conditions) {
        return this.maps(src, first, last, (Object)null, conditions);
    }

    public List<String> column2param(String var1);

    public DataSet caches(String var1, String var2, ConfigStore var3, Object var4, String ... var5);

    default public DataSet caches(String cache, String src, long first, long last, ConfigStore configs, Object obj, String ... conditions) {
        DefaultPageNavi navi = new DefaultPageNavi();
        navi.scope(first, last);
        configs.setPageNavi((PageNavi)navi);
        return this.caches(cache, src, configs, obj, conditions);
    }

    default public DataSet caches(String cache, String src, Object obj, String ... conditions) {
        return this.caches(cache, src, null, obj, conditions);
    }

    default public DataSet caches(String cache, String src, long first, long last, Object obj, String ... conditions) {
        DefaultConfigStore configs = new DefaultConfigStore(first, last);
        return this.caches(cache, src, (ConfigStore)configs, obj, conditions);
    }

    public DataRow cache(String var1, String var2, ConfigStore var3, Object var4, String ... var5);

    default public DataRow cache(String cache, String src, Object obj, String ... conditions) {
        return this.cache(cache, src, null, obj, conditions);
    }

    default public DataSet caches(String cache, String src, ConfigStore configs, String ... conditions) {
        return this.caches(cache, src, configs, (Object)null, conditions);
    }

    default public DataSet caches(String cache, String src, long first, long last, ConfigStore configs, String ... conditions) {
        DefaultPageNavi navi = new DefaultPageNavi();
        navi.scope(first, last);
        configs.setPageNavi((PageNavi)navi);
        return this.caches(cache, src, configs, conditions);
    }

    default public DataSet caches(String cache, String src, String ... conditions) {
        return this.caches(cache, src, null, (Object)null, conditions);
    }

    default public DataSet caches(String cache, String src, long first, long last, String ... conditions) {
        return this.caches(cache, src, first, last, (ConfigStore)null, conditions);
    }

    default public DataRow cache(String cache, String src, ConfigStore configs, String ... conditions) {
        return this.cache(cache, src, configs, (Object)null, conditions);
    }

    default public DataRow cache(String cache, String src, String ... conditions) {
        return this.cache(cache, src, null, (Object)null, conditions);
    }

    public DataSet querys(RunPrepare var1, ConfigStore var2, Object var3, String ... var4);

    default public DataSet querys(RunPrepare prepare, long first, long last, ConfigStore configs, Object obj, String ... conditions) {
        DefaultPageNavi navi = new DefaultPageNavi();
        navi.scope(first, last);
        configs.setPageNavi((PageNavi)navi);
        return this.querys(prepare, configs, obj, conditions);
    }

    default public DataSet querys(RunPrepare prepare, Object obj, String ... conditions) {
        return this.querys(prepare, (ConfigStore)null, obj, conditions);
    }

    default public void querys(RunPrepare prepare, StreamHandler handler, Object obj, String ... conditions) {
        DefaultConfigStore configs = new DefaultConfigStore(new String[0]);
        configs.stream(handler);
        this.querys(prepare, (ConfigStore)configs, obj, conditions);
    }

    default public DataSet querys(RunPrepare prepare, long first, long last, Object obj, String ... conditions) {
        DefaultConfigStore configs = new DefaultConfigStore(first, last);
        return this.querys(prepare, (ConfigStore)configs, obj, conditions);
    }

    default public DataSet querys(RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return this.querys(prepare, configs, (Object)null, conditions);
    }

    default public DataSet querys(RunPrepare prepare, String ... conditions) {
        return this.querys(prepare, (ConfigStore)null, (Object)null, conditions);
    }

    default public void querys(RunPrepare prepare, StreamHandler handler, String ... conditions) {
        DefaultConfigStore configs = new DefaultConfigStore(new String[0]);
        configs.stream(handler);
        this.querys(prepare, (ConfigStore)configs, (Object)null, conditions);
    }

    default public DataSet querys(RunPrepare prepare, long first, long last, String ... conditions) {
        return this.querys(prepare, first, last, (Object)null, conditions);
    }

    public DataSet caches(String var1, RunPrepare var2, ConfigStore var3, Object var4, String ... var5);

    default public DataSet caches(String cache, RunPrepare prepare, Object obj, String ... conditions) {
        return this.caches(cache, prepare, null, obj, conditions);
    }

    default public DataSet caches(String cache, RunPrepare prepare, long first, long last, Object obj, String ... conditions) {
        DefaultConfigStore configs = new DefaultConfigStore(first, last);
        return this.caches(cache, prepare, (ConfigStore)configs, obj, conditions);
    }

    public DataRow cache(String var1, RunPrepare var2, ConfigStore var3, Object var4, String ... var5);

    default public DataRow cache(String cache, RunPrepare prepare, Object obj, String ... conditions) {
        return this.cache(cache, prepare, null, obj, conditions);
    }

    default public DataSet caches(String cache, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return this.caches(cache, prepare, configs, (Object)null, conditions);
    }

    default public DataSet caches(String cache, RunPrepare prepare, String ... conditions) {
        return this.caches(cache, prepare, null, (Object)null, conditions);
    }

    default public DataSet caches(String cache, RunPrepare prepare, long first, long last, String ... conditions) {
        return this.caches(cache, prepare, first, last, (Object)null, conditions);
    }

    default public DataRow cache(String cache, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        return this.cache(cache, prepare, configs, (Object)null, conditions);
    }

    default public DataRow cache(String cache, RunPrepare prepare, long first, long last, ConfigStore configs, String ... conditions) {
        DefaultPageNavi navi = new DefaultPageNavi();
        navi.scope(first, last);
        configs.setPageNavi((PageNavi)navi);
        return this.cache(cache, prepare, configs, conditions);
    }

    default public DataRow cache(String cache, RunPrepare prepare, String ... conditions) {
        return this.cache(cache, prepare, null, (Object)null, conditions);
    }

    public boolean removeCache(String var1, String var2, ConfigStore var3, String ... var4);

    default public boolean removeCache(String channel, String src, String ... conditions) {
        return this.removeCache(channel, src, (ConfigStore)null, conditions);
    }

    default public boolean removeCache(String channel, String src, long first, long last, String ... conditions) {
        return this.removeCache(channel, src, new DefaultConfigStore(first, last), conditions);
    }

    public boolean clearCache(String var1);

    public boolean exists(String var1, ConfigStore var2, Object var3, String ... var4);

    default public boolean exists(String src, Object obj, String ... conditions) {
        return this.exists(src, null, obj, conditions);
    }

    default public boolean exists(String src, ConfigStore configs, String ... conditions) {
        return this.exists(src, configs, (Object)null, conditions);
    }

    default public boolean exists(String src, String ... conditions) {
        return this.exists(src, null, (Object)null, conditions);
    }

    public boolean exists(String var1, DataRow var2);

    default public boolean exists(DataRow row) {
        return this.exists(null, row);
    }

    public long count(String var1, ConfigStore var2, Object var3, String ... var4);

    default public long count(String src, Object obj, String ... conditions) {
        return this.count(src, null, obj, conditions);
    }

    default public long count(String src, ConfigStore configs, String ... conditions) {
        return this.count(src, configs, (Object)null, conditions);
    }

    default public long count(String src, String ... conditions) {
        return this.count(src, null, (Object)null, conditions);
    }

    public boolean execute(Procedure var1, String ... var2);

    public long execute(String var1, ConfigStore var2, String ... var3);

    default public long execute(String src, String ... conditions) {
        return this.execute(src, (ConfigStore)null, conditions);
    }

    public long execute(int var1, String var2, List<Object> var3);

    default public boolean executeProcedure(String procedure, String ... inputs) {
        Procedure proc = new Procedure();
        proc.setName(procedure);
        for (String input : inputs) {
            proc.addInput(input);
        }
        return this.execute(proc, new String[0]);
    }

    public DataSet querys(Procedure var1, PageNavi var2, String ... var3);

    default public DataSet querysProcedure(String procedure, long first, long last, String ... inputs) {
        DefaultPageNavi navi = new DefaultPageNavi();
        navi.scope(first, last);
        return this.querysProcedure(procedure, (PageNavi)navi, inputs);
    }

    default public DataSet querysProcedure(String procedure, PageNavi navi, String ... inputs) {
        Procedure proc = new Procedure();
        proc.setName(procedure);
        if (null != inputs) {
            for (String input : inputs) {
                proc.addInput(input);
            }
        }
        return this.querys(proc, navi, new String[0]);
    }

    default public DataSet querysProcedure(String procedure, String ... inputs) {
        return this.querysProcedure(procedure, (PageNavi)null, inputs);
    }

    default public DataSet querys(Procedure procedure, String ... inputs) {
        return this.querys(procedure, (PageNavi)null, inputs);
    }

    default public DataSet querys(Procedure procedure, long first, long last, String ... inputs) {
        DefaultPageNavi navi = new DefaultPageNavi();
        navi.scope(first, last);
        return this.querys(procedure, (PageNavi)navi, inputs);
    }

    default public DataRow queryProcedure(String procedure, String ... inputs) {
        Procedure proc = new Procedure();
        proc.setName(procedure);
        return this.query(procedure, inputs);
    }

    public DataRow query(Procedure var1, String ... var2);

    public long delete(String var1, ConfigStore var2, String ... var3);

    public long delete(String var1, DataSet var2, String ... var3);

    default public long delete(DataSet set, String ... columns) {
        String dest = DataSourceUtil.parseDataSource(null, set);
        return this.delete(dest, set, columns);
    }

    public long delete(String var1, DataRow var2, String ... var3);

    public long delete(Object var1, String ... var2);

    public long delete(String var1, String ... var2);

    public <T> long deletes(int var1, String var2, String var3, Collection<T> var4);

    default public <T> long deletes(String table, String key, Collection<T> values) {
        return this.deletes(0, table, key, values);
    }

    public <T> long deletes(int var1, String var2, String var3, T ... var4);

    default public <T> long deletes(String table, String key, T ... values) {
        return this.deletes(0, table, key, values);
    }

    public int truncate(String var1);

    public List<String> tables(String var1, String var2, String var3, String var4);

    default public List<String> tables(String schema, String name, String types) {
        return this.tables(null, schema, name, types);
    }

    default public List<String> tables(String name, String types) {
        return this.tables(null, null, name, types);
    }

    default public List<String> tables(String types) {
        return this.tables(null, null, null, types);
    }

    default public List<String> tables() {
        return this.tables(null);
    }

    public List<String> views(boolean var1, String var2, String var3, String var4, String var5);

    default public List<String> views(boolean greedy, String schema, String name, String types) {
        return this.views(greedy, null, schema, name, types);
    }

    default public List<String> views(boolean greedy, String name, String types) {
        return this.views(greedy, null, null, name, types);
    }

    default public List<String> views(boolean greedy, String types) {
        return this.views(greedy, null, null, null, types);
    }

    default public List<String> views(boolean greedy) {
        return this.views(greedy, null);
    }

    default public List<String> views(String catalog, String schema, String name, String types) {
        return this.views(false, catalog, schema, name, types);
    }

    default public List<String> views(String schema, String name, String types) {
        return this.views(false, null, schema, name, types);
    }

    default public List<String> views(String name, String types) {
        return this.views(false, null, null, name, types);
    }

    default public List<String> views(String types) {
        return this.views(false, null, null, null, types);
    }

    default public List<String> views() {
        return this.views(false, null);
    }

    public List<String> mtables(boolean var1, String var2, String var3, String var4, String var5);

    default public List<String> mtables(boolean greedy, String schema, String name, String types) {
        return this.mtables(greedy, null, schema, name, types);
    }

    default public List<String> mtables(boolean greedy, String name, String types) {
        return this.mtables(greedy, null, null, name, types);
    }

    default public List<String> mtables(boolean greedy, String types) {
        return this.mtables(greedy, null, null, null, types);
    }

    default public List<String> mtables(boolean greedy) {
        return this.mtables(greedy, "STABLE");
    }

    default public List<String> mtables(String catalog, String schema, String name, String types) {
        return this.mtables(false, catalog, schema, name, types);
    }

    default public List<String> mtables(String schema, String name, String types) {
        return this.mtables(false, null, schema, name, types);
    }

    default public List<String> mtables(String name, String types) {
        return this.mtables(false, null, null, name, types);
    }

    default public List<String> mtables(String types) {
        return this.mtables(false, null, null, null, types);
    }

    default public List<String> mtables() {
        return this.mtables(false, "STABLE");
    }

    public List<String> columns(boolean var1, Table var2);

    default public List<String> columns(boolean greedy, String table) {
        return this.columns(greedy, null, null, table);
    }

    default public List<String> columns(boolean greedy, String catalog, String schema, String table) {
        return this.columns(greedy, new Table(catalog, schema, table));
    }

    default public List<String> columns(Table table) {
        return this.columns(false, table);
    }

    default public List<String> columns(String table) {
        return this.columns(false, null, null, table);
    }

    default public List<String> columns(String catalog, String schema, String table) {
        return this.columns(false, catalog, schema, table);
    }

    public List<String> tags(boolean var1, Table var2);

    default public List<String> tags(boolean greedy, String catalog, String schema, String table) {
        return this.tags(greedy, new Table(catalog, schema, table));
    }

    default public List<String> tags(boolean greedy, String table) {
        return this.tags(greedy, null, null, table);
    }

    default public List<String> tags(Table table) {
        return this.tags(false, table);
    }

    default public List<String> tags(String table) {
        return this.tags(false, new Table(table));
    }

    default public List<String> tags(String catalog, String schema, String table) {
        return this.tags(false, new Table(catalog, schema, table));
    }

    public boolean save(Table var1) throws Exception;

    public boolean save(Column var1) throws Exception;

    public boolean drop(Table var1) throws Exception;

    public boolean drop(Column var1) throws Exception;

    public DDLService ddl();

    public MetaDataService metadata();

    public ConfigStore condition();

    public static interface DDLService {
        public boolean save(Table var1) throws Exception;

        public boolean create(Table var1) throws Exception;

        public boolean alter(Table var1) throws Exception;

        public boolean drop(Table var1) throws Exception;

        public boolean rename(Table var1, String var2) throws Exception;

        public boolean save(View var1) throws Exception;

        public boolean create(View var1) throws Exception;

        public boolean alter(View var1) throws Exception;

        public boolean drop(View var1) throws Exception;

        public boolean rename(View var1, String var2) throws Exception;

        public boolean save(MasterTable var1) throws Exception;

        public boolean create(MasterTable var1) throws Exception;

        public boolean alter(MasterTable var1) throws Exception;

        public boolean drop(MasterTable var1) throws Exception;

        public boolean rename(MasterTable var1, String var2) throws Exception;

        public boolean save(PartitionTable var1) throws Exception;

        public boolean create(PartitionTable var1) throws Exception;

        public boolean alter(PartitionTable var1) throws Exception;

        public boolean drop(PartitionTable var1) throws Exception;

        public boolean rename(PartitionTable var1, String var2) throws Exception;

        public boolean save(Column var1) throws Exception;

        public boolean add(Column var1) throws Exception;

        public boolean alter(Column var1) throws Exception;

        public boolean drop(Column var1) throws Exception;

        public boolean rename(Column var1, String var2) throws Exception;

        public boolean save(Tag var1) throws Exception;

        public boolean add(Tag var1) throws Exception;

        public boolean alter(Tag var1) throws Exception;

        public boolean drop(Tag var1) throws Exception;

        public boolean rename(Tag var1, String var2) throws Exception;

        public boolean add(PrimaryKey var1) throws Exception;

        public boolean alter(PrimaryKey var1) throws Exception;

        public boolean drop(PrimaryKey var1) throws Exception;

        public boolean rename(PrimaryKey var1, String var2) throws Exception;

        public boolean add(ForeignKey var1) throws Exception;

        public boolean alter(ForeignKey var1) throws Exception;

        public boolean drop(ForeignKey var1) throws Exception;

        public boolean rename(ForeignKey var1, String var2) throws Exception;

        public boolean add(Index var1) throws Exception;

        public boolean alter(Index var1) throws Exception;

        public boolean drop(Index var1) throws Exception;

        public boolean rename(Index var1, String var2) throws Exception;

        public boolean add(Constraint var1) throws Exception;

        public boolean alter(Constraint var1) throws Exception;

        public boolean drop(Constraint var1) throws Exception;

        public boolean rename(Constraint var1, String var2) throws Exception;

        public boolean create(Trigger var1) throws Exception;

        public boolean alter(Trigger var1) throws Exception;

        public boolean drop(Trigger var1) throws Exception;

        public boolean rename(Trigger var1, String var2) throws Exception;

        public boolean create(Procedure var1) throws Exception;

        public boolean alter(Procedure var1) throws Exception;

        public boolean drop(Procedure var1) throws Exception;

        public boolean rename(Procedure var1, String var2) throws Exception;

        public boolean create(Function var1) throws Exception;

        public boolean alter(Function var1) throws Exception;

        public boolean drop(Function var1) throws Exception;

        public boolean rename(Function var1, String var2) throws Exception;
    }

    public static interface MetaDataService {
        public LinkedHashMap<String, Database> databases();

        public Database database(String var1);

        public boolean exists(boolean var1, Table var2);

        default public boolean exists(Table table) {
            return this.exists(false, table);
        }

        public boolean exists(boolean var1, View var2);

        default public boolean exists(View view) {
            return this.exists(false, view);
        }

        public <T extends Table> List<T> tables(boolean var1, String var2, String var3, String var4, String var5);

        default public <T extends Table> List<T> tables(boolean greedy, String schema, String name, String types) {
            return this.tables(greedy, null, schema, name, types);
        }

        default public <T extends Table> List<T> tables(boolean greedy, String name, String types) {
            return this.tables(greedy, null, null, name, types);
        }

        default public <T extends Table> List<T> tables(boolean greedy, String types) {
            return this.tables(greedy, null, types);
        }

        default public <T extends Table> List<T> tables(boolean greedy) {
            return this.tables(greedy, null);
        }

        public <T extends Table> LinkedHashMap<String, T> tables(String var1, String var2, String var3, String var4);

        default public <T extends Table> LinkedHashMap<String, T> tables(String schema, String name, String types) {
            return this.tables(null, schema, name, types);
        }

        default public <T extends Table> LinkedHashMap<String, T> tables(String name, String types) {
            return this.tables(null, null, name, types);
        }

        default public <T extends Table> LinkedHashMap<String, T> tables(String types) {
            return this.tables(null, types);
        }

        default public <T extends Table> LinkedHashMap<String, T> tables() {
            return this.tables(null);
        }

        public Table table(boolean var1, String var2, String var3, String var4, boolean var5);

        default public Table table(boolean greedy, String schema, String name, boolean struct) {
            return this.table(greedy, null, schema, name, struct);
        }

        default public Table table(boolean greedy, String name, boolean struct) {
            return this.table(greedy, null, null, name, struct);
        }

        public Table table(String var1, String var2, String var3, boolean var4);

        default public Table table(String schema, String name, boolean struct) {
            return this.table(false, null, schema, name, struct);
        }

        default public Table table(String name, boolean struct) {
            return this.table(false, null, null, name, struct);
        }

        default public Table table(boolean greedy, String catalog, String schema, String name) {
            return this.table(greedy, catalog, schema, name, true);
        }

        default public Table table(boolean greedy, String schema, String name) {
            return this.table(greedy, null, schema, name, true);
        }

        default public Table table(boolean greedy, String name) {
            return this.table(greedy, null, null, name, true);
        }

        default public Table table(String catalog, String schema, String name) {
            return this.table(catalog, schema, name, true);
        }

        default public Table table(String schema, String name) {
            return this.table(null, schema, name, true);
        }

        default public Table table(String name) {
            return this.table(null, null, name, true);
        }

        public List<String> ddl(Table var1, boolean var2);

        default public List<String> ddl(String table, boolean init) {
            return this.ddl(new Table(table), init);
        }

        default public List<String> ddl(Table table) {
            return this.ddl(table, false);
        }

        default public List<String> ddl(String table) {
            return this.ddl(new Table(table));
        }

        public <T extends View> LinkedHashMap<String, T> views(boolean var1, String var2, String var3, String var4, String var5);

        default public <T extends View> LinkedHashMap<String, T> views(boolean greedy, String schema, String name, String types) {
            return this.views(greedy, null, schema, name, types);
        }

        default public <T extends View> LinkedHashMap<String, T> views(boolean greedy, String name, String types) {
            return this.views(greedy, null, null, name, types);
        }

        default public <T extends View> LinkedHashMap<String, T> views(boolean greedy, String types) {
            return this.views(greedy, null, types);
        }

        default public <T extends View> LinkedHashMap<String, T> views(boolean greedy) {
            return this.views(greedy, null);
        }

        public <T extends View> LinkedHashMap<String, T> views(String var1, String var2, String var3, String var4);

        default public <T extends View> LinkedHashMap<String, T> views(String schema, String name, String types) {
            return this.views(false, null, schema, name, types);
        }

        default public <T extends View> LinkedHashMap<String, T> views(String name, String types) {
            return this.views(false, null, null, name, types);
        }

        default public <T extends View> LinkedHashMap<String, T> views(String types) {
            return this.views(false, null, types);
        }

        default public <T extends View> LinkedHashMap<String, T> views() {
            return this.views(false, null);
        }

        public View view(boolean var1, String var2, String var3, String var4);

        default public View view(boolean greedy, String schema, String name) {
            return this.view(greedy, null, schema, name);
        }

        default public View view(boolean greedy, String name) {
            return this.view(greedy, null, null, name);
        }

        default public View view(String catalog, String schema, String name) {
            return this.view(false, catalog, schema, name);
        }

        default public View view(String schema, String name) {
            return this.view(false, null, schema, name);
        }

        default public View view(String name) {
            return this.view(false, null, null, name);
        }

        public List<String> ddl(View var1);

        public boolean exists(boolean var1, MasterTable var2);

        default public boolean exists(MasterTable table) {
            return this.exists(false, table);
        }

        public <T extends MasterTable> LinkedHashMap<String, T> mtables(boolean var1, String var2, String var3, String var4, String var5);

        default public <T extends MasterTable> LinkedHashMap<String, T> mtables(boolean greedy, String schema, String name, String types) {
            return this.mtables(greedy, null, schema, name, types);
        }

        default public <T extends MasterTable> LinkedHashMap<String, T> mtables(boolean greedy, String name, String types) {
            return this.mtables(greedy, null, null, name, types);
        }

        default public <T extends MasterTable> LinkedHashMap<String, T> mtables(boolean greedy, String types) {
            return this.mtables(greedy, null, null, null, types);
        }

        default public <T extends MasterTable> LinkedHashMap<String, T> mtables(boolean greedy) {
            return this.mtables(greedy, "STABLE");
        }

        default public <T extends MasterTable> LinkedHashMap<String, T> mtables(String catalog, String schema, String name, String types) {
            return this.mtables(false, catalog, schema, name, types);
        }

        default public <T extends MasterTable> LinkedHashMap<String, T> mtables(String schema, String name, String types) {
            return this.mtables(false, schema, name, types);
        }

        default public <T extends MasterTable> LinkedHashMap<String, T> mtables(String name, String types) {
            return this.mtables(false, name, types);
        }

        default public <T extends MasterTable> LinkedHashMap<String, T> mtables(String types) {
            return this.mtables(false, types);
        }

        default public <T extends MasterTable> LinkedHashMap<String, T> mtables() {
            return this.mtables(false);
        }

        public MasterTable mtable(boolean var1, String var2, String var3, String var4, boolean var5);

        default public MasterTable mtable(boolean greedy, String schema, String name, boolean strut) {
            return this.mtable(greedy, null, schema, name, strut);
        }

        default public MasterTable mtable(boolean greedy, String name, boolean strut) {
            return this.mtable(greedy, null, null, name, strut);
        }

        default public MasterTable mtable(String catalog, String schema, String name, boolean strut) {
            return this.mtable(false, catalog, schema, name, strut);
        }

        default public MasterTable mtable(String schema, String name, boolean strut) {
            return this.mtable(false, schema, name, strut);
        }

        default public MasterTable mtable(String name, boolean strut) {
            return this.mtable(false, name, strut);
        }

        default public MasterTable mtable(boolean greedy, String catalog, String schema, String name) {
            return this.mtable(greedy, catalog, schema, name, true);
        }

        default public MasterTable mtable(boolean greedy, String schema, String name) {
            return this.mtable(greedy, schema, name, true);
        }

        default public MasterTable mtable(boolean greedy, String name) {
            return this.mtable(greedy, name, true);
        }

        default public MasterTable mtable(String catalog, String schema, String name) {
            return this.mtable(false, catalog, schema, name, true);
        }

        default public MasterTable mtable(String schema, String name) {
            return this.mtable(false, schema, name, true);
        }

        default public MasterTable mtable(String name) {
            return this.mtable(false, name, true);
        }

        public List<String> ddl(MasterTable var1);

        public boolean exists(boolean var1, PartitionTable var2);

        default public boolean exists(PartitionTable table) {
            return this.exists(false, table);
        }

        public <T extends PartitionTable> LinkedHashMap<String, T> ptables(boolean var1, MasterTable var2, Map<String, Object> var3, String var4);

        default public <T extends PartitionTable> LinkedHashMap<String, T> ptables(MasterTable master, Map<String, Object> tags, String name) {
            return this.ptables(false, master, tags, name);
        }

        default public <T extends PartitionTable> LinkedHashMap<String, T> ptables(boolean greedy, MasterTable master, Map<String, Object> tags) {
            return this.ptables(greedy, master, tags, null);
        }

        default public <T extends PartitionTable> LinkedHashMap<String, T> ptables(MasterTable master, Map<String, Object> tags) {
            return this.ptables(false, master, tags, null);
        }

        default public <T extends PartitionTable> LinkedHashMap<String, T> ptables(boolean greedy, String catalog, String schema, String master, String name) {
            return this.ptables(greedy, new MasterTable(catalog, schema, master), null, name);
        }

        default public <T extends PartitionTable> LinkedHashMap<String, T> ptables(boolean greedy, String schema, String master, String name) {
            return this.ptables(greedy, new MasterTable(schema, master), null, name);
        }

        default public <T extends PartitionTable> LinkedHashMap<String, T> ptables(boolean greedy, String master, String name) {
            return this.ptables(greedy, new MasterTable(master), null, name);
        }

        default public <T extends PartitionTable> LinkedHashMap<String, T> ptables(boolean greedy, String master) {
            return this.ptables(greedy, new MasterTable(master), null, null);
        }

        default public <T extends PartitionTable> LinkedHashMap<String, T> ptables(boolean greedy, MasterTable master) {
            return this.ptables(greedy, master, null, null);
        }

        default public <T extends PartitionTable> LinkedHashMap<String, T> ptables(boolean greedy, MasterTable master, String name) {
            return this.ptables(greedy, master, null, name);
        }

        default public <T extends PartitionTable> LinkedHashMap<String, T> ptables(String catalog, String schema, String master, String name) {
            return this.ptables(false, catalog, schema, master, name);
        }

        default public <T extends PartitionTable> LinkedHashMap<String, T> ptables(String schema, String master, String name) {
            return this.ptables(false, schema, master, name);
        }

        default public <T extends PartitionTable> LinkedHashMap<String, T> ptables(String master, String name) {
            return this.ptables(false, master, name);
        }

        default public <T extends PartitionTable> LinkedHashMap<String, T> ptables(String master) {
            return this.ptables(false, master);
        }

        default public <T extends PartitionTable> LinkedHashMap<String, T> ptables(MasterTable master) {
            return this.ptables(false, master);
        }

        public PartitionTable ptable(boolean var1, MasterTable var2, String var3);

        default public PartitionTable ptable(boolean greedy, String catalog, String schema, String master, String name) {
            return this.ptable(greedy, new MasterTable(catalog, schema, master), name);
        }

        default public PartitionTable ptable(boolean greedy, String schema, String master, String name) {
            return this.ptable(greedy, new MasterTable(schema, master), name);
        }

        default public PartitionTable ptable(boolean greedy, String master, String name) {
            return this.ptable(greedy, new MasterTable(master), name);
        }

        default public PartitionTable ptable(String catalog, String schema, String master, String name) {
            return this.ptable(false, catalog, schema, master, name);
        }

        default public PartitionTable ptable(String schema, String master, String name) {
            return this.ptable(false, new MasterTable(schema, master), name);
        }

        default public PartitionTable ptable(String master, String name) {
            return this.ptable(false, new MasterTable(master), name);
        }

        public List<String> ddl(PartitionTable var1);

        public boolean exists(boolean var1, Table var2, Column var3);

        default public boolean exists(boolean greedy, Column column) {
            return this.exists(greedy, null, column);
        }

        default public boolean exists(boolean greedy, String table, String column) {
            return this.exists(greedy, new Table(table), new Column(column));
        }

        default public boolean exists(boolean greedy, String catalog, String schema, String table, String column) {
            return this.exists(greedy, new Table(catalog, schema, table), new Column(column));
        }

        default public boolean exists(Column column) {
            return this.exists(false, null, column);
        }

        default public boolean exists(String table, String column) {
            return this.exists(false, new Table(table), new Column(column));
        }

        default public boolean exists(Table table, String column) {
            return this.exists(false, table, new Column(column));
        }

        default public boolean exists(String catalog, String schema, String table, String column) {
            return this.exists(false, new Table(catalog, schema, table), new Column(column));
        }

        public <T extends Column> LinkedHashMap<String, T> columns(boolean var1, Table var2);

        default public <T extends Column> LinkedHashMap<String, T> columns(boolean greedy, String table) {
            return this.columns(greedy, new Table(table));
        }

        default public <T extends Column> LinkedHashMap<String, T> columns(boolean greedy, String catalog, String schema, String table) {
            return this.columns(greedy, new Table(catalog, schema, table));
        }

        default public <T extends Column> LinkedHashMap<String, T> columns(Table table) {
            return this.columns(false, table);
        }

        default public <T extends Column> LinkedHashMap<String, T> columns(String table) {
            return this.columns(false, new Table(table));
        }

        default public <T extends Column> LinkedHashMap<String, T> columns(String catalog, String schema, String table) {
            return this.columns(false, new Table(catalog, schema, table));
        }

        public Column column(boolean var1, Table var2, String var3);

        default public Column column(boolean greedy, String table, String name) {
            return this.column(greedy, new Table(table), name);
        }

        default public Column column(boolean greedy, String catalog, String schema, String table, String name) {
            return this.column(greedy, new Table(catalog, schema, table), name);
        }

        default public Column column(Table table, String name) {
            return this.column(false, table, name);
        }

        default public Column column(String table, String name) {
            return this.column(false, new Table(table), name);
        }

        default public Column column(String catalog, String schema, String table, String name) {
            return this.column(false, new Table(catalog, schema, table), name);
        }

        public <T extends Tag> LinkedHashMap<String, T> tags(boolean var1, Table var2);

        default public <T extends Tag> LinkedHashMap<String, T> tags(boolean greedy, String table) {
            return this.tags(greedy, new Table(table));
        }

        default public <T extends Tag> LinkedHashMap<String, T> tags(boolean greedy, String catalog, String schema, String table) {
            return this.tags(greedy, new Table(catalog, schema, table));
        }

        default public <T extends Tag> LinkedHashMap<String, T> tags(Table table) {
            return this.tags(false, table);
        }

        default public <T extends Tag> LinkedHashMap<String, T> tags(String table) {
            return this.tags(false, null, null, table);
        }

        default public <T extends Tag> LinkedHashMap<String, T> tags(String catalog, String schema, String table) {
            return this.tags(false, new Table(catalog, schema, table));
        }

        public PrimaryKey primary(boolean var1, Table var2);

        default public PrimaryKey primary(boolean greedy, String table) {
            return this.primary(greedy, new Table(table));
        }

        default public PrimaryKey primary(boolean greedy, String catalog, String schema, String table) {
            return this.primary(greedy, new Table(catalog, schema, table));
        }

        default public PrimaryKey primary(Table table) {
            return this.primary(false, table);
        }

        default public PrimaryKey primary(String table) {
            return this.primary(false, new Table(table));
        }

        default public PrimaryKey primary(String catalog, String schema, String table) {
            return this.primary(false, new Table(catalog, schema, table));
        }

        public <T extends ForeignKey> LinkedHashMap<String, T> foreigns(boolean var1, Table var2);

        default public <T extends ForeignKey> LinkedHashMap<String, T> foreigns(boolean greedy, String table) {
            return this.foreigns(greedy, new Table(table));
        }

        default public <T extends ForeignKey> LinkedHashMap<String, T> foreigns(boolean greedy, String catalog, String schema, String table) {
            return this.foreigns(greedy, new Table(catalog, schema, table));
        }

        default public <T extends ForeignKey> LinkedHashMap<String, T> foreigns(Table table) {
            return this.foreigns(false, table);
        }

        default public <T extends ForeignKey> LinkedHashMap<String, T> foreigns(String table) {
            return this.foreigns(false, new Table(table));
        }

        default public <T extends ForeignKey> LinkedHashMap<String, T> foreigns(String catalog, String schema, String table) {
            return this.foreigns(false, new Table(catalog, schema, table));
        }

        public ForeignKey foreign(boolean var1, Table var2, List<String> var3);

        default public ForeignKey foreign(boolean greedy, Table table, String ... columns) {
            return this.foreign(greedy, table, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
        }

        default public ForeignKey foreign(boolean greedy, String table, String ... columns) {
            return this.foreign(greedy, new Table(table), (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
        }

        default public ForeignKey foreign(boolean greedy, String table, List<String> columns) {
            return this.foreign(greedy, new Table(table), columns);
        }

        default public ForeignKey foreign(boolean greedy, String catalog, String schema, String table, List<String> columns) {
            return this.foreign(greedy, new Table(catalog, schema, table), columns);
        }

        default public ForeignKey foreign(Table table, String ... columns) {
            return this.foreign(false, table, (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
        }

        default public ForeignKey foreign(Table table, List<String> columns) {
            return this.foreign(false, table, columns);
        }

        default public ForeignKey foreign(String table, String ... columns) {
            return this.foreign(false, new Table(table), (List<String>)BeanUtil.array2list((Object[][])new String[][]{columns}));
        }

        default public ForeignKey foreign(String table, List<String> columns) {
            return this.foreign(false, new Table(table), columns);
        }

        default public ForeignKey foreign(String catalog, String schema, String table, List<String> columns) {
            return this.foreign(false, new Table(catalog, schema, table), columns);
        }

        public <T extends Index> LinkedHashMap<String, T> indexs(boolean var1, Table var2);

        default public <T extends Index> LinkedHashMap<String, T> indexs(boolean greedy, String table) {
            return this.indexs(greedy, new Table(table));
        }

        default public <T extends Index> LinkedHashMap<String, T> indexs(boolean greedy, String catalog, String schema, String table) {
            return this.indexs(greedy, new Table(catalog, schema, table));
        }

        default public <T extends Index> LinkedHashMap<String, T> indexs(Table table) {
            return this.indexs(false, table);
        }

        default public <T extends Index> LinkedHashMap<String, T> indexs(String table) {
            return this.indexs(false, new Table(table));
        }

        default public <T extends Index> LinkedHashMap<String, T> indexs(String catalog, String schema, String table) {
            return this.indexs(false, new Table(catalog, schema, table));
        }

        public Index index(boolean var1, Table var2, String var3);

        default public Index index(boolean greedy, String table, String name) {
            return this.index(greedy, new Table(table), name);
        }

        default public Index index(boolean greedy, String name) {
            return this.index(greedy, (Table)null, name);
        }

        default public Index index(Table table, String name) {
            return this.index(false, table, name);
        }

        default public Index index(String table, String name) {
            return this.index(false, new Table(table), name);
        }

        default public Index index(String name) {
            return this.index(false, name);
        }

        public <T extends Constraint> LinkedHashMap<String, T> constraints(boolean var1, Table var2);

        default public <T extends Constraint> LinkedHashMap<String, T> constraints(boolean greedy, String table) {
            return this.constraints(greedy, new Table(table));
        }

        default public <T extends Constraint> LinkedHashMap<String, T> constraints(boolean greedy, String catalog, String schema, String table) {
            return this.constraints(greedy, new Table(catalog, schema, table));
        }

        default public <T extends Constraint> LinkedHashMap<String, T> constraints(Table table) {
            return this.constraints(false, table);
        }

        default public <T extends Constraint> LinkedHashMap<String, T> constraints(String table) {
            return this.constraints(false, table);
        }

        default public <T extends Constraint> LinkedHashMap<String, T> constraints(String catalog, String schema, String table) {
            return this.constraints(false, new Table(catalog, schema, table));
        }

        public Constraint constraint(boolean var1, Table var2, String var3);

        default public Constraint constraint(boolean greedy, String table, String name) {
            return this.constraint(greedy, new Table(table), name);
        }

        default public Constraint constraint(boolean greedy, String name) {
            return this.constraint(greedy, (Table)null, name);
        }

        default public Constraint constraint(Table table, String name) {
            return this.constraint(false, table, name);
        }

        default public Constraint constraint(String table, String name) {
            return this.constraint(false, table, name);
        }

        default public Constraint constraint(String name) {
            return this.constraint(false, name);
        }

        public <T extends Trigger> LinkedHashMap<String, T> triggers(boolean var1, Table var2, List<Trigger.EVENT> var3);

        default public <T extends Trigger> LinkedHashMap<String, T> triggers(boolean greedy, String catalog, String schema, String table, List<Trigger.EVENT> events) {
            return this.triggers(greedy, new Table(catalog, schema, table), events);
        }

        default public <T extends Trigger> LinkedHashMap<String, T> triggers(boolean greedy, String schema, String table, List<Trigger.EVENT> events) {
            return this.triggers(greedy, new Table(schema, table), events);
        }

        default public <T extends Trigger> LinkedHashMap<String, T> triggers(boolean greedy, String table, List<Trigger.EVENT> events) {
            return this.triggers(greedy, new Table(table), events);
        }

        default public <T extends Trigger> LinkedHashMap<String, T> triggers(boolean greedy, List<Trigger.EVENT> events) {
            return this.triggers(greedy, (Table)null, events);
        }

        default public <T extends Trigger> LinkedHashMap<String, T> triggers(boolean greedy) {
            return this.triggers(greedy, (Table)null, null);
        }

        default public <T extends Trigger> LinkedHashMap<String, T> triggers(String catalog, String schema, String table, List<Trigger.EVENT> events) {
            return this.triggers(false, new Table(catalog, schema, table), events);
        }

        default public <T extends Trigger> LinkedHashMap<String, T> triggers(String schema, String table, List<Trigger.EVENT> events) {
            return this.triggers(false, schema, table, events);
        }

        default public <T extends Trigger> LinkedHashMap<String, T> triggers(String table, List<Trigger.EVENT> events) {
            return this.triggers(false, table, events);
        }

        default public <T extends Trigger> LinkedHashMap<String, T> triggers(List<Trigger.EVENT> events) {
            return this.triggers(false, events);
        }

        default public <T extends Trigger> LinkedHashMap<String, T> triggers() {
            return this.triggers(false);
        }

        public Trigger trigger(boolean var1, String var2, String var3, String var4);

        default public Trigger trigger(boolean greedy, String schema, String name) {
            return this.trigger(greedy, null, schema, name);
        }

        default public Trigger trigger(boolean greedy, String name) {
            return this.trigger(greedy, null, null, name);
        }

        default public Trigger trigger(String catalog, String schema, String name) {
            return this.trigger(false, catalog, schema, name);
        }

        default public Trigger trigger(String schema, String name) {
            return this.trigger(false, null, schema, name);
        }

        default public Trigger trigger(String name) {
            return this.trigger(false, name);
        }

        public <T extends Procedure> LinkedHashMap<String, T> procedures(boolean var1, String var2, String var3, String var4);

        default public <T extends Procedure> LinkedHashMap<String, T> procedures(boolean greedy, String schema, String name) {
            return this.procedures(greedy, null, schema, name);
        }

        default public <T extends Procedure> LinkedHashMap<String, T> procedures(boolean greedy, String name) {
            return this.procedures(greedy, null, null, name);
        }

        default public <T extends Procedure> LinkedHashMap<String, T> procedures(boolean greedy) {
            return this.procedures(greedy, null, null, null);
        }

        default public <T extends Procedure> LinkedHashMap<String, T> procedures(String catalog, String schema, String name) {
            return this.procedures(false, catalog, schema, name);
        }

        default public <T extends Procedure> LinkedHashMap<String, T> procedures(String schema, String name) {
            return this.procedures(false, null, schema, name);
        }

        default public <T extends Procedure> LinkedHashMap<String, T> procedures(String name) {
            return this.procedures(false, name);
        }

        default public <T extends Procedure> LinkedHashMap<String, T> procedures() {
            return this.procedures(false);
        }

        public Procedure procedure(boolean var1, String var2, String var3, String var4);

        default public Procedure procedure(boolean greedy, String schema, String name) {
            return this.procedure(greedy, null, schema, name);
        }

        default public Procedure procedure(boolean greedy, String name) {
            return this.procedure(greedy, null, null, name);
        }

        default public Procedure procedure(String catalog, String schema, String name) {
            return this.procedure(false, catalog, schema, name);
        }

        default public Procedure procedure(String schema, String name) {
            return this.procedure(false, schema, name);
        }

        default public Procedure procedure(String name) {
            return this.procedure(false, name);
        }

        public List<String> ddl(Procedure var1);

        public <T extends Function> LinkedHashMap<String, T> functions(boolean var1, String var2, String var3, String var4);

        default public <T extends Function> LinkedHashMap<String, T> functions(boolean greedy, String schema, String name) {
            return this.functions(greedy, null, schema, name);
        }

        default public <T extends Function> LinkedHashMap<String, T> functions(boolean greedy, String name) {
            return this.functions(greedy, null, null, name);
        }

        default public <T extends Function> LinkedHashMap<String, T> functions(boolean greedy) {
            return this.functions(greedy, null, null, null);
        }

        default public <T extends Function> LinkedHashMap<String, T> functions(String catalog, String schema, String name) {
            return this.functions(false, catalog, schema, name);
        }

        default public <T extends Function> LinkedHashMap<String, T> functions(String schema, String name) {
            return this.functions(false, schema, name);
        }

        default public <T extends Function> LinkedHashMap<String, T> functions(String name) {
            return this.functions(false, name);
        }

        default public <T extends Function> LinkedHashMap<String, T> functions() {
            return this.functions(false);
        }

        public Function function(boolean var1, String var2, String var3, String var4);

        default public Function function(boolean greedy, String schema, String name) {
            return this.function(greedy, null, schema, name);
        }

        default public Function function(boolean greedy, String name) {
            return this.function(greedy, null, null, name);
        }

        default public Function function(String catalog, String schema, String name) {
            return this.function(false, catalog, schema, name);
        }

        default public Function function(String schema, String name) {
            return this.function(false, schema, name);
        }

        default public Function function(String name) {
            return this.function(false, name);
        }

        public List<String> ddl(Function var1);
    }
}

