/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.metadata.type.DatabaseType;
import org.anyline.util.BasicUtil;
import org.anyline.util.LogUtil;
import org.anyline.util.SpringContextUtil;
import org.anyline.util.regular.RegularUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="anyline.data.DriverAdapterHolder")
public class DriverAdapterHolder {
    private static final Logger log = LoggerFactory.getLogger(DriverAdapterHolder.class);
    private static ConcurrentHashMap<String, DriverAdapter> adapters = new ConcurrentHashMap();
    private static Map<String, Boolean> supports = new HashMap<String, Boolean>();
    private static List<DriverAdapterHolder> utils = new ArrayList<DriverAdapterHolder>();
    private static DriverAdapter defaultAdapter = null;

    public static void remove(String datasource) {
        adapters.remove("al-ds:" + datasource);
    }

    @Autowired(required=false)
    public void setAdapters(Map<String, DriverAdapter> map) {
        for (DriverAdapter adapter : map.values()) {
            String version = adapter.version();
            if (null == version) {
                adapters.put(adapter.type().name(), adapter);
            } else {
                adapters.put(adapter.type().name() + "_" + adapter.version(), adapter);
            }
            supports.put(adapter.type().name(), true);
        }
    }

    public static boolean support(DatabaseType type) {
        return supports.containsKey(type.name());
    }

    public static DriverAdapter getAdapter(String datasource, DataRuntime runtime) {
        if (null != defaultAdapter) {
            return defaultAdapter;
        }
        if (adapters.size() == 1) {
            defaultAdapter = adapters.values().iterator().next();
            return defaultAdapter;
        }
        DriverAdapter adapter = null;
        adapter = adapters.get("al-ds:" + datasource);
        if (null != adapter) {
            return adapter;
        }
        try {
            String feature = runtime.getFeature();
            if (null != runtime && null == (adapter = DriverAdapterHolder.getAdapter(datasource, feature, null))) {
                String version = runtime.getVersion();
                adapter = DriverAdapterHolder.getAdapter(datasource, feature, version);
            }
            if (null == adapter) {
                // empty if block
            }
            if (null == adapter) {
                log.warn("[\u68c0\u6d4b\u6570\u636e\u5e93\u9002\u914d\u5668][\u68c0\u6d4b\u5931\u8d25][\u53ef\u7528\u9002\u914d\u5668\u6570\u91cf:{}][\u68c0\u6d4b\u5176\u4ed6\u53ef\u7528\u7684\u9002\u914d\u5668]", (Object)adapters.size());
                adapter = (DriverAdapter)SpringContextUtil.getBean(DriverAdapter.class);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (null == adapter) {
            log.error("[\u68c0\u6d4b\u6570\u636e\u5e93\u9002\u914d\u5668][\u68c0\u6d4b\u5176\u4ed6\u53ef\u7528\u7684\u9002\u914d\u5668\u5931\u8d25][\u53ef\u7528\u9002\u914d\u5668\u6570\u91cf:{}][{}]", (Object)adapters.size(), (Object)LogUtil.format((String)"\u53ef\u80fd\u6ca1\u6709\u4f9d\u8d56anyline-data-jdbc-*(\u5982mysql,neo4j)\u6216\u6ca1\u6709\u626b\u63cforg.anyline\u5305", (int)31));
        }
        return adapter;
    }

    private static DriverAdapter getAdapter() {
        return null;
    }

    private static int versions(DatabaseType type, String ... versions) {
        int qty = 0;
        for (String version : versions) {
            if (!adapters.containsKey(type.name() + "_" + version)) continue;
            ++qty;
        }
        return qty;
    }

    private static DriverAdapter adapter(DatabaseType type, String ... versions) {
        for (String version : versions) {
            DriverAdapter adapter = adapters.get(type.name() + "_" + version);
            if (null == adapter) continue;
            return adapter;
        }
        return null;
    }

    private static DriverAdapter getAdapter(String datasource, String feature, String version) {
        DriverAdapter adapter = null;
        if (null != version) {
            version = version.toLowerCase();
        }
        if (DriverAdapterHolder.support(DatabaseType.MYSQL) && feature.contains("mysql")) {
            adapter = adapters.get(DatabaseType.MYSQL.name());
        } else if (DriverAdapterHolder.support(DatabaseType.MSSQL) && (feature.contains("mssql") || feature.contains("sqlserver"))) {
            if (null != version) {
                version = version.split("\\.")[0];
                double v = BasicUtil.parseDouble((Object)version, (Double)0.0);
                String key = null;
                key = v >= 9.0 ? "2005" : "2000";
                adapter = adapters.get(DatabaseType.MSSQL.name() + "_" + key);
            } else if (DriverAdapterHolder.versions(DatabaseType.ORACLE, "2000", "2005") == 1) {
                adapter = DriverAdapterHolder.adapter(DatabaseType.MSSQL, "2005", "2000");
            }
            if (null == adapter) {
                adapter = adapters.get(DatabaseType.MSSQL.name() + "_2005");
            }
        } else if (DriverAdapterHolder.support(DatabaseType.ORACLE) && feature.contains("oracle")) {
            if (null != version) {
                if (null != (version = RegularUtil.cut((String)version, (String[])new String[]{"release", "-"}))) {
                    version = version.split("\\.")[0];
                }
                double v = BasicUtil.parseDouble((Object)version, (Double)0.0);
                String key = null;
                key = v >= 12.0 ? "12" : "11";
                adapter = adapters.get(DatabaseType.ORACLE.name() + "_" + key);
            } else if (DriverAdapterHolder.versions(DatabaseType.ORACLE, "11", "12") == 1) {
                adapter = DriverAdapterHolder.adapter(DatabaseType.ORACLE, "11", "12");
            }
            if (null == adapter) {
                adapter = adapters.get(DatabaseType.ORACLE.name() + "_" + version);
            }
        } else if (DriverAdapterHolder.support(DatabaseType.PostgreSQL) && feature.contains("postgresql")) {
            adapter = adapters.get(DatabaseType.PostgreSQL.name());
        } else if (DriverAdapterHolder.support(DatabaseType.ClickHouse) && feature.contains("clickhouse")) {
            adapter = adapters.get(DatabaseType.ClickHouse.name());
        } else if (DriverAdapterHolder.support(DatabaseType.DB2) && feature.contains("db2")) {
            adapter = adapters.get(DatabaseType.DB2.name());
        } else if (DriverAdapterHolder.support(DatabaseType.Derby) && feature.contains("derby")) {
            adapter = adapters.get(DatabaseType.Derby.name());
        } else if (DriverAdapterHolder.support(DatabaseType.DM) && feature.contains("dmdbms")) {
            adapter = adapters.get(DatabaseType.DM.name());
        } else if (DriverAdapterHolder.support(DatabaseType.HighGo) && feature.contains("hgdb") || feature.contains("highgo")) {
            adapter = adapters.get(DatabaseType.HighGo.name());
        } else if (DriverAdapterHolder.support(DatabaseType.KingBase) && feature.contains("kingbase")) {
            adapter = adapters.get(DatabaseType.KingBase.name());
        } else if (DriverAdapterHolder.support(DatabaseType.GBase) && feature.contains("gbase")) {
            adapter = adapters.get(DatabaseType.GBase.name());
        } else if (DriverAdapterHolder.support(DatabaseType.OceanBase) && feature.contains("oceanbase")) {
            adapter = adapters.get(DatabaseType.OceanBase.name());
        } else if (DriverAdapterHolder.support(DatabaseType.OpenGauss) && feature.contains("opengauss")) {
            adapter = adapters.get(DatabaseType.OpenGauss.name());
        } else if (DriverAdapterHolder.support(DatabaseType.PolarDB) && feature.contains("polardb")) {
            adapter = adapters.get(DatabaseType.PolarDB.name());
        } else if (DriverAdapterHolder.support(DatabaseType.SQLite) && feature.contains("sqlite")) {
            adapter = adapters.get(DatabaseType.SQLite.name());
        } else if (DriverAdapterHolder.support(DatabaseType.SQLite) && feature.contains("informix")) {
            adapter = adapters.get(DatabaseType.Informix.name());
        } else if (DriverAdapterHolder.support(DatabaseType.H2) && feature.contains(":h2:")) {
            adapter = adapters.get(DatabaseType.H2.name());
        } else if (DriverAdapterHolder.support(DatabaseType.Hive) && feature.contains("hive")) {
            adapter = adapters.get(DatabaseType.H2.name());
        } else if (DriverAdapterHolder.support(DatabaseType.HSQLDB) && feature.contains("hsqldb")) {
            adapter = adapters.get(DatabaseType.HSQLDB.name());
        } else if (DriverAdapterHolder.support(DatabaseType.TDengine) && feature.contains("taos")) {
            adapter = adapters.get(DatabaseType.TDengine.name());
        } else if (DriverAdapterHolder.support(DatabaseType.Neo4j) && feature.contains("neo4j")) {
            adapter = adapters.get(DatabaseType.Neo4j.name());
        } else if (DriverAdapterHolder.support(DatabaseType.Neo4j) && feature.contains("uxdb")) {
            adapter = adapters.get(DatabaseType.UXDB.name());
        } else if (DriverAdapterHolder.support(DatabaseType.HANA) && feature.contains("sap")) {
            adapter = adapters.get(DatabaseType.HANA.name());
        } else if (DriverAdapterHolder.support(DatabaseType.MongoDB) && feature.contains("mongo")) {
            adapter = adapters.get(DatabaseType.MongoDB.name());
        }
        if (null != adapter) {
            adapters.put("al-ds:" + datasource, adapter);
            log.info("[\u68c0\u6d4b\u6570\u636e\u5e93\u9002\u914d\u5668][datasource:{}][\u7279\u5f81:{}][\u9002\u914d\u5668:{}]", new Object[]{datasource, feature, adapter});
        }
        return adapter;
    }
}

