/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.anyline.metadata.type.DatabaseType;
import org.anyline.util.ConfigTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientHolder {
    public static Logger log = LoggerFactory.getLogger(ClientHolder.class);
    protected static final ThreadLocal<String> THREAD_RECALL_SOURCE = new ThreadLocal();
    protected static final ThreadLocal<String> THREAD_CUR_SOURCE = new ThreadLocal();
    protected static final ThreadLocal<Boolean> THREAD_AUTO_RECOVER = new ThreadLocal();
    protected static List<String> dataSources = new ArrayList<String>();
    protected static Map<String, DatabaseType> types = new HashMap<String, DatabaseType>();

    public static List<String> list() {
        return dataSources;
    }

    public static String curDataSource() {
        return THREAD_CUR_SOURCE.get();
    }

    public static DatabaseType dialect() {
        String ds = ClientHolder.curDataSource();
        return types.get(ds);
    }

    public static void dialect(String ds, DatabaseType type) {
        types.put(ds, type);
    }

    public static void setDataSource(String dataSource) {
        ClientHolder.setDataSource(dataSource, false);
    }

    public static void setDataSource(String dataSource, boolean auto) {
        if (null == dataSource || !dataSources.contains(dataSource)) {
            throw new RuntimeException("\u6570\u636e\u6e90\u672a\u6ce8\u518c:" + dataSource);
        }
        if (ConfigTable.IS_DEBUG && log.isWarnEnabled()) {
            log.info("[\u5207\u6362\u6570\u636e\u6e90][thread:{}][\u6570\u636e\u6e90:{}>{}][auto recover:{}]", new Object[]{Thread.currentThread().getId(), THREAD_RECALL_SOURCE.get(), dataSource, auto});
        }
        THREAD_RECALL_SOURCE.set(THREAD_CUR_SOURCE.get());
        THREAD_CUR_SOURCE.set(dataSource);
        THREAD_AUTO_RECOVER.set(auto);
    }

    public static void recoverDataSource() {
        String fr = THREAD_CUR_SOURCE.get();
        String to = THREAD_RECALL_SOURCE.get();
        if (null == fr && null == to) {
            return;
        }
        if (null != fr && fr.equals(to)) {
            return;
        }
        THREAD_CUR_SOURCE.set(to);
        log.info("[\u8fd8\u539f\u6570\u636e\u6e90][thread:{}][\u6570\u636e\u6e90:{}>{}][auto recover:{}]", new Object[]{Thread.currentThread().getId(), fr, to});
    }

    public static void setDefaultDataSource() {
        ClientHolder.clearDataSource();
        if (dataSources.contains("dataSource")) {
            ClientHolder.setDataSource("dataSource");
        } else if (dataSources.contains("default")) {
            ClientHolder.setDataSource("default");
        }
        THREAD_AUTO_RECOVER.set(false);
        if (ConfigTable.IS_DEBUG && log.isWarnEnabled()) {
            log.info("[\u5207\u6362\u6570\u636e\u6e90][thread:{}][\u6570\u636e\u6e90:{}>\u9ed8\u8ba4\u6570\u636e\u6e90]", (Object)Thread.currentThread().getId(), (Object)THREAD_RECALL_SOURCE.get());
        }
    }

    public static void clearDataSource() {
        THREAD_CUR_SOURCE.remove();
    }

    public static boolean isAutoRecover() {
        if (null == THREAD_AUTO_RECOVER || null == THREAD_AUTO_RECOVER.get()) {
            return false;
        }
        return THREAD_AUTO_RECOVER.get();
    }

    public static void reg(String ds) {
        if (!dataSources.contains(ds)) {
            dataSources.add(ds);
        }
    }

    public static boolean contains(String ds) {
        return dataSources.contains(ds);
    }

    static {
        THREAD_AUTO_RECOVER.set(false);
    }
}

