/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.runtime;

import java.util.Hashtable;
import java.util.Map;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.data.util.ClientHolder;
import org.anyline.proxy.RuntimeHolderProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;

public abstract class RuntimeHolder {
    protected static Logger log = LoggerFactory.getLogger(RuntimeHolder.class);
    protected static Map<String, DataRuntime> runtimes = new Hashtable<String, DataRuntime>();
    protected static DefaultListableBeanFactory factory;

    public static void init(DefaultListableBeanFactory factory) {
        RuntimeHolder.factory = factory;
    }

    public DataRuntime temporary(String key, Object datasource, String database, DriverAdapter adapter) throws Exception {
        return RuntimeHolderProxy.temporary(key, datasource, database, adapter);
    }

    public abstract DataRuntime regTemporary(String var1, Object var2, String var3, DriverAdapter var4) throws Exception;

    public static void destroy(String key) {
        RuntimeHolderProxy.destroy(key);
    }

    public abstract void exeDestroy(String var1);

    public static void reg(String key, DataRuntime runtime) {
        runtimes.put(key, runtime);
    }

    public static DataRuntime getRuntime() {
        return RuntimeHolder.getRuntime(ClientHolder.curDataSource());
    }

    public static DataRuntime getRuntime(String datasource) {
        DataRuntime runtime = null;
        if (null == datasource) {
            if (null == runtime) {
                datasource = "common";
                runtime = runtimes.get(datasource);
            }
        } else {
            runtime = runtimes.get(datasource);
        }
        if (null == runtime) {
            throw new RuntimeException("\u672a\u6ce8\u518c\u6570\u636e\u6e90:" + datasource);
        }
        return runtime;
    }

    public static void destroyBean(String bean) {
        if (factory.containsSingleton(bean)) {
            factory.destroySingleton(bean);
        }
        if (factory.containsBeanDefinition(bean)) {
            factory.removeBeanDefinition(bean);
        }
    }
}

