/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.prepare.xml.init;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.anyline.data.prepare.Condition;
import org.anyline.data.prepare.Variable;
import org.anyline.data.prepare.init.DefaultCondition;
import org.anyline.data.prepare.init.DefaultVariable;
import org.anyline.data.run.RunValue;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.entity.Compare;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.regular.Regular;
import org.anyline.util.regular.RegularUtil;

public class DefaultXMLCondition
extends DefaultCondition
implements Condition {
    private String text;

    @Override
    public Object clone() throws CloneNotSupportedException {
        DefaultXMLCondition clone = (DefaultXMLCondition)super.clone();
        if (null != this.variables) {
            ArrayList<Variable> cVariables = new ArrayList<Variable>();
            for (Variable var : this.variables) {
                if (null == var) continue;
                cVariables.add((Variable)var.clone());
            }
            clone.setSwitch(this.swt);
            clone.variables = cVariables;
        }
        return clone;
    }

    public DefaultXMLCondition() {
        this.join = "";
    }

    public DefaultXMLCondition(String id, String text, boolean isStatic) {
        this.join = "";
        this.id = id;
        this.text = text;
        this.setVariableType(0);
        if (!isStatic) {
            this.parseText();
        } else {
            this.setVariableType(2);
        }
    }

    @Override
    public void init() {
        this.setActive(false);
        if (null == this.variables) {
            this.variables = new ArrayList();
        }
        for (Variable variable : this.variables) {
            variable.init();
        }
    }

    @Override
    public void setValue(String variable, Object values) {
        this.runValuesMap.put(variable, values);
        if (null == variable || null == this.variables) {
            return;
        }
        for (Variable v : this.variables) {
            if (null == v || !variable.equalsIgnoreCase(v.getKey())) continue;
            v.setValue(values);
            Compare.EMPTY_VALUE_SWITCH swt = v.getSwitch();
            if (!BasicUtil.isNotEmpty((boolean)true, (Object)values) && swt != Compare.EMPTY_VALUE_SWITCH.NULL && swt != Compare.EMPTY_VALUE_SWITCH.SRC) continue;
            this.setActive(true);
        }
    }

    private void parseText() {
        try {
            List keys = null;
            keys = RegularUtil.fetchs((String)this.text, (String)"([^\\s\\$#]+)\\s*\\(?(\\s*[\\$|#]*{\\w+})(\\+|\\s|'|\\)|%)?", (Regular.MATCH_MODE)Regular.MATCH_MODE.CONTAIN);
            if (keys.size() == 0) {
                keys = RegularUtil.fetchs((String)this.text, (String)"(\\S+)\\s*\\(?(\\s*:+\\w+)(\\s|'|\\)|%|\\,)?", (Regular.MATCH_MODE)Regular.MATCH_MODE.CONTAIN);
            }
            if (BasicUtil.isNotEmpty((boolean)true, (Object)keys)) {
                this.setVariableType(1);
                int varType = 0;
                Compare compare = Compare.EQUAL;
                for (int i = 0; i < keys.size(); ++i) {
                    List keyItem = (List)keys.get(i);
                    String prefix = ((String)keyItem.get(1)).trim();
                    String fullKey = ((String)keyItem.get(2)).trim();
                    String typeChar = (String)keyItem.get(3);
                    varType = fullKey.startsWith("::") || fullKey.startsWith("${") ? 3 : (BasicUtil.isNotEmpty((Object)typeChar) && ("'".equals(typeChar) || "%".equals(typeChar)) ? 2 : 1);
                    if (prefix.equalsIgnoreCase("IN") || prefix.equalsIgnoreCase("IN(")) {
                        compare = Compare.IN;
                    }
                    DefaultVariable var = new DefaultVariable();
                    var.setFullKey(fullKey);
                    var.setType(varType);
                    var.setCompare(compare);
                    this.addVariable(var);
                }
            } else {
                List idxKeys = RegularUtil.fetch((String)this.text, (String)"\\?", (Regular.MATCH_MODE)Regular.MATCH_MODE.CONTAIN, (int)0);
                if (BasicUtil.isNotEmpty((boolean)true, (Object)idxKeys)) {
                    this.setVariableType(0);
                    int varType = 0;
                    for (int i = 0; i < idxKeys.size(); ++i) {
                        DefaultVariable var = new DefaultVariable();
                        var.setType(varType);
                        var.setKey(this.id);
                        this.addVariable(var);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addVariable(Variable variable) {
        if (null == this.variables) {
            this.variables = new ArrayList();
        }
        this.variables.add(variable);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getText() {
        return this.text;
    }

    @Override
    public String getRunText(String prefix, DataRuntime runtime) {
        String value;
        List<Object> values;
        String result = this.text;
        this.runValues = new ArrayList();
        if (null == this.variables) {
            return result;
        }
        for (Variable var : this.variables) {
            if (null == var || var.getType() != 3) continue;
            values = var.getValues();
            value = null;
            if (BasicUtil.isNotEmpty((boolean)true, values)) {
                value = var.getCompare() == Compare.IN ? BeanUtil.concat((Collection)BeanUtil.wrap(values, (String)"'")) : values.get(0).toString();
            }
            if (BasicUtil.isNotEmpty(value)) {
                result = result.replace(var.getFullKey(), value);
                continue;
            }
            result = result.replace(var.getFullKey(), "NULL");
        }
        for (Variable var : this.variables) {
            if (null == var || var.getType() != 2) continue;
            values = var.getValues();
            value = null;
            if (BasicUtil.isNotEmpty((boolean)true, values)) {
                value = (String)values.get(0);
            }
            if (null != value) {
                result = result.replace(var.getFullKey(), value);
                continue;
            }
            result = result.replace(var.getFullKey(), "");
        }
        for (Variable var : this.variables) {
            if (null == var || var.getType() != 1) continue;
            List<Object> varValues = var.getValues();
            if (Compare.IN == var.getCompare()) {
                String replaceDst = "";
                for (int i = 0; i < varValues.size(); ++i) {
                    replaceDst = replaceDst + "?";
                    if (i >= varValues.size() - 1) continue;
                    replaceDst = replaceDst + ",";
                }
                result = result.replace(var.getFullKey(), replaceDst);
                for (Object obj : varValues) {
                    this.runValues.add(new RunValue(var.getKey(), obj));
                }
                continue;
            }
            result = result.replace(var.getFullKey(), "?");
            value = null;
            if (BasicUtil.isNotEmpty((boolean)true, varValues)) {
                value = varValues.get(0).toString();
            }
            this.runValues.add(new RunValue(var.getKey(), (Object)value));
        }
        for (Variable var : this.variables) {
            if (null == var || var.getType() != 0) continue;
            values = var.getValues();
            value = null;
            if (BasicUtil.isNotEmpty((boolean)true, values)) {
                value = (String)values.get(0);
            }
            this.runValues.add(new RunValue((String)null, (Object)value));
        }
        return result;
    }

    @Override
    public Condition setRunText(String text) {
        this.text = text;
        return this;
    }

    @Override
    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        if (null != this.variables) {
            for (Variable variable : this.variables) {
                if (null == variable) continue;
                List<Object> values = variable.getValues();
                if (this.swt != Compare.EMPTY_VALUE_SWITCH.BREAK || !BasicUtil.isEmpty((boolean)true, values)) continue;
                return false;
            }
        }
        return true;
    }
}

