/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.param;

import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.anyline.data.param.Config;
import org.anyline.data.param.ConfigChain;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.param.DefaultPrepare;
import org.anyline.data.param.ParseResult;
import org.anyline.entity.Compare;
import org.anyline.entity.OrderStore;
import org.anyline.entity.PageNavi;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.ClassUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.DateUtil;
import org.anyline.util.XssUtil;
import org.anyline.util.encrypt.DESKey;
import org.anyline.util.encrypt.DESUtil;
import org.anyline.util.encrypt.MD5Util;
import org.anyline.util.regular.Regular;
import org.anyline.util.regular.RegularUtil;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigParser {
    static final Logger log = LoggerFactory.getLogger(ConfigParser.class);
    private static Map<String, DESKey> deskeys = null;
    private static DESKey defaultDesKey = null;
    private static final int MAX_DES_VERSION_INDEX = 12;
    private static final int DES_VERSION_LENGTH = 3;
    private static final String ENCRYPT_TYPE_PARAM = "param";
    private static final String ENCRYPT_TYPE_KEY = "name";
    private static final String ENCRYPT_TYPE_VALUE = "value";

    public static ParseResult parse(String config, boolean isKey) {
        ParseResult result = ConfigParser.parseInit(config);
        result = ConfigParser.parseCompare(result, isKey);
        result = ConfigParser.parseClassMethod(result);
        result = ConfigParser.parseOr(result);
        result = ConfigParser.parseDef(result);
        result = ConfigParser.parseEncrypt(result);
        return result;
    }

    private static ParseResult parseInit(String config) {
        ParseResult result = new ParseResult();
        String prefix = null;
        String var = config;
        String key = config;
        Compare.EMPTY_VALUE_SWITCH swt = Compare.EMPTY_VALUE_SWITCH.IGNORE;
        if (key.contains(":")) {
            var = config.substring(0, config.indexOf(":"));
            if (key.contains("|")) {
                String[] tmp = key.split("\\|");
                ParseResult or = new ParseResult();
                or.setKey(tmp[1]);
                or = ConfigParser.parseEncrypt(or);
                result.setOr(or);
                key = config.substring(config.indexOf(":") + 1, config.indexOf("|"));
            } else {
                key = config.substring(config.indexOf(":") + 1, config.length());
            }
        }
        if (var.startsWith("+")) {
            swt = Compare.EMPTY_VALUE_SWITCH.NULL;
            var = var.substring(1, var.length());
            if (ConfigTable.getBoolean((String)"CONDITION_VALUE_STRICT")) {
                swt = Compare.EMPTY_VALUE_SWITCH.BREAK;
            }
        }
        if (var.startsWith("+")) {
            swt = Compare.EMPTY_VALUE_SWITCH.BREAK;
            var = var.substring(1, var.length());
        }
        if (var.contains(".")) {
            prefix = var.substring(0, var.indexOf("."));
            var = var.substring(var.indexOf(".") + 1, var.length());
            result.setPrefix(prefix);
        }
        result.setSwitch(swt);
        result.setVar(var);
        result.setKey(key);
        return result;
    }

    private static ParseResult parseClassMethod(ParseResult result) {
        String config = result.getKey();
        String className = null;
        String methodName = null;
        String regx = "^([a-z]+[0-9a-zA-Z_]*(\\.[a-z]+[0-9a-zA-Z_]*)*\\.?[A-Z]+[0-9a-zA-Z_]*\\.?)?[a-z]+\\S+\\(\\S+\\)$";
        if (RegularUtil.match((String)config, (String)regx, (Regular.MATCH_MODE)Regular.MATCH_MODE.MATCH)) {
            String classMethod = config.substring(0, config.indexOf("("));
            if (classMethod.contains(".")) {
                className = classMethod.substring(0, classMethod.lastIndexOf("."));
                methodName = classMethod.substring(classMethod.lastIndexOf(".") + 1, classMethod.length());
            } else {
                methodName = classMethod;
            }
            config = config.substring(config.indexOf("(") + 1, config.indexOf(")"));
            if (config.contains(",")) {
                String[] tmps = config.split(",");
                int len = tmps.length;
                for (int i = 1; i < len; ++i) {
                    String arg = tmps[i];
                    arg.replace("'", "").replace("\"", "");
                    result.addArg(arg);
                }
                config = tmps[0];
            }
        }
        result.setClazz(className);
        result.setMethod(methodName);
        result.setKey(config);
        return result;
    }

    private static ParseResult parseCompare(ParseResult result, boolean isKey) {
        String key = result.getKey();
        String var = result.getVar();
        if (key.startsWith(">=")) {
            result.setCompare(Compare.GREAT_EQUAL);
            key = key.substring(2);
        } else if (key.startsWith(">")) {
            result.setCompare(Compare.GREAT);
            key = key.substring(1);
        } else if (key.startsWith("<=")) {
            result.setCompare(Compare.LESS_EQUAL);
            key = key.substring(2);
        } else if (key.startsWith("<>") || key.startsWith("!=")) {
            result.setCompare(Compare.NOT_EQUAL);
            key = key.substring(2);
        } else if (key.startsWith("<")) {
            result.setCompare(Compare.LESS);
            key = key.substring(1);
        } else if (key.startsWith("[") && key.endsWith("]")) {
            result.setCompare(Compare.IN);
            result.setParamFetchType(ParseResult.FETCH_REQUEST_VALUE_TYPE_MULTIPLE);
            if (isKey) {
                key = key.substring(1, key.length() - 1);
            }
        } else if (key.startsWith("%")) {
            if (key.endsWith("%")) {
                result.setCompare(Compare.LIKE);
                key = key.substring(1, key.length() - 1);
            } else {
                result.setCompare(Compare.LIKE_SUFFIX);
                key = key.substring(1, key.length());
            }
        } else if (key.endsWith("%")) {
            result.setCompare(Compare.LIKE_PREFIX);
            key = key.substring(0, key.length() - 1);
        } else {
            result.setCompare(Compare.EQUAL);
        }
        result.setKey(key);
        if (var.startsWith("[") && var.endsWith("]")) {
            result.setCompare(Compare.FIND_IN_SET);
            var = var.substring(1, var.length() - 1);
            result.setVar(var);
        }
        return result;
    }

    private static ParseResult parseDef(ParseResult result) {
        String key = result.getKey();
        if (key.contains(":") && !DateUtil.isDate((String)key)) {
            String[] tmp = key.split(":");
            result.setKey(tmp[0]);
            int size = tmp.length;
            for (int i = 1; i < size; ++i) {
                if (BasicUtil.isEmpty((Object)tmp[i])) continue;
                ParseResult def = new ParseResult();
                def.setKey(tmp[i]);
                def = ConfigParser.parseEncrypt(def);
                result.addDef(def);
            }
        }
        return result;
    }

    private static ParseResult parseOr(ParseResult result) {
        String key = result.getKey();
        if (key.indexOf("|") != -1) {
            String[] tmp = key.split("\\|");
            ParseResult or = new ParseResult();
            or.setKey(tmp[1]);
            or = ConfigParser.parseEncrypt(or);
            result.setOr(or);
        }
        return result;
    }

    private static ParseResult parseEncrypt(ParseResult result) {
        Map<String, Object> map = ConfigParser.parseEncrypt(result.getKey());
        result.setKey((String)map.get("SRC"));
        result.setKeyEncrypt((Boolean)map.get("KEY_ENCRYPT"));
        result.setValueEncrypt((Boolean)map.get("VALUE_ENCRYPT"));
        return result;
    }

    private static Map<String, Object> parseEncrypt(String key) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        boolean isKeyEncrypt = false;
        boolean isValueEncrypt = false;
        if (null != key && (key.endsWith("+") || key.endsWith("-"))) {
            String paramEncrypt = key.substring(key.length() - 2, key.length() - 1);
            String valueEncrypt = key.substring(key.length() - 1);
            if ("+".equals(paramEncrypt)) {
                isKeyEncrypt = true;
            }
            if ("+".equals(valueEncrypt)) {
                isValueEncrypt = true;
            }
            key = key.replace("+", "").replace("-", "");
        }
        result.put("SRC", key);
        result.put("KEY_ENCRYPT", isKeyEncrypt);
        result.put("VALUE_ENCRYPT", isValueEncrypt);
        return result;
    }

    public static Object getValue(Map<String, Object> values, ParseResult parser) {
        List<Object> list = ConfigParser.getValues(values, parser);
        if (null != list && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public static String parseVar(Map<String, Object> values, ParseResult parser) {
        String var = parser.getVar().trim();
        if (var.startsWith("${") && var.endsWith("}")) {
            Object varv = values.get(var = var.substring(2, var.length() - 1));
            if (null == varv) {
                log.warn("[\u52a8\u6001key\u89e3\u6790\u5931\u8d25][key:{}]", (Object)var);
                return null;
            }
            var = (String)varv;
            parser.setVar(var);
        }
        return var;
    }

    public static List<Object> getValues(Map<String, Object> values, ParseResult parser) {
        List<Object> defs;
        List<Object> list;
        block15: {
            list = new ArrayList<Object>();
            if (null == parser) {
                return list;
            }
            try {
                String key = parser.getKey();
                String className = parser.getClazz();
                String methodName = parser.getMethod();
                int fetchValueType = 2;
                boolean isKeyEncrypt = parser.isKeyEncrypt();
                boolean isValueEncrypt = parser.isValueEncrypt();
                if (null != methodName) {
                    Class clazz = null;
                    clazz = null == className ? DefaultPrepare.class : Class.forName(className);
                    Method method = clazz.getMethod(methodName, String.class);
                    if (1 == fetchValueType) {
                        Object v = ConfigParser.getRuntimeValue(values, key, isKeyEncrypt, isValueEncrypt);
                        v = method.invoke((Object)clazz, v);
                        list.add(v);
                        break block15;
                    }
                    List<Object> vs = ConfigParser.getRuntimeValues(values, key, isKeyEncrypt, isValueEncrypt);
                    for (Object v : vs) {
                        if (null != v) {
                            if (null != (v = method.invoke((Object)clazz, v))) {
                                Object[] tmps;
                                if (v instanceof Collection) {
                                    tmps = (Object[])v;
                                    for (Object e : tmps) {
                                        list.add(e);
                                    }
                                }
                                if (v instanceof Object[]) {
                                    for (Object tmp : tmps = (Object[])v) {
                                        list.add(tmp);
                                    }
                                    continue;
                                }
                                list.add(v);
                                continue;
                            }
                            list.add(null);
                            continue;
                        }
                        list.add(null);
                    }
                    break block15;
                }
                if (1 == fetchValueType) {
                    Object v = ConfigParser.getRuntimeValue(values, key, isKeyEncrypt, isValueEncrypt);
                    list.add(v);
                } else {
                    list = ConfigParser.getRuntimeValues(values, key, isKeyEncrypt, isValueEncrypt);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (BasicUtil.isEmpty((boolean)true, list) && (defs = ConfigParser.getDefValues(values, parser)).size() > 0) {
            list = defs;
        }
        return list;
    }

    private static List<Object> getDefValues(Map<String, Object> values, ParseResult parser) {
        List<Object> result = new ArrayList<Object>();
        List<ParseResult> defs = parser.getDefs();
        if (null != defs) {
            for (ParseResult def : defs) {
                result = new ArrayList();
                String key = def.getKey();
                if (key.startsWith("${") && key.endsWith("}")) {
                    key = key.substring(2, key.length() - 1);
                    if (ParseResult.FETCH_REQUEST_VALUE_TYPE_MULTIPLE == parser.getParamFetchType()) {
                        String[] tmps;
                        if (key.startsWith("[") && key.endsWith("]")) {
                            key = key.substring(1, key.length() - 1);
                        }
                        for (String tmp : tmps = key.split(",")) {
                            if (!BasicUtil.isNotEmpty((Object)tmp)) continue;
                            result.add(tmp);
                        }
                    } else if (BasicUtil.isNotEmpty((Object)key)) {
                        result.add(key);
                    }
                } else if (1 == parser.getParamFetchType()) {
                    Object v = ConfigParser.getRuntimeValue(values, key, def.isKeyEncrypt(), def.isValueEncrypt());
                    if (BasicUtil.isNotEmpty((Object)v)) {
                        result.add(v);
                    }
                } else {
                    result = ConfigParser.getRuntimeValues(values, key, def.isKeyEncrypt(), def.isValueEncrypt());
                }
                if (BasicUtil.isEmpty((boolean)true, result)) continue;
                break;
            }
        }
        return result;
    }

    public static List<Object> getValues(ParseResult parser) {
        List<Object> result = new ArrayList<Object>();
        String value = parser.getKey();
        if (BasicUtil.isNotEmpty((Object)value)) {
            if (ParseResult.FETCH_REQUEST_VALUE_TYPE_MULTIPLE == parser.getParamFetchType()) {
                String[] values;
                if (value.startsWith("[") && value.endsWith("]")) {
                    value = value.substring(1, value.length() - 1);
                }
                for (String tmp : values = value.split(",")) {
                    if (!BasicUtil.isNotEmpty((Object)tmp)) continue;
                    result.add(tmp);
                }
            } else {
                result.add(parser.getKey());
            }
        }
        if (BasicUtil.isEmpty((boolean)true, result)) {
            result = ConfigParser.getDefValues(parser);
        }
        return result;
    }

    private static List<Object> getDefValues(ParseResult parser) {
        ArrayList<Object> result = new ArrayList<Object>();
        List<ParseResult> defs = parser.getDefs();
        if (null != defs) {
            for (ParseResult def : defs) {
                String key = def.getKey();
                if (ParseResult.FETCH_REQUEST_VALUE_TYPE_MULTIPLE == parser.getParamFetchType()) {
                    String[] tmps;
                    if (key.startsWith("[") && key.endsWith("]")) {
                        key = key.substring(1, key.length() - 1);
                    }
                    for (String tmp : tmps = key.split(",")) {
                        if (!BasicUtil.isNotEmpty((Object)tmp)) continue;
                        result.add(tmp);
                    }
                } else if (BasicUtil.isNotEmpty((Object)key)) {
                    result.add(key);
                }
                if (result.isEmpty()) continue;
                break;
            }
        }
        return result;
    }

    public static String createSQLSign(boolean page, boolean order, String src, ConfigStore store, String ... conditions) {
        conditions = BasicUtil.compress((String[])conditions);
        String result = src + "|";
        if (null != store) {
            OrderStore orders;
            List<Config> configs;
            ConfigChain chain = store.getConfigChain();
            if (null != chain && null != (configs = chain.getConfigs())) {
                for (Config config : configs) {
                    List<Object> values = config.getValues();
                    if (null == values) continue;
                    result = result + config.toString() + "|";
                }
            }
            PageNavi navi = store.getPageNavi();
            if (page && null != navi) {
                result = result + "page=" + navi.getCurPage() + "|first=" + navi.getFirstRow() + "|last=" + navi.getLastRow() + "|";
            }
            if (order && null != (orders = store.getOrders())) {
                result = result + orders.getRunText("").toUpperCase() + "|";
            }
        }
        if (null != conditions) {
            for (String condition : conditions) {
                if (!BasicUtil.isNotEmpty((Object)condition)) continue;
                if (condition.trim().toUpperCase().startsWith("ORDER")) {
                    if (!order) continue;
                    result = result + condition.toUpperCase() + "|";
                    continue;
                }
                result = result + condition + "|";
            }
        }
        return MD5Util.crypto((String)result);
    }

    public static String encryptRequestParam(String param) {
        if (null == param || "".equals(param.trim())) {
            return "";
        }
        return ConfigParser.encryptByType(param, ENCRYPT_TYPE_PARAM);
    }

    public static String decryptRequestParam(String param) {
        if (null == param) {
            return null;
        }
        return ConfigParser.decrypt(param, ENCRYPT_TYPE_PARAM);
    }

    public static String encryptHttpRequestParamKey(String key) {
        if (null == key || "".equals(key.trim())) {
            return "";
        }
        return ConfigParser.encryptKey(key);
    }

    public static String decryptParamKey(String key) {
        if (null == key) {
            return null;
        }
        return ConfigParser.decrypt(key, ENCRYPT_TYPE_KEY);
    }

    public static String encryptHttpRequestParamValue(String value) {
        if (null == value || "".equals(value.trim())) {
            return "";
        }
        return ConfigParser.encryptValue(value);
    }

    public static String decryptParamValue(String value) {
        if (null == value) {
            return null;
        }
        return ConfigParser.decrypt(value.trim(), ENCRYPT_TYPE_VALUE);
    }

    private static String encryptByType(String src, String type, boolean mix) {
        String result = null;
        if (null == src) {
            return null;
        }
        if (ConfigParser.isEncrypt(src, type)) {
            return src;
        }
        DESUtil des = DESUtil.getInstance((String)defaultDesKey.getKey(type));
        try {
            result = des.encrypt(src);
            result = ConfigParser.insertDESVersion(result);
            String pre = defaultDesKey.getPrefix(type);
            if (mix && ENCRYPT_TYPE_VALUE.equals(type)) {
                String rand = "v" + BasicUtil.getRandomNumberString((int)5) + "v";
                pre = rand + pre;
            }
            result = pre + result;
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }

    public static String encryptByType(String src, String type) {
        return ConfigParser.encryptByType(src, type, false);
    }

    public static String encryptKey(String src) {
        if (null == src) {
            return src;
        }
        return ConfigParser.encryptByType(src, ENCRYPT_TYPE_KEY);
    }

    public static String encryptValue(String src, boolean mix) {
        if (null == src) {
            return src;
        }
        return ConfigParser.encryptByType(src, ENCRYPT_TYPE_VALUE, mix);
    }

    public static String encryptValue(String src) {
        return ConfigParser.encryptValue(src, false);
    }

    public static boolean isEncrypt(String src, String type) {
        if (null == src) {
            return false;
        }
        try {
            String value = ConfigParser.decrypt(src, type);
            return null != value;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static String decrypt(String src, String type) {
        String result;
        block2: {
            DESKey key;
            if (null == src || null == type) {
                return null;
            }
            result = null;
            result = ConfigParser.decrypt(src, defaultDesKey, type);
            if (null != result) break block2;
            Iterator<String> versions = deskeys.keySet().iterator();
            while (versions.hasNext() && null == (result = ConfigParser.decrypt(src, key = deskeys.get(versions.next()), type))) {
            }
        }
        return result;
    }

    private static String decrypt(String src, DESKey key, String type) {
        if (ConfigTable.getBoolean((String)"IS_DECRYPT_LOG")) {
            log.info("[decrypt][start][src:{}][type:{}]", (Object)src, (Object)type);
        }
        if (null != src && DESUtil.ignores.contains(src)) {
            return src;
        }
        String result = src;
        if (null == src) {
            return null;
        }
        if (ENCRYPT_TYPE_VALUE.equals(type) && RegularUtil.match((String)result, (String)"v\\d{5}v", (Regular.MATCH_MODE)Regular.MATCH_MODE.PREFIX)) {
            result = result.substring(7);
            if (ConfigTable.getBoolean((String)"IS_DECRYPT_LOG")) {
                log.info("[decrypt][\u5220\u9664\u6df7\u6dc6\u7801][result:{}]", (Object)result);
            }
        }
        try {
            DESUtil des;
            String[] tmp;
            String prefix = key.getPrefix(type);
            int sub = -1;
            if (null != prefix) {
                sub = prefix.length();
            }
            if (sub > result.length() || sub == -1) {
                return null;
            }
            result = result.substring(sub);
            if (ConfigTable.getBoolean((String)"IS_DECRYPT_LOG")) {
                log.info("[decrypt][\u5220\u9664\u524d\u7f00][result:{}]", (Object)result);
            }
            if (null != (tmp = ConfigParser.parseDESVersion(result)) && tmp.length == 2 && key.getVersion().equals(tmp[0])) {
                result = tmp[1];
            }
            if (null != (des = DESUtil.getInstance((String)key.getKey(type)))) {
                try {
                    result = des.decrypt(result);
                }
                catch (Exception e) {
                    result = null;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        if (ConfigTable.getBoolean((String)"IS_DECRYPT_LOG")) {
            log.info("[decrypt][end][result:{}]", (Object)result);
        }
        return result;
    }

    public static String encryptUrl(String url) {
        if (null == url || !url.contains("?")) {
            return url;
        }
        String param = url.substring(url.indexOf("?") + 1);
        try {
            param = ConfigParser.encryptRequestParam(param);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        url = url.substring(0, url.indexOf("?") + 1) + param;
        return url;
    }

    public static String encryptUrl(String url, boolean union, boolean encryptKey, boolean encryptValue) {
        if (null == url || !url.contains("?")) {
            return url;
        }
        String param = url.substring(url.indexOf("?") + 1);
        try {
            if (union) {
                param = ConfigParser.encryptRequestParam(param);
            } else {
                String[] params = param.split("&");
                param = "";
                for (String p : params) {
                    String[] kv = p.split("=");
                    if (kv.length != 2) continue;
                    String k = kv[0];
                    if (encryptKey) {
                        k = ConfigParser.encryptKey(k);
                    }
                    String v = kv[1];
                    if (encryptValue) {
                        v = ConfigParser.encryptValue(v);
                    }
                    if (!"".equals(params)) {
                        param = param + "&";
                    }
                    param = param + k + "=" + v;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        url = url.substring(0, url.indexOf("?") + 1) + param;
        return url;
    }

    public static String encryptHtmlTagA(String tag) {
        try {
            String url = RegularUtil.fetchUrl((String)tag);
            tag = tag.replace(url, ConfigParser.encryptUrl(url));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tag;
    }

    private static List<Object> getRuntimeValuesFromDecryptMap(Map<String, Object> values, String key, boolean valueEncrypt) {
        ArrayList<Object> result = new ArrayList<Object>();
        valueEncrypt = false;
        Map partMap = (Map)values.get("DECRYPT_PARAM_MAP");
        List list = null;
        if (null != key && null != partMap && (null == (list = (List)partMap.get(ConfigParser.encryptHttpRequestParamKey(key))) || list.size() == 0)) {
            list = (List)partMap.get(key);
        }
        if (null != values && null != list) {
            if (valueEncrypt) {
                for (String value : list) {
                    value = ConfigParser.decryptParamValue(value);
                    result.add(value);
                }
            } else {
                result.addAll(list);
            }
        }
        return result;
    }

    private static String getRuntimeValueFormDecryptMap(Map<String, Object> values, String key, boolean valueEncrypt) {
        Object tmp;
        String result = null;
        List<Object> list = ConfigParser.getRuntimeValuesFromDecryptMap(values, key, valueEncrypt);
        if (null != list && list.size() > 0 && null != (tmp = list.get(0))) {
            result = tmp.toString().trim();
        }
        return result;
    }

    public static List<Object> getRuntimeValues(Map<String, Object> values, String key, boolean keyEncrypt, boolean valueEncrypt) {
        ArrayList<Object> result = new ArrayList<String>();
        if (null == values || null == key) {
            return null;
        }
        if (key.startsWith("${") && key.endsWith("}")) {
            result.add(key.substring(2, key.length() - 1));
        } else if (keyEncrypt) {
            result = ConfigParser.getRuntimeValuesFromDecryptMap(values, key, valueEncrypt);
        } else {
            Object obj = values.get(key);
            if (null != obj) {
                if (obj instanceof Collection) {
                    Collection cols = (Collection)obj;
                    for (Object value : cols) {
                        if (null == value) {
                            result.add("");
                        } else {
                            if (valueEncrypt && null != (value = ConfigParser.decryptParamValue(value.toString()))) {
                                value = ConfigParser.filterIllegalChar(value.toString());
                            }
                            if (null != value) {
                                value = ConfigParser.filterIllegalChar(value);
                            }
                        }
                        result.add(value);
                    }
                } else if (valueEncrypt) {
                    result.add(ConfigParser.decryptParamValue(obj.toString()));
                } else {
                    result.add(obj.toString());
                }
            }
        }
        return result;
    }

    public static List<Object> getRuntimeValues(Map<String, Object> values, String param, boolean keyEncrypt) {
        return ConfigParser.getRuntimeValues(values, param, keyEncrypt, false);
    }

    public static List<Object> getRuntimeValues(Map<String, Object> values, String param) {
        return ConfigParser.getRuntimeValues(values, param, false, false);
    }

    public static Object getRuntimeValue(Map<String, Object> values, String key, boolean keyEncrypt, boolean valueEncrypt) {
        String result = "";
        List<Object> list = ConfigParser.getRuntimeValues(values, key, keyEncrypt, valueEncrypt);
        if (null != list && list.size() > 0) {
            result = (String)list.get(0);
        }
        return result;
    }

    public static Object getRuntimeValue(Map<String, Object> values, String param, boolean keyEncrypt) {
        return ConfigParser.getRuntimeValue(values, param, keyEncrypt, false);
    }

    public static Object getRuntimeValue(Map<String, Object> values, String param) {
        return ConfigParser.getRuntimeValue(values, param, false, false);
    }

    public static Object filterIllegalChar(Object src) {
        block5: {
            block7: {
                block6: {
                    block4: {
                        if (null == src) {
                            return src;
                        }
                        if (!(src instanceof String)) break block4;
                        src = XssUtil.strip((String)src.toString());
                        break block5;
                    }
                    if (!(src instanceof Map)) break block6;
                    Map map = (Map)src;
                    List keys = BeanUtil.getMapKeys((Map)map);
                    for (String key : keys) {
                        map.put(key, ConfigParser.filterIllegalChar(map.get(key)));
                    }
                    break block5;
                }
                if (!(src instanceof Collection)) break block7;
                Collection cols = (Collection)src;
                for (Object value : cols) {
                    value = ConfigParser.filterIllegalChar(value);
                }
                break block5;
            }
            if (!ClassUtil.isWrapClass(src.getClass())) break block5;
            List keys = ClassUtil.getFieldsName(src.getClass());
            for (String key : keys) {
                Object value = BeanUtil.getFieldValue((Object)src, (String)key);
                BeanUtil.setFieldValue((Object)src, (String)key, (Object)ConfigParser.filterIllegalChar(value));
            }
        }
        return src;
    }

    private static int getDESVersionIndex(String src) {
        int idx = -1;
        if (null != src && src.length() > 12) {
            String tmp = src.substring(12);
            int len = tmp.length();
            String chr = src.substring(len / 2, len / 2 + 1);
            idx = chr.toCharArray()[0];
            idx = Math.abs(idx % 12);
        }
        return idx;
    }

    private static String insertDESVersion(String src, String version) {
        int idx = ConfigParser.getDESVersionIndex(src);
        if (idx >= 0) {
            src = BasicUtil.insert((String)src, (int)idx, (String)version);
        }
        return src;
    }

    private static String insertDESVersion(String src) {
        return ConfigParser.insertDESVersion(src, defaultDesKey.getVersion());
    }

    private static String[] parseDESVersion(String src) {
        String[] result = null;
        if (null != src && src.length() > 3) {
            try {
                result = new String[2];
                String tmp = src.substring(3);
                int idx = ConfigParser.getDESVersionIndex(tmp);
                if (idx >= 0) {
                    result[0] = src.substring(idx, idx + 3);
                    result[1] = src.substring(0, idx) + src.substring(idx + 3);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    static {
        deskeys = new HashMap<String, DESKey>();
        try {
            String keyPath = ConfigTable.getString((String)"DES_KEY_FILE");
            if (BasicUtil.isNotEmpty((Object)keyPath)) {
                if (keyPath.contains("${classpath}")) {
                    keyPath = keyPath.replace("${classpath}", ConfigTable.getClassPath());
                } else if (keyPath.startsWith("/")) {
                    keyPath = ConfigTable.getWebRoot() + keyPath;
                }
                File keyFile = new File(keyPath);
                if (keyFile.exists()) {
                    SAXReader reader = new SAXReader();
                    Document document = reader.read(keyFile);
                    Element root = document.getRootElement();
                    Iterator itrKey = root.elementIterator();
                    while (itrKey.hasNext()) {
                        Element element = (Element)itrKey.next();
                        DESKey key = new DESKey();
                        String version = element.attributeValue("version");
                        key.setVersion(version);
                        key.setKey(element.elementTextTrim("des-key"));
                        key.setKeyParam(element.elementTextTrim("des-key-param"));
                        key.setKeyParamName(element.elementTextTrim("des-key-param-name"));
                        key.setKeyParamValue(element.elementTextTrim("des-key-param-value"));
                        key.setPrefix(element.elementTextTrim("des-prefix"));
                        key.setPrefixParam(element.elementTextTrim("des-prefix-param"));
                        key.setPrefixParamName(element.elementTextTrim("des-prefix-param-name"));
                        key.setPrefixParamValue(element.elementTextTrim("des-prefix-param-value"));
                        if (null == defaultDesKey) {
                            defaultDesKey = key;
                            continue;
                        }
                        deskeys.put(version, key);
                    }
                }
            }
            if (null == defaultDesKey) {
                defaultDesKey = new DESKey();
                String version = "vic";
                defaultDesKey.setVersion(version);
                defaultDesKey.setKey("5*(YHU*6d9");
                defaultDesKey.setKeyParam("@#$%0(*7#");
                defaultDesKey.setKeyParamName("@#$%#");
                defaultDesKey.setKeyParamValue("@#23$%097#");
                defaultDesKey.setPrefix("");
                defaultDesKey.setPrefixParam("als7n6e9o1r5gv78ac1vice624c623f");
                defaultDesKey.setPrefixParamName("l80j0sa9n2y1l4i7n6e9o1r5gk");
                defaultDesKey.setPrefixParamValue("p298pn6e9o1r5gv");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

