/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.adapter.init;

import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.anyline.adapter.DataReader;
import org.anyline.adapter.DataWriter;
import org.anyline.adapter.EntityAdapter;
import org.anyline.adapter.KeyAdapter;
import org.anyline.adapter.init.ConvertAdapter;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.listener.DDListener;
import org.anyline.data.listener.DMListener;
import org.anyline.data.metadata.StandardColumnType;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.prepare.RunPrepare;
import org.anyline.data.prepare.auto.TablePrepare;
import org.anyline.data.prepare.auto.TextPrepare;
import org.anyline.data.prepare.auto.init.DefaultTablePrepare;
import org.anyline.data.prepare.xml.XMLPrepare;
import org.anyline.data.run.BasicRun;
import org.anyline.data.run.Run;
import org.anyline.data.run.RunValue;
import org.anyline.data.run.SimpleRun;
import org.anyline.data.run.TableRun;
import org.anyline.data.run.TextRun;
import org.anyline.data.run.XMLRun;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.data.util.DataSourceUtil;
import org.anyline.data.util.ThreadConfig;
import org.anyline.entity.Compare;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.entity.generator.GeneratorConfig;
import org.anyline.entity.generator.PrimaryGenerator;
import org.anyline.exception.SQLUpdateException;
import org.anyline.metadata.ACTION;
import org.anyline.metadata.Column;
import org.anyline.metadata.Constraint;
import org.anyline.metadata.Database;
import org.anyline.metadata.ForeignKey;
import org.anyline.metadata.Function;
import org.anyline.metadata.Index;
import org.anyline.metadata.MasterTable;
import org.anyline.metadata.Parameter;
import org.anyline.metadata.PartitionTable;
import org.anyline.metadata.PrimaryKey;
import org.anyline.metadata.Procedure;
import org.anyline.metadata.Table;
import org.anyline.metadata.Tag;
import org.anyline.metadata.Trigger;
import org.anyline.metadata.View;
import org.anyline.metadata.type.ColumnType;
import org.anyline.metadata.type.DatabaseType;
import org.anyline.proxy.EntityAdapterProxy;
import org.anyline.proxy.InterceptorProxy;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.ClassUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.LogUtil;
import org.anyline.util.SQLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class DefaultDriverAdapter
implements DriverAdapter {
    protected static final Logger log = LoggerFactory.getLogger(DefaultDriverAdapter.class);
    @Autowired(required=false)
    protected DMListener dmListener;
    @Autowired(required=false)
    protected DDListener ddListener;
    protected DatabaseType db;
    public String delimiterFr = "";
    public String delimiterTo = "";
    protected Map<String, ColumnType> types = new Hashtable<String, ColumnType>();
    protected Map<Object, DataReader> readers = new Hashtable<Object, DataReader>();
    protected Map<Object, DataWriter> writers = new Hashtable<Object, DataWriter>();
    @Autowired(required=false)
    protected PrimaryGenerator primaryGenerator;
    protected Map<String, String> versions = new Hashtable<String, String>();

    public DMListener getListener() {
        return this.dmListener;
    }

    @Autowired(required=false)
    public void setListener(DMListener listener) {
        this.dmListener = listener;
    }

    @Override
    public String version() {
        return null;
    }

    @Override
    public DatabaseType compatible() {
        return null;
    }

    public DefaultDriverAdapter() {
        block0: for (StandardColumnType type : StandardColumnType.values()) {
            DatabaseType[] dbs;
            for (DatabaseType db : dbs = type.dbs()) {
                if (db != this.type()) continue;
                this.types.put(type.getName(), type);
                continue block0;
            }
        }
    }

    @Override
    public String getDelimiterFr() {
        return this.delimiterFr;
    }

    @Override
    public String getDelimiterTo() {
        return this.delimiterTo;
    }

    protected PrimaryGenerator checkPrimaryGenerator(DatabaseType type, String table) {
        PrimaryGenerator generator = GeneratorConfig.get((String)table);
        if (null != generator && generator != PrimaryGenerator.GENERATOR.DISABLE && generator != PrimaryGenerator.GENERATOR.AUTO) {
            return generator;
        }
        if (null == this.primaryGenerator) {
            if (null == this.primaryGenerator) {
                this.primaryGenerator = GeneratorConfig.get();
            }
            if (null == this.primaryGenerator) {
                if (ConfigTable.PRIMARY_GENERATOR_SNOWFLAKE_ACTIVE) {
                    this.primaryGenerator = PrimaryGenerator.GENERATOR.SNOWFLAKE;
                } else if (ConfigTable.PRIMARY_GENERATOR_UUID_ACTIVE) {
                    this.primaryGenerator = PrimaryGenerator.GENERATOR.RANDOM;
                } else if (ConfigTable.PRIMARY_GENERATOR_UUID_ACTIVE) {
                    this.primaryGenerator = PrimaryGenerator.GENERATOR.UUID;
                } else if (ConfigTable.PRIMARY_GENERATOR_TIME_ACTIVE) {
                    this.primaryGenerator = PrimaryGenerator.GENERATOR.TIME;
                } else if (ConfigTable.PRIMARY_GENERATOR_TIMESTAMP_ACTIVE) {
                    this.primaryGenerator = PrimaryGenerator.GENERATOR.TIMESTAMP;
                }
            }
        }
        if (null != this.primaryGenerator) {
            return this.primaryGenerator;
        }
        return null;
    }

    public void setDelimiter(String delimiter) {
        if (BasicUtil.isNotEmpty((Object)delimiter)) {
            if ((delimiter = delimiter.replaceAll("\\s", "")).length() == 1) {
                this.delimiterFr = delimiter;
                this.delimiterTo = delimiter;
            } else {
                this.delimiterFr = delimiter.substring(0, 1);
                this.delimiterTo = delimiter.substring(1, 2);
            }
        }
    }

    @Override
    public ColumnType type(String type) {
        if (null == type) {
            return null;
        }
        return this.types.get(type.toUpperCase());
    }

    @Override
    public DataReader reader(Class clazz) {
        if (null == clazz) {
            return null;
        }
        return this.readers.get(clazz);
    }

    @Override
    public DataReader reader(ColumnType type) {
        if (null == type) {
            return null;
        }
        return this.readers.get(type);
    }

    @Override
    public DataWriter writer(Object support) {
        if (null == support) {
            return null;
        }
        return this.writers.get(support);
    }

    @Override
    public Run buildInsertRun(DataRuntime runtime, int batch, String dest, Object obj, boolean checkPrimary, List<String> columns) {
        if (null == obj) {
            return null;
        }
        if (null == dest) {
            dest = DataSourceUtil.parseDataSource(dest, obj);
        }
        if (obj instanceof Collection) {
            Collection list = (Collection)obj;
            if (list.size() > 0) {
                return this.createInsertRunFromCollection(runtime, batch, dest, list, checkPrimary, columns);
            }
            return null;
        }
        return this.createInsertRun(runtime, dest, obj, checkPrimary, columns);
    }

    @Override
    public void fillInsertContent(DataRuntime runtime, Run run, String dest, DataSet set, LinkedHashMap<String, Column> columns) {
    }

    @Override
    public void fillInsertContent(DataRuntime runtime, Run run, String dest, Collection list, LinkedHashMap<String, Column> columns) {
    }

    @Override
    public LinkedHashMap<String, Column> confirmInsertColumns(DataRuntime runtime, String dest, Object obj, List<String> columns, boolean batch) {
        LinkedHashMap cols = new LinkedHashMap<String, Column>();
        if (null == obj) {
            return new LinkedHashMap<String, Column>();
        }
        LinkedHashMap<String, Column> mastKeys = new LinkedHashMap<String, Column>();
        ArrayList<String> ignores = new ArrayList<String>();
        ArrayList<String> factKeys = new ArrayList<String>();
        boolean each = true;
        if (null != columns && columns.size() > 0) {
            each = false;
            cols = new LinkedHashMap();
            for (String column : columns) {
                if (BasicUtil.isEmpty((Object)column)) continue;
                if (column.startsWith("+")) {
                    column = column.substring(1);
                    mastKeys.put(column.toUpperCase(), new Column(column));
                    each = true;
                } else if (column.startsWith("-")) {
                    column = column.substring(1);
                    ignores.add(column);
                    each = true;
                } else if (column.startsWith("?")) {
                    column = column.substring(1);
                    factKeys.add(column);
                    each = true;
                }
                cols.put(column.toUpperCase(), new Column(column));
            }
        }
        if (each) {
            boolean isInsertNullColumn = false;
            boolean isInsertEmptyColumn = false;
            DataRow row = null;
            if (obj instanceof DataRow) {
                row = (DataRow)obj;
                mastKeys.putAll(row.getUpdateColumns(true));
                ignores.addAll(row.getIgnoreUpdateColumns());
                cols = row.getColumns();
                isInsertNullColumn = row.isInsertNullColumn();
                isInsertEmptyColumn = row.isInsertEmptyColumn();
            } else {
                isInsertNullColumn = ConfigTable.IS_INSERT_NULL_FIELD;
                isInsertEmptyColumn = ConfigTable.IS_INSERT_EMPTY_FIELD;
                if (EntityAdapterProxy.hasAdapter(obj.getClass())) {
                    cols.putAll(EntityAdapterProxy.columns(obj.getClass(), (EntityAdapter.MODE)EntityAdapter.MODE.INSERT));
                } else {
                    cols = new LinkedHashMap();
                    List fields = ClassUtil.getFields(obj.getClass(), (boolean)false, (boolean)false);
                    Iterator iterator = fields.iterator();
                    while (iterator.hasNext()) {
                        Field field = (Field)iterator.next();
                        Class<?> clazz = field.getType();
                        if (clazz != String.class && clazz != Date.class && !ClassUtil.isPrimitiveClass(clazz)) continue;
                        cols.put(field.getName().toUpperCase(), new Column(field.getName()));
                    }
                }
            }
            if (batch) {
                isInsertNullColumn = true;
                isInsertEmptyColumn = true;
            }
            if (log.isDebugEnabled()) {
                log.debug("[confirm insert columns][columns:{}]", (Object)cols);
            }
            BeanUtil.removeAll(ignores, columns);
            for (String ignore : ignores) {
                cols.remove(ignore.toUpperCase());
            }
            if (log.isDebugEnabled()) {
                log.debug("[confirm insert columns][ignores:{}]", ignores);
            }
            List keys = BeanUtil.getMapKeys((Map)cols);
            for (String key : keys) {
                if (mastKeys.containsKey(key = key.toUpperCase())) continue;
                Object value = null;
                value = !(obj instanceof Map) && EntityAdapterProxy.hasAdapter(obj.getClass()) ? BeanUtil.getFieldValue((Object)obj, (Field)EntityAdapterProxy.field(obj.getClass(), (String)key)) : BeanUtil.getFieldValue((Object)obj, (String)key);
                if (null == value) {
                    if (factKeys.contains(key)) {
                        cols.remove(key);
                        continue;
                    }
                    if (isInsertNullColumn) continue;
                    cols.remove(key);
                    continue;
                }
                if (!BasicUtil.isEmpty((boolean)true, (Object)value)) continue;
                if (factKeys.contains(key)) {
                    cols.remove(key);
                    continue;
                }
                if (isInsertEmptyColumn) continue;
                cols.remove(key);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("[confirm insert columns][result:{}]", cols);
        }
        cols = this.checkMetadata(runtime, dest, cols);
        return cols;
    }

    @Override
    public String batchInsertSeparator() {
        return ",";
    }

    @Override
    public boolean supportInsertPlaceholder() {
        return true;
    }

    protected void setPrimaryValue(Object obj, Object value) {
        if (null == obj) {
            return;
        }
        if (obj instanceof DataRow) {
            DataRow row = (DataRow)obj;
            row.put(row.getPrimaryKey(), value);
        } else {
            Column key = EntityAdapterProxy.primaryKey(obj.getClass());
            Field field = EntityAdapterProxy.field(obj.getClass(), (Column)key);
            BeanUtil.setFieldValue((Object)obj, (Field)field, (Object)value);
        }
    }

    protected Run createInsertRun(DataRuntime runtime, String dest, Object obj, boolean checkPrimary, List<String> columns) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 Run createInsertRun(DataRuntime runtime, String dest, Object obj, boolean checkPrimary, List<String> columns)"), (int)37));
        }
        return null;
    }

    protected Run createInsertRunFromCollection(DataRuntime runtime, int batch, String dest, Collection list, boolean checkPrimary, List<String> columns) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 Run createInsertRunFromCollection(DataRuntime runtime, int batch, String dest, Collection list, boolean checkPrimary, List<String> columns)"), (int)37));
        }
        return null;
    }

    @Override
    public String generatedKey() {
        return null;
    }

    @Override
    public Run buildUpdateRun(DataRuntime runtime, int batch, String dest, Object obj, ConfigStore configs, boolean checkPrimary, List<String> columns) {
        if (null == obj) {
            return null;
        }
        if (null == dest) {
            dest = DataSourceUtil.parseDataSource(null, obj);
        }
        if (!(obj instanceof DataRow) && obj instanceof Map) {
            obj = new DataRow((Map)obj);
        }
        if (obj instanceof Collection) {
            return this.buildUpdateRunFromCollection(runtime, batch, dest, (Collection)obj, configs, checkPrimary, columns);
        }
        if (obj instanceof DataRow) {
            return this.buildUpdateRunFromDataRow(runtime, dest, (DataRow)obj, configs, checkPrimary, columns);
        }
        return this.buildUpdateRunFromEntity(runtime, dest, obj, configs, checkPrimary, columns);
    }

    protected Run buildUpdateRunFromEntity(DataRuntime runtime, String dest, Object obj, ConfigStore configs, boolean checkPrimary, List<String> columns) {
        LinkedHashMap<String, Column> cols = new LinkedHashMap<String, Column>();
        if (null != columns) {
            for (String column : columns) {
                cols.put(column.toUpperCase(), new Column(column));
            }
        }
        return this.buildUpdateRunFromEntity(runtime, dest, obj, configs, checkPrimary, cols);
    }

    protected Run buildUpdateRunFromDataRow(DataRuntime runtime, String dest, DataRow row, ConfigStore configs, boolean checkPrimary, List<String> columns) {
        LinkedHashMap<String, Column> cols = new LinkedHashMap<String, Column>();
        if (null != columns) {
            for (String column : columns) {
                cols.put(column.toUpperCase(), new Column(column));
            }
        }
        return this.buildUpdateRunFromDataRow(runtime, dest, row, configs, checkPrimary, cols);
    }

    protected Run buildUpdateRunFromCollection(DataRuntime runtime, int batch, String dest, Collection list, ConfigStore configs, boolean checkPrimary, List<String> columns) {
        LinkedHashMap<String, Column> cols = new LinkedHashMap<String, Column>();
        if (null != columns) {
            for (String column : columns) {
                cols.put(column.toUpperCase(), new Column(column));
            }
        }
        return this.buildUpdateRunFromCollection(runtime, batch, dest, list, configs, checkPrimary, cols);
    }

    public LinkedHashMap<String, Column> checkMetadata(DataRuntime runtime, String table, LinkedHashMap<String, Column> columns) {
        if (!ConfigTable.IS_AUTO_CHECK_METADATA) {
            return columns;
        }
        LinkedHashMap<String, Column> result = new LinkedHashMap<String, Column>();
        LinkedHashMap metadatas = this.columns(runtime, null, false, new Table(table), false);
        if (metadatas.size() > 0) {
            for (String key : columns.keySet()) {
                if (metadatas.containsKey(key)) {
                    result.put(key, columns.get(key));
                    continue;
                }
                log.warn("[{}][column:{}.{}][insert/update\u5ffd\u7565\u5f53\u524d\u5217\u540d]", new Object[]{LogUtil.format((String)"\u5217\u540d\u68c0\u6d4b\u4e0d\u5b58\u5728", (int)33), table, key});
            }
        } else {
            log.warn("[{}][table:{}][\u5ffd\u7565\u5217\u540d\u68c0\u6d4b]", (Object)LogUtil.format((String)"\u8868\u7ed3\u6784\u68c0\u6d4b\u5931\u8d25(\u68c0\u67e5\u8868\u540d\u662f\u5426\u5b58\u5728)", (int)33), (Object)table);
        }
        log.info("[check column metadata][src:{}][result:{}]", (Object)columns.size(), (Object)result.size());
        return result;
    }

    protected LinkedHashMap<String, Column> confirmUpdateColumns(DataRuntime runtime, String dest, DataRow row, ConfigStore configs, List<String> columns) {
        LinkedHashMap<String, Column> cols = null;
        if (null == row) {
            return new LinkedHashMap<String, Column>();
        }
        boolean each = true;
        ArrayList conditions = new ArrayList();
        LinkedHashMap masters = row.getUpdateColumns(true);
        List ignores = BeanUtil.copy((Collection)row.getIgnoreUpdateColumns());
        ArrayList<String> factKeys = new ArrayList<String>();
        BeanUtil.removeAll((List)ignores, columns);
        if (null != columns && columns.size() > 0) {
            each = false;
            cols = new LinkedHashMap<String, Column>();
            for (String column : columns) {
                if (BasicUtil.isEmpty((Object)column)) continue;
                if (column.startsWith("+")) {
                    column = column.substring(1);
                    masters.put(column.toUpperCase(), new Column(column));
                    each = true;
                } else if (column.startsWith("-")) {
                    column = column.substring(1);
                    ignores.add(column);
                    each = true;
                } else if (column.startsWith("?")) {
                    column = column.substring(1);
                    factKeys.add(column);
                    each = true;
                }
                cols.put(column.toUpperCase(), new Column(column));
            }
        } else if (null != masters && masters.size() > 0) {
            each = false;
            cols = masters;
        }
        if (each) {
            cols = row.getUpdateColumns(true);
            cols.putAll(masters);
            boolean isUpdateNullColumn = row.isUpdateNullColumn();
            boolean isUpdateEmptyColumn = row.isUpdateEmptyColumn();
            List keys = BeanUtil.getMapKeys(cols);
            int size = keys.size();
            for (int i = size - 1; i >= 0; --i) {
                String key = (String)keys.get(i);
                if (masters.containsKey(key)) continue;
                Object value = row.get(key);
                if (null == value) {
                    if (factKeys.contains(key)) {
                        keys.remove(key);
                        continue;
                    }
                    if (isUpdateNullColumn) continue;
                    keys.remove(i);
                    continue;
                }
                if (!"".equals(value.toString().trim())) continue;
                if (factKeys.contains(key)) {
                    keys.remove(key);
                    continue;
                }
                if (isUpdateEmptyColumn) continue;
                keys.remove(i);
            }
        }
        if (null != ignores) {
            for (String ignore : ignores) {
                cols.remove(ignore.toUpperCase());
            }
        }
        cols = this.checkMetadata(runtime, dest, cols);
        return cols;
    }

    @Override
    public long update(DataRuntime runtime, String random, int batch, String dest, Object data, ConfigStore configs, List<String> columns) {
        dest = DataSourceUtil.parseDataSource(dest, data);
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        boolean cmd_success = false;
        if (null == random) {
            random = this.random(runtime);
        }
        if ((swt = InterceptorProxy.prepareUpdate(runtime, random, batch, dest, data, configs, columns)) == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        if (null != this.dmListener) {
            swt = this.dmListener.prepareUpdate(runtime, random, batch, dest, data, configs, false, columns);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        if (null == data) {
            if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                throw new SQLUpdateException("\u66f4\u65b0\u7a7a\u6570\u636e");
            }
            log.error("\u66f4\u65b0\u7a7a\u6570\u636e");
        }
        long result = 0L;
        if (data instanceof Collection && batch <= 1) {
            Collection list = (Collection)data;
            for (Object item : list) {
                result += this.update(runtime, random, 0, dest, item, configs, columns);
            }
            return result;
        }
        Run run = this.buildUpdateRun(runtime, batch, dest, data, configs, false, columns);
        Table table = new Table(dest);
        if (ConfigTable.IS_AUTO_CHECK_METADATA) {
            table.setColumns(this.columns(runtime, null, false, table, false));
        }
        if (!run.isValid()) {
            if (ConfigTable.IS_SHOW_SQL && log.isWarnEnabled()) {
                log.warn("[valid:false][\u4e0d\u5177\u5907\u6267\u884c\u6761\u4ef6][dest:" + dest + "]");
            }
            return -1L;
        }
        long fr = System.currentTimeMillis();
        long millis = -1L;
        swt = InterceptorProxy.beforeUpdate(runtime, random, run, dest, data, configs, columns);
        if (swt == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        if (null != this.dmListener) {
            swt = this.dmListener.beforeUpdate(runtime, random, run, dest, data, columns);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return -1L;
        }
        result = this.update(runtime, random, dest, data, run);
        cmd_success = true;
        millis = System.currentTimeMillis() - fr;
        if (null != this.dmListener) {
            this.dmListener.afterUpdate(runtime, random, run, result, dest, data, columns, cmd_success, result, millis);
        }
        InterceptorProxy.afterUpdate(runtime, random, run, dest, data, configs, columns, cmd_success, result, System.currentTimeMillis() - fr);
        return result;
    }

    @Override
    public Run buildQueryRun(DataRuntime runtime, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        BasicRun run = null;
        if (prepare instanceof TablePrepare) {
            run = new TableRun(runtime, prepare.getTable());
        } else if (prepare instanceof XMLPrepare) {
            run = new XMLRun();
        } else if (prepare instanceof TextPrepare) {
            run = new TextRun();
        }
        if (null != run) {
            run.setRuntime(runtime);
            run.setPrepare(prepare);
            run.setConfigStore(configs);
            run.addCondition(conditions);
            if (run.checkValid()) {
                run.init();
                this.fillQueryContent(runtime, run);
            }
        }
        return run;
    }

    @Override
    public void fillQueryContent(DataRuntime runtime, Run run) {
        if (null != run) {
            if (run instanceof TableRun) {
                TableRun r = (TableRun)run;
                this.fillQueryContent(runtime, r);
            } else if (run instanceof XMLRun) {
                XMLRun r = (XMLRun)run;
                this.fillQueryContent(runtime, r);
            } else if (run instanceof TextRun) {
                TextRun r = (TextRun)run;
                this.fillQueryContent(runtime, r);
            }
        }
    }

    protected void fillQueryContent(DataRuntime runtime, XMLRun run) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 fillQueryContent(DataRuntime runtime, XMLRun run)"), (int)37));
        }
    }

    protected void fillQueryContent(DataRuntime runtime, TextRun run) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 fillQueryContent(DataRuntime runtime, TextRun run)"), (int)37));
        }
    }

    protected void fillQueryContent(DataRuntime runtime, TableRun run) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 fillQueryContent(DataRuntime runtime, TableRun run)"), (int)37));
        }
    }

    @Override
    public List<Run> buildQuerySequence(DataRuntime runtime, boolean next, String ... names) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildQuerySequence(DataRuntime runtime, boolean next, String ... names)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public void fillExecuteContent(DataRuntime runtime, Run run) {
        if (null != run) {
            if (run instanceof TableRun) {
                TableRun r = (TableRun)run;
                this.fillExecuteContent(runtime, r);
            } else if (run instanceof XMLRun) {
                XMLRun r = (XMLRun)run;
                this.fillExecuteContent(runtime, r);
            } else if (run instanceof TextRun) {
                TextRun r = (TextRun)run;
                this.fillExecuteContent(runtime, r);
            }
        }
    }

    protected void fillExecuteContent(DataRuntime runtime, XMLRun run) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 fillExecuteContent(DataRuntime runtime, XMLRun run)"), (int)37));
        }
    }

    protected void fillExecuteContent(DataRuntime runtime, TextRun run) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 fillExecuteContent(DataRuntime runtime, TextRun run)"), (int)37));
        }
    }

    protected void fillExecuteContent(DataRuntime runtime, TableRun run) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 fillExecuteContent(DataRuntime runtime, TableRun run)"), (int)37));
        }
    }

    @Override
    public List<Map<String, Object>> process(DataRuntime runtime, List<Map<String, Object>> list) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Map<String,Object>> process(DataRuntime runtime, List<Map<String,Object>> list)"), (int)37));
        }
        return list;
    }

    @Override
    public Run buildExecuteRun(DataRuntime runtime, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        BasicRun run = null;
        if (prepare instanceof XMLPrepare) {
            run = new XMLRun();
        } else if (prepare instanceof TextPrepare) {
            run = new TextRun();
        }
        if (null != run) {
            run.setRuntime(runtime);
            run.setPrepare(prepare);
            run.setConfigStore(configs);
            run.addCondition(conditions);
            run.init();
            this.fillQueryContent(runtime, run);
        }
        return run;
    }

    @Override
    public String mergeFinalExists(DataRuntime runtime, Run run) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 String mergeFinalExists(DataRuntime runtime, Run run)"), (int)37));
        }
        return null;
    }

    @Override
    public String mergeFinalTotal(DataRuntime runtime, Run run) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 String mergeFinalTotal(DataRuntime runtime, Run run)"), (int)37));
        }
        return null;
    }

    @Override
    public Run buildDeleteRun(DataRuntime runtime, int batch, String table, String key, Object values) {
        return this.buildDeleteRunFromTable(runtime, batch, table, key, values);
    }

    @Override
    public Run buildDeleteRun(DataRuntime runtime, String dest, Object obj, String ... columns) {
        if (null == obj) {
            return null;
        }
        Run run = null;
        if (null == dest) {
            dest = DataSourceUtil.parseDataSource(dest, obj);
        }
        if (null == dest) {
            Table table;
            Object entity = obj;
            if (obj instanceof Collection) {
                entity = ((Collection)obj).iterator().next();
            }
            if (null != (table = EntityAdapterProxy.table(entity.getClass()))) {
                dest = table.getName();
            }
        }
        if (obj instanceof ConfigStore) {
            run = new TableRun(runtime, dest);
            DefaultTablePrepare prepare = new DefaultTablePrepare();
            prepare.setDataSource(dest);
            run.setPrepare(prepare);
            run.setConfigStore((ConfigStore)obj);
            run.addCondition(columns);
            run.init();
            this.fillDeleteRunContent(runtime, run);
        } else {
            run = this.buildDeleteRunFromEntity(runtime, dest, obj, columns);
        }
        return run;
    }

    @Override
    public List<Run> buildTruncateRun(DataRuntime runtime, String table) {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add(run);
        StringBuilder builder = run.getBuilder();
        builder.append("TRUNCATE TABLE ");
        SQLUtil.delimiter((StringBuilder)builder, (String)table, (String)this.delimiterFr, (String)this.delimiterTo);
        return runs;
    }

    @Override
    public List<Run> buildQueryDatabaseRun(DataRuntime runtime) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildQueryDatabaseRun(DataRuntime runtime)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildQueryDatabaseRun(DataRuntime runtime, String name) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildQueryDatabaseRun(DataRuntime runtime)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public LinkedHashMap<String, Database> databases(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, Database> databases, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 LinkedHashMap<String, Database> databases(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, Database> databases, DataSet set)"), (int)37));
        }
        return new LinkedHashMap<String, Database>();
    }

    @Override
    public Database database(DataRuntime runtime, int index, boolean create, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 LinkedHashMap<String, Database> databases(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, Database> databases, DataSet set)"), (int)37));
        }
        return null;
    }

    @Override
    public List<Run> buildQueryTableRun(DataRuntime runtime, boolean greedy, String catalog, String schema, String pattern, String types) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildQueryTableRun(DataRuntime runtime, String catalog, String schema, String pattern, String types)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildQueryTableCommentRun(DataRuntime runtime, String catalog, String schema, String pattern, String types) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildQueryTableCommentRun(DataRuntime runtime, String catalog, String schema, String pattern, String types)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, int index, boolean create, String catalog, String schema, LinkedHashMap<String, T> tables, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, int index, boolean create, String catalog, String schema, LinkedHashMap<String, T> tables, DataSet set)"), (int)37));
        }
        if (null == tables) {
            tables = new LinkedHashMap();
        }
        return tables;
    }

    @Override
    public <T extends Table> List<T> tables(DataRuntime runtime, int index, boolean create, String catalog, String schema, List<T> tables, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 <T extends Table> List<T> tables(DataRuntime runtime, int index, boolean create, String catalog, String schema, List<T> tables, DataSet set)"), (int)37));
        }
        if (null == tables) {
            tables = new ArrayList<T>();
        }
        return tables;
    }

    @Override
    public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tables, String catalog, String schema, String pattern, String ... types) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tables, String catalog, String schema, String pattern, String ... types)"), (int)37));
        }
        if (null == tables) {
            tables = new LinkedHashMap();
        }
        return tables;
    }

    @Override
    public <T extends Table> List<T> tables(DataRuntime runtime, boolean create, List<T> tables, String catalog, String schema, String pattern, String ... types) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 <T extends Table> List<T> tables(DataRuntime runtime, boolean create, List<T> tables, String catalog, String schema, String pattern, String ... types)"), (int)37));
        }
        if (null == tables) {
            tables = new ArrayList<T>();
        }
        return tables;
    }

    public <T extends Table> T table(List<T> tables, String catalog, String schema, String name) {
        if (null != tables) {
            for (Table table : tables) {
                if (null != catalog && catalog != table.getCatalog() || null != schema && schema != table.getSchema() || !table.getName().equalsIgnoreCase(name)) continue;
                return (T)table;
            }
        }
        return null;
    }

    @Override
    public <T extends Table> LinkedHashMap<String, T> comments(DataRuntime runtime, int index, boolean create, String catalog, String schema, LinkedHashMap<String, T> tables, DataSet set) throws Exception {
        if (null == tables) {
            tables = new LinkedHashMap();
        }
        for (DataRow row : set) {
            Table table;
            String name = row.getString("TABLE_NAME");
            String comment = row.getString("TABLE_COMMENT");
            if (null == name || null == comment || null == (table = (Table)tables.get(name.toUpperCase()))) continue;
            table.setComment(comment);
        }
        return tables;
    }

    public <T extends Table> List<T> comments(DataRuntime runtime, int index, boolean create, String catalog, String schema, List<T> tables, DataSet set) throws Exception {
        if (null == tables) {
            tables = new ArrayList<T>();
        }
        for (DataRow row : set) {
            String name = row.getString("TABLE_NAME");
            String comment = row.getString("TABLE_COMMENT");
            if (null == catalog) {
                catalog = row.getString("TABLE_CATALOG");
            }
            if (null == schema) {
                schema = row.getString("TABLE_SCHEMA");
            }
            boolean contains = true;
            Object table = this.table(tables, catalog, schema, name);
            if (null == table) {
                if (!create) continue;
                table = new Table(catalog, schema, name);
                contains = false;
            }
            table.setComment(comment);
            if (contains) continue;
            tables.add(table);
        }
        return tables;
    }

    @Override
    public List<Run> buildQueryDDLRun(DataRuntime runtime, Table table) throws Exception {
        return new ArrayList<Run>();
    }

    @Override
    public List<String> ddl(DataRuntime runtime, int index, Table table, List<String> ddls, DataSet set) {
        if (null == ddls) {
            ddls = new ArrayList<String>();
        }
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<String> ddl(DataRuntime runtime, int index, Table table, List<String> ddls, DataSet set)"), (int)37));
        }
        return ddls;
    }

    @Override
    public List<Run> buildQueryViewRun(DataRuntime runtime, boolean greedy, String catalog, String schema, String pattern, String types) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildQueryViewRun(DataRuntime runtime, String catalog, String schema, String pattern, String types)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public <T extends View> LinkedHashMap<String, T> views(DataRuntime runtime, int index, boolean create, String catalog, String schema, LinkedHashMap<String, T> views, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 <T extends View> LinkedHashMap<String, T> views(DataRuntime runtime, int index, boolean create, String catalog, String schema, LinkedHashMap<String, T> views, DataSet set)"), (int)37));
        }
        if (null == views) {
            views = new LinkedHashMap();
        }
        return views;
    }

    @Override
    public <T extends View> LinkedHashMap<String, T> views(DataRuntime runtime, boolean create, LinkedHashMap<String, T> views, String catalog, String schema, String pattern, String ... types) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 <T extends View> LinkedHashMap<String, T> views(DataRuntime runtime, boolean create, LinkedHashMap<String, T> views, String catalog, String schema, String pattern, String ... types)"), (int)37));
        }
        if (null == views) {
            views = new LinkedHashMap();
        }
        return views;
    }

    @Override
    public List<Run> buildQueryDDLRun(DataRuntime runtime, View view) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildQueryDDLRun(DataRuntime runtime, View view)"), (int)37));
        }
        return runs;
    }

    @Override
    public List<String> ddl(DataRuntime runtime, int index, View view, List<String> ddls, DataSet set) {
        if (null == ddls) {
            ddls = new ArrayList<String>();
        }
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<String> ddl(DataRuntime runtime, int index, View view, List<String> ddls, DataSet set)"), (int)37));
        }
        return ddls;
    }

    @Override
    public List<Run> buildQueryMasterTableRun(DataRuntime runtime, String catalog, String schema, String pattern, String types) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildQueryMasterTableRun(DataRuntime runtime, String catalog, String schema, String pattern, String types)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public <T extends MasterTable> LinkedHashMap<String, T> mtables(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tables, String catalog, String schema, String pattern, String ... types) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 <T extends MasterTable> LinkedHashMap<String, T> mtables(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tables, String catalog, String schema, String pattern, String ... types)"), (int)37));
        }
        if (null == tables) {
            tables = new LinkedHashMap();
        }
        return tables;
    }

    @Override
    public <T extends MasterTable> LinkedHashMap<String, T> mtables(DataRuntime runtime, int index, boolean create, String catalog, String schema, LinkedHashMap<String, T> tables, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 <T extends MasterTable> LinkedHashMap<String, T> mtables(DataRuntime runtime, int index, boolean create, String catalog, String schema, LinkedHashMap<String, T> tables, DataSet set)"), (int)37));
        }
        if (null == tables) {
            tables = new LinkedHashMap();
        }
        return tables;
    }

    @Override
    public List<Run> buildQueryDDLRun(DataRuntime runtime, MasterTable table) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildQueryDDLRun(DataRuntime runtime, MasterTable table)"), (int)37));
        }
        return runs;
    }

    @Override
    public List<String> ddl(DataRuntime runtime, int index, MasterTable table, List<String> ddls, DataSet set) {
        if (null == ddls) {
            ddls = new ArrayList<String>();
        }
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<String> ddl(DataRuntime runtime, int index, MasterTable table, List<String> ddls, DataSet set)"), (int)37));
        }
        return ddls;
    }

    @Override
    public List<Run> buildQueryPartitionTableRun(DataRuntime runtime, String catalog, String schema, String pattern, String types) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildQueryPartitionTableRun(DataRuntime runtime, String catalog, String schema, String pattern, String types)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildQueryPartitionTableRun(DataRuntime runtime, MasterTable master, Map<String, Object> tags) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildQueryPartitionTableRun(DataRuntime runtime, MasterTable master, Map<String,Object> tags)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildQueryPartitionTableRun(DataRuntime runtime, MasterTable master, Map<String, Object> tags, String name) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildQueryPartitionTableRun(DataRuntime runtime, MasterTable master, Map<String,Object> tags, String name)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(DataRuntime runtime, int total, int index, boolean create, MasterTable master, String catalog, String schema, LinkedHashMap<String, T> tables, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 LinkedHashMap<String, PartitionTable> ptables(DataRuntime runtime, int total, int index, boolean create, MasterTable table, String catalog, String schema, LinkedHashMap<String, PartitionTable> tables, DataSet set)"), (int)37));
        }
        if (null == tables) {
            tables = new LinkedHashMap();
        }
        return tables;
    }

    @Override
    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tables, String catalog, String schema, MasterTable master) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 LinkedHashMap<String, PartitionTable> ptables(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tables, String catalog, String schema, MasterTable master)"), (int)37));
        }
        if (null == tables) {
            tables = new LinkedHashMap();
        }
        return tables;
    }

    @Override
    public List<Run> buildQueryDDLRun(DataRuntime runtime, PartitionTable table) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildQueryDDLRun(DataRuntime runtime, PartitionTable table)"), (int)37));
        }
        return runs;
    }

    @Override
    public List<String> ddl(DataRuntime runtime, int index, PartitionTable table, List<String> ddls, DataSet set) {
        if (null == ddls) {
            ddls = new ArrayList<String>();
        }
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<String> ddl(DataRuntime runtime, int index, PartitionTable table, List<String> ddls, DataSet set)"), (int)37));
        }
        return ddls;
    }

    @Override
    public List<Run> buildQueryColumnRun(DataRuntime runtime, Table table, boolean metadata) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildQueryColumnRun(DataRuntime runtime, Table table, boolean metadata)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public Column column(DataRuntime runtime, Column column, ResultSet rs) {
        if (null == column) {
            column = new Column();
        }
        try {
            Map<String, Integer> keys = this.keys(rs);
            if (null == column.getName()) {
                column.setName(this.string(keys, "COLUMN_NAME", rs));
            }
            if (null == column.getType()) {
                column.setType(BasicUtil.parseInt((Object)this.string(keys, "DATA_TYPE", rs), null));
            }
            if (null == column.getType()) {
                column.setType(BasicUtil.parseInt((Object)this.string(keys, "SQL_DATA_TYPE", rs), null));
            }
            if (null == column.getTypeName()) {
                String jdbcType = this.string(keys, "TYPE_NAME", rs);
                column.setJdbcType(jdbcType);
                if (BasicUtil.isEmpty((Object)column.getTypeName())) {
                    column.setTypeName(jdbcType);
                }
            }
            if (null == column.getPrecision()) {
                column.setPrecision(this.integer(keys, "COLUMN_SIZE", rs, null));
            }
            if (null == column.getScale()) {
                column.setScale(BasicUtil.parseInt((Object)this.string(keys, "DECIMAL_DIGITS", rs), null));
            }
            if (null == column.getPosition()) {
                column.setPosition(BasicUtil.parseInt((Object)this.string(keys, "ORDINAL_POSITION", rs), (Integer)0));
            }
            if (-1 == column.isAutoIncrement()) {
                column.setAutoIncrement(BasicUtil.parseBoolean((Object)this.string(keys, "IS_AUTOINCREMENT", rs), (Boolean)false));
            }
            if (-1 == column.isGenerated()) {
                column.setGenerated(BasicUtil.parseBoolean((Object)this.string(keys, "IS_GENERATEDCOLUMN", rs), (Boolean)false));
            }
            if (null == column.getComment()) {
                column.setComment(this.string(keys, "REMARKS", rs));
            }
            if (null == column.getPosition()) {
                column.setPosition(BasicUtil.parseInt((Object)this.string(keys, "ORDINAL_POSITION", rs), (Integer)0));
            }
            if (BasicUtil.isEmpty((Object)column.getDefaultValue())) {
                column.setDefaultValue((Object)this.string(keys, "COLUMN_DEF", rs));
            }
            ColumnType columnType = this.type(column.getTypeName());
            column.setColumnType(columnType);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return column;
    }

    protected Map<String, Integer> keys(ResultSet set) throws Exception {
        ResultSetMetaData rsmd = set.getMetaData();
        HashMap<String, Integer> keys = new HashMap<String, Integer>();
        if (null != rsmd) {
            for (int i = 1; i < rsmd.getColumnCount(); ++i) {
                keys.put(rsmd.getColumnLabel(i).toUpperCase(), i);
            }
        }
        return keys;
    }

    @Override
    public List<Run> buildQueryTagRun(DataRuntime runtime, Table table, boolean metadata) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildQueryTagRun(DataRuntime runtime, Table table, boolean metadata)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> tags, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> tags, DataSet set)"), (int)37));
        }
        if (null == tags) {
            tags = new LinkedHashMap();
        }
        return tags;
    }

    @Override
    public <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tags, Table table, String pattern) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, boolean create, LinkedHashMap<String, T> tags, Table table, String pattern)"), (int)37));
        }
        if (null == tags) {
            tags = new LinkedHashMap();
        }
        return tags;
    }

    @Override
    public List<Run> buildQueryPrimaryRun(DataRuntime runtime, Table table) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildQueryPrimaryRun(DataRuntime runtime, Table table)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public PrimaryKey primary(DataRuntime runtime, int index, Table table, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 PrimaryKey primary(DataRuntime runtime, int index, Table table, DataSet set)"), (int)37));
        }
        return null;
    }

    @Override
    public List<Run> buildQueryForeignsRun(DataRuntime runtime, Table table) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildQueryForeignsRun(DataRuntime runtime, Table table)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public <T extends ForeignKey> LinkedHashMap<String, T> foreigns(DataRuntime runtime, int index, Table table, LinkedHashMap<String, T> foreigns, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 <T extends ForeignKey> LinkedHashMap<String, T> foreigns(DataRuntime runtime, int index, Table table, LinkedHashMap<String, T> foreigns, DataSet set)"), (int)37));
        }
        return new LinkedHashMap();
    }

    @Override
    public List<Run> buildQueryIndexRun(DataRuntime runtime, Table table, String name) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildQueryIndexRun(DataRuntime runtime, Table table, String name)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public <T extends Index> LinkedHashMap<String, T> indexs(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> indexs, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 <T extends Index> LinkedHashMap<String, T> indexs(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> indexs, DataSet set)"), (int)37));
        }
        if (null == indexs) {
            indexs = new LinkedHashMap();
        }
        return indexs;
    }

    @Override
    public <T extends Index> LinkedHashMap<String, T> indexs(DataRuntime runtime, boolean create, LinkedHashMap<String, T> indexs, Table table, boolean unique, boolean approximate) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 <T extends Index> LinkedHashMap<String, T> indexs(DataRuntime runtime, boolean create, LinkedHashMap<String, T> indexs, Table table, boolean unique, boolean approximate)"), (int)37));
        }
        if (null == indexs) {
            indexs = new LinkedHashMap();
        }
        return indexs;
    }

    @Override
    public List<Run> buildQueryConstraintRun(DataRuntime runtime, Table table, boolean metadata) throws Exception {
        log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildQueryConstraintRun(DataRuntime runtime, Table table, boolean metadata)"), (int)37));
        return new ArrayList<Run>();
    }

    @Override
    public <T extends Constraint> LinkedHashMap<String, T> constraints(DataRuntime runtime, int constraint, boolean create, Table table, LinkedHashMap<String, T> constraints, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 LinkedHashMap<String, Constraint> constraints(int constraint, boolean create,  Table table, LinkedHashMap<String, Constraint> constraints, DataSet set)"), (int)37));
        }
        if (null == constraints) {
            constraints = new LinkedHashMap();
        }
        return constraints;
    }

    @Override
    public <T extends Constraint> LinkedHashMap<String, T> constraints(DataRuntime runtime, boolean create, Table table, LinkedHashMap<String, T> constraints, ResultSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 <T extends Constraint> LinkedHashMap<String, T> constraints(DataRuntime runtime, boolean create, Table table, LinkedHashMap<String, T> constraints, ResultSet set)"), (int)37));
        }
        if (null == constraints) {
            constraints = new LinkedHashMap();
        }
        return constraints;
    }

    @Override
    public List<Run> buildQueryTriggerRun(DataRuntime runtime, Table table, List<Trigger.EVENT> events) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 buildQueryTriggerRun(DataRuntime runtime, Table table, List<Trigger.EVENT> events)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public <T extends Trigger> LinkedHashMap<String, T> triggers(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> triggers, DataSet set) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 <T extends Trigger> LinkedHashMap<String, T> triggers(DataRuntime runtime, int index, boolean create, Table table, LinkedHashMap<String, T> triggers, DataSet set)"), (int)37));
        }
        if (null == triggers) {
            this.readers = new LinkedHashMap<Object, DataReader>();
        }
        return triggers;
    }

    @Override
    public List<Run> buildQueryProcedureRun(DataRuntime runtime, String catalog, String schema, String name) {
        return new ArrayList<Run>();
    }

    @Override
    public <T extends Procedure> LinkedHashMap<String, T> procedures(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> procedures, DataSet set) throws Exception {
        return new LinkedHashMap();
    }

    @Override
    public List<String> ddl(DataRuntime runtime, String random, Procedure procedure) {
        ArrayList<String> list = new ArrayList<String>();
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<String> ddl(DataRuntime runtime, String random, Procedure procedure)"), (int)37));
        }
        return list;
    }

    @Override
    public List<Run> buildQueryDDLRun(DataRuntime runtime, Procedure procedure) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildQueryDDLRun(DataRuntime runtime, Procedure procedure)"), (int)37));
        }
        return runs;
    }

    @Override
    public List<String> ddl(DataRuntime runtime, int index, Procedure procedure, List<String> ddls, DataSet set) {
        if (null == ddls) {
            ddls = new ArrayList<String>();
        }
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<String> ddl(DataRuntime runtime, int index, Procedure procedure, List<String> ddls, DataSet set)"), (int)37));
        }
        return ddls;
    }

    @Override
    public List<Run> buildQueryFunctionRun(DataRuntime runtime, String catalog, String schema, String name) {
        return new ArrayList<Run>();
    }

    @Override
    public <T extends Function> LinkedHashMap<String, T> functions(DataRuntime runtime, int index, boolean create, LinkedHashMap<String, T> functions, DataSet set) throws Exception {
        return new LinkedHashMap();
    }

    @Override
    public List<String> ddl(DataRuntime runtime, String random, Function function) {
        ArrayList<String> list = new ArrayList<String>();
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<String> ddl(DataRuntime runtime, String random, Function function)"), (int)37));
        }
        return list;
    }

    @Override
    public List<Run> buildQueryDDLRun(DataRuntime runtime, Function function) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildQueryDDLRun(DataRuntime runtime, Function function)"), (int)37));
        }
        return runs;
    }

    @Override
    public List<String> ddl(DataRuntime runtime, int index, Function function, List<String> ddls, DataSet set) {
        if (null == ddls) {
            ddls = new ArrayList<String>();
        }
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<String> ddl(DataRuntime runtime, int index, Function function, List<String> ddls, DataSet set)"), (int)37));
        }
        return ddls;
    }

    @Override
    public List<Run> buildCreateRun(DataRuntime runtime, Table table) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add(run);
        StringBuilder builder = run.getBuilder();
        builder.append("CREATE ").append(table.getKeyword()).append(" ");
        this.checkTableExists(runtime, builder, false);
        this.name(runtime, builder, table);
        LinkedHashMap columMap = table.getColumns();
        Collection columns = null;
        List pks = table.primarys();
        if (null != columMap && null != (columns = columMap.values()) && columns.size() > 0) {
            builder.append("(\n");
            int idx = 0;
            for (Object column : columns) {
                builder.append("\t");
                if (idx > 0) {
                    builder.append(",");
                }
                SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(" ");
                this.define(runtime, builder, (Column)column).append("\n");
                ++idx;
            }
            builder.append("\t");
            if (pks.size() == 1) {
                this.primary(runtime, builder, table);
            }
            builder.append(")");
        }
        this.comment(runtime, builder, table);
        List<Run> tableComment = this.buildAppendCommentRun(runtime, table);
        if (null != tableComment) {
            runs.addAll(tableComment);
        }
        if (null != columns) {
            for (Object column : columns) {
                List<Run> columnComment = this.buildAppendCommentRun(runtime, (Column)column);
                if (null == columnComment) continue;
                runs.addAll(columnComment);
            }
        }
        if (pks.size() > 1) {
            PrimaryKey primary = new PrimaryKey();
            primary.setTable(table);
            for (Column col : pks) {
                primary.addColumn(col);
            }
            List<Run> pksql = this.buildAddRun(runtime, primary);
            if (null != pksql) {
                runs.addAll(pksql);
            }
        }
        return runs;
    }

    @Override
    public List<Run> buildAppendCommentRun(DataRuntime runtime, Table table) throws Exception {
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Table table) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildAlterRun(DataRuntime runtime, Table table)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Table table, Collection<Column> columns) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        for (Column column : columns) {
            String action = column.getAction();
            if ("add".equalsIgnoreCase(action)) {
                runs.addAll(this.buildAddRun(runtime, column, false));
                continue;
            }
            if ("alter".equalsIgnoreCase(action)) {
                runs.addAll(this.buildAlterRun(runtime, column, false));
                continue;
            }
            if (!"drop".equalsIgnoreCase(action)) continue;
            runs.addAll(this.buildDropRun(runtime, column, false));
        }
        return runs;
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Table table) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildRenameRun(DataRuntime runtime, Table table)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildChangeCommentRun(DataRuntime runtime, Table table) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildChangeCommentRun(DataRuntime runtime, Table table)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Table table) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add(run);
        StringBuilder builder = run.getBuilder();
        String catalog = table.getCatalog();
        String schema = table.getSchema();
        builder.append("DROP ").append(table.getKeyword()).append(" ");
        this.checkTableExists(runtime, builder, true);
        this.name(runtime, builder, table);
        return runs;
    }

    @Override
    public StringBuilder checkTableExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        builder.append(" IF ");
        if (!exists) {
            builder.append("NOT ");
        }
        builder.append("EXISTS ");
        return builder;
    }

    @Override
    public StringBuilder primary(DataRuntime runtime, StringBuilder builder, Table table) {
        List pks = table.primarys();
        if (pks.size() > 0) {
            builder.append(",PRIMARY KEY (");
            boolean first = true;
            for (Column pk : pks) {
                if (!first) {
                    builder.append(",");
                }
                SQLUtil.delimiter((StringBuilder)builder, (String)pk.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
                first = false;
            }
            builder.append(")");
        }
        return builder;
    }

    @Override
    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, Table table) {
        String comment = table.getComment();
        if (BasicUtil.isNotEmpty((Object)comment)) {
            builder.append(" COMMENT'").append(comment).append("'");
        }
        return builder;
    }

    @Override
    public StringBuilder name(DataRuntime runtime, StringBuilder builder, Table table) {
        String catalog = table.getCatalog();
        String schema = table.getSchema();
        String name = table.getName();
        if (BasicUtil.isNotEmpty((Object)catalog)) {
            SQLUtil.delimiter((StringBuilder)builder, (String)catalog, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(".");
        }
        if (BasicUtil.isNotEmpty((Object)schema)) {
            SQLUtil.delimiter((StringBuilder)builder, (String)schema, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(".");
        }
        SQLUtil.delimiter((StringBuilder)builder, (String)name, (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        return builder;
    }

    @Override
    public StringBuilder name(DataRuntime runtime, StringBuilder builder, Procedure procedure) {
        String catalog = procedure.getCatalog();
        String schema = procedure.getSchema();
        String name = procedure.getName();
        if (BasicUtil.isNotEmpty((Object)catalog)) {
            SQLUtil.delimiter((StringBuilder)builder, (String)catalog, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(".");
        }
        if (BasicUtil.isNotEmpty((Object)schema)) {
            SQLUtil.delimiter((StringBuilder)builder, (String)schema, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(".");
        }
        SQLUtil.delimiter((StringBuilder)builder, (String)name, (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        return builder;
    }

    @Override
    public StringBuilder name(DataRuntime runtime, StringBuilder builder, Function function) {
        String catalog = function.getCatalog();
        String schema = function.getSchema();
        String name = function.getName();
        if (BasicUtil.isNotEmpty((Object)catalog)) {
            SQLUtil.delimiter((StringBuilder)builder, (String)catalog, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(".");
        }
        if (BasicUtil.isNotEmpty((Object)schema)) {
            SQLUtil.delimiter((StringBuilder)builder, (String)schema, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(".");
        }
        SQLUtil.delimiter((StringBuilder)builder, (String)name, (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        return builder;
    }

    @Override
    public List<Run> buildCreateRun(DataRuntime runtime, View view) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add(run);
        StringBuilder builder = run.getBuilder();
        builder.append("CREATE VIEW ");
        this.name(runtime, builder, (Table)view);
        builder.append(" AS \n").append(view.getDefinition());
        runs.addAll(this.buildAppendCommentRun(runtime, view));
        return runs;
    }

    @Override
    public List<Run> buildAppendCommentRun(DataRuntime runtime, View view) throws Exception {
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, View view) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add(run);
        StringBuilder builder = run.getBuilder();
        builder.append("ALTER VIEW ");
        this.name(runtime, builder, (Table)view);
        builder.append(" AS \n").append(view.getDefinition());
        return runs;
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, View view) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildRenameRun(DataRuntime runtime, View view)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildChangeCommentRun(DataRuntime runtime, View view) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildChangeCommentRun(DataRuntime runtime, View view)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, View view) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add(run);
        StringBuilder builder = run.getBuilder();
        builder.append("DROP ").append(view.getKeyword()).append(" ");
        this.checkViewExists(runtime, builder, true);
        this.name(runtime, builder, (Table)view);
        return runs;
    }

    @Override
    public StringBuilder checkViewExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        builder.append(" IF ");
        if (!exists) {
            builder.append("NOT ");
        }
        builder.append("EXISTS ");
        return builder;
    }

    @Override
    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, View view) {
        return builder;
    }

    @Override
    public List<Run> buildCreateRun(DataRuntime runtime, MasterTable table) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildCreateRun(DataRuntime runtime, MasterTable table)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAppendCommentRun(DataRuntime runtime, MasterTable table) throws Exception {
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, MasterTable table) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildAlterRun(DataRuntime runtime, MasterTable table)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, MasterTable table) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildDropRun(DataRuntime runtime, MasterTable table)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, MasterTable table) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildRenameRun(DataRuntime runtime, MasterTable table)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildChangeCommentRun(DataRuntime runtime, MasterTable table) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildChangeCommentRun(DataRuntime runtime, MasterTable table)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildCreateRun(DataRuntime runtime, PartitionTable table) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildCreateRun(DataRuntime runtime, PartitionTable table)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAppendCommentRun(DataRuntime runtime, PartitionTable table) throws Exception {
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, PartitionTable table) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildAlterRun(DataRuntime runtime, PartitionTable table)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, PartitionTable table) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildDropRun(DataRuntime runtime, PartitionTable table)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, PartitionTable table) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildRenameRun(DataRuntime runtime, PartitionTable table)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildChangeCommentRun(DataRuntime runtime, PartitionTable table) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildChangeCommentRun(DataRuntime runtime, PartitionTable table)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public String alterColumnKeyword(DataRuntime runtime) {
        return "ALTER";
    }

    @Override
    public List<Run> buildAddRun(DataRuntime runtime, Column column, boolean slice) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add(run);
        StringBuilder builder = run.getBuilder();
        if (!slice) {
            Table table = column.getTable(true);
            builder.append("ALTER ").append(table.getKeyword()).append(" ");
            this.name(runtime, builder, table);
        }
        this.addColumnGuide(runtime, builder, column);
        SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(" ");
        this.define(runtime, builder, column);
        runs.addAll(this.buildAppendCommentRun(runtime, column));
        return runs;
    }

    @Override
    public List<Run> buildAddRun(DataRuntime runtime, Column column) throws Exception {
        return this.buildAddRun(runtime, column, false);
    }

    @Override
    public StringBuilder addColumnGuide(DataRuntime runtime, StringBuilder builder, Column column) {
        return builder.append(" ADD ").append(column.getKeyword()).append(" ");
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Column column, boolean slice) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        Column update = column.getUpdate();
        if (null != update) {
            List<Run> cmts;
            String ucomment;
            String comment;
            List<Run> nulls;
            int unullable;
            int nullable;
            List<Run> defs;
            List<Run> list;
            String uname;
            String name = column.getName();
            if (!BasicUtil.equalsIgnoreCase((Object)name, (Object)(uname = update.getName())) && !uname.endsWith("_TMP_UPDATE_TYPE")) {
                runs.addAll(this.buildRenameRun(runtime, column));
            }
            String type = this.type(runtime, null, column).toString();
            String utype = this.type(runtime, null, update).toString();
            boolean exe = false;
            if (!BasicUtil.equalsIgnoreCase((Object)type, (Object)utype)) {
                list = this.buildChangeTypeRun(runtime, column);
                if (null != list) {
                    runs.addAll(list);
                    exe = true;
                }
            } else if ((column.getPrecision() != update.getPrecision() || column.getScale() != update.getScale()) && null != (list = this.buildChangeTypeRun(runtime, column))) {
                runs.addAll(list);
                exe = true;
            }
            Object def = column.getDefaultValue();
            Object udef = update.getDefaultValue();
            if (!BasicUtil.equalsIgnoreCase((Object)def, (Object)udef) && null != (defs = this.buildChangeDefaultRun(runtime, column))) {
                runs.addAll(defs);
            }
            if ((nullable = column.isNullable()) != (unullable = update.isNullable()) && null != (nulls = this.buildChangeNullableRun(runtime, column))) {
                runs.addAll(nulls);
            }
            if (!BasicUtil.equalsIgnoreCase((Object)(comment = column.getComment()), (Object)(ucomment = update.getComment())) && null != (cmts = this.buildChangeCommentRun(runtime, column))) {
                runs.addAll(cmts);
            }
        }
        return runs;
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Column column) throws Exception {
        return this.buildAlterRun(runtime, column, false);
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Column column, boolean slice) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add(run);
        StringBuilder builder = run.getBuilder();
        if (column instanceof Tag) {
            Tag tag = (Tag)column;
            return this.buildDropRun(runtime, tag);
        }
        if (!slice) {
            Table table = column.getTable(true);
            builder.append("ALTER ").append(table.getKeyword()).append(" ");
            this.name(runtime, builder, table);
        }
        this.dropColumnGuide(runtime, builder, column);
        SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        return runs;
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Column column) throws Exception {
        return this.buildDropRun(runtime, column, false);
    }

    @Override
    public StringBuilder dropColumnGuide(DataRuntime runtime, StringBuilder builder, Column column) {
        return builder.append(" DROP ").append(column.getKeyword()).append(" ");
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Column column) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add(run);
        StringBuilder builder = run.getBuilder();
        Table table = column.getTable(true);
        builder.append("ALTER ").append(table.getKeyword()).append(" ");
        this.name(runtime, builder, table);
        builder.append(" RENAME ").append(column.getKeyword()).append(" ");
        SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        builder.append(" ");
        SQLUtil.delimiter((StringBuilder)builder, (String)column.getUpdate().getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        column.setName(column.getUpdate().getName());
        return runs;
    }

    @Override
    public List<Run> buildChangeTypeRun(DataRuntime runtime, Column column) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildChangeTypeRun(DataRuntime runtime, Column column)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildChangeDefaultRun(DataRuntime runtime, Column column) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildChangeDefaultRun(DataRuntime runtime, Column column)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildChangeNullableRun(DataRuntime runtime, Column column) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildChangeNullableRun(DataRuntime runtime, Column column)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildChangeCommentRun(DataRuntime runtime, Column column) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildChangeCommentRun(DataRuntime runtime, Column column)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAppendCommentRun(DataRuntime runtime, Column column) throws Exception {
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropAutoIncrement(DataRuntime runtime, Column column) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildDropAutoIncrement(DataRuntime runtime, Column column)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public StringBuilder define(DataRuntime runtime, StringBuilder builder, Column column) {
        this.type(runtime, builder, column);
        this.charset(runtime, builder, column);
        this.defaultValue(runtime, builder, column);
        this.nullable(runtime, builder, column);
        this.primary(runtime, builder, column);
        if (column.isPrimaryKey() == 1) {
            this.increment(runtime, builder, column);
        }
        this.onupdate(runtime, builder, column);
        this.comment(runtime, builder, column);
        this.position(runtime, builder, column);
        return builder;
    }

    @Override
    public StringBuilder type(DataRuntime runtime, StringBuilder builder, Column column) {
        if (null == builder) {
            builder = new StringBuilder();
        }
        boolean isIgnorePrecision = false;
        boolean isIgnoreScale = false;
        String typeName = column.getTypeName();
        ColumnType type = this.type(typeName);
        if (null != type) {
            if (!type.support()) {
                throw new RuntimeException("\u6570\u636e\u7c7b\u578b\u4e0d\u652f\u6301:" + typeName);
            }
            isIgnorePrecision = type.ignorePrecision();
            isIgnoreScale = type.ignoreScale();
            typeName = type.getName();
        } else {
            isIgnorePrecision = this.isIgnorePrecision(runtime, column);
            isIgnoreScale = this.isIgnoreScale(runtime, column);
        }
        return this.type(runtime, builder, column, typeName, isIgnorePrecision, isIgnoreScale);
    }

    @Override
    public StringBuilder type(DataRuntime runtime, StringBuilder builder, Column column, String type, boolean isIgnorePrecision, boolean isIgnoreScale) {
        Integer precision;
        if (null == builder) {
            builder = new StringBuilder();
        }
        builder.append(type);
        if (!isIgnorePrecision && null != (precision = column.getPrecision())) {
            if (precision > 0) {
                builder.append("(").append(precision);
                Integer scale = column.getScale();
                if (null != scale && scale > 0 && !isIgnoreScale) {
                    builder.append(",").append(scale);
                }
                builder.append(")");
            } else if (precision == -1) {
                builder.append("(max)");
            }
        }
        return builder;
    }

    @Override
    public Boolean checkIgnorePrecision(DataRuntime runtime, String type) {
        if ((type = type.toUpperCase()).contains("INT")) {
            return false;
        }
        if (type.contains("DATE")) {
            return true;
        }
        if (type.contains("TIME")) {
            return true;
        }
        if (type.contains("YEAR")) {
            return true;
        }
        if (type.contains("TEXT")) {
            return true;
        }
        if (type.contains("BLOB")) {
            return true;
        }
        if (type.contains("JSON")) {
            return true;
        }
        if (type.contains("POINT")) {
            return true;
        }
        if (type.contains("LINE")) {
            return true;
        }
        if (type.contains("POLYGON")) {
            return true;
        }
        if (type.contains("GEOMETRY")) {
            return true;
        }
        return null;
    }

    @Override
    public Boolean checkIgnoreScale(DataRuntime runtime, String type) {
        if ((type = type.toUpperCase()).contains("INT")) {
            return true;
        }
        if (type.contains("DATE")) {
            return true;
        }
        if (type.contains("TIME")) {
            return true;
        }
        if (type.contains("YEAR")) {
            return true;
        }
        if (type.contains("TEXT")) {
            return true;
        }
        if (type.contains("BLOB")) {
            return true;
        }
        if (type.contains("JSON")) {
            return true;
        }
        if (type.contains("POINT")) {
            return true;
        }
        if (type.contains("LINE")) {
            return true;
        }
        if (type.contains("POLYGON")) {
            return true;
        }
        if (type.contains("GEOMETRY")) {
            return true;
        }
        return null;
    }

    @Override
    public boolean isIgnorePrecision(DataRuntime runtime, Column column) {
        String chk;
        Boolean chkResult;
        ColumnType type = column.getColumnType();
        if (null != type) {
            return type.ignorePrecision();
        }
        String typeName = column.getTypeName();
        if (null != typeName && null != (chkResult = this.checkIgnorePrecision(runtime, chk = typeName.toUpperCase()))) {
            return chkResult;
        }
        return false;
    }

    @Override
    public boolean isIgnoreScale(DataRuntime runtime, Column column) {
        String chk;
        Boolean chkResult;
        ColumnType type = column.getColumnType();
        if (null != type) {
            return type.ignoreScale();
        }
        String name = column.getTypeName();
        if (null != name && null != (chkResult = this.checkIgnoreScale(runtime, chk = name.toUpperCase()))) {
            return chkResult;
        }
        return false;
    }

    @Override
    public StringBuilder nullable(DataRuntime runtime, StringBuilder builder, Column column) {
        int nullable;
        if (column.isNullable() == 0 && (nullable = column.isNullable()) != -1) {
            if (nullable == 0) {
                builder.append(" NOT");
            }
            builder.append(" NULL");
        }
        return builder;
    }

    @Override
    public StringBuilder charset(DataRuntime runtime, StringBuilder builder, Column column) {
        String charset;
        String typeName = column.getTypeName();
        if (null != typeName && typeName.toLowerCase().contains("char") && BasicUtil.isNotEmpty((Object)(charset = column.getCharset()))) {
            builder.append(" CHARACTER SET ").append(charset);
            String collate = column.getCollate();
            if (BasicUtil.isNotEmpty((Object)collate)) {
                builder.append(" COLLATE ").append(collate);
            }
        }
        return builder;
    }

    @Override
    public StringBuilder defaultValue(DataRuntime runtime, StringBuilder builder, Column column) {
        Object def = column.getDefaultValue();
        if (null != def) {
            builder.append(" DEFAULT ");
            boolean isCharColumn = this.isCharColumn(runtime, column);
            if (def instanceof DriverAdapter.SQL_BUILD_IN_VALUE) {
                String value = this.value(runtime, column, (DriverAdapter.SQL_BUILD_IN_VALUE)((Object)def));
                if (null != value) {
                    builder.append(value);
                }
            } else {
                if (null == (def = this.write(runtime, column, def, false))) {
                    def = column.getDefaultValue();
                }
                builder.append(def);
            }
        }
        return builder;
    }

    @Override
    public StringBuilder primary(DataRuntime runtime, StringBuilder builder, Column column) {
        return builder;
    }

    @Override
    public StringBuilder increment(DataRuntime runtime, StringBuilder builder, Column column) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 StringBuilder increment(DataRuntime runtime, StringBuilder builder, Column column)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder onupdate(DataRuntime runtime, StringBuilder builder, Column column) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 StringBuilder onupdate(DataRuntime runtime, StringBuilder builder, Column column)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder position(DataRuntime runtime, StringBuilder builder, Column column) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 StringBuilder position(DataRuntime runtime, StringBuilder builder, Column column)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder comment(DataRuntime runtime, StringBuilder builder, Column column) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 StringBuilder comment(DataRuntime runtime, StringBuilder builder, Column column)"), (int)37));
        }
        return builder;
    }

    @Override
    public StringBuilder checkColumnExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 checkColumnExists(DataRuntime runtime, StringBuilder builder, boolean exists)"), (int)37));
        }
        return builder;
    }

    @Override
    public List<Run> buildAddRun(DataRuntime runtime, Tag tag) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add(run);
        StringBuilder builder = run.getBuilder();
        Table table = tag.getTable(true);
        builder.append("ALTER ").append(table.getKeyword()).append(" ");
        this.name(runtime, builder, table);
        builder.append(" ADD TAG ");
        SQLUtil.delimiter((StringBuilder)builder, (String)tag.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(" ");
        this.define(runtime, builder, (Column)tag);
        return runs;
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Tag tag) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        Tag update = tag.getUpdate();
        if (null != update) {
            String ucomment;
            String comment;
            int unullable;
            int nullable;
            List<Run> list;
            String uname;
            String name = tag.getName();
            if (!BasicUtil.equalsIgnoreCase((Object)name, (Object)(uname = update.getName())) && !uname.endsWith("_TMP_UPDATE_TYPE")) {
                runs.addAll(this.buildRenameRun(runtime, tag));
            }
            tag.setName(uname);
            String type = this.type(runtime, null, (Column)tag).toString();
            String utype = this.type(runtime, null, (Column)update).toString();
            if (!BasicUtil.equalsIgnoreCase((Object)type, (Object)utype)) {
                list = this.buildChangeTypeRun(runtime, tag);
                if (null != list) {
                    runs.addAll(list);
                }
            } else if ((tag.getPrecision() != update.getPrecision() || tag.getScale() != update.getScale()) && null != (list = this.buildChangeTypeRun(runtime, tag))) {
                runs.addAll(list);
            }
            Object def = tag.getDefaultValue();
            Object udef = update.getDefaultValue();
            if (!BasicUtil.equalsIgnoreCase((Object)def, (Object)udef)) {
                runs.addAll(this.buildChangeDefaultRun(runtime, tag));
            }
            if ((nullable = tag.isNullable()) != (unullable = update.isNullable())) {
                runs.addAll(this.buildChangeNullableRun(runtime, tag));
            }
            if (!BasicUtil.equalsIgnoreCase((Object)(comment = tag.getComment()), (Object)(ucomment = update.getComment()))) {
                runs.addAll(this.buildChangeCommentRun(runtime, tag));
            }
        }
        return runs;
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Tag tag) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add(run);
        StringBuilder builder = run.getBuilder();
        Table table = tag.getTable(true);
        builder.append("ALTER ").append(table.getKeyword()).append(" ");
        this.name(runtime, builder, table);
        builder.append(" DROP ").append(tag.getKeyword()).append(" ");
        SQLUtil.delimiter((StringBuilder)builder, (String)tag.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        return runs;
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Tag tag) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add(run);
        StringBuilder builder = run.getBuilder();
        Table table = tag.getTable(true);
        builder.append("ALTER ").append(table.getKeyword()).append(" ");
        this.name(runtime, builder, table);
        builder.append(" RENAME ").append(tag.getKeyword()).append(" ");
        SQLUtil.delimiter((StringBuilder)builder, (String)tag.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        builder.append(" ");
        SQLUtil.delimiter((StringBuilder)builder, (String)tag.getUpdate().getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        return runs;
    }

    @Override
    public List<Run> buildChangeDefaultRun(DataRuntime runtime, Tag tag) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildChangeDefaultRun(DataRuntime runtime, Tag tag)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildChangeNullableRun(DataRuntime runtime, Tag tag) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildChangeNullableRun(DataRuntime runtime, Tag tag)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildChangeCommentRun(DataRuntime runtime, Tag tag) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildChangeCommentRun(DataRuntime runtime, Tag tag)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildChangeTypeRun(DataRuntime runtime, Tag tag) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildChangeTypeRun(DataRuntime runtime, Tag tag)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public StringBuilder checkTagExists(DataRuntime runtime, StringBuilder builder, boolean exists) {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 StringBuilder checkTagExists(DataRuntime runtime, StringBuilder builder, boolean exists)"), (int)37));
        }
        return builder;
    }

    @Override
    public List<Run> buildAddRun(DataRuntime runtime, PrimaryKey primary) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildAddRun(DataRuntime runtime, PrimaryKey primary)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, PrimaryKey primary) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildAlterRun(DataRuntime runtime, PrimaryKey primary)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, PrimaryKey primary) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add(run);
        StringBuilder builder = run.getBuilder();
        builder.append("ALTER TABLE ");
        this.name(runtime, builder, primary.getTable(true));
        builder.append(" DROP CONSTRAINT ");
        SQLUtil.delimiter((StringBuilder)builder, (String)primary.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        return runs;
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, PrimaryKey primary) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildAddRun(DataRuntime runtime, PrimaryKey primary)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAddRun(DataRuntime runtime, ForeignKey foreign) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add(run);
        StringBuilder builder = run.getBuilder();
        LinkedHashMap columns = foreign.getColumns();
        if (columns.size() > 0) {
            builder.append("ALTER TABLE ");
            this.name(runtime, builder, foreign.getTable(true));
            builder.append(" ADD");
            if (BasicUtil.isNotEmpty((Object)foreign.getName())) {
                builder.append(" CONSTRAINT ").append(foreign.getName());
            }
            builder.append(" FOREIGN KEY (");
            boolean first = true;
            for (Column column : columns.values()) {
                if (!first) {
                    builder.append(",");
                }
                SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
                first = false;
            }
            builder.append(")");
            builder.append(" REFERENCES ").append(foreign.getReference().getName()).append("(");
            first = true;
            for (Column column : columns.values()) {
                if (!first) {
                    builder.append(",");
                }
                SQLUtil.delimiter((StringBuilder)builder, (String)column.getReference(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
                first = false;
            }
            builder.append(")");
        }
        return runs;
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, ForeignKey foreign) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildAlterRun(DataRuntime runtime, PrimaryKey primary)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, ForeignKey foreign) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add(run);
        StringBuilder builder = run.getBuilder();
        builder.append("ALTER TABLE");
        this.name(runtime, builder, foreign.getTable(true));
        builder.append(" DROP FOREIGN KEY ").append(foreign.getName());
        return runs;
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, ForeignKey foreign) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildRenameRun(DataRuntime runtime, ForeignKey foreign) "), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAddRun(DataRuntime runtime, Index index) throws Exception {
        String name = index.getName();
        if (BasicUtil.isEmpty((Object)name)) {
            name = "index_" + BasicUtil.getRandomString((int)10);
        }
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add(run);
        StringBuilder builder = run.getBuilder();
        builder.append("CREATE");
        if (index.isUnique()) {
            builder.append(" UNIQUE");
        } else if (index.isFulltext()) {
            builder.append(" FULLTEXT");
        } else if (index.isSpatial()) {
            builder.append(" SPATIAL");
        }
        builder.append(" INDEX ").append(name).append(" ON ");
        Table table = index.getTable(true);
        this.name(runtime, builder, table);
        builder.append("(");
        int qty = 0;
        for (Column column : index.getColumns().values()) {
            if (qty > 0) {
                builder.append(",");
            }
            SQLUtil.delimiter((StringBuilder)builder, (String)column.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
            String order = column.getOrder();
            if (BasicUtil.isNotEmpty((Object)order)) {
                builder.append(" ").append(order);
            }
            ++qty;
        }
        builder.append(")");
        String type = index.getType();
        if (BasicUtil.isNotEmpty((Object)type)) {
            builder.append("USING ").append(type).append(" ");
        }
        this.comment(runtime, builder, index);
        return runs;
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Index index) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildAddRun(DataRuntime runtime, Index index)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Index index) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add(run);
        StringBuilder builder = run.getBuilder();
        Table table = index.getTable(true);
        if (index.isPrimary()) {
            builder.append("ALTER TABLE ");
            this.name(runtime, builder, table);
            builder.append(" DROP CONSTRAINT ").append(index.getName());
        } else {
            builder.append("DROP INDEX ").append(index.getName());
            if (BasicUtil.isNotEmpty((Object)table)) {
                builder.append(" ON ");
                this.name(runtime, builder, table);
            }
        }
        return runs;
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Index index) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildAddRun(DataRuntime runtime, Index index)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public void comment(DataRuntime runtime, StringBuilder builder, Index index) {
    }

    @Override
    public List<Run> buildAddRun(DataRuntime runtime, Constraint constraint) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildAddRun(DataRuntime runtime, Constraint constraint)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Constraint constraint) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(LogUtil.format((String)("\u5b50\u7c7b(" + this.getClass().getName().replace("org.anyline.data.jdbc.config.db.impl.", "") + ")\u672a\u5b9e\u73b0 List<Run> buildAlterRun(DataRuntime runtime, Constraint constraint)"), (int)37));
        }
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Constraint constraint) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add(run);
        StringBuilder builder = run.getBuilder();
        builder.append("ALTER TABLE ");
        Table table = constraint.getTable(true);
        this.name(runtime, builder, table);
        builder.append(" DROP CONSTRAINT ").append(constraint.getName());
        return runs;
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Constraint constraint) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add(run);
        StringBuilder builder = run.getBuilder();
        Table table = constraint.getTable(true);
        String catalog = constraint.getCatalog();
        String schema = table.getSchema();
        builder.append("ALTER CONSTRAINT ");
        if (BasicUtil.isNotEmpty((Object)catalog)) {
            SQLUtil.delimiter((StringBuilder)builder, (String)catalog, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(".");
        }
        if (BasicUtil.isNotEmpty((Object)schema)) {
            SQLUtil.delimiter((StringBuilder)builder, (String)schema, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(".");
        }
        SQLUtil.delimiter((StringBuilder)builder, (String)constraint.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        builder.append(" RENAME TO ");
        SQLUtil.delimiter((StringBuilder)builder, (String)constraint.getUpdate().getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        return runs;
    }

    @Override
    public List<Run> buildCreateRun(DataRuntime runtime, Trigger trigger) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add(run);
        StringBuilder builder = run.getBuilder();
        builder.append("CREATE TRIGGER ").append(trigger.getName());
        builder.append(" ").append(trigger.getTime().sql()).append(" ");
        List events = trigger.getEvents();
        boolean first = true;
        for (Trigger.EVENT event : events) {
            if (!first) {
                builder.append(" OR ");
            }
            builder.append(event);
            first = false;
        }
        builder.append(" ON ");
        this.name(runtime, builder, trigger.getTable(true));
        this.each(runtime, builder, trigger);
        builder.append("\n").append(trigger.getDefinition());
        return runs;
    }

    @Override
    public void each(DataRuntime runtime, StringBuilder builder, Trigger trigger) {
        if (trigger.isEach()) {
            builder.append(" FOR EACH ROW ");
        } else {
            builder.append(" FOR EACH STATEMENT ");
        }
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Trigger trigger) throws Exception {
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Trigger trigger) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add(run);
        StringBuilder builder = run.getBuilder();
        builder.append("DROP TRIGGER ");
        Table table = trigger.getTable(true);
        if (null != table) {
            String catalog = table.getCatalog();
            String schema = table.getSchema();
            if (BasicUtil.isNotEmpty((Object)catalog)) {
                SQLUtil.delimiter((StringBuilder)builder, (String)catalog, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(".");
            }
            if (BasicUtil.isNotEmpty((Object)schema)) {
                SQLUtil.delimiter((StringBuilder)builder, (String)schema, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(".");
            }
        }
        SQLUtil.delimiter((StringBuilder)builder, (String)trigger.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        return runs;
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Trigger trigger) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add(run);
        StringBuilder builder = run.getBuilder();
        Table table = trigger.getTable(true);
        String catalog = table.getCatalog();
        String schema = table.getSchema();
        builder.append("ALTER TRIGGER ");
        if (BasicUtil.isNotEmpty((Object)catalog)) {
            SQLUtil.delimiter((StringBuilder)builder, (String)catalog, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(".");
        }
        if (BasicUtil.isNotEmpty((Object)schema)) {
            SQLUtil.delimiter((StringBuilder)builder, (String)schema, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(".");
        }
        SQLUtil.delimiter((StringBuilder)builder, (String)trigger.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        builder.append(" RENAME TO ");
        SQLUtil.delimiter((StringBuilder)builder, (String)trigger.getUpdate().getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        return runs;
    }

    @Override
    public List<Run> buildCreateRun(DataRuntime runtime, Procedure procedure) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add(run);
        StringBuilder builder = run.getBuilder();
        builder.append("CREATE PROCEDURE ");
        String catalog = procedure.getCatalog();
        String schema = procedure.getSchema();
        if (BasicUtil.isNotEmpty((Object)catalog)) {
            SQLUtil.delimiter((StringBuilder)builder, (String)catalog, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(".");
        }
        if (BasicUtil.isNotEmpty((Object)schema)) {
            SQLUtil.delimiter((StringBuilder)builder, (String)schema, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(".");
        }
        SQLUtil.delimiter((StringBuilder)builder, (String)procedure.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        builder.append("(\n");
        List ins = procedure.getInputs();
        List outs = procedure.getOutputs();
        boolean first = true;
        for (Parameter parameter : ins) {
            if (parameter.isOutput()) continue;
            if (!first) {
                builder.append(",");
            }
            this.parameter(runtime, builder, parameter);
        }
        for (Parameter parameter : outs) {
            if (!first) {
                builder.append(",");
            }
            this.parameter(runtime, builder, parameter);
        }
        builder.append("\n)");
        String returnType = procedure.getReturnType();
        if (BasicUtil.isNotEmpty((Object)returnType)) {
            builder.append(" RETURNS ").append(returnType);
        }
        builder.append("\n");
        builder.append(procedure.getDefinition());
        return runs;
    }

    @Override
    public void parameter(DataRuntime runtime, StringBuilder builder, Parameter parameter) {
        boolean in = parameter.isInput();
        boolean out = parameter.isOutput();
        if (in) {
            builder.append("IN");
        }
        if (out) {
            builder.append("OUT");
        }
        builder.append(" ").append(parameter.getName());
        ColumnType type = parameter.getColumnType();
        boolean isIgnorePrecision = type.ignorePrecision();
        boolean isIgnoreScale = type.ignoreScale();
        builder.append(type);
        if (!isIgnorePrecision) {
            Integer precision = parameter.getPrecision();
            Integer scale = parameter.getScale();
            if (null != precision) {
                if (precision > 0) {
                    builder.append("(").append(precision);
                    if (null != scale && scale > 0 && !isIgnoreScale) {
                        builder.append(",").append(scale);
                    }
                    builder.append(")");
                } else if (precision == -1) {
                    builder.append("(max)");
                }
            }
        }
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Procedure procedure) throws Exception {
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Procedure procedure) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add(run);
        StringBuilder builder = run.getBuilder();
        builder.append("DROP PROCEDURE ");
        String catalog = procedure.getCatalog();
        String schema = procedure.getSchema();
        if (BasicUtil.isNotEmpty((Object)catalog)) {
            SQLUtil.delimiter((StringBuilder)builder, (String)catalog, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(".");
        }
        if (BasicUtil.isNotEmpty((Object)schema)) {
            SQLUtil.delimiter((StringBuilder)builder, (String)schema, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(".");
        }
        SQLUtil.delimiter((StringBuilder)builder, (String)procedure.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        return runs;
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Procedure procedure) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add(run);
        StringBuilder builder = run.getBuilder();
        String catalog = procedure.getCatalog();
        String schema = procedure.getSchema();
        builder.append("ALTER PROCEDURE ");
        if (BasicUtil.isNotEmpty((Object)catalog)) {
            SQLUtil.delimiter((StringBuilder)builder, (String)catalog, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(".");
        }
        if (BasicUtil.isNotEmpty((Object)schema)) {
            SQLUtil.delimiter((StringBuilder)builder, (String)schema, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(".");
        }
        SQLUtil.delimiter((StringBuilder)builder, (String)procedure.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        builder.append(" RENAME TO ");
        SQLUtil.delimiter((StringBuilder)builder, (String)procedure.getUpdate().getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        return runs;
    }

    @Override
    public List<Run> buildCreateRun(DataRuntime runtime, Function function) throws Exception {
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildAlterRun(DataRuntime runtime, Function function) throws Exception {
        return new ArrayList<Run>();
    }

    @Override
    public List<Run> buildDropRun(DataRuntime runtime, Function function) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add(run);
        StringBuilder builder = run.getBuilder();
        builder.append("DROP FUNCTION ");
        String catalog = function.getCatalog();
        String schema = function.getSchema();
        if (BasicUtil.isNotEmpty((Object)catalog)) {
            SQLUtil.delimiter((StringBuilder)builder, (String)catalog, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(".");
        }
        if (BasicUtil.isNotEmpty((Object)schema)) {
            SQLUtil.delimiter((StringBuilder)builder, (String)schema, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(".");
        }
        SQLUtil.delimiter((StringBuilder)builder, (String)function.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        return runs;
    }

    @Override
    public List<Run> buildRenameRun(DataRuntime runtime, Function function) throws Exception {
        ArrayList<Run> runs = new ArrayList<Run>();
        SimpleRun run = new SimpleRun();
        runs.add(run);
        StringBuilder builder = run.getBuilder();
        String catalog = function.getCatalog();
        String schema = function.getSchema();
        builder.append("ALTER FUNCTION ");
        if (BasicUtil.isNotEmpty((Object)catalog)) {
            SQLUtil.delimiter((StringBuilder)builder, (String)catalog, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(".");
        }
        if (BasicUtil.isNotEmpty((Object)schema)) {
            SQLUtil.delimiter((StringBuilder)builder, (String)schema, (String)this.getDelimiterFr(), (String)this.getDelimiterTo()).append(".");
        }
        SQLUtil.delimiter((StringBuilder)builder, (String)function.getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        builder.append(" RENAME TO ");
        SQLUtil.delimiter((StringBuilder)builder, (String)function.getUpdate().getName(), (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        return runs;
    }

    @Override
    public boolean isBooleanColumn(DataRuntime runtime, Column column) {
        String type;
        String clazz = column.getClassName();
        return null != clazz ? (clazz = clazz.toLowerCase()).contains("boolean") : null != (type = column.getTypeName()) && ((type = type.toLowerCase()).equals("bit") || type.equals("bool"));
    }

    @Override
    public boolean isNumberColumn(DataRuntime runtime, Column column) {
        String type;
        String clazz = column.getClassName();
        return null != clazz ? (clazz = clazz.toLowerCase()).startsWith("int") || clazz.contains("integer") || clazz.contains("long") || clazz.contains("decimal") || clazz.contains("float") || clazz.contains("double") || clazz.contains("timestamp") || clazz.contains("short") : null != (type = column.getTypeName()) && ((type = type.toLowerCase()).startsWith("int") || type.contains("float") || type.contains("double") || type.contains("short") || type.contains("long") || type.contains("decimal") || type.contains("numeric") || type.contains("timestamp"));
    }

    @Override
    public boolean isCharColumn(DataRuntime runtime, Column column) {
        return !this.isNumberColumn(runtime, column) && !this.isBooleanColumn(runtime, column);
    }

    @Override
    public String value(DataRuntime runtime, Column column, DriverAdapter.SQL_BUILD_IN_VALUE value) {
        return null;
    }

    protected String string(Map<String, Integer> keys, String key, ResultSet set, String def) throws Exception {
        Object value = this.value(keys, key, set);
        if (null != value) {
            return value.toString();
        }
        return def;
    }

    protected String string(Map<String, Integer> keys, String key, ResultSet set) throws Exception {
        return this.string(keys, key, set, null);
    }

    protected Integer integer(Map<String, Integer> keys, String key, ResultSet set, Integer def) throws Exception {
        Object value = this.value(keys, key, set);
        if (null != value) {
            return BasicUtil.parseInt((Object)value, (Integer)def);
        }
        return null;
    }

    protected Boolean bool(Map<String, Integer> keys, String key, ResultSet set, Boolean def) throws Exception {
        Object value = this.value(keys, key, set);
        if (null != value) {
            return BasicUtil.parseBoolean((Object)value, (Boolean)def);
        }
        return null;
    }

    protected Boolean bool(Map<String, Integer> keys, String key, ResultSet set, int def) throws Exception {
        Boolean defaultValue = null;
        if (def == 0) {
            defaultValue = false;
        } else if (def == 1) {
            defaultValue = true;
        }
        return this.bool(keys, key, set, defaultValue);
    }

    protected Object value(Map<String, Integer> keys, String key, ResultSet set, Object def) throws Exception {
        Integer index = keys.get(key);
        if (null != index && index >= 0) {
            try {
                return set.getObject(index);
            }
            catch (Exception e) {
                return def;
            }
        }
        return def;
    }

    protected Object value(Map<String, Integer> keys, String key, ResultSet set) throws Exception {
        return this.value(keys, key, set, null);
    }

    @Override
    public String getPrimaryKey(DataRuntime runtime, Object obj) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof DataRow) {
            return ((DataRow)obj).getPrimaryKey();
        }
        return EntityAdapterProxy.primaryKey(obj.getClass(), (boolean)true);
    }

    @Override
    public Object getPrimaryValue(DataRuntime runtime, Object obj) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof DataRow) {
            return ((DataRow)obj).getPrimaryValue();
        }
        return EntityAdapterProxy.primaryValue((Object)obj);
    }

    public String parseTable(String table) {
        if (null == table) {
            return table;
        }
        table = table.replace(this.getDelimiterFr(), "").replace(this.getDelimiterTo(), "");
        if ((table = DataSourceUtil.parseDataSource(table, null)).contains(".")) {
            String[] tmps = table.split("\\.");
            table = SQLUtil.delimiter((String)tmps[0], (String)this.getDelimiterFr(), (String)this.getDelimiterTo()) + "." + SQLUtil.delimiter((String)tmps[1], (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        } else {
            table = SQLUtil.delimiter((String)table, (String)this.getDelimiterFr(), (String)this.getDelimiterTo());
        }
        return table;
    }

    @Override
    public Object write(DataRuntime runtime, Column metadata, Object value, boolean placeholder) {
        if (null == value) {
            return value;
        }
        Object result = value;
        if (null != metadata && null != value) {
            String typeName;
            ColumnType ctype = metadata.getColumnType();
            if (null == ctype && null != (typeName = metadata.getTypeName())) {
                ctype = this.type(typeName.toUpperCase());
            }
            if (null != ctype) {
                if (!placeholder) {
                    result = ctype.write(value, null, false);
                } else {
                    Class writeClass = ctype.compatible();
                    result = ConvertAdapter.convert((Object)value, (Class)writeClass, (boolean)metadata.isArray());
                }
            }
        } else if (!placeholder && null != value && !BasicUtil.isNumber((Object)value)) {
            result = "'" + result + "'";
        }
        return result;
    }

    @Override
    public Object read(DataRuntime runtime, Column metadata, Object value, Class clazz) {
        Object result = value;
        if (null == value) {
            return null;
        }
        DataReader reader = null;
        ColumnType ctype = null;
        if (null != metadata) {
            String typeName;
            ctype = metadata.getColumnType();
            if (null == ctype && null != (typeName = metadata.getTypeName())) {
                ctype = this.type(typeName);
            }
            if (null != ctype) {
                reader = this.reader(ctype);
            }
        }
        if (null == reader) {
            reader = this.reader(value.getClass());
        }
        if (null != reader) {
            result = reader.read(value);
        }
        if ((null == reader || null == result) && null != ctype) {
            result = ctype.read(value, null, clazz);
        }
        return result;
    }

    @Override
    public void value(DataRuntime runtime, StringBuilder builder, Object obj, String key) {
        Object value = null;
        if (obj instanceof DataRow) {
            value = ((DataRow)obj).get(key);
        } else if (EntityAdapterProxy.hasAdapter(obj.getClass())) {
            Field field = EntityAdapterProxy.field(obj.getClass(), (String)key);
            value = BeanUtil.getFieldValue((Object)obj, (Field)field);
        } else {
            value = BeanUtil.getFieldValue((Object)obj, (String)key);
        }
        if (null == value) {
            if (value instanceof DriverAdapter.SQL_BUILD_IN_VALUE) {
                builder.append(this.value(runtime, null, (DriverAdapter.SQL_BUILD_IN_VALUE)((Object)value)));
            } else {
                ColumnType type = this.type(value.getClass().getName());
                if (null != type) {
                    value = type.write(value, null, false);
                }
                builder.append(value);
            }
        } else {
            builder.append("null");
        }
    }

    @Override
    public boolean convert(DataRuntime runtime, String catalog, String schema, String table, RunValue value) {
        boolean result = false;
        if (ConfigTable.IS_AUTO_CHECK_METADATA) {
            LinkedHashMap<String, Column> columns = this.columns(runtime, null, false, new Table(catalog, schema, table), false);
            result = this.convert(runtime, columns, value);
        } else {
            result = this.convert(runtime, (Column)null, value);
        }
        return result;
    }

    @Override
    public void addRunValue(DataRuntime runtime, Run run, Compare compare, Column column, Object value) {
        boolean split = ConfigTable.IS_AUTO_SPLIT_ARRAY;
        if (ThreadConfig.check(runtime.getKey()).IS_AUTO_CHECK_METADATA()) {
            LinkedHashMap columns;
            String type = null;
            if (null != column && null == (type = column.getTypeName()) && BasicUtil.isNotEmpty((Object)run.getTable()) && null != (column = (Column)(columns = this.columns(runtime, null, false, new Table(run.getTable()), false)).get(column.getName().toUpperCase()))) {
                type = column.getTypeName();
            }
        }
        RunValue rv = run.addValues(compare, column, value, split);
        if (null != column) {
            value = this.convert(runtime, column, rv);
        }
    }

    @Override
    public boolean convert(DataRuntime runtime, Table table, Run run) {
        List<RunValue> values;
        boolean result = false;
        LinkedHashMap<String, Column> columns = table.getColumns();
        if (ConfigTable.IS_AUTO_CHECK_METADATA && (null == columns || columns.isEmpty())) {
            columns = this.columns(runtime, null, false, table, false);
        }
        if (null != (values = run.getRunValues())) {
            for (RunValue value : values) {
                if (ConfigTable.IS_AUTO_CHECK_METADATA) {
                    result = this.convert(runtime, columns, value);
                    continue;
                }
                result = this.convert(runtime, (Column)null, value);
            }
        }
        return result;
    }

    @Override
    public boolean convert(DataRuntime runtime, Map<String, Column> columns, RunValue value) {
        boolean result = false;
        if (null != columns && null != value) {
            Column meta = columns.get(value.getKey().toUpperCase());
            result = this.convert(runtime, meta, value);
        }
        return result;
    }

    @Override
    public boolean convert(DataRuntime runtime, Column metadata, RunValue run) {
        if (null == run) {
            return true;
        }
        Object value = run.getValue();
        if (null == value) {
            return true;
        }
        try {
            if (null != metadata) {
                value = this.convert(runtime, metadata, value);
            } else {
                DataWriter writer = this.writer(value.getClass());
                if (null != writer) {
                    value = writer.write(value, true);
                }
            }
            run.setValue(value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public Object convert(DataRuntime runtime, Column metadata, Object value) {
        if (null == value) {
            return value;
        }
        try {
            if (null != metadata) {
                ColumnType columnType = metadata.getColumnType();
                if (null == columnType && null != (columnType = this.type(metadata.getTypeName()))) {
                    columnType.setArray(metadata.isArray());
                    metadata.setColumnType(columnType);
                }
                value = this.convert(runtime, columnType, value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }

    @Override
    public Object convert(DataRuntime runtime, ColumnType columnType, Object value) {
        if (null == columnType) {
            return value;
        }
        String typeName = columnType.getName();
        boolean parseJson = false;
        if (null != typeName && !(value instanceof String)) {
            if (typeName.contains("JSON")) {
                value = BeanUtil.object2json((Object)value);
                parseJson = true;
            } else if (typeName.contains("XML")) {
                value = BeanUtil.object2xml((Object)value);
                parseJson = true;
            }
        }
        if (!parseJson && null != columnType) {
            DataWriter writer = this.writer(columnType);
            if (null != writer) {
                value = writer.write(value, true);
            } else {
                Class transfer = columnType.transfer();
                Class compatible = columnType.compatible();
                if (null != transfer) {
                    value = ConvertAdapter.convert((Object)value, (Class)transfer, (boolean)columnType.isArray());
                }
                if (null != compatible) {
                    value = ConvertAdapter.convert((Object)value, (Class)compatible, (boolean)columnType.isArray());
                }
            }
        }
        return value;
    }

    public PrimaryGenerator getPrimaryGenerator() {
        return this.primaryGenerator;
    }

    public void setPrimaryGenerator(PrimaryGenerator primaryGenerator) {
        this.primaryGenerator = primaryGenerator;
    }

    @Override
    public String objectName(DataRuntime runtime, String name) {
        KeyAdapter.KEY_CASE keyCase = this.type().nameCase();
        if (null != keyCase) {
            return keyCase.convert(name);
        }
        return name;
    }

    protected String random(DataRuntime runtime) {
        StringBuilder builder = new StringBuilder();
        builder.append("[SQL:").append(System.currentTimeMillis()).append("-").append(BasicUtil.getRandomNumberString((int)8)).append("][thread:").append(Thread.currentThread().getId()).append("][ds:").append(runtime.datasource()).append("]");
        return builder.toString();
    }
}

