/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.dao.init.springjdbc;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.anyline.adapter.PersistenceAdapter;
import org.anyline.dao.AnylineDao;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.listener.DDListener;
import org.anyline.data.listener.DMListener;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.param.init.DefaultConfigStore;
import org.anyline.data.prepare.RunPrepare;
import org.anyline.data.prepare.auto.init.DefaultTablePrepare;
import org.anyline.data.prepare.auto.init.DefaultTextPrepare;
import org.anyline.data.run.Run;
import org.anyline.data.run.SimpleRun;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.data.runtime.RuntimeHolder;
import org.anyline.data.util.ClientHolder;
import org.anyline.data.util.ThreadConfig;
import org.anyline.entity.Compare;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.entity.EntitySet;
import org.anyline.entity.PageNavi;
import org.anyline.exception.AnylineException;
import org.anyline.metadata.ACTION;
import org.anyline.metadata.Column;
import org.anyline.metadata.Constraint;
import org.anyline.metadata.Database;
import org.anyline.metadata.ForeignKey;
import org.anyline.metadata.Function;
import org.anyline.metadata.Index;
import org.anyline.metadata.MasterTable;
import org.anyline.metadata.PartitionTable;
import org.anyline.metadata.PrimaryKey;
import org.anyline.metadata.Procedure;
import org.anyline.metadata.Table;
import org.anyline.metadata.Tag;
import org.anyline.metadata.Trigger;
import org.anyline.metadata.View;
import org.anyline.metadata.persistence.ManyToMany;
import org.anyline.metadata.persistence.OneToMany;
import org.anyline.proxy.CacheProxy;
import org.anyline.proxy.EntityAdapterProxy;
import org.anyline.proxy.InterceptorProxy;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.ClassUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.LogUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Repository;

@Primary
@Repository(value="anyline.dao")
public class DefaultDao<E>
implements AnylineDao<E> {
    protected static final Logger log = LoggerFactory.getLogger(DefaultDao.class);
    protected static DMListener dmListener;
    protected static DDListener ddListener;
    protected static boolean isBatchInsertRun;
    protected DataRuntime runtime = null;

    @Override
    public DataRuntime runtime() {
        if (null != this.runtime) {
            return this.runtime;
        }
        DataRuntime r = RuntimeHolder.getRuntime();
        if (null != r) {
            // empty if block
        }
        return r;
    }

    public boolean isFix() {
        return false;
    }

    public DMListener getListener() {
        return dmListener;
    }

    @Autowired(required=false)
    public void setDMListener(DMListener listener) {
        dmListener = listener;
    }

    @Autowired(required=false)
    public void setDDListener(DDListener listener) {
        ddListener = listener;
    }

    public DataRuntime getRuntime() {
        return this.runtime;
    }

    @Override
    public void setRuntime(DataRuntime runtime) {
        this.runtime = runtime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Map<String, Object>> maps(DataRuntime runtime, String random, boolean recover, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        try {
            List<Map<String, Object>> list = runtime.getAdapter().maps(runtime, random, prepare, configs, conditions);
            return list;
        }
        finally {
            if (recover && !this.isFix() && ClientHolder.isAutoRecover()) {
                ClientHolder.recoverDataSource();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSet querys(DataRuntime runtime, String random, boolean recover, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        try {
            DataSet dataSet = runtime.getAdapter().querys(runtime, null, prepare, configs, conditions);
            return dataSet;
        }
        finally {
            if (recover && !this.isFix() && ClientHolder.isAutoRecover()) {
                ClientHolder.recoverDataSource();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> EntitySet<T> selects(DataRuntime runtime, String random, boolean recover, RunPrepare prepare, Class<T> clazz, ConfigStore configs, String ... conditions) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        try {
            EntitySet<T> set = runtime.getAdapter().selects(runtime, null, prepare, clazz, configs, conditions);
            int dependency = ThreadConfig.check(runtime.getKey()).ENTITY_FIELD_SELECT_DEPENDENCY();
            if (dependency > 0) {
                this.checkMany2ManyDependencyQuery(runtime, random, set, dependency);
                this.checkOne2ManyDependencyQuery(runtime, random, set, dependency);
            }
            EntitySet<T> entitySet = set;
            return entitySet;
        }
        finally {
            if (recover && !this.isFix() && ClientHolder.isAutoRecover()) {
                ClientHolder.recoverDataSource();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataRow sequence(DataRuntime runtime, String random, boolean recover, boolean next, String ... names) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        try {
            DataRow dataRow = runtime.getAdapter().sequence(runtime, null, next, names);
            return dataRow;
        }
        finally {
            if (recover && !this.isFix() && ClientHolder.isAutoRecover()) {
                ClientHolder.recoverDataSource();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long count(DataRuntime runtime, String random, boolean recover, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        try {
            long l = runtime.getAdapter().count(runtime, null, prepare, configs, conditions);
            return l;
        }
        finally {
            if (!this.isFix() && ClientHolder.isAutoRecover()) {
                ClientHolder.recoverDataSource();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(DataRuntime runtime, String random, boolean recover, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        try {
            boolean bl = runtime.getAdapter().exists(runtime, random, prepare, configs, conditions);
            return bl;
        }
        finally {
            if (recover && !this.isFix() && ClientHolder.isAutoRecover()) {
                ClientHolder.recoverDataSource();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long update(DataRuntime runtime, String random, boolean recover, int batch, String dest, Object data, ConfigStore configs, List<String> columns) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        try {
            long result = runtime.getAdapter().update(runtime, random, batch, dest, data, configs, columns);
            this.checkMany2ManyDependencySave(runtime, random, data, ConfigTable.ENTITY_FIELD_INSERT_DEPENDENCY, 1);
            this.checkOne2ManyDependencySave(runtime, random, data, ConfigTable.ENTITY_FIELD_INSERT_DEPENDENCY, 1);
            long l = result;
            return l;
        }
        finally {
            if (recover && !this.isFix() && ClientHolder.isAutoRecover()) {
                ClientHolder.recoverDataSource();
            }
        }
    }

    private int checkMany2ManyDependencySave(DataRuntime runtime, String random, Object obj, int dependency, int mode) {
        int result = 0;
        if (dependency <= 0) {
            return result;
        }
        if (obj instanceof DataSet || obj instanceof DataRow || obj instanceof Map) {
            return result;
        }
        if (obj instanceof EntitySet) {
            EntitySet set = (EntitySet)obj;
            for (Object entity : set) {
                this.checkMany2ManyDependencySave(runtime, random, entity, dependency, mode);
            }
        } else {
            Class<?> clazz = obj.getClass();
            Column pc = EntityAdapterProxy.primaryKey(clazz);
            String pk = null;
            if (null != pc) {
                pk = pc.getName();
            }
            List fields = ClassUtil.getFieldsByAnnotation(clazz, (String[])new String[]{"ManyToMany"});
            for (Field field : fields) {
                try {
                    long qty;
                    ManyToMany join = PersistenceAdapter.manyToMany((Field)field);
                    Map primaryValueMap = EntityAdapterProxy.primaryValue((Object)obj);
                    Object pv = primaryValueMap.get(pk.toUpperCase());
                    Object fv = BeanUtil.getFieldValue((Object)obj, (Field)field);
                    if (null == fv) continue;
                    DataSet set = new DataSet();
                    Collection fvs = new ArrayList();
                    if (null == join.dependencyTable) {
                        if (fv.getClass().isArray()) {
                            fvs = BeanUtil.array2collection((Object)fv);
                        } else if (fv instanceof Collection) {
                            fvs = (Collection)fv;
                        }
                    } else {
                        Object objs;
                        Column joinpc = EntityAdapterProxy.primaryKey(clazz);
                        String joinpk = null;
                        if (null != joinpc) {
                            joinpk = joinpc.getName();
                        }
                        if (fv.getClass().isArray()) {
                            for (Object item : objs = (Object[])fv) {
                                fvs.add(EntityAdapterProxy.primaryValue((Object)item).get(joinpk.toUpperCase()));
                            }
                        } else if (fv instanceof Collection) {
                            objs = (Collection)fv;
                            Iterator iterator = objs.iterator();
                            while (iterator.hasNext()) {
                                Object item = iterator.next();
                                fvs.add(EntityAdapterProxy.primaryValue(item).get(joinpk.toUpperCase()));
                            }
                        }
                    }
                    for (Object item : fvs) {
                        DataRow row = new DataRow();
                        row.put(join.joinColumn, pv);
                        row.put(join.inverseJoinColumn, item);
                        set.add(row);
                    }
                    if (mode == 1 && (qty = runtime.getAdapter().deletes(runtime, random, join.joinTable, join.joinColumn, pv)) > 0L && ConfigTable.ENTITY_FIELD_DELETE_DEPENDENCY > 0 && !(obj instanceof DataRow)) {
                        this.checkMany2ManyDependencyDelete(runtime, random, obj, ConfigTable.ENTITY_FIELD_DELETE_DEPENDENCY);
                        this.checkOne2ManyDependencyDelete(runtime, random, obj, ConfigTable.ENTITY_FIELD_DELETE_DEPENDENCY);
                    }
                    runtime.getAdapter().save(runtime, random, join.joinTable, (Object)set, false, new String[0]);
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                        continue;
                    }
                    log.error("[check Many2ManyDependency Save][result:fail][msg:{}]", (Object)e.toString());
                }
            }
        }
        --dependency;
        return result;
    }

    private int checkOne2ManyDependencySave(DataRuntime runtime, String random, Object obj, int dependency, int mode) {
        int result = 0;
        if (dependency <= 0) {
            return result;
        }
        if (obj instanceof DataSet || obj instanceof DataRow || obj instanceof Map) {
            return result;
        }
        if (obj instanceof EntitySet) {
            EntitySet set = (EntitySet)obj;
            for (Object entity : set) {
                this.checkOne2ManyDependencySave(runtime, random, entity, dependency, mode);
            }
        } else {
            Class<?> clazz = obj.getClass();
            Column pc = EntityAdapterProxy.primaryKey(clazz);
            String pk = null;
            if (null != pc) {
                pk = pc.getName();
            }
            List fields = ClassUtil.getFieldsByAnnotation(clazz, (String[])new String[]{"OneToMany"});
            for (Field field : fields) {
                try {
                    long qty;
                    OneToMany join = PersistenceAdapter.oneToMany((Field)field);
                    Object pv = EntityAdapterProxy.primaryValue((Object)obj).get(pk.toUpperCase());
                    Object fv = BeanUtil.getFieldValue((Object)obj, (Field)field);
                    if (null == fv) continue;
                    if (null == join.joinField) {
                        throw new RuntimeException(field + "\u5173\u8054\u5c5e\u6027\u5f02\u5e38");
                    }
                    if (null == join.joinColumn) {
                        throw new RuntimeException(field + "\u5173\u8054\u5217\u5f02\u5e38");
                    }
                    if (null == join.dependencyTable) {
                        throw new RuntimeException(field + "\u5173\u8054\u8868\u5f02\u5e38");
                    }
                    if (mode == 1 && (qty = runtime.getAdapter().deletes(runtime, random, join.dependencyTable, join.joinColumn, pv)) > 0L && ConfigTable.ENTITY_FIELD_DELETE_DEPENDENCY > 0 && !(obj instanceof Map)) {
                        this.checkMany2ManyDependencyDelete(runtime, random, obj, ConfigTable.ENTITY_FIELD_DELETE_DEPENDENCY);
                        this.checkOne2ManyDependencyDelete(runtime, random, obj, ConfigTable.ENTITY_FIELD_DELETE_DEPENDENCY);
                    }
                    ArrayList<Object> items = new ArrayList<Object>();
                    if (fv.getClass().isArray()) {
                        Object[] objs = (Object[])fv;
                        for (Object item : objs) {
                            BeanUtil.setFieldValue((Object)item, (Field)join.joinField, pv);
                            items.add(item);
                        }
                    } else if (fv instanceof Collection) {
                        Collection cols = (Collection)fv;
                        for (Object item : cols) {
                            BeanUtil.setFieldValue(item, (Field)join.joinField, pv);
                            items.add(item);
                        }
                    }
                    runtime.getAdapter().save(runtime, random, join.dependencyTable, items, false, new String[0]);
                }
                catch (Exception e) {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                        continue;
                    }
                    log.error("[check One2ManyDependency Save][result:fail][msg:{}]", (Object)e.toString());
                }
            }
        }
        --dependency;
        return result;
    }

    protected <T> void checkMany2ManyDependencyQuery(DataRuntime runtime, String random, EntitySet<T> set, int dependency) {
        if (set.size() == 0 || dependency <= 0) {
            return;
        }
        --dependency;
        Class<?> clazz = set.get(0).getClass();
        Column pc = EntityAdapterProxy.primaryKey(clazz);
        String pk = null;
        if (null != pc) {
            pk = pc.getName();
        }
        List fields = ClassUtil.getFieldsByAnnotation(clazz, (String[])new String[]{"ManyToMany"});
        Compare compare = ThreadConfig.check(runtime.getKey()).ENTITY_FIELD_SELECT_DEPENDENCY_COMPARE();
        for (Field field : fields) {
            try {
                DefaultConfigStore conditions;
                String sql;
                ManyToMany join = PersistenceAdapter.manyToMany((Field)field);
                if (Compare.EQUAL == compare || set.size() == 1) {
                    for (Object entity : set) {
                        Map primaryValueMap = EntityAdapterProxy.primaryValue(entity);
                        if (null == join.dependencyTable) {
                            DataSet items = runtime.getAdapter().querys(runtime, random, new DefaultTablePrepare(join.joinTable), new DefaultConfigStore(new String[0]), "++" + join.joinColumn + ":" + primaryValueMap.get(pk.toUpperCase()));
                            List ids = items.getStrings(join.inverseJoinColumn);
                            BeanUtil.setFieldValue(entity, (Field)field, (Object)ids);
                            continue;
                        }
                        sql = "SELECT * FROM " + join.dependencyTable + " WHERE " + join.dependencyPk + " IN (SELECT " + join.inverseJoinColumn + " FROM " + join.joinTable + " WHERE " + join.joinColumn + "= #{JOIN_VALUE}" + ")";
                        DefaultConfigStore configs = new DefaultConfigStore(new String[0]);
                        configs.param("JOIN_VALUE", primaryValueMap.get(pk.toUpperCase()));
                        EntitySet dependencys = runtime.getAdapter().selects(runtime, random, new DefaultTextPrepare(sql), join.itemClass, configs, new String[0]);
                        BeanUtil.setFieldValue(entity, (Field)field, dependencys);
                    }
                    continue;
                }
                if (Compare.IN != compare) continue;
                ArrayList pvs = new ArrayList();
                HashMap idmap = new HashMap();
                for (Object entity : set) {
                    Map primaryValueMap = EntityAdapterProxy.primaryValue(entity);
                    Object pv = primaryValueMap.get(pk.toUpperCase());
                    pvs.add(pv);
                    idmap.put(entity, pv);
                }
                if (null == join.dependencyTable) {
                    conditions = new DefaultConfigStore(new String[0]);
                    conditions.and(join.joinColumn, pvs);
                    DataSet allItems = runtime.getAdapter().querys(runtime, random, new DefaultTablePrepare(join.joinTable), conditions, new String[0]);
                    for (Object entity : set) {
                        DataSet items = allItems.getRows(new String[]{join.joinColumn, idmap.get(entity) + ""});
                        List ids = items.getStrings(join.inverseJoinColumn);
                        BeanUtil.setFieldValue(entity, (Field)field, (Object)ids);
                    }
                    continue;
                }
                conditions = new DefaultConfigStore(new String[0]);
                conditions.param("JOIN_PVS", pvs);
                sql = "SELECT M.*, F." + join.joinColumn + " FK_" + join.joinColumn + " FROM " + join.dependencyTable + " M RIGHT JOIN " + join.joinTable + " F ON M." + join.dependencyPk + " = " + join.inverseJoinColumn + " WHERE " + join.joinColumn + " IN(#{JOIN_PVS})";
                DataSet alls = runtime.getAdapter().querys(runtime, random, new DefaultTextPrepare(sql), conditions, new String[0]);
                for (Object entity : set) {
                    DataSet items = alls.getRows(new String[]{"FK_" + join.joinColumn, idmap.get(entity) + ""});
                    BeanUtil.setFieldValue(entity, (Field)field, (Object)items.entity(join.itemClass));
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                    continue;
                }
                log.error("[check Many2ManyDependency query][result:fail][msg:{}]", (Object)e.toString());
            }
        }
    }

    private int checkMany2ManyDependencyDelete(DataRuntime runtime, String random, Object entity, int dependency) {
        int result = 0;
        if (dependency <= 0) {
            return result;
        }
        --dependency;
        Class<?> clazz = entity.getClass();
        Column pc = EntityAdapterProxy.primaryKey(clazz);
        String pk = null;
        if (null != pc) {
            pk = pc.getName();
        }
        List fields = ClassUtil.getFieldsByAnnotation(clazz, (String[])new String[]{"ManyToMany"});
        for (Field field : fields) {
            try {
                ManyToMany join = PersistenceAdapter.manyToMany((Field)field);
                runtime.getAdapter().deletes(runtime, random, join.joinTable, join.joinColumn, EntityAdapterProxy.primaryValue((Object)entity).get(pk.toUpperCase()));
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                    continue;
                }
                log.error("[check Many2ManyDependency delete][result:fail][msg:{}]", (Object)e.toString());
            }
        }
        return result;
    }

    private int checkOne2ManyDependencyDelete(DataRuntime runtime, String random, Object entity, int dependency) {
        int result = 0;
        if (dependency <= 0) {
            return result;
        }
        --dependency;
        Class<?> clazz = entity.getClass();
        Column pc = EntityAdapterProxy.primaryKey(clazz);
        String pk = null;
        if (null != pc) {
            pk = pc.getName();
        }
        List fields = ClassUtil.getFieldsByAnnotation(clazz, (String[])new String[]{"OneToMany"});
        for (Field field : fields) {
            try {
                OneToMany join = PersistenceAdapter.oneToMany((Field)field);
                runtime.getAdapter().deletes(runtime, random, join.dependencyTable, join.joinColumn, EntityAdapterProxy.primaryValue((Object)entity).get(pk.toUpperCase()));
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                    continue;
                }
                log.error("[check One2ManyDependency delete][result:fail][msg:{}]", (Object)e.toString());
            }
        }
        return result;
    }

    protected <T> void checkOne2ManyDependencyQuery(DataRuntime runtime, String random, EntitySet<T> set, int dependency) {
        if (set.size() == 0 || dependency <= 0) {
            return;
        }
        --dependency;
        Class<?> clazz = set.get(0).getClass();
        Column pc = EntityAdapterProxy.primaryKey(clazz);
        String pk = null;
        if (null != pc) {
            pk = pc.getName();
        }
        List fields = ClassUtil.getFieldsByAnnotation(clazz, (String[])new String[]{"OneToMany"});
        Compare compare = ThreadConfig.check(runtime.getKey()).ENTITY_FIELD_SELECT_DEPENDENCY_COMPARE();
        for (Field field : fields) {
            try {
                OneToMany join = PersistenceAdapter.oneToMany((Field)field);
                if (Compare.EQUAL == compare || set.size() == 1) {
                    for (Object entity : set) {
                        Object pv = EntityAdapterProxy.primaryValue(entity).get(pk.toUpperCase());
                        Map primaryValueMap = EntityAdapterProxy.primaryValue(entity);
                        ArrayList params = new ArrayList();
                        params.add(primaryValueMap.get(pk.toUpperCase()));
                        EntitySet dependencys = runtime.getAdapter().selects(runtime, random, null, join.dependencyClass, new DefaultConfigStore(new String[0]).and(join.joinColumn, pv), new String[0]);
                        BeanUtil.setFieldValue(entity, (Field)field, dependencys);
                    }
                    continue;
                }
                if (Compare.IN != compare) continue;
                ArrayList pvs = new ArrayList();
                HashMap idmap = new HashMap();
                for (Object entity : set) {
                    Map primaryValueMap = EntityAdapterProxy.primaryValue(entity);
                    Object pv = primaryValueMap.get(pk.toUpperCase());
                    pvs.add(pv);
                    idmap.put(entity, pv);
                }
                DefaultConfigStore conditions = new DefaultConfigStore(new String[0]);
                conditions.and(join.joinColumn, pvs);
                EntitySet alls = runtime.getAdapter().selects(runtime, random, null, join.dependencyClass, conditions, new String[0]);
                for (Object entity : set) {
                    EntitySet items = alls.gets(join.joinField, idmap.get(entity));
                    BeanUtil.setFieldValue(entity, (Field)field, (Object)items);
                }
            }
            catch (Exception e) {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    e.printStackTrace();
                    continue;
                }
                log.error("[check One2ManyDependency query][result:fail][msg:{}]", (Object)e.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long save(DataRuntime runtime, String random, boolean recover, int batch, String dest, Object data, boolean checkPrimary, List<String> columns) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        try {
            long result = runtime.getAdapter().save(runtime, random, dest, data, checkPrimary, columns);
            int ENTITY_FIELD_INSERT_DEPENDENCY = ThreadConfig.check(runtime.getKey()).ENTITY_FIELD_INSERT_DEPENDENCY();
            this.checkMany2ManyDependencySave(runtime, random, data, ENTITY_FIELD_INSERT_DEPENDENCY, 1);
            this.checkOne2ManyDependencySave(runtime, random, data, ENTITY_FIELD_INSERT_DEPENDENCY, 1);
            long l = result;
            return l;
        }
        finally {
            if (recover && !this.isFix() && ClientHolder.isAutoRecover()) {
                ClientHolder.recoverDataSource();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long insert(DataRuntime runtime, String random, boolean recover, int batch, String dest, Object data, boolean checkPrimary, List<String> columns) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        try {
            long result = runtime.getAdapter().insert(runtime, random, batch, dest, data, checkPrimary, columns);
            int ENTITY_FIELD_INSERT_DEPENDENCY = ThreadConfig.check(runtime.getKey()).ENTITY_FIELD_INSERT_DEPENDENCY();
            this.checkMany2ManyDependencySave(runtime, random, data, ENTITY_FIELD_INSERT_DEPENDENCY, 0);
            this.checkOne2ManyDependencySave(runtime, random, data, ENTITY_FIELD_INSERT_DEPENDENCY, 0);
            long l = result;
            return l;
        }
        finally {
            if (recover && !this.isFix() && ClientHolder.isAutoRecover()) {
                ClientHolder.recoverDataSource();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataSet select(DataRuntime runtime, String random, boolean recover, boolean system, String table, ConfigStore configs, Run run) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        try {
            DataSet dataSet = runtime.getAdapter().select(runtime, random, system, table, configs, run);
            return dataSet;
        }
        finally {
            if (recover && !this.isFix() && ClientHolder.isAutoRecover()) {
                ClientHolder.recoverDataSource();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long execute(DataRuntime runtime, String random, boolean recover, RunPrepare prepare, ConfigStore configs, String ... conditions) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        try {
            long l = runtime.getAdapter().execute(runtime, random, prepare, configs, conditions);
            return l;
        }
        finally {
            if (recover && !this.isFix() && ClientHolder.isAutoRecover()) {
                ClientHolder.recoverDataSource();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long execute(DataRuntime runtime, String random, boolean recover, int batch, String sql, List<Object> values) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        try {
            long l = runtime.getAdapter().execute(runtime, random, batch, sql, values);
            return l;
        }
        finally {
            if (recover && !this.isFix() && ClientHolder.isAutoRecover()) {
                ClientHolder.recoverDataSource();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(DataRuntime runtime, String random, boolean recover, Procedure procedure) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        try {
            boolean bl = runtime.getAdapter().execute(runtime, random, procedure);
            return bl;
        }
        finally {
            if (recover && !this.isFix() && ClientHolder.isAutoRecover()) {
                ClientHolder.recoverDataSource();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSet querys(DataRuntime runtime, String random, boolean recover, Procedure procedure, PageNavi navi) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        try {
            DataSet dataSet = runtime.getAdapter().querys(runtime, random, procedure, navi);
            return dataSet;
        }
        finally {
            if (recover && !this.isFix() && ClientHolder.isAutoRecover()) {
                ClientHolder.recoverDataSource();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> long deletes(DataRuntime runtime, String random, boolean recover, int batch, String table, String key, Collection<T> values) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        try {
            long l = runtime.getAdapter().deletes(runtime, random, batch, table, key, values);
            return l;
        }
        finally {
            if (recover && !this.isFix() && ClientHolder.isAutoRecover()) {
                ClientHolder.recoverDataSource();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long delete(DataRuntime runtime, String random, boolean recover, String dest, Object obj, String ... columns) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        try {
            long qty = runtime.getAdapter().delete(runtime, random, dest, obj, columns);
            if (qty > 0L && ConfigTable.ENTITY_FIELD_DELETE_DEPENDENCY > 0 && !(obj instanceof DataRow)) {
                this.checkMany2ManyDependencyDelete(runtime, random, obj, ConfigTable.ENTITY_FIELD_DELETE_DEPENDENCY);
                this.checkOne2ManyDependencyDelete(runtime, random, obj, ConfigTable.ENTITY_FIELD_DELETE_DEPENDENCY);
            }
            long l = qty;
            return l;
        }
        finally {
            if (recover && !this.isFix() && ClientHolder.isAutoRecover()) {
                ClientHolder.recoverDataSource();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long delete(DataRuntime runtime, String random, boolean recover, String table, ConfigStore configs, String ... conditions) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        try {
            long l = runtime.getAdapter().delete(runtime, random, table, configs, conditions);
            return l;
        }
        finally {
            if (recover && !this.isFix() && ClientHolder.isAutoRecover()) {
                ClientHolder.recoverDataSource();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int truncate(DataRuntime runtime, String random, boolean recover, String table) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        try {
            int n = runtime.getAdapter().truncate(runtime, random, table);
            return n;
        }
        finally {
            if (recover && !this.isFix() && ClientHolder.isAutoRecover()) {
                ClientHolder.recoverDataSource();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LinkedHashMap<String, Database> databases(DataRuntime runtime, String random, boolean recover) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        try {
            LinkedHashMap<String, Database> linkedHashMap = runtime.getAdapter().databases(runtime, random);
            return linkedHashMap;
        }
        finally {
            if (recover && !this.isFix() && ClientHolder.isAutoRecover()) {
                ClientHolder.recoverDataSource();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Database database(DataRuntime runtime, String random, boolean recover, String name) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        try {
            Database database = runtime.getAdapter().database(runtime, random, name);
            return database;
        }
        finally {
            if (recover && !this.isFix() && ClientHolder.isAutoRecover()) {
                ClientHolder.recoverDataSource();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Table> List<T> tables(DataRuntime runtime, String random, boolean recover, boolean greedy, String catalog, String schema, String pattern, String types) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        try {
            List list = runtime.getAdapter().tables(runtime, random, greedy, catalog, schema, pattern, types);
            return list;
        }
        finally {
            if (recover && !this.isFix() && ClientHolder.isAutoRecover()) {
                ClientHolder.recoverDataSource();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Table> LinkedHashMap<String, T> tables(DataRuntime runtime, String random, boolean recover, String catalog, String schema, String pattern, String types) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        try {
            LinkedHashMap linkedHashMap = runtime.getAdapter().tables(runtime, random, catalog, schema, pattern, types);
            return linkedHashMap;
        }
        finally {
            if (recover && !this.isFix() && ClientHolder.isAutoRecover()) {
                ClientHolder.recoverDataSource();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> ddl(DataRuntime runtime, String random, boolean recover, Table table, boolean init) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        try {
            List<String> list = runtime.getAdapter().ddl(runtime, random, table, init);
            return list;
        }
        finally {
            if (recover && !this.isFix() && ClientHolder.isAutoRecover()) {
                ClientHolder.recoverDataSource();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends View> LinkedHashMap<String, T> views(DataRuntime runtime, String random, boolean recover, boolean greedy, String catalog, String schema, String pattern, String types) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        try {
            LinkedHashMap linkedHashMap = runtime.getAdapter().views(runtime, random, greedy, catalog, schema, pattern, types);
            return linkedHashMap;
        }
        finally {
            if (recover && !this.isFix() && ClientHolder.isAutoRecover()) {
                ClientHolder.recoverDataSource();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> ddl(DataRuntime runtime, String random, boolean recover, View view) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        try {
            List<String> list = runtime.getAdapter().ddl(runtime, random, view);
            return list;
        }
        finally {
            if (recover && !this.isFix() && ClientHolder.isAutoRecover()) {
                ClientHolder.recoverDataSource();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends MasterTable> LinkedHashMap<String, T> mtables(DataRuntime runtime, String random, boolean recover, boolean greedy, String catalog, String schema, String pattern, String types) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        try {
            LinkedHashMap linkedHashMap = runtime.getAdapter().mtables(runtime, random, greedy, catalog, schema, pattern, types);
            return linkedHashMap;
        }
        finally {
            if (recover && !this.isFix() && ClientHolder.isAutoRecover()) {
                ClientHolder.recoverDataSource();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> ddl(DataRuntime runtime, String random, boolean recover, MasterTable table) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        try {
            List<String> list = runtime.getAdapter().ddl(runtime, random, table);
            return list;
        }
        finally {
            if (recover && !this.isFix() && ClientHolder.isAutoRecover()) {
                ClientHolder.recoverDataSource();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends PartitionTable> LinkedHashMap<String, T> ptables(DataRuntime runtime, String random, boolean recover, boolean greedy, MasterTable master, Map<String, Object> tags, String name) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        try {
            LinkedHashMap linkedHashMap = runtime.getAdapter().ptables(runtime, random, greedy, master, tags, name);
            return linkedHashMap;
        }
        finally {
            if (recover && !this.isFix() && ClientHolder.isAutoRecover()) {
                ClientHolder.recoverDataSource();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> ddl(DataRuntime runtime, String random, boolean recover, PartitionTable table) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        try {
            List<String> list = runtime.getAdapter().ddl(runtime, random, table);
            return list;
        }
        finally {
            if (recover && !this.isFix() && ClientHolder.isAutoRecover()) {
                ClientHolder.recoverDataSource();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Column> LinkedHashMap<String, T> columns(DataRuntime runtime, String random, boolean recover, boolean greedy, Table table, boolean primary) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        try {
            LinkedHashMap linkedHashMap = runtime.getAdapter().columns(runtime, random, greedy, table, primary);
            return linkedHashMap;
        }
        finally {
            if (recover && !this.isFix() && ClientHolder.isAutoRecover()) {
                ClientHolder.recoverDataSource();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Tag> LinkedHashMap<String, T> tags(DataRuntime runtime, String random, boolean recover, boolean greedy, Table table) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        try {
            LinkedHashMap linkedHashMap = runtime.getAdapter().tags(runtime, random, greedy, table);
            return linkedHashMap;
        }
        finally {
            if (recover && !this.isFix() && ClientHolder.isAutoRecover()) {
                ClientHolder.recoverDataSource();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrimaryKey primary(DataRuntime runtime, String random, boolean recover, boolean greedy, Table table) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        try {
            PrimaryKey primaryKey = runtime.getAdapter().primary(runtime, random, greedy, table);
            return primaryKey;
        }
        finally {
            if (recover && !this.isFix() && ClientHolder.isAutoRecover()) {
                ClientHolder.recoverDataSource();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends ForeignKey> LinkedHashMap<String, T> foreigns(DataRuntime runtime, String random, boolean recover, boolean greedy, Table table) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        try {
            LinkedHashMap linkedHashMap = runtime.getAdapter().foreigns(runtime, random, greedy, table);
            return linkedHashMap;
        }
        finally {
            if (recover && !this.isFix() && ClientHolder.isAutoRecover()) {
                ClientHolder.recoverDataSource();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Index> LinkedHashMap<String, T> indexs(DataRuntime runtime, String random, boolean recover, boolean greedy, Table table, String name) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        try {
            LinkedHashMap linkedHashMap = runtime.getAdapter().indexs(runtime, random, greedy, table, name);
            return linkedHashMap;
        }
        finally {
            if (recover && !this.isFix() && ClientHolder.isAutoRecover()) {
                ClientHolder.recoverDataSource();
            }
        }
    }

    @Override
    public <T extends Constraint> LinkedHashMap<String, T> constraints(DataRuntime runtime, String random, boolean recover, boolean greedy, Table table, String name) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Trigger> LinkedHashMap<String, T> triggers(DataRuntime runtime, String random, boolean recover, boolean greedy, Table table, List<Trigger.EVENT> events) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        try {
            LinkedHashMap linkedHashMap = runtime.getAdapter().triggers(runtime, random, greedy, table, events);
            return linkedHashMap;
        }
        finally {
            if (recover && !this.isFix() && ClientHolder.isAutoRecover()) {
                ClientHolder.recoverDataSource();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Procedure> LinkedHashMap<String, T> procedures(DataRuntime runtime, String random, boolean recover, boolean greedy, String catalog, String schema, String name) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        try {
            LinkedHashMap linkedHashMap = runtime.getAdapter().procedures(runtime, random, greedy, catalog, schema, name);
            return linkedHashMap;
        }
        finally {
            if (recover && !this.isFix() && ClientHolder.isAutoRecover()) {
                ClientHolder.recoverDataSource();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> ddl(DataRuntime runtime, String random, boolean recover, Procedure procedure) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        try {
            List<String> list = runtime.getAdapter().ddl(runtime, random, procedure);
            return list;
        }
        finally {
            if (recover && !this.isFix() && ClientHolder.isAutoRecover()) {
                ClientHolder.recoverDataSource();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Function> LinkedHashMap<String, T> functions(DataRuntime runtime, String random, boolean recover, boolean greedy, String catalog, String schema, String name) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        try {
            LinkedHashMap linkedHashMap = runtime.getAdapter().functions(runtime, random, greedy, catalog, schema, name);
            return linkedHashMap;
        }
        finally {
            if (recover && !this.isFix() && ClientHolder.isAutoRecover()) {
                ClientHolder.recoverDataSource();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> ddl(DataRuntime runtime, String random, boolean recover, Function function) {
        if (null == runtime) {
            runtime = this.runtime();
        }
        try {
            List<String> list = runtime.getAdapter().ddl(runtime, random, function);
            return list;
        }
        finally {
            if (recover && !this.isFix() && ClientHolder.isAutoRecover()) {
                ClientHolder.recoverDataSource();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean create(Table meta) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.TABLE_CREATE;
        DataRuntime runtime = this.runtime();
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareCreate(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        DriverAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, meta);
        List<Run> runs = adapter.buildCreateRun(runtime, meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeCreate(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterCreate(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterCreate(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    @Override
    public boolean alter(Table table) throws Exception {
        List<Run> alters;
        boolean change_pk;
        boolean result = true;
        ArrayList<Run> runs = new ArrayList<Run>();
        Table update = table.getUpdate();
        LinkedHashMap columns = table.getColumns();
        LinkedHashMap ucolumns = update.getColumns();
        String name = table.getName();
        String uname = update.getName();
        DataRuntime runtime = this.runtime();
        String random = this.random(runtime);
        DriverAdapter adapter = runtime.getAdapter();
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, ACTION.DDL.TABLE_ALTER, table);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.parepareAlter(runtime, random, table);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        this.checkSchema(runtime, table);
        this.checkSchema(runtime, update);
        long fr = System.currentTimeMillis();
        if (!name.equalsIgnoreCase(uname)) {
            result = this.rename(runtime, random, table, uname);
            table.setName(uname);
        }
        if (!result) {
            return result;
        }
        String comment = update.getComment() + "";
        if (!comment.equals(table.getComment()) && (swt = InterceptorProxy.prepare(runtime, random, ACTION.DDL.TABLE_COMMENT, table)) != ACTION.SWITCH.BREAK) {
            if (BasicUtil.isNotEmpty((Object)table.getComment())) {
                runs.addAll(adapter.buildChangeCommentRun(runtime, update));
            } else {
                runs.addAll(adapter.buildAppendCommentRun(runtime, update));
            }
            swt = InterceptorProxy.before(runtime, random, ACTION.DDL.TABLE_COMMENT, table, runs);
            if (swt != ACTION.SWITCH.BREAK) {
                long cmt_fr = System.currentTimeMillis();
                result = this.execute(runtime, random, ACTION.DDL.TABLE_COMMENT, runs) && result;
                InterceptorProxy.after(runtime, random, ACTION.DDL.TABLE_COMMENT, table, runs, result, System.currentTimeMillis() - cmt_fr);
            }
        }
        LinkedHashMap<String, Object> cols = new LinkedHashMap<String, Object>();
        for (Object ucolumn : ucolumns.values()) {
            Column column = (Column)columns.get(ucolumn.getName().toUpperCase());
            if (null != ucolumn.getUpdate()) {
                ucolumn = ucolumn.getUpdate();
            }
            if (null != column) {
                if (column.equals((Column)ucolumn)) continue;
                column.setTable(update);
                column.setUpdate((Column)ucolumn, false, false);
                column.setAction("alter");
                cols.put(column.getName().toUpperCase(), column);
                continue;
            }
            ucolumn.setTable(update);
            ucolumn.setAction("add");
            cols.put(ucolumn.getName().toUpperCase(), ucolumn);
        }
        ArrayList<String> deletes = new ArrayList<String>();
        for (Column column : ucolumns.values()) {
            if (!column.isDrop()) continue;
            deletes.add(column.getName().toUpperCase());
            column.setAction("drop");
            cols.put(column.getName().toUpperCase(), column);
        }
        if (table.isAutoDropColumn()) {
            for (Column column : columns.values()) {
                Column ucolumn;
                if (column instanceof Tag || column.isDrop() || deletes.contains(column.getName().toUpperCase()) || "drop".equals(column.getAction()) || null != (ucolumn = (Column)ucolumns.get(column.getName().toUpperCase()))) continue;
                column.setTable(update);
                column.setAction("drop");
                cols.put(column.getName().toUpperCase(), column);
            }
        }
        PrimaryKey src_primary = this.primary(table);
        PrimaryKey cur_primary = update.getPrimaryKey();
        String src_define = "";
        String cur_define = "";
        if (null != src_primary) {
            src_define = BeanUtil.concat(src_primary.getColumns().values(), (String)"name", (String)",");
        }
        if (null != cur_primary) {
            cur_define = BeanUtil.concat(cur_primary.getColumns().values(), (String)"name", (String)",");
        }
        boolean bl = change_pk = !cur_define.equalsIgnoreCase(src_define);
        if (change_pk) {
            LinkedHashMap pks = src_primary.getColumns();
            LinkedHashMap npks = cur_primary.getColumns();
            for (String k : pks.keySet()) {
                Column auto = (Column)columns.get(k.toUpperCase());
                if (null == auto || auto.isAutoIncrement() != 1 || npks.containsKey(auto.getName().toUpperCase())) continue;
                auto.setPrimaryKey(Boolean.valueOf(false));
                result = this.execute(runtime, random, ACTION.DDL.TABLE_ALTER, adapter.buildDropAutoIncrement(runtime, auto)) && result;
            }
            if (null != src_primary) {
                this.drop(src_primary);
            }
        }
        if (null != (alters = adapter.buildAlterRun(runtime, table, cols.values())) && alters.size() > 0) {
            boolean bl2 = result = this.execute(runtime, random, ACTION.DDL.COLUMN_ALTER, alters) && result;
        }
        if (change_pk && null != cur_primary) {
            this.add(cur_primary);
        }
        CacheProxy.clear();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean drop(Table meta) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.TABLE_DROP;
        DataRuntime runtime = this.runtime();
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareDrop(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        DriverAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, meta);
        List<Run> runs = adapter.buildDropRun(runtime, meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeDrop(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterDrop(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterDrop(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    private List<Run> runs(String sql) {
        ArrayList<Run> runs = new ArrayList<Run>();
        runs.add(new SimpleRun(sql));
        return runs;
    }

    @Override
    public boolean rename(Table origin, String name) throws Exception {
        return this.rename(null, null, origin, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean rename(DataRuntime runtime, String random, Table origin, String name) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.TABLE_RENAME;
        if (null == runtime) {
            runtime = this.runtime();
        }
        if (null == random) {
            random = this.random(runtime);
        }
        origin.setNewName(name);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, origin);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareRename(runtime, random, origin);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        DriverAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, origin);
        List<Run> runs = adapter.buildRenameRun(runtime, origin);
        swt = InterceptorProxy.before(runtime, random, action, origin, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeRename(runtime, random, origin, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][name:{}][rename:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, origin.getName(), name, runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterRename(runtime, random, origin, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][name:{}][rename:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, origin.getName(), name, runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterRename(runtime, random, origin, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean create(View meta) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.VIEW_CREATE;
        DataRuntime runtime = this.runtime();
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareCreate(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        DriverAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, (Table)meta);
        List<Run> runs = adapter.buildCreateRun(runtime, meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeCreate(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterCreate(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterCreate(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean alter(View meta) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.VIEW_ALTER;
        DataRuntime runtime = this.runtime();
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareAlter(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        DriverAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, (Table)meta);
        List<Run> runs = adapter.buildAlterRun(runtime, meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeAlter(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterAlter(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterAlter(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean drop(View meta) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.VIEW_DROP;
        DataRuntime runtime = this.runtime();
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareDrop(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        DriverAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, (Table)meta);
        List<Run> runs = adapter.buildDropRun(runtime, meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeDrop(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterDrop(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterDrop(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    @Override
    public boolean rename(View origin, String name) throws Exception {
        return this.rename(this.runtime(), origin, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean rename(DataRuntime runtime, View origin, String name) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.VIEW_RENAME;
        String random = this.random(runtime);
        origin.setNewName(name);
        if (null == runtime) {
            runtime = this.runtime();
        }
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, origin);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareRename(runtime, random, origin);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        DriverAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, (Table)origin);
        List<Run> runs = adapter.buildRenameRun(runtime, origin);
        swt = InterceptorProxy.before(runtime, random, action, origin, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeRename(runtime, random, origin, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][name:{}][rename:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, origin.getName(), name, runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterRename(runtime, random, origin, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][name:{}][rename:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, origin.getName(), name, runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterRename(runtime, random, origin, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean create(MasterTable meta) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.MASTER_TABLE_CREATE;
        DataRuntime runtime = this.runtime();
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareCreate(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        DriverAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, (Table)meta);
        List<Run> runs = adapter.buildCreateRun(runtime, meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeCreate(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterCreate(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterCreate(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    @Override
    public boolean alter(MasterTable table) throws Exception {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        DataRuntime runtime = this.runtime();
        String random = this.random(runtime);
        if (null != ddListener) {
            // empty if block
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        boolean result = true;
        DriverAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, (Table)table);
        MasterTable update = table.getUpdate();
        LinkedHashMap columns = table.getColumns();
        LinkedHashMap ucolumns = update.getColumns();
        LinkedHashMap tags = table.getTags();
        LinkedHashMap utags = update.getTags();
        String name = table.getName();
        String uname = update.getName();
        long fr = System.currentTimeMillis();
        if (!name.equalsIgnoreCase(uname)) {
            result = this.rename(runtime, random, (Table)table, uname);
        }
        for (Column ucolumn : ucolumns.values()) {
            Column column = (Column)columns.get(ucolumn.getName().toUpperCase());
            if (null != column) {
                column.setTable((Table)update);
                column.setUpdate(ucolumn, false, false);
                this.alter(column);
                result = true;
                continue;
            }
            ucolumn.setTable((Table)update);
            this.add(ucolumn);
            result = true;
        }
        if (table.isAutoDropColumn()) {
            for (Column column : columns.values()) {
                Column ucolumn;
                if (column instanceof Tag || null != (ucolumn = (Column)ucolumns.get(column.getName().toUpperCase()))) continue;
                column.setTable((Table)update);
                this.drop(column);
                result = true;
            }
        }
        for (Tag utag : utags.values()) {
            Tag tag = (Tag)tags.get(utag.getName().toUpperCase());
            if (null != tag) {
                tag.setTable((Table)update);
                tag.setUpdate(utag, false, false);
                this.alter(tag);
                result = true;
                continue;
            }
            utag.setTable((Table)update);
            this.add(utag);
            result = true;
        }
        if (table.isAutoDropColumn()) {
            for (Tag tag : tags.values()) {
                Tag utag = (Tag)utags.get(tag.getName().toUpperCase());
                if (null != utag) continue;
                tag.setTable((Table)update);
                this.drop(tag);
                result = true;
            }
        }
        if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[alter master table][table:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, table.getName(), result, System.currentTimeMillis() - fr});
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean drop(MasterTable meta) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.MASTER_TABLE_DROP;
        DataRuntime runtime = this.runtime();
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareDrop(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        DriverAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, (Table)meta);
        List<Run> runs = adapter.buildDropRun(runtime, meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeDrop(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterDrop(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterDrop(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    @Override
    public boolean rename(MasterTable origin, String name) throws Exception {
        return this.rename(this.runtime(), origin, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rename(DataRuntime runtime, MasterTable origin, String name) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.MASTER_TABLE_RENAME;
        if (null == runtime) {
            runtime = this.runtime();
        }
        String random = this.random(runtime);
        origin.setNewName(name);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, origin);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareRename(runtime, random, origin);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        DriverAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, (Table)origin);
        List<Run> runs = adapter.buildRenameRun(runtime, origin);
        swt = InterceptorProxy.before(runtime, random, action, origin, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeRename(runtime, random, origin, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][name:{}][rename:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, origin.getName(), name, runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterRename(runtime, random, origin, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                swt = InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][name:{}][rename:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, origin.getName(), name, runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterRename(runtime, random, origin, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            swt = InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean create(PartitionTable meta) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.PARTITION_TABLE_CREATE;
        DataRuntime runtime = this.runtime();
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareCreate(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        DriverAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, (Table)meta);
        List<Run> runs = adapter.buildCreateRun(runtime, meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeCreate(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][master:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getMasterName(), meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterCreate(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][master:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getMasterName(), meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterCreate(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    @Override
    public boolean alter(PartitionTable table) throws Exception {
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        DataRuntime runtime = this.runtime();
        String random = this.random(runtime);
        if (null != ddListener) {
            // empty if block
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        boolean result = true;
        DriverAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, (Table)table);
        Table update = table.getUpdate();
        LinkedHashMap columns = table.getColumns();
        LinkedHashMap ucolumns = update.getColumns();
        String name = table.getName();
        String uname = update.getName();
        long fr = System.currentTimeMillis();
        if (!name.equalsIgnoreCase(uname)) {
            result = this.rename(runtime, random, table, uname);
        }
        for (Column ucolumn : ucolumns.values()) {
            Column column = (Column)columns.get(ucolumn.getName().toUpperCase());
            if (null != column) {
                column.setTable(update);
                column.setUpdate(ucolumn, false, false);
                this.alter(column);
                result = true;
                continue;
            }
            ucolumn.setTable(update);
            this.add(ucolumn);
            result = true;
        }
        if (table.isAutoDropColumn()) {
            for (Column column : columns.values()) {
                Column ucolumn;
                if (column instanceof Tag || null != (ucolumn = (Column)ucolumns.get(column.getName().toUpperCase()))) continue;
                column.setTable(update);
                this.drop(column);
                result = true;
            }
        }
        if (null != ddListener) {
            // empty if block
        }
        if (ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[alter partition table][table:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, table.getName(), result, System.currentTimeMillis() - fr});
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean drop(PartitionTable meta) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.PARTITION_TABLE_DROP;
        DataRuntime runtime = this.runtime();
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareDrop(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        DriverAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, (Table)meta);
        List<Run> runs = adapter.buildDropRun(runtime, meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeDrop(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][master:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getMasterName(), meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterDrop(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][master:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getMasterName(), meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterDrop(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    @Override
    public boolean rename(PartitionTable origin, String name) throws Exception {
        return this.rename(null, null, origin, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean rename(DataRuntime runtime, String random, PartitionTable origin, String name) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.PARTITION_TABLE_RENAME;
        origin.setNewName(name);
        if (null == random) {
            random = this.random(runtime);
        }
        if (null == runtime) {
            runtime = this.runtime();
        }
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, origin);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareRename(runtime, random, origin);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        DriverAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, (Table)origin);
        List<Run> runs = adapter.buildRenameRun(runtime, origin);
        swt = InterceptorProxy.before(runtime, random, action, origin, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeRename(runtime, random, origin, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][master:{}][name:{}][rename:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, origin.getMasterName(), origin.getName(), name, runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterRename(runtime, random, origin, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][master:{}][name:{}][rename:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, origin.getMasterName(), origin.getName(), name, runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterRename(runtime, random, origin, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(Column meta) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.COLUMN_ADD;
        DataRuntime runtime = this.runtime();
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareAdd(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        DriverAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, meta);
        List<Run> runs = adapter.buildAddRun(runtime, meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeAdd(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterAdd(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterAdd(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    @Override
    public boolean alter(Table table, Column column) throws Exception {
        return this.alter(table, column, true);
    }

    @Override
    public boolean alter(Column column) throws Exception {
        Table table = column.getTable(true);
        if (null == table) {
            LinkedHashMap tables = this.tables(column.getCatalog(), column.getSchema(), column.getTableName(true), "TABLE");
            if (tables.size() == 0) {
                if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                    throw new AnylineException("\u8868\u4e0d\u5b58\u5728:" + column.getTableName(true));
                }
                log.error("\u8868\u4e0d\u5b58\u5728:" + column.getTableName(true));
            } else {
                table = (Table)tables.values().iterator().next();
            }
        }
        return this.alter(table, column, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean drop(Column meta) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.COLUMN_DROP;
        DataRuntime runtime = this.runtime();
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareDrop(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        DriverAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, meta);
        List<Run> runs = adapter.buildDropRun(runtime, meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeDrop(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterDrop(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterDrop(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean alter(Table table, Column meta, boolean trigger) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.COLUMN_ALTER;
        DataRuntime runtime = this.runtime();
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareAlter(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        DriverAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, meta);
        List<Run> runs = adapter.buildAlterRun(runtime, meta, false);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeAlter(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Exception e) {
            block21: {
                try {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    log.warn("{}[{}][exception:{}]", new Object[]{random, LogUtil.format((String)"\u4fee\u6539Column\u6267\u884c\u5f02\u5e38", (int)33), e.toString()});
                    if (trigger && null != ddListener && !BasicUtil.equalsIgnoreCase((Object)meta.getTypeName(), (Object)meta.getUpdate().getTypeName())) {
                        if (ConfigTable.AFTER_ALTER_COLUMN_EXCEPTION_ACTION != 0) {
                            swt = ddListener.afterAlterColumnException(runtime, random, table, meta, e);
                        }
                        log.warn("{}[\u4fee\u6539Column\u6267\u884c\u5f02\u5e38][\u5c1d\u8bd5\u4fee\u6b63\u6570\u636e][\u4fee\u6b63\u7ed3\u679c:{}]", (Object)random, (Object)swt);
                        if (swt == ACTION.SWITCH.CONTINUE) {
                            result = this.alter(table, meta, false);
                        }
                        break block21;
                    }
                    log.error("{}[\u4fee\u6539Column\u6267\u884c\u5f02\u5e38][\u4e2d\u65ad\u6267\u884c]", (Object)random);
                    result = false;
                    throw e;
                }
                catch (Throwable throwable) {
                    long millis = System.currentTimeMillis() - fr;
                    if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                        log.info("{}[action:{}][table:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
                    }
                    swt = ACTION.SWITCH.CONTINUE;
                    if (null != ddListener) {
                        swt = ddListener.afterAlter(runtime, random, meta, runs, result, millis);
                    }
                    if (swt == ACTION.SWITCH.CONTINUE) {
                        InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
                    }
                    throw throwable;
                }
            }
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterAlter(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterAlter(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rename(Column origin, String name) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.COLUMN_RENAME;
        DataRuntime runtime = this.runtime();
        String random = this.random(runtime);
        origin.setNewName(name);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, origin);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareRename(runtime, random, origin);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        DriverAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, origin);
        List<Run> runs = adapter.buildRenameRun(runtime, origin);
        swt = InterceptorProxy.before(runtime, random, action, origin, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeRename(runtime, random, origin, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][name:{}][rename:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, origin.getTableName(true), origin.getName(), name, runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterRename(runtime, random, origin, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][name:{}][rename:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, origin.getTableName(true), origin.getName(), name, runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterRename(runtime, random, origin, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(Tag meta) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.TAG_ADD;
        DataRuntime runtime = this.runtime();
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareAdd(runtime, random, (Column)meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        DriverAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, (Column)meta);
        List<Run> runs = adapter.buildAddRun(runtime, meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeAdd(runtime, random, (Column)meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterAdd(runtime, random, (Column)meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterAdd(runtime, random, (Column)meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    @Override
    public boolean alter(Table table, Tag tag) throws Exception {
        return this.alter(table, tag, true);
    }

    @Override
    public boolean alter(Tag tag) throws Exception {
        Table table = tag.getTable(true);
        if (null == table) {
            List tables = this.tables(false, tag.getCatalog(), tag.getSchema(), tag.getTableName(true), "TABLE");
            if (tables.size() == 0) {
                if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                    throw new AnylineException("\u8868\u4e0d\u5b58\u5728:" + tag.getTableName(true));
                }
                log.error("\u8868\u4e0d\u5b58\u5728:" + tag.getTableName(true));
            } else {
                table = (Table)tables.get(0);
            }
        }
        return this.alter(table, tag, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean drop(Tag meta) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.TAG_DROP;
        DataRuntime runtime = this.runtime();
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareDrop(runtime, random, (Column)meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        DriverAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, (Column)meta);
        List<Run> runs = adapter.buildDropRun(runtime, meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeDrop(runtime, random, (Column)meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterDrop(runtime, random, (Column)meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterDrop(runtime, random, (Column)meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean alter(Table table, Tag meta, boolean trigger) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.TAG_ALTER;
        DataRuntime runtime = this.runtime();
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareAlter(runtime, random, (Column)meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        DriverAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, (Column)meta);
        List<Run> runs = adapter.buildAlterRun(runtime, (Column)meta, false);
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Exception e) {
            block19: {
                try {
                    if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                        e.printStackTrace();
                    }
                    log.warn("{}[{}][exception:{}]", new Object[]{random, LogUtil.format((String)"\u4fee\u6539TAG\u6267\u884c\u5f02\u5e38", (int)33), e.toString()});
                    if (trigger && null != ddListener && !BasicUtil.equalsIgnoreCase((Object)meta.getTypeName(), (Object)meta.getUpdate().getTypeName())) {
                        if (ConfigTable.AFTER_ALTER_COLUMN_EXCEPTION_ACTION != 0) {
                            swt = ddListener.afterAlterColumnException(runtime, random, table, (Column)meta, e);
                        }
                        log.warn("{}[\u4fee\u6539TAG\u6267\u884c\u5f02\u5e38][\u5c1d\u8bd5\u4fee\u6b63\u6570\u636e][\u4fee\u6b63\u7ed3\u679c:{}]", (Object)random, (Object)swt);
                        if (swt == ACTION.SWITCH.CONTINUE) {
                            result = this.alter(table, meta, false);
                        }
                        break block19;
                    }
                    log.error("{}[\u4fee\u6539Column\u6267\u884c\u5f02\u5e38][\u4e2d\u65ad\u6267\u884c]", (Object)random);
                    result = false;
                    throw e;
                }
                catch (Throwable throwable) {
                    long millis = System.currentTimeMillis() - fr;
                    if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                        log.info("{}[action:{}][table:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
                    }
                    swt = ACTION.SWITCH.CONTINUE;
                    if (null != ddListener) {
                        swt = ddListener.afterAlter(runtime, random, (Column)meta, runs, result, millis);
                    }
                    if (swt == ACTION.SWITCH.CONTINUE) {
                        InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
                    }
                    throw throwable;
                }
            }
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterAlter(runtime, random, (Column)meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterAlter(runtime, random, (Column)meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rename(Tag origin, String name) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.TAG_RENAME;
        DataRuntime runtime = this.runtime();
        String random = this.random(runtime);
        origin.setNewName(name);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, origin);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareRename(runtime, random, (Column)origin);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        DriverAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, (Column)origin);
        List<Run> runs = adapter.buildRenameRun(runtime, origin);
        swt = InterceptorProxy.before(runtime, random, action, origin, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeRename(runtime, random, (Column)origin, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][name:{}][rename:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, origin.getTableName(true), origin.getName(), name, runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterRename(runtime, random, (Column)origin, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][name:{}][rename:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, origin.getTableName(true), origin.getName(), name, runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterRename(runtime, random, (Column)origin, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(PrimaryKey meta) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.PRIMARY_ADD;
        DataRuntime runtime = this.runtime();
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareAdd(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        DriverAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, (Index)meta);
        List<Run> runs = adapter.buildAddRun(runtime, meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeAdd(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterAdd(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterAdd(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    @Override
    public boolean alter(PrimaryKey primary) throws Exception {
        Table table = primary.getTable(true);
        if (null == table) {
            List tables = this.tables(false, primary.getCatalog(), primary.getSchema(), primary.getTableName(true), "TABLE");
            if (tables.size() == 0) {
                if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                    throw new AnylineException("\u8868\u4e0d\u5b58\u5728:" + primary.getTableName(true));
                }
                log.error("\u8868\u4e0d\u5b58\u5728:" + primary.getTableName(true));
            } else {
                table = (Table)tables.get(0);
            }
        }
        return this.alter(table, primary);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean alter(Table table, PrimaryKey meta) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.PRIMARY_ALTER;
        DataRuntime runtime = this.runtime();
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareAlter(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        DriverAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, (Index)meta);
        List<Run> runs = adapter.buildAlterRun(runtime, meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeAlter(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterAlter(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterAlter(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean drop(PrimaryKey meta) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.PRIMARY_DROP;
        DataRuntime runtime = this.runtime();
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareDrop(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        DriverAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, (Index)meta);
        List<Run> runs = adapter.buildDropRun(runtime, meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeDrop(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterDrop(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterDrop(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rename(PrimaryKey origin, String name) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.PRIMARY_RENAME;
        DataRuntime runtime = this.runtime();
        String random = this.random(runtime);
        origin.setNewName(name);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, origin);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareRename(runtime, random, origin);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        DriverAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, (Index)origin);
        List<Run> runs = adapter.buildRenameRun(runtime, origin);
        swt = InterceptorProxy.before(runtime, random, action, origin, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeRename(runtime, random, origin, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][name:{}][rename:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, origin.getTableName(true), origin.getName(), name, runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterRename(runtime, random, origin, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][name:{}][rename:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, origin.getTableName(true), origin.getName(), name, runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterRename(runtime, random, origin, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(ForeignKey meta) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.FOREIGN_ADD;
        DataRuntime runtime = this.runtime();
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareAdd(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        DriverAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, (Constraint)meta);
        List<Run> runs = adapter.buildAddRun(runtime, meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeAdd(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterAdd(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterAdd(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    @Override
    public boolean alter(ForeignKey meta) throws Exception {
        Table table = meta.getTable(true);
        if (null == table) {
            List tables = this.tables(false, meta.getCatalog(), meta.getSchema(), meta.getTableName(true), "TABLE");
            if (tables.size() == 0) {
                if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                    throw new AnylineException("\u8868\u4e0d\u5b58\u5728:" + meta.getTableName(true));
                }
                log.error("\u8868\u4e0d\u5b58\u5728:" + meta.getTableName(true));
            } else {
                table = (Table)tables.get(0);
            }
        }
        return this.alter(table, meta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean alter(Table table, ForeignKey meta) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.TRIGGER_ALTER;
        DataRuntime runtime = this.runtime();
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareAlter(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        DriverAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, (Constraint)meta);
        List<Run> runs = adapter.buildAlterRun(runtime, meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeAlter(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterAlter(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterAlter(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean drop(ForeignKey meta) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.FOREIGN_DROP;
        DataRuntime runtime = this.runtime();
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareDrop(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        DriverAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, (Constraint)meta);
        List<Run> runs = adapter.buildDropRun(runtime, meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeDrop(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterDrop(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterDrop(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rename(ForeignKey origin, String name) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.FOREIGN_RENAME;
        DataRuntime runtime = this.runtime();
        String random = this.random(runtime);
        origin.setNewName(name);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, origin);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareRename(runtime, random, origin);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        DriverAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, (Constraint)origin);
        List<Run> runs = adapter.buildRenameRun(runtime, origin);
        swt = InterceptorProxy.before(runtime, random, action, origin, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeRename(runtime, random, origin, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][name:{}][rename:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, origin.getTableName(true), origin.getName(), name, runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterRename(runtime, random, origin, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][name:{}][rename:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, origin.getTableName(true), origin.getName(), name, runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterRename(runtime, random, origin, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(Index meta) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.INDEX_ADD;
        DataRuntime runtime = this.runtime();
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareAdd(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        DriverAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, meta);
        List<Run> runs = adapter.buildAddRun(runtime, meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeAdd(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterAdd(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterAdd(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    @Override
    public boolean alter(Index meta) throws Exception {
        Table table = meta.getTable(true);
        if (null == table) {
            List tables = this.tables(false, meta.getCatalog(), meta.getSchema(), meta.getTableName(true), "TABLE");
            if (tables.size() == 0) {
                if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                    throw new AnylineException("\u8868\u4e0d\u5b58\u5728:" + meta.getTableName(true));
                }
                log.error("\u8868\u4e0d\u5b58\u5728:" + meta.getTableName(true));
            } else {
                table = (Table)tables.get(0);
            }
        }
        return this.alter(table, meta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean alter(Table table, Index index) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.INDEX_ALTER;
        DataRuntime runtime = this.runtime();
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, index);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareAlter(runtime, random, index);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        DriverAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, index);
        List<Run> runs = adapter.buildAlterRun(runtime, index);
        swt = InterceptorProxy.before(runtime, random, action, index, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeAlter(runtime, random, index, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, index.getTableName(true), index.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterAlter(runtime, random, index, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, index, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, index.getTableName(true), index.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterAlter(runtime, random, index, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, index, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean drop(Index meta) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.INDEX_DROP;
        DataRuntime runtime = this.runtime();
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareDrop(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        DriverAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, meta);
        List<Run> runs = adapter.buildDropRun(runtime, meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeDrop(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterDrop(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterDrop(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rename(Index origin, String name) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.INDEX_RENAME;
        DataRuntime runtime = this.runtime();
        String random = this.random(runtime);
        origin.setNewName(name);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, origin);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareRename(runtime, random, origin);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        DriverAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, origin);
        List<Run> runs = adapter.buildRenameRun(runtime, origin);
        swt = InterceptorProxy.before(runtime, random, action, origin, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeRename(runtime, random, origin, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][name:{}][rename:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, origin.getTableName(true), origin.getName(), name, runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterRename(runtime, random, origin, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][name:{}][rename:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, origin.getTableName(true), origin.getName(), name, runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterRename(runtime, random, origin, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(Constraint meta) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.CONSTRAINT_ADD;
        DataRuntime runtime = this.runtime();
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareAdd(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        DriverAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, meta);
        List<Run> runs = adapter.buildAddRun(runtime, meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeAdd(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterAdd(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterAdd(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    @Override
    public boolean alter(Constraint meta) throws Exception {
        Table table = meta.getTable(true);
        if (null == table) {
            List tables = this.tables(false, meta.getCatalog(), meta.getSchema(), meta.getTableName(true), "TABLE");
            if (tables.size() == 0) {
                if (ConfigTable.IS_THROW_SQL_UPDATE_EXCEPTION) {
                    throw new AnylineException("\u8868\u4e0d\u5b58\u5728:" + meta.getTableName(true));
                }
                log.error("\u8868\u4e0d\u5b58\u5728:" + meta.getTableName(true));
            } else {
                table = (Table)tables.get(0);
            }
        }
        return this.alter(table, meta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean alter(Table table, Constraint meta) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.CONSTRAINT_ALTER;
        DataRuntime runtime = this.runtime();
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareAlter(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        DriverAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, meta);
        List<Run> runs = adapter.buildAlterRun(runtime, meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeAlter(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterAlter(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterAlter(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean drop(Constraint meta) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.CONSTRAINT_DROP;
        DataRuntime runtime = this.runtime();
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareDrop(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        DriverAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, meta);
        List<Run> runs = adapter.buildDropRun(runtime, meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeDrop(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterDrop(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterDrop(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rename(Constraint origin, String name) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.CONSTRAINT_RENAME;
        DataRuntime runtime = this.runtime();
        String random = this.random(runtime);
        origin.setNewName(name);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, origin);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareRename(runtime, random, origin);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        DriverAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, origin);
        List<Run> runs = adapter.buildRenameRun(runtime, origin);
        swt = InterceptorProxy.before(runtime, random, action, origin, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeRename(runtime, random, origin, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][name:{}][rename:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, origin.getTableName(true), origin.getName(), name, runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterRename(runtime, random, origin, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][name:{}][rename:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, origin.getTableName(true), origin.getName(), name, runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterRename(runtime, random, origin, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(Trigger meta) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.TRIGGER_ADD;
        DataRuntime runtime = this.runtime();
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareCreate(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        DriverAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, meta);
        List<Run> runs = adapter.buildCreateRun(runtime, meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeCreate(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterCreate(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterCreate(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean alter(Trigger meta) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.TRIGGER_ALTER;
        DataRuntime runtime = this.runtime();
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareAlter(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        DriverAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, meta);
        List<Run> runs = adapter.buildAlterRun(runtime, meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeAlter(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterAlter(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][namer:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterAlter(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean drop(Trigger meta) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.TRIGGER_DROP;
        DataRuntime runtime = this.runtime();
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareDrop(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        DriverAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, meta);
        List<Run> runs = adapter.buildDropRun(runtime, meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeDrop(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterDrop(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getTableName(true), meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterDrop(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rename(Trigger origin, String name) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.TRIGGER_RENAME;
        DataRuntime runtime = this.runtime();
        String random = this.random(runtime);
        origin.setNewName(name);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, origin);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareRename(runtime, random, origin);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        DriverAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, origin);
        List<Run> runs = adapter.buildRenameRun(runtime, origin);
        swt = InterceptorProxy.before(runtime, random, action, origin, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeRename(runtime, random, origin, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][table:{}][name:{}][rename:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, origin.getTableName(true), origin.getName(), name, runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterRename(runtime, random, origin, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][table:{}][name:{}][rename:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, origin.getTableName(true), origin.getName(), name, runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterRename(runtime, random, origin, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean create(Procedure meta) throws Exception {
        boolean result = false;
        DataRuntime runtime = this.runtime();
        ACTION.DDL action = ACTION.DDL.PRIMARY_ADD;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareCreate(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        DriverAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, meta);
        List<Run> runs = adapter.buildCreateRun(runtime, meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeCreate(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterCreate(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterCreate(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean alter(Procedure meta) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.PROCEDURE_ALTER;
        DataRuntime runtime = this.runtime();
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareAlter(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        DriverAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, meta);
        List<Run> runs = adapter.buildAlterRun(runtime, meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeAlter(runtime, random, meta, runs);
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterAlter(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterAlter(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean drop(Procedure meta) throws Exception {
        boolean result = true;
        DataRuntime runtime = this.runtime();
        ACTION.DDL action = ACTION.DDL.PROCEDURE_DROP;
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareDrop(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        DriverAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, meta);
        List<Run> runs = adapter.buildDropRun(runtime, meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeDrop(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterDrop(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterDrop(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rename(Procedure origin, String name) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.PROCEDURE_RENAME;
        DataRuntime runtime = this.runtime();
        origin.setNewName(name);
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, origin);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareRename(runtime, random, origin);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        DriverAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, origin);
        List<Run> runs = adapter.buildRenameRun(runtime, origin);
        swt = InterceptorProxy.before(runtime, random, action, origin, runs);
        if (null == ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeRename(runtime, random, origin, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, origin.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterRename(runtime, random, origin, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, origin.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterRename(runtime, random, origin, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean create(Function meta) throws Exception {
        boolean result = true;
        ACTION.DDL action = ACTION.DDL.FUNCTION_CREATE;
        DataRuntime runtime = this.runtime();
        String random = this.random(runtime);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareCreate(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        DriverAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, meta);
        List<Run> runs = adapter.buildCreateRun(runtime, meta);
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            swt = ACTION.SWITCH.CONTINUE;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getName(), runs.size(), result, millis});
            }
            if (null != ddListener) {
                swt = ddListener.afterCreate(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        swt = ACTION.SWITCH.CONTINUE;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getName(), runs.size(), result, millis});
        }
        if (null != ddListener) {
            swt = ddListener.afterCreate(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean alter(Function meta) throws Exception {
        boolean result = false;
        DataRuntime runtime = this.runtime();
        String random = this.random(runtime);
        ACTION.DDL action = ACTION.DDL.FUNCTION_ALTER;
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, meta);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareDrop(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        DriverAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, meta);
        List<Run> runs = adapter.buildAlterRun(runtime, meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeDrop(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterAlter(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterAlter(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean drop(Function meta) throws Exception {
        ACTION.DDL action;
        String random;
        boolean result = false;
        DataRuntime runtime = this.runtime();
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random = this.random(runtime), action = ACTION.DDL.FUNCTION_DROP, meta);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareDrop(runtime, random, meta);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        DriverAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, meta);
        List<Run> runs = adapter.buildDropRun(runtime, meta);
        swt = InterceptorProxy.before(runtime, random, action, meta, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeDrop(runtime, random, meta, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getName(), runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterDrop(runtime, random, meta, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][name:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, meta.getName(), runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterDrop(runtime, random, meta, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, meta, runs, result, millis);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rename(Function origin, String name) throws Exception {
        boolean result = false;
        ACTION.DDL action = ACTION.DDL.FUNCTION_RENAME;
        DataRuntime runtime = this.runtime();
        String random = this.random(runtime);
        origin.setNewName(name);
        ACTION.SWITCH swt = InterceptorProxy.prepare(runtime, random, action, origin);
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.prepareRename(runtime, random, origin);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        DriverAdapter adapter = runtime.getAdapter();
        this.checkSchema(runtime, origin);
        List<Run> runs = adapter.buildRenameRun(runtime, origin);
        swt = InterceptorProxy.before(runtime, random, action, origin, runs);
        if (null != ddListener && swt == ACTION.SWITCH.CONTINUE) {
            swt = ddListener.beforeRename(runtime, random, origin, runs);
        }
        if (swt == ACTION.SWITCH.BREAK) {
            return false;
        }
        long fr = System.currentTimeMillis();
        try {
            result = this.execute(runtime, random, action, runs);
        }
        catch (Throwable throwable) {
            long millis = System.currentTimeMillis() - fr;
            if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
                log.info("{}[action:{}][name:{}][rename:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, origin.getName(), name, runs.size(), result, millis});
            }
            swt = ACTION.SWITCH.CONTINUE;
            if (null != ddListener) {
                swt = ddListener.afterRename(runtime, random, origin, runs, result, millis);
            }
            if (swt == ACTION.SWITCH.CONTINUE) {
                InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
            }
            throw throwable;
        }
        long millis = System.currentTimeMillis() - fr;
        if (runs.size() > 1 && ConfigTable.IS_SHOW_SQL && log.isInfoEnabled()) {
            log.info("{}[action:{}][name:{}][rename:{}][sqls:{}][result:{}][\u6267\u884c\u8017\u65f6:{}ms]", new Object[]{random, action, origin.getName(), name, runs.size(), result, millis});
        }
        swt = ACTION.SWITCH.CONTINUE;
        if (null != ddListener) {
            swt = ddListener.afterRename(runtime, random, origin, runs, result, millis);
        }
        if (swt == ACTION.SWITCH.CONTINUE) {
            InterceptorProxy.after(runtime, random, action, origin, runs, result, millis);
        }
        return result;
    }

    public boolean execute(DataRuntime runtime, String random, ACTION.DDL action, Run run) {
        if (null == run) {
            return false;
        }
        boolean result = false;
        String sql = run.getFinalUpdate();
        if (BasicUtil.isNotEmpty((Object)sql)) {
            Long fr = System.currentTimeMillis();
            runtime.getAdapter().update(runtime, random, null, null, run);
            result = true;
        }
        return result;
    }

    public boolean execute(DataRuntime runtime, String random, ACTION.DDL action, List<Run> runs) {
        boolean result = true;
        int idx = 0;
        for (Run run : runs) {
            result = this.execute(runtime, random + "[index:" + idx++ + "]", action, run) && result;
        }
        return result;
    }

    public void checkSchema(DataRuntime runtime, Table table) {
        if (null != table) {
            DriverAdapter adapter = runtime.getAdapter();
            adapter.checkSchema(runtime, table);
        }
    }

    public void checkSchema(DataRuntime runtime, Column column) {
        Table table = column.getTable(true);
        if (null != table) {
            this.checkSchema(runtime, table);
            column.setCatalog(table.getCatalog());
            column.setSchema(table.getSchema());
        }
    }

    public void checkSchema(DataRuntime runtime, Index index) {
        Table table = index.getTable(true);
        if (null != table) {
            this.checkSchema(runtime, table);
            index.setCatalog(table.getCatalog());
            index.setSchema(table.getSchema());
        }
    }

    public void checkSchema(DataRuntime runtime, Constraint constraint) {
        Table table = constraint.getTable(true);
        if (null != table) {
            this.checkSchema(runtime, table);
            constraint.setCatalog(table.getCatalog());
            constraint.setSchema(table.getSchema());
        }
    }

    public void checkSchema(DataRuntime runtime, Trigger trigger) {
        Table table = trigger.getTable(true);
        if (null != table) {
            this.checkSchema(runtime, table);
        }
    }

    public void checkSchema(DataRuntime runtime, Procedure procedure) {
        Table table = new Table(procedure.getCatalog(), procedure.getSchema());
        this.checkSchema(runtime, table);
        procedure.setCatalog(table.getCatalog());
        procedure.setSchema(table.getSchema());
    }

    public void checkSchema(DataRuntime runtime, Function function) {
        Table table = new Table(function.getCatalog(), function.getSchema());
        this.checkSchema(runtime, table);
        function.setCatalog(table.getCatalog());
        function.setSchema(table.getSchema());
    }

    private String random(DataRuntime runtime) {
        StringBuilder builder = new StringBuilder();
        builder.append("[SQL:").append(System.currentTimeMillis()).append("-").append(BasicUtil.getRandomNumberString((int)8)).append("][thread:").append(Thread.currentThread().getId()).append("][ds:").append(runtime.datasource()).append("]");
        return builder.toString();
    }

    static {
        isBatchInsertRun = false;
    }
}

