/*
 * Decompiled with CFR 0.152.
 */
package org.amqphub.spring.boot.jms.autoconfigure;

import java.time.Duration;
import java.util.List;
import org.springframework.boot.autoconfigure.jms.JmsPoolConnectionFactoryProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@ConfigurationProperties(prefix="amqphub.amqp10jms")
public class AMQP10JMSProperties {
    private String remoteUrl = "amqp://localhost:5672";
    private String username;
    private String password;
    private String clientId;
    private boolean receiveLocalOnly = false;
    private boolean receiveNoWaitLocalOnly = false;
    @NestedConfigurationProperty
    private final DeserializationPolicy deserializationPolicy = new DeserializationPolicy();
    @NestedConfigurationProperty
    private Pool pool = new Pool();

    public String getRemoteUrl() {
        return this.remoteUrl;
    }

    public void setRemoteUrl(String remoteUrl) {
        this.remoteUrl = remoteUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public boolean isReceiveLocalOnly() {
        return this.receiveLocalOnly;
    }

    public void setReceiveLocalOnly(boolean receiveLocalOnly) {
        this.receiveLocalOnly = receiveLocalOnly;
    }

    public boolean isReceiveNoWaitLocalOnly() {
        return this.receiveNoWaitLocalOnly;
    }

    public void setReceiveNoWaitLocalOnly(boolean receiveNoWaitLocalOnly) {
        this.receiveNoWaitLocalOnly = receiveNoWaitLocalOnly;
    }

    public DeserializationPolicy getDeserializationPolicy() {
        return this.deserializationPolicy;
    }

    public Pool getPool() {
        return this.pool;
    }

    public static class DeserializationPolicy {
        private List<String> allowList;
        private List<String> denyList;

        public List<String> getAllowList() {
            return this.allowList;
        }

        public void setAllowList(List<String> allowList) {
            this.allowList = allowList;
        }

        @Deprecated
        public void setWhiteList(List<String> allowList) {
            this.allowList = allowList;
        }

        public List<String> getDenyList() {
            return this.denyList;
        }

        public void setDenyList(List<String> denyList) {
            this.denyList = denyList;
        }

        @Deprecated
        public void setBlackList(List<String> denyList) {
            this.denyList = denyList;
        }
    }

    public static class Pool
    extends JmsPoolConnectionFactoryProperties {
        private int explicitProducerCacheSize = 0;
        private boolean useProviderJMSContext = false;

        public boolean isBlockIfSessionPoolIsFull() {
            return this.isBlockIfFull();
        }

        public void setBlockIfSessionPoolIsFull(boolean blockIfSessionPoolIsFull) {
            this.setBlockIfFull(blockIfSessionPoolIsFull);
        }

        public Duration getBlockIfSessionPoolIsFullTimeout() {
            return this.getBlockIfFullTimeout();
        }

        public void setBlockIfSessionPoolIsFullTimeout(long blockIfSessionPoolIsFullTimeout) {
            this.setBlockIfFullTimeout(Duration.ofMillis(blockIfSessionPoolIsFullTimeout));
        }

        public void setBlockIfSessionPoolIsFullTimeout(Duration blockIfSessionPoolIsFullTimeout) {
            this.setBlockIfFullTimeout(blockIfSessionPoolIsFullTimeout);
        }

        public Duration getConnectionIdleTimeout() {
            return this.getIdleTimeout();
        }

        public void setConnectionIdleTimeout(long connectionIdleTimeout) {
            this.setIdleTimeout(Duration.ofMillis(connectionIdleTimeout));
        }

        public void setConnectionIdleTimeout(Duration connectionIdleTimeout) {
            this.setIdleTimeout(connectionIdleTimeout);
        }

        public Duration getConnectionCheckInterval() {
            return this.getTimeBetweenExpirationCheck();
        }

        public void setConnectionCheckInterval(long connectionCheckInterval) {
            this.setTimeBetweenExpirationCheck(Duration.ofMillis(connectionCheckInterval));
        }

        public void setConnectionCheckInterval(Duration connectionCheckInterval) {
            this.setTimeBetweenExpirationCheck(connectionCheckInterval);
        }

        public boolean isUseProviderJMSContext() {
            return this.useProviderJMSContext;
        }

        public void setUseProviderJMSContext(boolean useProviderJMSContext) {
            this.useProviderJMSContext = useProviderJMSContext;
        }

        public int getExplicitProducerCacheSize() {
            return this.explicitProducerCacheSize;
        }

        public void setExplicitProducerCacheSize(int explicitProducerCacheSize) {
            this.explicitProducerCacheSize = explicitProducerCacheSize;
        }
    }
}

