/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.rest.service.api.repository;

import javax.servlet.http.HttpServletResponse;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.rest.service.api.repository.BaseDeploymentResourceDataResource;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ProcessDefinitionResourceDataResource
extends BaseDeploymentResourceDataResource {
    @RequestMapping(value={"/repository/process-definitions/{processDefinitionId}/resourcedata"}, method={RequestMethod.GET})
    @ResponseBody
    public byte[] getProcessDefinitionResource(@PathVariable String processDefinitionId, HttpServletResponse response) {
        ProcessDefinition processDefinition = this.getProcessDefinitionFromRequest(processDefinitionId);
        return this.getDeploymentResourceData(processDefinition.getDeploymentId(), processDefinition.getResourceName(), response);
    }

    protected ProcessDefinition getProcessDefinitionFromRequest(String processDefinitionId) {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(processDefinitionId).singleResult();
        if (processDefinition == null) {
            throw new ActivitiObjectNotFoundException("Could not find a process definition with id '" + processDefinitionId + "'.", ProcessDefinition.class);
        }
        return processDefinition;
    }
}

