/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.editor.language.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.UserTask;
import org.activiti.editor.language.json.converter.BaseBpmnJsonConverter;
import org.apache.commons.lang3.StringUtils;

public class UserTaskJsonConverter
extends BaseBpmnJsonConverter {
    public static void fillTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        UserTaskJsonConverter.fillJsonTypes(convertersToBpmnMap);
        UserTaskJsonConverter.fillBpmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("UserTask", UserTaskJsonConverter.class);
    }

    public static void fillBpmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(UserTask.class, UserTaskJsonConverter.class);
    }

    @Override
    protected String getStencilId(FlowElement flowElement) {
        return "UserTask";
    }

    @Override
    protected void convertElementToJson(ObjectNode propertiesNode, FlowElement flowElement) {
        ArrayNode itemsNode;
        UserTask userTask = (UserTask)flowElement;
        String owner = userTask.getOwner();
        String assignee = userTask.getAssignee();
        String candidateUsers = this.convertListToCommaSeparatedString(userTask.getCandidateUsers());
        String candidateGroups = this.convertListToCommaSeparatedString(userTask.getCandidateGroups());
        if (StringUtils.isNotEmpty((CharSequence)owner) || StringUtils.isNotEmpty((CharSequence)assignee) || StringUtils.isNotEmpty((CharSequence)candidateUsers) || StringUtils.isNotEmpty((CharSequence)candidateGroups)) {
            ObjectNode assignmentItemNode;
            ObjectNode assignmentNode = this.objectMapper.createObjectNode();
            itemsNode = this.objectMapper.createArrayNode();
            if (StringUtils.isNotEmpty((CharSequence)owner)) {
                assignmentItemNode = this.objectMapper.createObjectNode();
                assignmentItemNode.put("assignment_type", "owner");
                assignmentItemNode.put("resourceassignmentexpr", owner);
                itemsNode.add((JsonNode)assignmentItemNode);
            }
            if (StringUtils.isNotEmpty((CharSequence)assignee)) {
                assignmentItemNode = this.objectMapper.createObjectNode();
                assignmentItemNode.put("assignment_type", "assignee");
                assignmentItemNode.put("resourceassignmentexpr", assignee);
                itemsNode.add((JsonNode)assignmentItemNode);
            }
            if (StringUtils.isNotEmpty((CharSequence)candidateUsers)) {
                assignmentItemNode = this.objectMapper.createObjectNode();
                assignmentItemNode.put("assignment_type", "candidateUsers");
                assignmentItemNode.put("resourceassignmentexpr", candidateUsers);
                itemsNode.add((JsonNode)assignmentItemNode);
            }
            if (StringUtils.isNotEmpty((CharSequence)candidateGroups)) {
                assignmentItemNode = this.objectMapper.createObjectNode();
                assignmentItemNode.put("assignment_type", "candidateGroups");
                assignmentItemNode.put("resourceassignmentexpr", candidateGroups);
                itemsNode.add((JsonNode)assignmentItemNode);
            }
            assignmentNode.put("totalCount", itemsNode.size());
            assignmentNode.put("items", (JsonNode)itemsNode);
            propertiesNode.put("usertaskassignment", (JsonNode)assignmentNode);
        }
        if (!userTask.getCustomUserIdentityLinks().isEmpty() || !userTask.getCustomGroupIdentityLinks().isEmpty()) {
            ObjectNode identityItemNode;
            ObjectNode customIdentityLinksNode = this.objectMapper.createObjectNode();
            itemsNode = this.objectMapper.createArrayNode();
            for (String linkType : userTask.getCustomUserIdentityLinks().keySet()) {
                identityItemNode = this.objectMapper.createObjectNode();
                identityItemNode.put("identity_type", "user");
                identityItemNode.put("identity_link_type", linkType);
                String users = this.convertListToCommaSeparatedString(new ArrayList<String>((Collection)userTask.getCustomUserIdentityLinks().get(linkType)));
                identityItemNode.put("identitylinkexpr", users);
                itemsNode.add((JsonNode)identityItemNode);
            }
            for (String linkType : userTask.getCustomGroupIdentityLinks().keySet()) {
                identityItemNode = this.objectMapper.createObjectNode();
                identityItemNode.put("identity_type", "group");
                identityItemNode.put("identity_link_type", linkType);
                String groups = this.convertListToCommaSeparatedString(new ArrayList<String>((Collection)userTask.getCustomGroupIdentityLinks().get(linkType)));
                identityItemNode.put("identitylinkexpr", groups);
                itemsNode.add((JsonNode)identityItemNode);
            }
            customIdentityLinksNode.put("totalCount", itemsNode.size());
            customIdentityLinksNode.put("items", (JsonNode)itemsNode);
            propertiesNode.put("customidentitylinks", (JsonNode)customIdentityLinksNode);
        }
        if (userTask.getPriority() != null) {
            this.setPropertyValue("prioritydefinition", userTask.getPriority().toString(), propertiesNode);
        }
        this.setPropertyValue("formkeydefinition", userTask.getFormKey(), propertiesNode);
        this.setPropertyValue("duedatedefinition", userTask.getDueDate(), propertiesNode);
        this.setPropertyValue("categoryDefinition", userTask.getCategory(), propertiesNode);
        this.addFormProperties(userTask.getFormProperties(), propertiesNode);
    }

    @Override
    protected FlowElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, Map<String, JsonNode> shapeMap) {
        JsonNode itemsNode;
        JsonNode customIdentityLinksNode;
        JsonNode itemsNode2;
        UserTask task = new UserTask();
        task.setPriority(this.getPropertyValueAsString("prioritydefinition", elementNode));
        task.setFormKey(this.getPropertyValueAsString("formkeydefinition", elementNode));
        task.setDueDate(this.getPropertyValueAsString("duedatedefinition", elementNode));
        task.setCategory(this.getPropertyValueAsString("categoryDefinition", elementNode));
        JsonNode assignmentNode = this.getProperty("usertaskassignment", elementNode);
        if (assignmentNode != null && (itemsNode2 = assignmentNode.get("items")) != null) {
            Iterator assignmentIterator = itemsNode2.elements();
            while (assignmentIterator.hasNext()) {
                JsonNode assignmentItemNode = (JsonNode)assignmentIterator.next();
                if (assignmentItemNode.get("assignment_type") == null || assignmentItemNode.get("resourceassignmentexpr") == null) continue;
                String assignmentType = assignmentItemNode.get("assignment_type").asText();
                if ("assignee".equals(assignmentType)) {
                    task.setAssignee(assignmentItemNode.get("resourceassignmentexpr").asText());
                    continue;
                }
                if ("owner".equals(assignmentType)) {
                    task.setOwner(assignmentItemNode.get("resourceassignmentexpr").asText());
                    continue;
                }
                if ("candidateUsers".equals(assignmentType)) {
                    task.setCandidateUsers(this.getValueAsList("resourceassignmentexpr", assignmentItemNode));
                    continue;
                }
                if (!"candidateGroups".equals(assignmentType)) continue;
                task.setCandidateGroups(this.getValueAsList("resourceassignmentexpr", assignmentItemNode));
            }
        }
        if ((customIdentityLinksNode = this.getProperty("customidentitylinks", elementNode)) != null && (itemsNode = customIdentityLinksNode.get("items")) != null) {
            Iterator customIdentityLinksIterator = itemsNode.elements();
            while (customIdentityLinksIterator.hasNext()) {
                JsonNode customIdentityLinksItemNode = (JsonNode)customIdentityLinksIterator.next();
                if (customIdentityLinksItemNode.get("identity_type") == null || customIdentityLinksItemNode.get("identity_link_type") == null || customIdentityLinksItemNode.get("identitylinkexpr") == null) continue;
                String identityType = customIdentityLinksItemNode.get("identity_type").asText();
                String identityLinkType = customIdentityLinksItemNode.get("identity_link_type").asText();
                List<String> identitiesList = this.getValueAsList("identitylinkexpr", customIdentityLinksItemNode);
                if ("user".equals(identityType)) {
                    HashSet<String> users = (HashSet<String>)task.getCustomUserIdentityLinks().get(identityLinkType);
                    if (users == null) {
                        users = new HashSet<String>();
                        task.getCustomUserIdentityLinks().put(identityLinkType, users);
                    }
                    users.addAll(identitiesList);
                    continue;
                }
                if (!"group".equals(identityType)) continue;
                HashSet<String> groups = (HashSet<String>)task.getCustomGroupIdentityLinks().get(identityLinkType);
                if (groups == null) {
                    groups = new HashSet<String>();
                    task.getCustomGroupIdentityLinks().put(identityLinkType, groups);
                }
                groups.addAll(identitiesList);
            }
        }
        this.convertJsonToFormProperties(elementNode, (BaseElement)task);
        return task;
    }
}

