/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.editor.language.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.GraphicInfo;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.editor.language.json.converter.ActivityProcessor;
import org.activiti.editor.language.json.converter.BaseBpmnJsonConverter;
import org.activiti.editor.language.json.converter.BpmnJsonConverterUtil;
import org.apache.commons.lang3.StringUtils;

public class SequenceFlowJsonConverter
extends BaseBpmnJsonConverter {
    public static void fillTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        SequenceFlowJsonConverter.fillJsonTypes(convertersToBpmnMap);
        SequenceFlowJsonConverter.fillBpmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("SequenceFlow", SequenceFlowJsonConverter.class);
    }

    public static void fillBpmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(SequenceFlow.class, SequenceFlowJsonConverter.class);
    }

    @Override
    protected String getStencilId(FlowElement flowElement) {
        return "SequenceFlow";
    }

    @Override
    public void convertToJson(FlowElement flowElement, ActivityProcessor processor, BpmnModel model, ArrayNode shapesArrayNode, double subProcessX, double subProcessY) {
        SequenceFlow sequenceFlow = (SequenceFlow)flowElement;
        ObjectNode flowNode = BpmnJsonConverterUtil.createChildShape(sequenceFlow.getId(), "SequenceFlow", 172.0, 212.0, 128.0, 212.0);
        ArrayNode dockersArrayNode = this.objectMapper.createArrayNode();
        ObjectNode dockNode = this.objectMapper.createObjectNode();
        dockNode.put("x", model.getGraphicInfo(sequenceFlow.getSourceRef()).getWidth() / 2.0);
        dockNode.put("y", model.getGraphicInfo(sequenceFlow.getSourceRef()).getHeight() / 2.0);
        dockersArrayNode.add((JsonNode)dockNode);
        if (model.getFlowLocationGraphicInfo(sequenceFlow.getId()).size() > 2) {
            for (int i = 1; i < model.getFlowLocationGraphicInfo(sequenceFlow.getId()).size() - 1; ++i) {
                GraphicInfo graphicInfo = (GraphicInfo)model.getFlowLocationGraphicInfo(sequenceFlow.getId()).get(i);
                dockNode = this.objectMapper.createObjectNode();
                dockNode.put("x", graphicInfo.getX());
                dockNode.put("y", graphicInfo.getY());
                dockersArrayNode.add((JsonNode)dockNode);
            }
        }
        dockNode = this.objectMapper.createObjectNode();
        dockNode.put("x", model.getGraphicInfo(sequenceFlow.getTargetRef()).getWidth() / 2.0);
        dockNode.put("y", model.getGraphicInfo(sequenceFlow.getTargetRef()).getHeight() / 2.0);
        dockersArrayNode.add((JsonNode)dockNode);
        flowNode.put("dockers", (JsonNode)dockersArrayNode);
        ArrayNode outgoingArrayNode = this.objectMapper.createArrayNode();
        outgoingArrayNode.add((JsonNode)BpmnJsonConverterUtil.createResourceNode(sequenceFlow.getTargetRef()));
        flowNode.put("outgoing", (JsonNode)outgoingArrayNode);
        flowNode.put("target", (JsonNode)BpmnJsonConverterUtil.createResourceNode(sequenceFlow.getTargetRef()));
        ObjectNode propertiesNode = this.objectMapper.createObjectNode();
        propertiesNode.put("overrideid", flowElement.getId());
        if (StringUtils.isNotEmpty((CharSequence)sequenceFlow.getName())) {
            propertiesNode.put("name", sequenceFlow.getName());
        }
        if (StringUtils.isNotEmpty((CharSequence)sequenceFlow.getDocumentation())) {
            propertiesNode.put("documentation", sequenceFlow.getDocumentation());
        }
        if (StringUtils.isNotEmpty((CharSequence)sequenceFlow.getConditionExpression())) {
            propertiesNode.put("conditionsequenceflow", sequenceFlow.getConditionExpression());
        }
        flowNode.put("properties", (JsonNode)propertiesNode);
        shapesArrayNode.add((JsonNode)flowNode);
    }

    @Override
    protected void convertElementToJson(ObjectNode propertiesNode, FlowElement flowElement) {
    }

    @Override
    protected FlowElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, Map<String, JsonNode> shapeMap) {
        SequenceFlow flow = new SequenceFlow();
        String sourceRef = this.lookForSourceRef(elementNode.get("resourceId").asText(), modelNode.get("childShapes"));
        if (sourceRef != null) {
            flow.setSourceRef(sourceRef);
            String targetId = elementNode.get("target").get("resourceId").asText();
            flow.setTargetRef(BpmnJsonConverterUtil.getElementId(shapeMap.get(targetId)));
        }
        flow.setConditionExpression(this.getPropertyValueAsString("conditionsequenceflow", elementNode));
        return flow;
    }

    private String lookForSourceRef(String flowId, JsonNode childShapesNode) {
        String sourceRef = null;
        if (childShapesNode != null) {
            for (JsonNode childNode : childShapesNode) {
                ArrayNode outgoingNode = (ArrayNode)childNode.get("outgoing");
                if (outgoingNode != null && outgoingNode.size() > 0) {
                    for (JsonNode outgoingChildNode : outgoingNode) {
                        JsonNode resourceNode = outgoingChildNode.get("resourceId");
                        if (resourceNode == null || !flowId.equals(resourceNode.asText())) continue;
                        sourceRef = BpmnJsonConverterUtil.getElementId(childNode);
                        break;
                    }
                    if (sourceRef != null) break;
                }
                if ((sourceRef = this.lookForSourceRef(flowId, childNode.get("childShapes"))) == null) continue;
                break;
            }
        }
        return sourceRef;
    }
}

