/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.process.simple.editor;

import com.vaadin.Application;
import com.vaadin.data.Property;
import com.vaadin.terminal.Resource;
import com.vaadin.terminal.StreamResource;
import com.vaadin.ui.AbstractSelect;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.ComponentContainer;
import com.vaadin.ui.Embedded;
import com.vaadin.ui.GridLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Panel;
import com.vaadin.ui.TextField;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import java.util.UUID;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.impl.ProcessEngineImpl;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.repository.Model;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.ui.AbstractPage;
import org.activiti.explorer.ui.custom.DetailPanel;
import org.activiti.explorer.ui.custom.ToolBar;
import org.activiti.explorer.ui.custom.ToolbarEntry;
import org.activiti.explorer.ui.process.simple.editor.table.TaskTable;
import org.activiti.image.ProcessDiagramGenerator;
import org.activiti.workflow.simple.converter.WorkflowDefinitionConversion;
import org.activiti.workflow.simple.definition.HumanStepDefinition;
import org.activiti.workflow.simple.definition.ListStepDefinition;
import org.activiti.workflow.simple.definition.ParallelStepsDefinition;
import org.activiti.workflow.simple.definition.StepDefinition;
import org.activiti.workflow.simple.definition.StepDefinitionContainer;
import org.activiti.workflow.simple.definition.WorkflowDefinition;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleTableEditor
extends AbstractPage {
    private static final long serialVersionUID = -4430424035744622992L;
    private static final Logger logger = LoggerFactory.getLogger(SimpleTableEditor.class);
    private static final String KEY_EDITOR = "editor";
    private static final String KEY_PREVIEW = "preview";
    protected String workflowName;
    protected String description;
    protected String modelId;
    protected WorkflowDefinition workflowDefinition;
    protected DetailPanel mainLayout;
    protected GridLayout editorGrid;
    protected TextField nameField;
    protected TextField descriptionField;
    protected TaskTable taskTable;
    protected Panel imagePanel;

    public SimpleTableEditor(String workflowName, String description) {
        this.workflowName = workflowName;
        this.description = description;
    }

    public SimpleTableEditor(String modelId, WorkflowDefinition workflowDefinition) {
        this(workflowDefinition.getName(), workflowDefinition.getDescription());
        this.modelId = modelId;
        this.workflowDefinition = workflowDefinition;
    }

    @Override
    protected void initUi() {
        super.initUi();
        this.setSizeFull();
        this.grid.setColumnExpandRatio(0, 0.0f);
        this.mainLayout = new DetailPanel();
        this.setDetailComponent((Component)this.mainLayout);
        this.editorGrid = new GridLayout(2, 7);
        this.editorGrid.setSizeFull();
        this.editorGrid.setMargin(true);
        this.editorGrid.setColumnExpandRatio(0, 1.0f);
        this.editorGrid.setColumnExpandRatio(1, 9.0f);
        this.editorGrid.setSpacing(true);
        this.mainLayout.addComponent((Component)this.editorGrid);
        this.initNameField(this.editorGrid);
        this.initDescriptionField(this.editorGrid);
        this.initTaskTable(this.editorGrid);
        this.initButtons(this.editorGrid);
        this.toolBar.setActiveEntry(KEY_EDITOR);
    }

    protected ToolBar initToolbar() {
        this.toolBar = new ToolBar();
        this.toolBar.addToolbarEntry(KEY_EDITOR, ExplorerApp.get().getI18nManager().getMessage("process.editor.title"), new ToolbarEntry.ToolbarCommand(){

            @Override
            public void toolBarItemSelected() {
                if (SimpleTableEditor.this.imagePanel != null) {
                    SimpleTableEditor.this.imagePanel.setVisible(false);
                    SimpleTableEditor.this.editorGrid.setVisible(true);
                    SimpleTableEditor.this.toolBar.setActiveEntry(SimpleTableEditor.KEY_EDITOR);
                }
            }
        });
        this.toolBar.addToolbarEntry(KEY_PREVIEW, ExplorerApp.get().getI18nManager().getMessage("process.editor.bpmn.preview"), new ToolbarEntry.ToolbarCommand(){

            @Override
            public void toolBarItemSelected() {
                SimpleTableEditor.this.editorGrid.setVisible(false);
                SimpleTableEditor.this.showDiagram();
                SimpleTableEditor.this.toolBar.setActiveEntry(SimpleTableEditor.KEY_PREVIEW);
            }
        });
        return this.toolBar;
    }

    protected void initNameField(GridLayout layout) {
        this.nameField = new TextField();
        this.nameField.setWriteThrough(true);
        this.nameField.setImmediate(true);
        layout.addComponent((Component)new Label(ExplorerApp.get().getI18nManager().getMessage("process.editor.name")));
        layout.addComponent((Component)this.nameField);
        if (this.workflowName != null) {
            this.nameField.setValue((Object)this.workflowName);
            this.workflowName = null;
        }
    }

    protected void initDescriptionField(GridLayout layout) {
        this.descriptionField = new TextField();
        this.descriptionField.setRows(4);
        this.descriptionField.setColumns(35);
        this.descriptionField.addStyleName("noResizeTextArea");
        layout.addComponent((Component)new Label(ExplorerApp.get().getI18nManager().getMessage("process.editor.description")));
        layout.addComponent((Component)this.descriptionField);
        if (this.description != null) {
            this.descriptionField.setValue((Object)this.description);
            this.description = null;
        }
    }

    protected void initTaskTable(GridLayout layout) {
        this.taskTable = new TaskTable();
        if (this.workflowDefinition != null) {
            this.loadTaskRows((StepDefinitionContainer<?>)this.workflowDefinition, this.taskTable);
        } else {
            this.taskTable.addDefaultTaskRow();
        }
        layout.addComponent((Component)new Label(ExplorerApp.get().getI18nManager().getMessage("process.editor.tasks")));
        layout.addComponent((Component)this.taskTable);
    }

    protected void loadTaskRows(StepDefinitionContainer<?> container, TaskTable taskTable) {
        for (StepDefinition stepDefinition : container.getSteps()) {
            if (stepDefinition instanceof HumanStepDefinition) {
                HumanStepDefinition humanStepDefinition = (HumanStepDefinition)stepDefinition;
                taskTable.addTaskRow(humanStepDefinition);
                continue;
            }
            if (!(stepDefinition instanceof StepDefinitionContainer)) continue;
            this.loadTaskRows((StepDefinitionContainer)stepDefinition, taskTable);
        }
    }

    protected void initButtons(GridLayout layout) {
        final Button saveButton = new Button(ExplorerApp.get().getI18nManager().getMessage("process.editor.save"));
        saveButton.setEnabled(this.nameField.getValue() != null && !"".equals((String)this.nameField.getValue()));
        this.toolBar.addButton(saveButton);
        saveButton.addListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                SimpleTableEditor.this.save();
            }
        });
        this.nameField.addListener(new Property.ValueChangeListener(){
            private static final long serialVersionUID = 1L;

            public void valueChange(Property.ValueChangeEvent event) {
                if (SimpleTableEditor.this.nameField.getValue() != null && !"".equals((String)SimpleTableEditor.this.nameField.getValue())) {
                    saveButton.setEnabled(true);
                } else {
                    saveButton.setEnabled(false);
                }
            }
        });
    }

    public TextField getNameTextField() {
        return this.nameField;
    }

    protected void showDiagram() {
        StreamResource.StreamSource streamSource = new StreamResource.StreamSource(){
            private static final long serialVersionUID = 6993112534181068935L;

            public InputStream getStream() {
                WorkflowDefinitionConversion workflowDefinitionConversion = ExplorerApp.get().getWorkflowDefinitionConversionFactory().createWorkflowDefinitionConversion(SimpleTableEditor.this.createWorkflow());
                ProcessEngineImpl defaultProcessEngine = (ProcessEngineImpl)ProcessEngines.getDefaultProcessEngine();
                ProcessEngineConfigurationImpl processEngineConfiguration = defaultProcessEngine.getProcessEngineConfiguration();
                ProcessDiagramGenerator diagramGenerator = processEngineConfiguration.getProcessDiagramGenerator();
                return diagramGenerator.generateDiagram(workflowDefinitionConversion.getBpmnModel(), "png", processEngineConfiguration.getActivityFontName(), processEngineConfiguration.getLabelFontName(), processEngineConfiguration.getClassLoader());
            }
        };
        StreamResource imageresource = new StreamResource(streamSource, UUID.randomUUID() + ".png", (Application)ExplorerApp.get());
        Embedded diagram = new Embedded("", (Resource)imageresource);
        diagram.setType(1);
        diagram.setSizeUndefined();
        this.imagePanel = new Panel();
        this.imagePanel.setScrollable(true);
        this.imagePanel.addStyleName("light");
        this.imagePanel.setWidth(100.0f, 8);
        this.imagePanel.setHeight("100%");
        this.mainLayout.addComponent((Component)this.imagePanel);
        HorizontalLayout panelLayout = new HorizontalLayout();
        panelLayout.setSizeUndefined();
        this.imagePanel.setContent((ComponentContainer)panelLayout);
        this.imagePanel.addComponent((Component)diagram);
    }

    protected void save() {
        WorkflowDefinition workflowDefinition = this.createWorkflow();
        ProcessEngineImpl defaultProcessEngine = (ProcessEngineImpl)ProcessEngines.getDefaultProcessEngine();
        RepositoryService repositoryService = defaultProcessEngine.getRepositoryService();
        ProcessEngineConfigurationImpl processEngineConfiguration = defaultProcessEngine.getProcessEngineConfiguration();
        ProcessDiagramGenerator diagramGenerator = processEngineConfiguration.getProcessDiagramGenerator();
        Model model = null;
        model = this.modelId == null ? repositoryService.newModel() : repositoryService.getModel(this.modelId);
        model.setName(workflowDefinition.getName());
        model.setCategory("table-editor");
        repositoryService.saveModel(model);
        WorkflowDefinitionConversion conversion = ExplorerApp.get().getWorkflowDefinitionConversionFactory().createWorkflowDefinitionConversion(workflowDefinition);
        conversion.convert();
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ExplorerApp.get().getSimpleWorkflowJsonConverter().writeWorkflowDefinition(workflowDefinition, (Writer)new OutputStreamWriter(baos));
            repositoryService.addModelEditorSource(model.getId(), baos.toByteArray());
            repositoryService.addModelEditorSourceExtra(model.getId(), IOUtils.toByteArray((InputStream)diagramGenerator.generateDiagram(conversion.getBpmnModel(), "png", processEngineConfiguration.getActivityFontName(), processEngineConfiguration.getLabelFontName(), processEngineConfiguration.getClassLoader())));
        }
        catch (IOException e) {
            logger.warn("Could not generate process image. Image is not stored and will not be shown.", (Throwable)e);
        }
        ExplorerApp.get().getViewManager().showEditorProcessDefinitionPage(model.getId());
    }

    protected WorkflowDefinition createWorkflow() {
        WorkflowDefinition workflow = new WorkflowDefinition();
        workflow.setName((String)this.nameField.getValue());
        String description = (String)this.descriptionField.getValue();
        if (description != null && description.length() > 0) {
            workflow.setDescription(description);
        }
        List<HumanStepDefinition> steps = this.taskTable.getSteps();
        for (int i = 0; i < steps.size(); ++i) {
            int nextIndex;
            HumanStepDefinition currentStep = steps.get(i);
            ParallelStepsDefinition parallelStepsDefinition = null;
            for (nextIndex = i + 1; nextIndex < steps.size() && steps.get(nextIndex).isStartsWithPrevious(); ++nextIndex) {
                ListStepDefinition listStepDef;
                if (parallelStepsDefinition == null) {
                    parallelStepsDefinition = new ParallelStepsDefinition();
                    listStepDef = new ListStepDefinition();
                    listStepDef.addStep((StepDefinition)currentStep);
                    parallelStepsDefinition.addStepList(listStepDef);
                }
                listStepDef = new ListStepDefinition();
                listStepDef.addStep((StepDefinition)steps.get(nextIndex));
                parallelStepsDefinition.addStepList(listStepDef);
            }
            if (parallelStepsDefinition != null) {
                workflow.addStep(parallelStepsDefinition);
                i = nextIndex - 1;
                continue;
            }
            workflow.addStep((StepDefinition)currentStep);
        }
        return workflow;
    }

    @Override
    protected ToolBar createMenuBar() {
        return this.initToolbar();
    }

    @Override
    protected AbstractSelect createSelectComponent() {
        return null;
    }

    @Override
    public void refreshSelectNext() {
    }

    @Override
    public void selectElement(int index) {
    }
}

