/*
 * Decompiled with CFR 0.152.
 */
package act.db.sql.tx;

import act.db.sql.tx.TxInfo;
import org.osgl.util.E;

public class TxContext {
    private static final ThreadLocal<TxInfo> info_ = new ThreadLocal();

    public static boolean readOnly() {
        TxInfo info = info_.get();
        E.illegalStateIf((null == info ? 1 : 0) != 0);
        return info.readOnly;
    }

    public static boolean readOnly(boolean defaultReadOnly) {
        TxInfo info = info_.get();
        return null == info ? defaultReadOnly : info.readOnly;
    }

    public static boolean withinTxScope() {
        TxInfo info = info_.get();
        return null != info && info.withinTxScope;
    }

    public static TxInfo enterTxScope(boolean readonly) {
        TxInfo info = info_.get();
        if (null == info) {
            info = new TxInfo(readonly);
            info_.set(info);
        } else {
            info.readOnly = readonly;
        }
        info.enterTxScope();
        return info;
    }

    public static void exitTxScope() {
        TxInfo info = info_.get();
        E.illegalStateIf((null == info || !info.withinTxScope ? 1 : 0) != 0, (String)"Not in a TX scope");
        info.exitTxScope();
    }

    public static void exitTxScope(Throwable cause) {
        TxInfo info = info_.get();
        E.illegalStateIf((null == info || !info.withinTxScope ? 1 : 0) != 0, (String)"Not in a TX scope");
        info.exitTxScope(cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        TxInfo info = info_.get();
        if (null == info) {
            return;
        }
        try {
            if (info.withinTxScope) {
                info.exitTxScope();
            }
        }
        finally {
            info_.remove();
        }
    }

    public static void reset() {
        info_.remove();
    }

    public static TxInfo info() {
        return info_.get();
    }
}

