/*
 * Decompiled with CFR 0.152.
 */
package act.db.sql.datasource;

import act.app.DbServiceManager;
import act.app.event.SysEventId;
import act.db.DbService;
import act.db.sql.DataSourceConfig;
import act.db.sql.DataSourceProvider;
import act.db.sql.SqlDbService;
import act.db.sql.monitor.DataSourceStatus;
import java.util.Map;
import javax.sql.DataSource;
import org.osgl.$;
import org.osgl.util.E;
import org.osgl.util.S;

public class SharedDataSourceProvider
extends DataSourceProvider {
    public DataSource ds;
    public DataSourceConfig dsConf;
    public DataSourceProvider realProvider;
    private boolean initialized;

    public SharedDataSourceProvider(final String dbId, DbServiceManager dbm) {
        DbService db = dbm.dbService(dbId);
        E.invalidConfigurationIf((null == db ? 1 : 0) != 0, (String)"Cannot find db service: %s", (Object[])new Object[]{dbId});
        E.invalidConfigurationIf((!(db instanceof SqlDbService) ? 1 : 0) != 0, (String)"DB service is not a SQL DB service: %s", (Object[])new Object[]{dbId});
        final SqlDbService sql = (SqlDbService)((Object)$.cast((Object)db));
        String jobId = S.buffer((String)"SharedDataSourceProvider[").append(dbId).append("] - init").toString();
        dbm.app().jobManager().on(SysEventId.DB_SVC_LOADED, jobId, new Runnable(){

            @Override
            public void run() {
                SharedDataSourceProvider.this.ds = sql.dataSource();
                E.illegalStateIf((null == SharedDataSourceProvider.this.ds ? 1 : 0) != 0, (String)"Datasource is not initialized in DB service: %s", (Object[])new Object[]{dbId});
                SharedDataSourceProvider.this.dsConf = sql.dataSourceConfig();
                SharedDataSourceProvider.this.realProvider = sql.dataSourceProvider();
                SharedDataSourceProvider.this.initialized = true;
                if (null != SharedDataSourceProvider.this.initializationCallback) {
                    SharedDataSourceProvider.this.initializationCallback.apply((Object)SharedDataSourceProvider.this);
                }
            }
        }, true);
    }

    @Override
    public DataSource createDataSource(DataSourceConfig conf) {
        return this.ds;
    }

    public DataSourceConfig dataSourceConfig() {
        return this.dsConf;
    }

    @Override
    public Map<String, String> confKeyMapping() {
        throw E.unsupport();
    }

    @Override
    public DataSourceStatus getStatus(DataSource ds) {
        return null != this.realProvider ? this.realProvider.getStatus(ds) : SqlDbService.DUMB_STATUS;
    }

    @Override
    public boolean initialized() {
        return this.initialized;
    }
}

