/*
 * Decompiled with CFR 0.152.
 */
package act.db.sql;

import act.Act;
import act.db.sql.DataSourceConfig;
import act.db.sql.DataSourceProvider;
import act.db.sql.DdlGeneratorConfig;
import act.db.sql.datasource.SharedDataSourceProvider;
import act.db.sql.util.NamingConvention;
import java.util.Map;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.Keyword;
import org.osgl.util.S;

public final class SqlDbServiceConfig {
    public DataSourceConfig dataSourceConfig;
    public DdlGeneratorConfig ddlGeneratorConfig;
    public Map<String, String> rawConf;
    public NamingConvention tableNamingConvention = NamingConvention.Default.MATCHING;
    public NamingConvention fieldNamingConvention = NamingConvention.Default.MATCHING;
    public SharedDataSourceProvider sharedDataSourceProvider;
    private DataSourceProvider loadedDataSourceProvider;
    private static final Map<String, String> aliases = C.Map((Object[])new Object[]{"jdbcDriver", "driver", "jdbcUrl", "url", "databaseDriver", "driver", "databaseUrl", "url", "datasource.provider", "datasource"});
    private static final String DRUID_PROVDER = "act.db.sql.datasource.DruidDataSourceProvider";
    private static final String HIKARI_PROVIDER = "act.db.sql.datasource.HikariDataSourceProvider";

    public SqlDbServiceConfig(String dbId, Map<String, String> conf) {
        this.rawConf = SqlDbServiceConfig.processAliases(conf, aliases);
        this.sharedDataSourceProvider = this.checkSharedDatasource(conf);
        if (null == this.sharedDataSourceProvider) {
            this.dataSourceConfig = new DataSourceConfig(dbId, this.rawConf);
            this.ddlGeneratorConfig = new DdlGeneratorConfig(this.rawConf);
        } else {
            this.dataSourceConfig = this.sharedDataSourceProvider.dataSourceConfig();
        }
        this.loadNamingConvention(this.rawConf);
    }

    public boolean isSharedDatasource() {
        return this.sharedDataSourceProvider != null;
    }

    public boolean createDdl() {
        return this.ddlGeneratorConfig.create;
    }

    public DataSourceProvider dataSourceProvider() {
        DataSourceProvider provider;
        if (null != this.sharedDataSourceProvider) {
            return this.sharedDataSourceProvider;
        }
        if (null != this.loadedDataSourceProvider) {
            return this.loadedDataSourceProvider;
        }
        String dsProvider = this.rawConf.get("datasource");
        if (S.notBlank((String)dsProvider)) {
            String s = dsProvider.toLowerCase();
            if (s.contains("hikari")) {
                dsProvider = HIKARI_PROVIDER;
            } else if (s.contains("druid")) {
                dsProvider = DRUID_PROVDER;
            } else if (Keyword.eq((CharSequence)"built-in", (CharSequence)s)) {
                return DataSourceProvider.NULL_PROVIDER;
            }
        }
        if (S.notBlank((String)dsProvider)) {
            provider = (DataSourceProvider)((Object)Act.getInstance((String)dsProvider));
        } else {
            try {
                Class.forName("com.zaxxer.hikari.HikariConfig");
                provider = (DataSourceProvider)((Object)Act.getInstance((String)HIKARI_PROVIDER));
            }
            catch (Exception e) {
                try {
                    Class.forName("com.alibaba.druid.pool.DruidDataSource");
                    provider = (DataSourceProvider)((Object)Act.getInstance((String)DRUID_PROVDER));
                }
                catch (Exception e1) {
                    return null;
                }
            }
        }
        this.loadedDataSourceProvider = provider;
        return provider;
    }

    private SharedDataSourceProvider checkSharedDatasource(Map<String, String> conf) {
        String s;
        String dsProvider = this.rawConf.get("datasource");
        if (S.notBlank((String)dsProvider) && (s = dsProvider.toLowerCase()).contains("shared:")) {
            String dbId = S.afterFirst((String)s, (String)":");
            E.invalidConfigurationIf((boolean)S.blank((String)dbId), (String)"Invalid datasource provider: %s", (Object[])new Object[]{dsProvider});
            return new SharedDataSourceProvider(dbId, Act.app().dbServiceManager());
        }
        return null;
    }

    private void loadNamingConvention(Map<String, String> conf) {
        String s;
        if (conf.containsKey("naming.convention")) {
            s = conf.get("naming.convention");
            this.fieldNamingConvention = this.tableNamingConvention = this.namingConventionOf(s);
        }
        if (conf.containsKey("naming.table")) {
            s = conf.get("naming.table");
            this.tableNamingConvention = this.namingConventionOf(s);
        }
        if (conf.containsKey("naming.field")) {
            s = conf.get("naming.field");
            this.fieldNamingConvention = this.namingConventionOf(s);
        }
    }

    private NamingConvention namingConventionOf(String s) {
        if (NamingConvention.Default.MATCHING.name().equalsIgnoreCase(s)) {
            return NamingConvention.Default.MATCHING;
        }
        if (NamingConvention.Default.UNDERSCORE.name().equalsIgnoreCase(s)) {
            return NamingConvention.Default.UNDERSCORE;
        }
        return (NamingConvention)Act.getInstance((String)s);
    }

    static Map<String, String> processAliases(Map<String, String> conf, Map<String, String> confMapping) {
        C.Map newConf = C.newMap(conf);
        for (Map.Entry<String, String> entry : confMapping.entrySet()) {
            String alias = entry.getKey();
            String key = entry.getValue();
            if (!newConf.containsKey(alias)) continue;
            newConf.put(key, newConf.get(alias));
        }
        return newConf;
    }
}

