/*
 * Decompiled with CFR 0.152.
 */
package act.db.sql;

import act.app.DbServiceManager;
import act.cli.Command;
import act.cli.Required;
import act.controller.Controller;
import act.db.DbService;
import act.db.sql.SqlDbService;
import act.db.sql.monitor.DataSourceStatus;
import act.util.JsonView;

public class SqlDbAdminConsole {
    @JsonView
    @Command(name="act.db.ds.status", help="report datasource status for specified SQL db service")
    public DataSourceStatus dataSourceStatus(@Required(value="specify the db service") String id, DbServiceManager dsm) {
        DbService dbs = dsm.dbService(id);
        Controller.Util.notFoundIfNull((Object)dbs, (String)"Cannot find db service with id specified: %s", (Object[])new Object[]{id});
        Controller.Util.badRequestIf((!(dbs instanceof SqlDbService) ? 1 : 0) != 0, (String)"Specified db service is not a SqlDbService: %s", (Object[])new Object[]{id});
        return ((SqlDbService)dbs).dataSourceStatus();
    }
}

