/*
 * Decompiled with CFR 0.152.
 */
package act.db.sql;

import act.Act;
import act.data.annotation.Data;
import act.util.SimpleBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgl.$;
import org.osgl.exception.ConfigurationException;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.Keyword;
import org.osgl.util.N;
import org.osgl.util.S;

@Data
public class DataSourceConfig
implements SimpleBean {
    public static final int DEF_MIN_CONN = 2;
    public static final int DEF_MAX_CONN = 10;
    public static final int DEF_INACTIVE_TIME = 600;
    public static final int DEF_MAX_LIFE_TIME = 1800;
    public static final int DEF_CONN_TIMEOUT = 30;
    public String id;
    public String url;
    public String username;
    public String password;
    public String driver;
    public int minConnections;
    public int maxConnections;
    public int isolationLevel = 2;
    public boolean autoCommit;
    public boolean readOnly;
    public int connectionTimeout;
    public Map<String, String> customProperties;
    public List<DataSourceConfig> slaveDataSourceConfigurations = new ArrayList<DataSourceConfig>();
    private static final Map<String, Integer> isolationLevels = C.Map((Object[])new Object[]{"NONE", 0, "READ_UNCOMMITTED", 1, "READ_COMMITTED", 2, "REPEATABLE_READ", 4, "SERIALIZABLE", 8});

    private DataSourceConfig(DataSourceConfig parent, Map<String, String> conf) {
        $.copy((Object)parent).to((Object)this);
        this.init(conf, true);
        this.readOnly = true;
    }

    public DataSourceConfig(String dbId, Map<String, String> conf) {
        this.id = dbId;
        this.init(conf, false);
        HashMap<String, String> soleSlaveConfig = new HashMap<String, String>();
        HashMap<String, HashMap<String, String>> slaves = new HashMap<String, HashMap<String, String>>();
        for (Map.Entry<String, String> entry : conf.entrySet()) {
            String key = entry.getKey();
            String lowercaseKey = key.toLowerCase();
            if (!lowercaseKey.startsWith("readonly.") && !lowercaseKey.startsWith("ro.") && !lowercaseKey.startsWith("slave")) continue;
            String probe = S.cut((Object)(key = S.cut((Object)key).afterFirst("."))).beforeFirst(".");
            if (probe.length() == 1) {
                key = S.cut((Object)key).afterFirst(".");
                HashMap<String, String> slaveConfig = (HashMap<String, String>)slaves.get(probe);
                if (null == slaveConfig) {
                    slaveConfig = new HashMap<String, String>();
                    slaves.put(probe, slaveConfig);
                }
                slaveConfig.put(key, entry.getValue());
                continue;
            }
            soleSlaveConfig.put(key, entry.getValue());
        }
        if (!soleSlaveConfig.isEmpty()) {
            this.slaveDataSourceConfigurations.add(new DataSourceConfig(this, soleSlaveConfig));
        }
        for (Map otherSlaveConf : slaves.values()) {
            this.slaveDataSourceConfigurations.add(new DataSourceConfig(this, (Map<String, String>)otherSlaveConf));
        }
    }

    public boolean hasSlave() {
        return !this.slaveDataSourceConfigurations.isEmpty();
    }

    public DataSourceConfig soleSlave() {
        return this.hasSoleSlave() ? this.slaveDataSourceConfigurations.get(0) : null;
    }

    public boolean hasSoleSlave() {
        return 1 == this.slaveDataSourceConfigurations.size();
    }

    protected void ensureEssentialDatasourceConfig(Map<String, String> conf) {
        if (null == this.username) {
            Act.LOGGER.warn("No data source user configuration specified. Will use the default 'sa' user");
            this.username = "sa";
            conf.put("username", this.username);
        }
        if (null == this.password) {
            this.password = "";
        }
        if (null == this.url) {
            try {
                Class.forName("org.h2.Driver");
                Act.LOGGER.warn("No database URL configuration specified. Will use the default h2 inmemory test database");
                this.url = "jdbc:h2:./test";
                conf.put("url", this.url);
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationException("No database URL configuration specified to db service: " + this.id);
            }
        }
        if (null == this.driver) {
            if (this.url.contains("mysql")) {
                try {
                    this.driver = "com.mysql.cj.jdbc.Driver";
                    Class.forName(this.driver);
                }
                catch (ClassNotFoundException e) {
                    this.driver = "com.mysql.jdbc.Driver";
                }
            } else if (this.url.contains("postgresql")) {
                this.driver = "org.postgresql.Driver";
            } else if (this.url.contains("jdbc:h2:")) {
                this.driver = "org.h2.Driver";
            } else if (this.url.contains("jdbc.mariadb")) {
                this.driver = "org.mariadb.jdbc.Driver";
            } else if (this.url.contains("jdbc:oracle")) {
                this.driver = "oracle.jdbc.OracleDriver";
            } else if (this.url.contains("sqlserver")) {
                this.driver = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
            } else if (this.url.contains("jdbc:db2")) {
                this.driver = "com.ibm.db2.jcc.DB2Driver";
            } else {
                throw E.invalidConfiguration((String)"JDBC driver needs to be configured for datasource: %s", (Object[])new Object[]{this.id});
            }
            conf.put("driver", this.driver);
            Act.LOGGER.warn("JDBC driver not configured, system automatically set to: " + this.driver);
        }
    }

    private void init(Map<String, String> conf, boolean readOnly) {
        this.username = DataSourceConfig.get(conf, "username", this.username);
        this.password = DataSourceConfig.get(conf, "password", this.password);
        this.driver = DataSourceConfig.get(conf, "driver");
        this.url = DataSourceConfig.get(conf, "url", this.url);
        this.minConnections = DataSourceConfig.getInt(conf, "minConnections", 2);
        this.maxConnections = DataSourceConfig.getInt(conf, "maxConnections", 10);
        this.connectionTimeout = DataSourceConfig.getInt(conf, "connectionTimeout", 30);
        this.autoCommit = DataSourceConfig.getBoolean(conf, "autoCommit", readOnly);
        this.readOnly = !readOnly ? DataSourceConfig.getBoolean(conf, "readonly", false) : readOnly;
        String isoLevel = DataSourceConfig.get(conf, "isolationLevel", String.valueOf(this.isolationLevel));
        if (null != isoLevel) {
            if (N.isInt((String)isoLevel)) {
                this.isolationLevel = Integer.parseInt(isoLevel);
            } else {
                if ((isoLevel = Keyword.of((CharSequence)isoLevel.toUpperCase()).constantName()).startsWith("TRANSACTION_")) {
                    isoLevel = isoLevel.substring("TRANSACTION_".length());
                }
                E.invalidConfigurationIf((!isolationLevels.containsKey(isoLevel) ? 1 : 0) != 0, (String)"Unknown isolationLevel: %s", (Object[])new Object[]{isoLevel});
                this.isolationLevel = isolationLevels.get(isoLevel);
            }
        }
        this.ensureEssentialDatasourceConfig(conf);
        this.customProperties = conf;
    }

    private static String get(Map<String, String> conf, String key, String def) {
        return conf.containsKey(key) ? conf.get(key) : def;
    }

    private static String get(Map<String, String> conf, String key) {
        return conf.get(key);
    }

    private static int getInt(Map<String, String> conf, String key, int def) {
        return conf.containsKey(key) ? DataSourceConfig.parseInt(DataSourceConfig.get(conf, key)) : def;
    }

    private static int parseInt(String s) {
        int seed;
        N.Op op;
        S.List parts;
        E.illegalArgumentIf((boolean)S.blank((String)s));
        if (s.contains("*")) {
            parts = S.fastSplit((String)s, (String)"*");
            op = N.Op.MUL;
            seed = 1;
        } else if (s.contains("+")) {
            parts = S.fastSplit((String)s, (String)"+");
            op = N.Op.ADD;
            seed = 0;
        } else {
            return Integer.parseInt(s);
        }
        int i = seed;
        for (String part : parts) {
            i = op.apply((Number)i, (Number)Integer.parseInt(part)).intValue();
        }
        return i;
    }

    private static boolean getBoolean(Map<String, String> conf, String key, boolean def) {
        return conf.containsKey(key) ? Boolean.parseBoolean(DataSourceConfig.get(conf, key)) : def;
    }
}

