/*
 * Decompiled with CFR 0.152.
 */
package nz.net.ultraq.thymeleaf.decorator;

import nz.net.ultraq.thymeleaf.LayoutUtilities;
import nz.net.ultraq.thymeleaf.decorator.XmlElementDecorator;
import org.thymeleaf.dom.Element;
import org.thymeleaf.dom.Node;
import org.thymeleaf.dom.Text;

public class HtmlHeadDecorator
extends XmlElementDecorator {
    @Override
    public void decorate(Element decoratorhtml, Element contenthead) {
        Element decoratorhead = HtmlHeadDecorator.findElement(decoratorhtml, "head");
        if (decoratorhead == null) {
            if (contenthead != null) {
                decoratorhtml.insertChild(0, (Node)new Text(LayoutUtilities.LINE_SEPARATOR));
                decoratorhtml.insertChild(1, (Node)contenthead);
                Element contenttitle = HtmlHeadDecorator.findElement(contenthead, "title");
                if (contenttitle != null) {
                    Element resultingtitle = new Element("title");
                    HtmlHeadDecorator.extractTitle(contenthead, contenttitle, "title-pattern::content-title", resultingtitle);
                    contenthead.insertChild(0, (Node)new Text(LayoutUtilities.LINE_SEPARATOR));
                    contenthead.insertChild(1, (Node)resultingtitle);
                }
            }
            return;
        }
        Element decoratortitle = HtmlHeadDecorator.findElement(decoratorhead, "title");
        Element contenttitle = null;
        if (contenthead != null) {
            contenttitle = HtmlHeadDecorator.findElement(contenthead, "title");
        }
        Element resultingtitle = null;
        if (decoratortitle != null || contenttitle != null) {
            resultingtitle = new Element("title");
            if (decoratortitle != null) {
                HtmlHeadDecorator.extractTitle(decoratorhead, decoratortitle, "title-pattern::decorator-title", resultingtitle);
            }
            if (contenttitle != null) {
                HtmlHeadDecorator.extractTitle(contenthead, contenttitle, "title-pattern::content-title", resultingtitle);
            }
            if (LayoutUtilities.hasAttribute(resultingtitle, "layout", "title-pattern")) {
                LayoutUtilities.removeAttribute(resultingtitle, "th", "text");
                LayoutUtilities.removeAttribute(resultingtitle, "th", "utext");
            }
        }
        if (contenthead != null) {
            for (Node contentheadnode : contenthead.getChildren()) {
                decoratorhead.addChild(contentheadnode);
            }
        }
        if (resultingtitle != null) {
            decoratorhead.insertChild(0, (Node)new Text(LayoutUtilities.LINE_SEPARATOR));
            decoratorhead.insertChild(1, (Node)resultingtitle);
        }
        super.decorate(decoratorhead, contenthead);
    }

    private static void extractTitle(Element head, Element title, String titlekey, Element result) {
        Text titletext = (Text)title.getFirstChild();
        result.clearChildren();
        result.addChild((Node)titletext);
        if (LayoutUtilities.hasAttribute(title, "th", "utext")) {
            result.setNodeProperty(titlekey, (Object)LayoutUtilities.getAttributeValue(title, "th", "utext"));
        } else if (LayoutUtilities.hasAttribute(title, "th", "text")) {
            result.setNodeProperty(titlekey, (Object)LayoutUtilities.getAttributeValue(title, "th", "text"));
        } else if (title.hasNodeProperty(titlekey)) {
            result.setNodeProperty(titlekey, title.getNodeProperty(titlekey));
        } else if (titletext != null) {
            result.setNodeProperty(titlekey, (Object)titletext.getContent());
        }
        LayoutUtilities.pullAttributes(result, title);
        head.removeChild((Node)title);
    }
}

