/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import weka.gui.EvaluationMetricSelectionDialog;
import weka.gui.PropertySheetPanel;
import weka.gui.beans.BeanCustomizer;
import weka.gui.beans.ClassifierPerformanceEvaluator;
import weka.gui.beans.CustomizerCloseRequester;
import weka.gui.beans.CustomizerClosingListener;

public class ClassifierPerformanceEvaluatorCustomizer
extends JPanel
implements BeanCustomizer,
CustomizerCloseRequester,
CustomizerClosingListener {
    private static final long serialVersionUID = -1055460295546483853L;
    private final PropertyChangeSupport m_pcSupport = new PropertyChangeSupport(this);
    private final PropertySheetPanel m_splitEditor = new PropertySheetPanel();
    private ClassifierPerformanceEvaluator m_cpe;
    private BeanCustomizer.ModifyListener m_modifyListener;
    private int m_executionSlotsBackup;
    private Window m_parent;
    private final JButton m_evalMetricsBut = new JButton("Evaluation metrics...");
    private List<String> m_evaluationMetrics;

    public ClassifierPerformanceEvaluatorCustomizer() {
        this.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        this.setLayout(new BorderLayout());
        JPanel holder = new JPanel();
        holder.setLayout(new BorderLayout());
        holder.add((Component)this.m_splitEditor, "North");
        holder.add((Component)this.m_evalMetricsBut, "South");
        this.add((Component)holder, "North");
        this.m_evalMetricsBut.setToolTipText("Enable/disable output of specific evaluation metrics");
        this.addButtons();
    }

    private void addButtons() {
        JButton okBut = new JButton("OK");
        JButton cancelBut = new JButton("Cancel");
        JPanel butHolder = new JPanel();
        butHolder.setLayout(new GridLayout(1, 2));
        butHolder.add(okBut);
        butHolder.add(cancelBut);
        this.add((Component)butHolder, "South");
        okBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ClassifierPerformanceEvaluatorCustomizer.this.m_modifyListener != null) {
                    ClassifierPerformanceEvaluatorCustomizer.this.m_modifyListener.setModifiedStatus(ClassifierPerformanceEvaluatorCustomizer.this, true);
                }
                if (ClassifierPerformanceEvaluatorCustomizer.this.m_evaluationMetrics.size() > 0) {
                    StringBuilder b = new StringBuilder();
                    for (String s : ClassifierPerformanceEvaluatorCustomizer.this.m_evaluationMetrics) {
                        b.append(s).append(",");
                    }
                    String newList = b.substring(0, b.length() - 1);
                    ClassifierPerformanceEvaluatorCustomizer.this.m_cpe.setEvaluationMetricsToOutput(newList);
                }
                if (ClassifierPerformanceEvaluatorCustomizer.this.m_parent != null) {
                    ClassifierPerformanceEvaluatorCustomizer.this.m_parent.dispose();
                }
            }
        });
        cancelBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClassifierPerformanceEvaluatorCustomizer.this.customizerClosing();
                if (ClassifierPerformanceEvaluatorCustomizer.this.m_parent != null) {
                    ClassifierPerformanceEvaluatorCustomizer.this.m_parent.dispose();
                }
            }
        });
    }

    @Override
    public void setObject(Object object) {
        this.m_cpe = (ClassifierPerformanceEvaluator)object;
        this.m_executionSlotsBackup = this.m_cpe.getExecutionSlots();
        this.m_splitEditor.setTarget(this.m_cpe);
        String list = this.m_cpe.getEvaluationMetricsToOutput();
        this.m_evaluationMetrics = new ArrayList<String>();
        if (list != null && list.length() > 0) {
            String[] parts;
            for (String s : parts = list.split(",")) {
                this.m_evaluationMetrics.add(s.trim());
            }
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.m_pcSupport.addPropertyChangeListener(pcl);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.m_pcSupport.removePropertyChangeListener(pcl);
    }

    @Override
    public void setModifiedListener(BeanCustomizer.ModifyListener l) {
        this.m_modifyListener = l;
    }

    @Override
    public void customizerClosing() {
        this.m_cpe.setExecutionSlots(this.m_executionSlotsBackup);
    }

    @Override
    public void setParentWindow(Window parent) {
        this.m_parent = parent;
        this.m_evalMetricsBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EvaluationMetricSelectionDialog esd = new EvaluationMetricSelectionDialog(ClassifierPerformanceEvaluatorCustomizer.this.m_parent, (List<String>)ClassifierPerformanceEvaluatorCustomizer.this.m_evaluationMetrics);
                esd.setLocation(ClassifierPerformanceEvaluatorCustomizer.this.m_evalMetricsBut.getLocationOnScreen());
                esd.pack();
                esd.setVisible(true);
                ClassifierPerformanceEvaluatorCustomizer.this.m_evaluationMetrics = esd.getSelectedEvalMetrics();
            }
        });
    }
}

