/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import proguard.io.DataEntry;
import proguard.io.DataEntryFilter;
import proguard.io.DataEntryWriter;

public class FilteredDataEntryWriter
implements DataEntryWriter {
    private final DataEntryFilter dataEntryFilter;
    private DataEntryWriter acceptedDataEntryWriter;
    private DataEntryWriter rejectedDataEntryWriter;

    public FilteredDataEntryWriter(DataEntryFilter dataEntryFilter, DataEntryWriter acceptedDataEntryWriter) {
        this(dataEntryFilter, acceptedDataEntryWriter, null);
    }

    public FilteredDataEntryWriter(DataEntryFilter dataEntryFilter, DataEntryWriter acceptedDataEntryWriter, DataEntryWriter rejectedDataEntryWriter) {
        this.dataEntryFilter = dataEntryFilter;
        this.acceptedDataEntryWriter = acceptedDataEntryWriter;
        this.rejectedDataEntryWriter = rejectedDataEntryWriter;
    }

    public boolean createDirectory(DataEntry dataEntry) throws IOException {
        DataEntryWriter dataEntryWriter = this.dataEntryFilter.accepts(dataEntry) ? this.acceptedDataEntryWriter : this.rejectedDataEntryWriter;
        return dataEntryWriter != null && dataEntryWriter.createDirectory(dataEntry);
    }

    public boolean sameOutputStream(DataEntry dataEntry1, DataEntry dataEntry2) throws IOException {
        boolean accepts1 = this.dataEntryFilter.accepts(dataEntry1);
        boolean accepts2 = this.dataEntryFilter.accepts(dataEntry2);
        return accepts1 ? !accepts2 || this.acceptedDataEntryWriter == null || this.acceptedDataEntryWriter.sameOutputStream(dataEntry1, dataEntry2) : accepts2 || this.rejectedDataEntryWriter == null || this.rejectedDataEntryWriter.sameOutputStream(dataEntry1, dataEntry2);
    }

    public OutputStream createOutputStream(DataEntry dataEntry) throws IOException {
        DataEntryWriter dataEntryWriter = this.dataEntryFilter.accepts(dataEntry) ? this.acceptedDataEntryWriter : this.rejectedDataEntryWriter;
        return dataEntryWriter != null ? dataEntryWriter.createOutputStream(dataEntry) : null;
    }

    public void close() throws IOException {
        if (this.acceptedDataEntryWriter != null) {
            this.acceptedDataEntryWriter.close();
            this.acceptedDataEntryWriter = null;
        }
        if (this.rejectedDataEntryWriter != null) {
            this.rejectedDataEntryWriter.close();
            this.rejectedDataEntryWriter = null;
        }
    }

    public void println(PrintWriter pw, String prefix) {
        pw.println(prefix + "FilteredDataEntryWriter (filter = " + this.dataEntryFilter + ")");
        if (this.acceptedDataEntryWriter != null) {
            this.acceptedDataEntryWriter.println(pw, prefix + "  ");
        }
        if (this.rejectedDataEntryWriter != null) {
            this.rejectedDataEntryWriter.println(pw, prefix + "  ");
        }
    }
}

