/*
 * Decompiled with CFR 0.152.
 */
package net.nicoulaj.maven.plugins.checksum.mojo;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import net.nicoulaj.maven.plugins.checksum.mojo.AbstractChecksumMojo;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="dependencies", defaultPhase=LifecyclePhase.VERIFY, requiresProject=true, inheritByDefault=false, requiresDependencyResolution=ResolutionScope.RUNTIME, threadSafe=true)
public class DependenciesMojo
extends AbstractChecksumMojo {
    public static final String NAME = "dependencies";
    @Parameter(defaultValue="false")
    protected boolean individualFiles;
    @Parameter(defaultValue="${project.build.directory}")
    protected String individualFilesOutputDirectory;
    @Parameter(defaultValue="true")
    protected boolean csvSummary;
    @Parameter(defaultValue="dependencies-checksums.csv")
    protected String csvSummaryFile;
    @Parameter(defaultValue="false")
    protected boolean xmlSummary;
    @Parameter(defaultValue="dependencies-checksums.xml")
    protected String xmlSummaryFile;
    @Parameter
    protected List<String> scopes;
    @Parameter
    protected List<String> types;

    @Override
    protected List<File> getFilesToProcess() {
        LinkedList<File> files = new LinkedList<File>();
        for (Artifact artifact : this.project.getDependencyArtifacts()) {
            if (this.scopes != null && !this.scopes.contains(artifact.getScope()) || this.types != null && !this.types.contains(artifact.getType())) continue;
            files.add(artifact.getFile());
        }
        return files;
    }

    @Override
    protected boolean isIndividualFiles() {
        return this.individualFiles;
    }

    @Override
    protected String getIndividualFilesOutputDirectory() {
        return this.individualFilesOutputDirectory;
    }

    @Override
    protected boolean isCsvSummary() {
        return this.csvSummary;
    }

    @Override
    protected String getCsvSummaryFile() {
        return this.csvSummaryFile;
    }

    @Override
    protected boolean isXmlSummary() {
        return this.xmlSummary;
    }

    @Override
    protected String getXmlSummaryFile() {
        return this.xmlSummaryFile;
    }
}

