/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.oauth.request;

import com.alibaba.fastjson.JSONObject;
import com.xkcoding.http.support.HttpHeader;
import com.xkcoding.http.util.UrlUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import me.zhyd.oauth.cache.AuthStateCache;
import me.zhyd.oauth.config.AuthConfig;
import me.zhyd.oauth.config.AuthDefaultSource;
import me.zhyd.oauth.enums.AuthResponseStatus;
import me.zhyd.oauth.enums.AuthUserGender;
import me.zhyd.oauth.enums.scope.AuthAmazonScope;
import me.zhyd.oauth.exception.AuthException;
import me.zhyd.oauth.model.AuthCallback;
import me.zhyd.oauth.model.AuthResponse;
import me.zhyd.oauth.model.AuthToken;
import me.zhyd.oauth.model.AuthUser;
import me.zhyd.oauth.request.AuthDefaultRequest;
import me.zhyd.oauth.utils.AuthScopeUtils;
import me.zhyd.oauth.utils.HttpUtils;
import me.zhyd.oauth.utils.PkceUtil;
import me.zhyd.oauth.utils.UrlBuilder;

public class AuthAmazonRequest
extends AuthDefaultRequest {
    public AuthAmazonRequest(AuthConfig config) {
        super(config, AuthDefaultSource.AMAZON);
    }

    public AuthAmazonRequest(AuthConfig config, AuthStateCache authStateCache) {
        super(config, AuthDefaultSource.AMAZON, authStateCache);
    }

    @Override
    public String authorize(String state) {
        UrlBuilder builder = UrlBuilder.fromBaseUrl(this.source.authorize()).queryParam("client_id", this.config.getClientId()).queryParam("scope", this.getScopes(" ", true, AuthScopeUtils.getDefaultScopes(AuthAmazonScope.values()))).queryParam("redirect_uri", this.config.getRedirectUri()).queryParam("response_type", "code").queryParam("state", this.getRealState(state));
        if (this.config.isPkce()) {
            String cacheKey = this.source.getName().concat(":code_verifier:").concat(this.config.getClientId());
            String codeVerifier = PkceUtil.generateCodeVerifier();
            String codeChallengeMethod = "S256";
            String codeChallenge = PkceUtil.generateCodeChallenge(codeChallengeMethod, codeVerifier);
            builder.queryParam("code_challenge", codeChallenge).queryParam("code_challenge_method", codeChallengeMethod);
            this.authStateCache.cache(cacheKey, codeVerifier, TimeUnit.MINUTES.toMillis(10L));
        }
        return builder.build();
    }

    @Override
    protected AuthToken getAccessToken(AuthCallback authCallback) {
        HashMap<String, String> form = new HashMap<String, String>(9);
        form.put("grant_type", "authorization_code");
        form.put("code", authCallback.getCode());
        form.put("redirect_uri", this.config.getRedirectUri());
        form.put("client_id", this.config.getClientId());
        form.put("client_secret", this.config.getClientSecret());
        if (this.config.isPkce()) {
            String cacheKey = this.source.getName().concat(":code_verifier:").concat(this.config.getClientId());
            String codeVerifier = this.authStateCache.get(cacheKey);
            form.put("code_verifier", codeVerifier);
        }
        return this.getToken(form, this.source.accessToken());
    }

    @Override
    public AuthResponse refresh(AuthToken authToken) {
        HashMap<String, String> form = new HashMap<String, String>(7);
        form.put("grant_type", "refresh_token");
        form.put("refresh_token", authToken.getRefreshToken());
        form.put("client_id", this.config.getClientId());
        form.put("client_secret", this.config.getClientSecret());
        return AuthResponse.builder().code(AuthResponseStatus.SUCCESS.getCode()).data(this.getToken(form, this.source.refresh())).build();
    }

    private AuthToken getToken(Map<String, String> param, String url) {
        HttpHeader httpHeader = new HttpHeader();
        httpHeader.add("Host", "api.amazon.com");
        httpHeader.add("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
        String response = new HttpUtils(this.config.getHttpConfig()).post(url, param, httpHeader, false).getBody();
        JSONObject jsonObject = JSONObject.parseObject((String)response);
        this.checkResponse(jsonObject);
        return AuthToken.builder().accessToken(jsonObject.getString("access_token")).tokenType(jsonObject.getString("token_type")).expireIn(jsonObject.getIntValue("expires_in")).refreshToken(jsonObject.getString("refresh_token")).build();
    }

    private void checkResponse(JSONObject jsonObject) {
        if (jsonObject.containsKey((Object)"error")) {
            throw new AuthException(jsonObject.getString("error_description").concat(" ") + jsonObject.getString("error_description"));
        }
    }

    @Override
    protected AuthUser getUserInfo(AuthToken authToken) {
        String accessToken = authToken.getAccessToken();
        this.checkToken(accessToken);
        HttpHeader httpHeader = new HttpHeader();
        httpHeader.add("Host", "api.amazon.com");
        httpHeader.add("Authorization", "bearer " + accessToken);
        String userInfo = new HttpUtils(this.config.getHttpConfig()).get(this.source.userInfo(), new HashMap<String, String>(0), httpHeader, false).getBody();
        JSONObject jsonObject = JSONObject.parseObject((String)userInfo);
        this.checkResponse(jsonObject);
        return AuthUser.builder().rawUserInfo(jsonObject).uuid(jsonObject.getString("user_id")).username(jsonObject.getString("name")).nickname(jsonObject.getString("name")).email(jsonObject.getString("email")).gender(AuthUserGender.UNKNOWN).source(this.source.toString()).token(authToken).build();
    }

    private void checkToken(String accessToken) {
        String tokenInfo = new HttpUtils(this.config.getHttpConfig()).get("https://api.amazon.com/auth/o2/tokeninfo?access_token=" + UrlUtil.urlEncode((String)accessToken)).getBody();
        JSONObject jsonObject = JSONObject.parseObject((String)tokenInfo);
        if (!this.config.getClientId().equals(jsonObject.getString("aud"))) {
            throw new AuthException(AuthResponseStatus.ILLEGAL_TOKEN);
        }
    }

    @Override
    protected String userInfoUrl(AuthToken authToken) {
        return UrlBuilder.fromBaseUrl(this.source.userInfo()).queryParam("user_id", authToken.getUserId()).queryParam("screen_name", authToken.getScreenName()).queryParam("include_entities", true).build();
    }
}

