/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.oauth.request;

import cn.hutool.core.codec.Base64;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.HashMap;
import me.zhyd.oauth.cache.AuthStateCache;
import me.zhyd.oauth.config.AuthConfig;
import me.zhyd.oauth.config.AuthDefaultSource;
import me.zhyd.oauth.enums.AuthResponseStatus;
import me.zhyd.oauth.enums.AuthUserGender;
import me.zhyd.oauth.exception.AuthException;
import me.zhyd.oauth.model.AuthCallback;
import me.zhyd.oauth.model.AuthResponse;
import me.zhyd.oauth.model.AuthToken;
import me.zhyd.oauth.model.AuthUser;
import me.zhyd.oauth.request.AuthDefaultRequest;
import me.zhyd.oauth.utils.GlobalAuthUtil;
import me.zhyd.oauth.utils.UrlBuilder;
import me.zhyd.oauth.utils.UuidUtils;

public class AuthElemeRequest
extends AuthDefaultRequest {
    public AuthElemeRequest(AuthConfig config) {
        super(config, AuthDefaultSource.ELEME);
    }

    public AuthElemeRequest(AuthConfig config, AuthStateCache authStateCache) {
        super(config, AuthDefaultSource.ELEME, authStateCache);
    }

    @Override
    protected AuthToken getAccessToken(AuthCallback authCallback) {
        HttpRequest request = HttpRequest.post((String)this.source.accessToken()).form("client_id", (Object)this.config.getClientId()).form("redirect_uri", (Object)this.config.getRedirectUri()).form("code", (Object)authCallback.getCode()).form("grant_type", (Object)"authorization_code");
        this.setHeader(request);
        HttpResponse response = request.execute();
        JSONObject object = JSONObject.parseObject((String)response.body());
        this.checkResponse(object);
        return AuthToken.builder().accessToken(object.getString("access_token")).refreshToken(object.getString("refresh_token")).tokenType(object.getString("token_type")).expireIn(object.getIntValue("expires_in")).build();
    }

    @Override
    protected AuthUser getUserInfo(AuthToken authToken) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        String action = "eleme.user.getUser";
        long timestamp = System.currentTimeMillis();
        HashMap<String, Object> metasHashMap = new HashMap<String, Object>();
        metasHashMap.put("app_key", this.config.getClientId());
        metasHashMap.put("timestamp", timestamp);
        String signature = GlobalAuthUtil.generateElemeSignature(this.config.getClientId(), this.config.getClientSecret(), timestamp, action, authToken.getAccessToken(), parameters);
        String requestId = this.getRequestId();
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("nop", "1.0.0");
        paramsMap.put("id", requestId);
        paramsMap.put("action", action);
        paramsMap.put("token", authToken.getAccessToken());
        paramsMap.put("metas", metasHashMap);
        paramsMap.put("params", parameters);
        paramsMap.put("signature", signature);
        HttpRequest request = HttpRequest.post((String)this.source.userInfo()).body(JSONObject.toJSONBytes(paramsMap, (SerializerFeature[])new SerializerFeature[0]));
        this.setHeader(request, "application/json; charset=utf-8", requestId);
        HttpResponse response = request.execute();
        JSONObject object = JSONObject.parseObject((String)response.body());
        if (object.containsKey((Object)"name")) {
            throw new AuthException(object.getString("message"));
        }
        if (object.containsKey((Object)"error") && null != object.get((Object)"error")) {
            throw new AuthException(object.getJSONObject("error").getString("message"));
        }
        JSONObject result = object.getJSONObject("result");
        return AuthUser.builder().uuid(result.getString("userId")).username(result.getString("userName")).nickname(result.getString("userName")).gender(AuthUserGender.UNKNOWN).token(authToken).source(this.source.toString()).build();
    }

    @Override
    public AuthResponse refresh(AuthToken oldToken) {
        HttpRequest request = HttpRequest.post((String)this.source.refresh()).form("refresh_token", (Object)oldToken.getRefreshToken()).form("grant_type", (Object)"refresh_token");
        this.setHeader(request);
        HttpResponse response = request.execute();
        JSONObject object = JSONObject.parseObject((String)response.body());
        this.checkResponse(object);
        return AuthResponse.builder().code(AuthResponseStatus.SUCCESS.getCode()).data(AuthToken.builder().accessToken(object.getString("access_token")).refreshToken(object.getString("refresh_token")).tokenType(object.getString("token_type")).expireIn(object.getIntValue("expires_in")).build()).build();
    }

    @Override
    public String authorize(String state) {
        return UrlBuilder.fromBaseUrl(super.authorize(state)).queryParam("scope", "all").build();
    }

    private String getBasic(String appKey, String appSecret) {
        StringBuilder sb = new StringBuilder();
        String encodeToString = Base64.encode((byte[])(appKey + ":" + appSecret).getBytes());
        sb.append("Basic").append(" ").append(encodeToString);
        return sb.toString();
    }

    private void setHeader(HttpRequest request) {
        this.setHeader(request, "application/x-www-form-urlencoded;charset=UTF-8", this.getRequestId());
        request.header("Authorization", this.getBasic(this.config.getClientId(), this.config.getClientSecret()));
    }

    private void setHeader(HttpRequest request, String contentType, String requestId) {
        ((HttpRequest)((HttpRequest)((HttpRequest)((HttpRequest)request.header("Accept", "text/xml,text/javascript,text/html")).header("Content-Type", contentType)).header("Accept-Encoding", "gzip")).header("User-Agent", "eleme-openapi-java-sdk")).header("x-eleme-requestid", requestId);
    }

    private String getRequestId() {
        return (UuidUtils.getUUID() + "|" + System.currentTimeMillis()).toUpperCase();
    }

    private void checkResponse(JSONObject object) {
        if (object.containsKey((Object)"error")) {
            throw new AuthException(object.getString("error_description"));
        }
    }
}

