/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.hunter.processor;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import me.zhyd.hunter.Hunter;
import me.zhyd.hunter.config.HunterConfig;
import me.zhyd.hunter.config.HunterConfigContext;
import me.zhyd.hunter.config.HunterDateDeserializer;
import me.zhyd.hunter.entity.Cookie;
import me.zhyd.hunter.entity.VirtualArticle;
import me.zhyd.hunter.resolver.HtmlResolver;
import me.zhyd.hunter.resolver.JsonResolver;
import me.zhyd.hunter.resolver.Resolver;
import me.zhyd.hunter.util.CommonUtil;
import me.zhyd.hunter.util.HunterPrintWriter;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.codecraft.webmagic.Page;
import us.codecraft.webmagic.ResultItems;
import us.codecraft.webmagic.Site;
import us.codecraft.webmagic.processor.PageProcessor;

public abstract class HunterProcessor
implements PageProcessor {
    private static final Logger log = LoggerFactory.getLogger(HunterProcessor.class);
    protected HunterConfig config;
    protected HunterPrintWriter writer = new HunterPrintWriter();
    protected String uuid;
    private Validator validator = Validation.buildDefaultValidatorFactory().getValidator();

    HunterProcessor() {
    }

    HunterProcessor(HunterConfig m) {
        this(m, UUID.randomUUID().toString());
    }

    HunterProcessor(HunterConfig m, String uuid) {
        this(m, null, uuid);
    }

    HunterProcessor(HunterConfig config, HunterPrintWriter writer, String uuid) {
        this.config = HunterConfigContext.parseConfig(config);
        this.uuid = uuid;
        if (null != writer) {
            this.writer = writer;
        }
    }

    HunterProcessor(String url, boolean convertImage) {
        this(HunterConfigContext.getHunterConfig(url).setConvertImg(convertImage));
    }

    HunterProcessor(String url, boolean convertImage, HunterPrintWriter writer) {
        this(HunterConfigContext.getHunterConfig(url).setConvertImg(convertImage));
        if (writer != null) {
            this.writer = writer;
        }
    }

    public abstract CopyOnWriteArrayList<VirtualArticle> execute();

    public void process(Page page) {
        Resolver resolver = new HtmlResolver();
        if (this.config.getAjaxRequest().booleanValue()) {
            resolver = new JsonResolver();
        }
        resolver.process(page, this.config);
    }

    public Site getSite() {
        Map<String, String> headers;
        Site site = Site.me().setCharset(this.config.getCharset()).setDomain(this.config.getDomain()).setUserAgent(this.config.getUa()).setSleepTime(this.config.getSleepTime()).setRetryTimes(this.config.getRetryTimes()).setCycleRetryTimes(this.config.getCycleRetryTimes());
        List<Cookie> cookies = this.config.getCookies();
        if (CollectionUtils.isNotEmpty(cookies)) {
            for (Cookie cookie : cookies) {
                if (StringUtils.isEmpty((CharSequence)cookie.getDomain())) {
                    site.addCookie(cookie.getName(), cookie.getValue());
                    continue;
                }
                site.addCookie(cookie.getDomain(), cookie.getName(), cookie.getValue());
            }
        }
        if (MapUtils.isNotEmpty(headers = this.config.getHeaders())) {
            Set<Map.Entry<String, String>> entrySet = headers.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                site.addHeader(entry.getKey(), entry.getValue());
            }
        }
        return site;
    }

    final <T> List<String> validateModel(T t) {
        Set constraintViolations = this.validator.validate(t, new Class[0]);
        ArrayList<String> messageList = new ArrayList<String>();
        for (ConstraintViolation constraintViolation : constraintViolations) {
            messageList.add(constraintViolation.getMessage());
        }
        return messageList;
    }

    final void process(ResultItems resultItems, List<VirtualArticle> virtualArticles, Hunter spider) {
        if (null == spider) {
            return;
        }
        Map map = resultItems.getAll();
        if (CollectionUtil.isEmpty((Map)map)) {
            return;
        }
        String title = String.valueOf(map.get("title"));
        ParserConfig jcParserConfig = new ParserConfig();
        jcParserConfig.putDeserializer(Date.class, (ObjectDeserializer)HunterDateDeserializer.instance);
        VirtualArticle virtualArticle = (VirtualArticle)JSON.parseObject((String)JSON.toJSONString((Object)map), VirtualArticle.class, (ParserConfig)jcParserConfig, (int)JSON.DEFAULT_PARSER_FEATURE, (Feature[])new Feature[0]);
        virtualArticle.setDescription(CommonUtil.getRealDescription(virtualArticle.getDescription(), virtualArticle.getContent())).setKeywords(CommonUtil.getRealKeywords(virtualArticle.getKeywords()));
        if (this.config.isConvertImg()) {
            virtualArticle.setContent(CommonUtil.formatHtml(virtualArticle.getContent()));
            virtualArticle.setImageLinks(CommonUtil.getAllImageLink(virtualArticle.getContent()));
        }
        if (CollectionUtils.isEmpty(virtualArticle.getTags())) {
            virtualArticle.setTags(Collections.singletonList("\u5176\u4ed6"));
        }
        virtualArticles.add(virtualArticle);
        this.writer.print(String.format("<a href=\"%s\" target=\"_blank\">%s</a> -- %s -- %s", virtualArticle.getSource(), title, virtualArticle.getAuthor(), virtualArticle.getReleaseDate()));
    }

    public HunterConfig getConfig() {
        return this.config;
    }
}

