/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.houtu.util;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import me.zhyd.houtu.entity.Template;
import me.zhyd.houtu.exception.GeneratorException;
import me.zhyd.houtu.util.StringUtils;

public class TemplateUtil
extends FileUtil {
    private static String getFileContentByResourcePath(String resourcePath) {
        try {
            InputStream inputStream = TemplateUtil.class.getResourceAsStream(resourcePath);
            if (null == inputStream) {
                throw new GeneratorException("\u8bf7\u68c0\u67e5`src/main/resources`\u4e0b\u662f\u5426\u5b58\u5728: " + resourcePath);
            }
            String content = IoUtil.read((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            if (StringUtils.isEmpty(content)) {
                throw new GeneratorException("\u6a21\u677f\u5185\u5bb9\u4e3a\u7a7a\uff1a" + resourcePath);
            }
            return content;
        }
        catch (Exception e) {
            throw new GeneratorException("\u65e0\u6cd5\u83b7\u53d6\u6a21\u677f\u5185\u5bb9\uff1a" + resourcePath);
        }
    }

    private static String getFileContentByFilePath(String filePath) {
        try {
            FileInputStream inputStream = new FileInputStream(new File(filePath));
            String content = IoUtil.read((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            if (StringUtils.isEmpty(content)) {
                throw new GeneratorException("\u6a21\u677f\u5185\u5bb9\u4e3a\u7a7a\uff1a" + filePath);
            }
            return content;
        }
        catch (Exception e) {
            throw new GeneratorException("\u65e0\u6cd5\u83b7\u53d6\u6a21\u677f\u5185\u5bb9\uff1a" + filePath);
        }
    }

    private static List<File> getFilesFromResource(String resourcePath) {
        List files = TemplateUtil.loopFiles((String)resourcePath);
        return files.stream().filter(f -> !f.getPath().endsWith(".include")).collect(Collectors.toList());
    }

    public static List<Template> listTemplates(String templatePath) {
        URL classPath = Thread.currentThread().getContextClassLoader().getResource(templatePath);
        if (null == classPath) {
            throw new GeneratorException("[" + templatePath + "] \u4e0b\u672a\u83b7\u53d6\u5230\u6a21\u677f\u4fe1\u606f");
        }
        String templateBasePath = TemplateUtil.file((String)classPath.getFile()).getAbsolutePath();
        ArrayList templates = Lists.newArrayList();
        List<File> templateFiles = TemplateUtil.getFilesFromResource(templateBasePath);
        for (File template : templateFiles) {
            String absolutePath = template.getAbsolutePath();
            templates.add(Template.builder().filePath(absolutePath.replace(templateBasePath, "")).fileContent(TemplateUtil.getFileContentByFilePath(template.getPath())).build());
        }
        return templates;
    }

    public static void deleteDir(String rootPath) {
        File dir = new File(rootPath);
        if (!dir.exists()) {
            return;
        }
        if (!dir.isDirectory()) {
            String message = dir + " is not a directory";
            throw new IllegalArgumentException(message);
        }
        File[] items = dir.listFiles();
        if (items != null && items.length > 0) {
            for (File item : items) {
                TemplateUtil.forceDelete(item);
            }
        }
    }

    public static void forceDelete(File file) {
        if (file.isDirectory()) {
            TemplateUtil.deleteDir(file.getAbsolutePath());
        } else {
            boolean filePresent = file.exists();
            if (!file.delete()) {
                if (!filePresent) {
                    throw new GeneratorException("File does not exist: " + file);
                }
                String message = "Unable to delete file: " + file;
                throw new GeneratorException(message);
            }
        }
    }
}

