/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.houtu.util;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.Version;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import me.zhyd.houtu.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FreemarkerUtil {
    private static final Logger log = LoggerFactory.getLogger(FreemarkerUtil.class);
    private static final String LT = "<";
    private static final String LT_CHAR = "&lt;";
    private static final String GT = ">";
    private static final String GT_CHAR = "&gt;";
    private static final String AMP = "&";
    private static final String AMP_CHAR = "&amp;";
    private static final String APOS = "'";
    private static final String APOS_CHAR = "&apos;";
    private static final String QUOT = "&quot;";
    private static final String QUOT_CHAR = "\"";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String template2String(String templateContent, Map<String, Object> map, boolean isNeedFilter) {
        if (StringUtils.isEmpty(templateContent)) {
            return null;
        }
        if (map == null) {
            map = new HashMap<String, Object>();
        }
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        Set<String> keySet = map.keySet();
        if (keySet.size() > 0) {
            for (String key : keySet) {
                Object o = map.get(key);
                if (o == null) continue;
                if (o instanceof String) {
                    String value = o.toString();
                    value = value.trim();
                    if (isNeedFilter) {
                        value = FreemarkerUtil.filterXmlString(value);
                    }
                    newMap.put(key, value);
                    continue;
                }
                newMap.put(key, o);
            }
        }
        Template t = null;
        try {
            t = new Template("", (Reader)new StringReader(templateContent), new Configuration(new Version(2, 3, 0)));
            StringWriter writer = new StringWriter();
            t.process(newMap, (Writer)writer);
            String string = writer.toString();
            return string;
        }
        catch (IOException e) {
            log.error("TemplateUtil -> template2String IOException.");
            e.printStackTrace();
        }
        catch (TemplateException e) {
            log.error("TemplateUtil -> template2String TemplateException.");
            e.printStackTrace();
        }
        finally {
            newMap.clear();
            newMap = null;
        }
        return null;
    }

    protected static String filterXmlString(String str) {
        str = str.replaceAll(LT, LT_CHAR);
        str = str.replaceAll(GT, GT_CHAR);
        str = str.replaceAll(AMP, AMP_CHAR);
        str = str.replaceAll(APOS, APOS_CHAR);
        str = str.replaceAll(QUOT, QUOT_CHAR);
        return str;
    }
}

