/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.houtu.entity;

import me.zhyd.houtu.config.JdbcType;
import me.zhyd.houtu.config.TypeMapping;
import me.zhyd.houtu.util.DbUtil;

public class Column {
    private String tableName;
    private String columnName;
    private String columnType;
    private Integer length;
    private Integer scale;
    private String keyType;
    private String extra;
    private String remark;
    private Boolean notNull;

    public String getColumnNameFirstUpper() {
        String columnName = DbUtil.makeAllWordFirstLetterUpperCase(this.columnName);
        return DbUtil.capitalize(columnName);
    }

    public String getColumnNameFirstLower() {
        String columnName = DbUtil.makeAllWordFirstLetterUpperCase(this.columnName);
        return DbUtil.unCapitalize(columnName);
    }

    public String getJavaType() {
        return TypeMapping.getJavaType(this.columnType);
    }

    public String getJdbcType() {
        JdbcType jdbcType = JdbcType.getJdbcTypeBySqlType(this.columnType);
        return jdbcType.name();
    }

    public String getPossibleShortJavaType() {
        if (this.getJavaType().startsWith("java.lang.") || this.getJavaType().startsWith("java.util.") || this.getJavaType().startsWith("java.sql.")) {
            return DbUtil.getJavaClassSimpleName(this.getJavaType());
        }
        return this.getJavaType();
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getColumnType() {
        return this.columnType;
    }

    public Integer getLength() {
        return this.length;
    }

    public Integer getScale() {
        return this.scale;
    }

    public String getKeyType() {
        return this.keyType;
    }

    public String getExtra() {
        return this.extra;
    }

    public String getRemark() {
        return this.remark;
    }

    public Boolean getNotNull() {
        return this.notNull;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public void setColumnType(String columnType) {
        this.columnType = columnType;
    }

    public void setLength(Integer length) {
        this.length = length;
    }

    public void setScale(Integer scale) {
        this.scale = scale;
    }

    public void setKeyType(String keyType) {
        this.keyType = keyType;
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public void setNotNull(Boolean notNull) {
        this.notNull = notNull;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Column)) {
            return false;
        }
        Column other = (Column)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$columnName = this.getColumnName();
        String other$columnName = other.getColumnName();
        if (this$columnName == null ? other$columnName != null : !this$columnName.equals(other$columnName)) {
            return false;
        }
        String this$columnType = this.getColumnType();
        String other$columnType = other.getColumnType();
        if (this$columnType == null ? other$columnType != null : !this$columnType.equals(other$columnType)) {
            return false;
        }
        Integer this$length = this.getLength();
        Integer other$length = other.getLength();
        if (this$length == null ? other$length != null : !((Object)this$length).equals(other$length)) {
            return false;
        }
        Integer this$scale = this.getScale();
        Integer other$scale = other.getScale();
        if (this$scale == null ? other$scale != null : !((Object)this$scale).equals(other$scale)) {
            return false;
        }
        String this$keyType = this.getKeyType();
        String other$keyType = other.getKeyType();
        if (this$keyType == null ? other$keyType != null : !this$keyType.equals(other$keyType)) {
            return false;
        }
        String this$extra = this.getExtra();
        String other$extra = other.getExtra();
        if (this$extra == null ? other$extra != null : !this$extra.equals(other$extra)) {
            return false;
        }
        String this$remark = this.getRemark();
        String other$remark = other.getRemark();
        if (this$remark == null ? other$remark != null : !this$remark.equals(other$remark)) {
            return false;
        }
        Boolean this$notNull = this.getNotNull();
        Boolean other$notNull = other.getNotNull();
        return !(this$notNull == null ? other$notNull != null : !((Object)this$notNull).equals(other$notNull));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Column;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $columnName = this.getColumnName();
        result = result * 59 + ($columnName == null ? 43 : $columnName.hashCode());
        String $columnType = this.getColumnType();
        result = result * 59 + ($columnType == null ? 43 : $columnType.hashCode());
        Integer $length = this.getLength();
        result = result * 59 + ($length == null ? 43 : ((Object)$length).hashCode());
        Integer $scale = this.getScale();
        result = result * 59 + ($scale == null ? 43 : ((Object)$scale).hashCode());
        String $keyType = this.getKeyType();
        result = result * 59 + ($keyType == null ? 43 : $keyType.hashCode());
        String $extra = this.getExtra();
        result = result * 59 + ($extra == null ? 43 : $extra.hashCode());
        String $remark = this.getRemark();
        result = result * 59 + ($remark == null ? 43 : $remark.hashCode());
        Boolean $notNull = this.getNotNull();
        result = result * 59 + ($notNull == null ? 43 : ((Object)$notNull).hashCode());
        return result;
    }

    public String toString() {
        return "Column(tableName=" + this.getTableName() + ", columnName=" + this.getColumnName() + ", columnType=" + this.getColumnType() + ", length=" + this.getLength() + ", scale=" + this.getScale() + ", keyType=" + this.getKeyType() + ", extra=" + this.getExtra() + ", remark=" + this.getRemark() + ", notNull=" + this.getNotNull() + ")";
    }
}

