/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.houtu.core;

import com.google.common.collect.Lists;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import me.zhyd.houtu.config.Config;
import me.zhyd.houtu.entity.Column;
import me.zhyd.houtu.entity.Table;
import me.zhyd.houtu.exception.GeneratorException;
import me.zhyd.houtu.util.CloseableUtil;
import me.zhyd.houtu.util.ListUtil;
import me.zhyd.houtu.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneratorHelper {
    private static final Logger log = LoggerFactory.getLogger(GeneratorHelper.class);
    private static boolean connected = false;
    Connection conn = null;
    Statement statement = null;
    Config config = null;
    List<String> databases = null;
    List<Table> tables = null;

    public GeneratorHelper(Config config) {
        this.init(config);
        this.config = config;
    }

    public Config getConfig() {
        return this.config;
    }

    private void init(Config config) {
        this.init(config.getDriver(), config.getUrl(), config.getUsername(), config.getPassword());
    }

    private void init(String driver, String url, String username, String password) {
        if (connected) {
            return;
        }
        try {
            Class.forName(driver);
            this.conn = DriverManager.getConnection(url, username, password);
            this.statement = this.conn.createStatement();
            connected = true;
        }
        catch (ClassNotFoundException | SQLException e) {
            throw new GeneratorException(String.format("\u6570\u636e\u5e93\u94fe\u63a5\u5931\u8d25\uff01\u8bf7\u68c0\u67e5\u6570\u636e\u5e93\u53c2\u6570\u662f\u5426\u914d\u7f6e\u6b63\u786e \ndriver = %s \nurl = %s \nusername = %s \npassword = %s", driver, url, username, password), e);
        }
    }

    public void destroy() {
        if (connected) {
            log.info("\u7a0b\u5e8f\u6267\u884c\u5b8c\u6bd5\uff0c\u91ca\u653e\u8d44\u6e90...");
            connected = false;
            this.databases = null;
            this.tables = null;
            CloseableUtil.close(this.conn, this.statement);
        }
    }

    private ResultSet exe(String sql) throws SQLException {
        return this.statement.executeQuery(sql);
    }

    public List<String> listDatabase() {
        if (!ListUtil.isEmpty(this.databases)) {
            return this.databases;
        }
        ArrayList list = Lists.newArrayList();
        ResultSet rs = null;
        try {
            String sql = "show databases";
            rs = this.exe(sql);
            while (rs.next()) {
                list.add(rs.getString(1));
            }
        }
        catch (SQLException e) {
            try {
                throw new GeneratorException("\u65e0\u6cd5\u83b7\u53d6database\u5217\u8868", e);
            }
            catch (Throwable throwable) {
                CloseableUtil.close(rs);
                throw throwable;
            }
        }
        CloseableUtil.close(rs);
        this.databases = list;
        return list;
    }

    public List<Table> listAllTable() {
        if (!ListUtil.isEmpty(this.tables)) {
            return this.tables;
        }
        String schema = this.config.getDb();
        this.checkDatabase(schema);
        this.tables = this.getTables(null, schema);
        return this.tables;
    }

    private List<Table> getTables(String tableName, String schema) {
        String sql = "select distinct table_schema, table_name, table_type, engine, create_time, table_comment, table_collation from information_schema.tables where table_schema = '" + schema + "'";
        if (!StringUtils.isEmpty(tableName)) {
            sql = sql + " and table_name = '" + tableName + "'";
        }
        ArrayList list = Lists.newArrayList();
        Table table = null;
        ResultSet rs = null;
        try {
            rs = this.exe(sql);
            while (rs.next()) {
                String realTableName = rs.getString("table_name");
                String tableSchema = rs.getString("table_schema");
                String createTime = rs.getString("create_time");
                String remarks = rs.getString("table_comment");
                String engine = rs.getString("engine");
                String coding = rs.getString("table_collation");
                String type = rs.getString("table_type");
                table = new Table();
                table.setDb(tableSchema);
                table.setTableName(realTableName);
                table.setType(type);
                table.setCreateTime(createTime);
                table.setEngine(engine);
                table.setCoding(coding);
                table.setRemark(remarks);
                list.add(table);
            }
        }
        catch (SQLException e) {
            try {
                throw new GeneratorException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                CloseableUtil.close(rs);
                throw throwable;
            }
        }
        CloseableUtil.close(rs);
        if (!ListUtil.isEmpty(list)) {
            list.forEach(t -> t.clearClassPrefix(this.config.getClearClassPrefix()).setClassNamePrefix(this.config.getClassPrefix()).setColumns(this.getTableColumnInfos(t.getTableName(), schema)));
        }
        return list;
    }

    public Table getTableInfo(String tableName) {
        return this.getTableInfo(tableName, this.config.getDb(), true);
    }

    public Table getTableInfo(String tableName, String schema, boolean checkTable) {
        if (checkTable) {
            this.checkTable(tableName, schema);
        }
        List<Table> list = this.getTables(tableName, schema);
        return list.get(0);
    }

    private List<Column> getTableColumnInfos(String table, String schema) {
        LinkedList cols = null;
        ResultSet rs = null;
        try {
            String sql = "select distinct table_schema, table_name, column_name, column_default, is_nullable, data_type, character_maximum_length, numeric_precision, numeric_scale, character_set_name, collation_name, column_type, column_key, extra, column_comment \nfrom information_schema.columns \nwhere table_name = '" + table + "' and table_schema = '" + schema + "'";
            rs = this.exe(sql);
            cols = Lists.newLinkedList();
            while (rs.next()) {
                Column column = new Column();
                column.setTableName(rs.getString("table_name"));
                column.setColumnName(rs.getString("column_name"));
                column.setColumnType(rs.getString("data_type"));
                column.setRemark(rs.getString("column_comment"));
                column.setNotNull("NO".equalsIgnoreCase(rs.getString("is_nullable")));
                if (Arrays.asList("decimal", "double", "float").contains(column.getColumnType())) {
                    column.setLength(rs.getInt("numeric_precision"));
                    column.setScale(rs.getInt("numeric_scale"));
                } else if (Arrays.asList("text", "tinytext", "mediumtext", "longtext", "blob", "tinyblob", "mediumblob", "longblob").contains(column.getColumnType())) {
                    column.setLength(0);
                } else {
                    column.setLength(rs.getInt("character_maximum_length"));
                }
                column.setKeyType(rs.getString("column_key"));
                column.setExtra(rs.getString("extra"));
                cols.add(column);
            }
        }
        catch (SQLException e) {
            throw new GeneratorException("\u65e0\u6cd5\u83b7\u53d6[" + table + "]\u8868\u7684\u5217\u4fe1\u606f", e);
        }
        return cols;
    }

    private void checkDatabase(String schema) {
        List<String> databases = this.listDatabase();
        if (!databases.contains(schema)) {
            throw new GeneratorException("\u6570\u636e\u5e93 [" + schema + "] \u4e0d\u5b58\u5728");
        }
    }

    private void checkTable(String table, String schema) {
        List<Table> tables = this.listAllTable();
        List tableNames = tables.stream().map(Table::getTableName).collect(Collectors.toList());
        if (!tableNames.contains(table)) {
            throw new GeneratorException("\u6570\u636e\u5e93 [" + schema + "] \u4e2d\u4e0d\u5b58\u5728 [" + table + "] \u8868");
        }
    }
}

