/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.houtu.config;

import java.util.HashMap;
import java.util.Map;
import me.zhyd.houtu.config.JdbcType;

public class TypeMapping {
    private static final String STRING_TYPE = "java.lang.String";
    private static Map<Integer, String> mapping = new HashMap<Integer, String>();

    public static String getJavaType(String sqlType) {
        if (null == sqlType || sqlType.isEmpty()) {
            return STRING_TYPE;
        }
        JdbcType jdbcType = JdbcType.getJdbcTypeBySqlType(sqlType);
        if (mapping.containsKey(jdbcType.getCode())) {
            return mapping.get(jdbcType.getCode());
        }
        return STRING_TYPE;
    }

    static {
        mapping.put(-6, "java.lang.Boolean");
        mapping.put(5, "java.lang.Integer");
        mapping.put(4, "java.lang.Integer");
        mapping.put(-5, "java.lang.Long");
        mapping.put(7, "java.lang.Float");
        mapping.put(6, "java.lang.Double");
        mapping.put(8, "java.lang.Double");
        mapping.put(3, "java.math.BigDecimal");
        mapping.put(2, "java.math.BigDecimal");
        mapping.put(-7, "java.lang.Boolean");
        mapping.put(16, "java.lang.Boolean");
        mapping.put(1, STRING_TYPE);
        mapping.put(12, STRING_TYPE);
        mapping.put(-1, STRING_TYPE);
        mapping.put(-2, "byte[]");
        mapping.put(-3, "byte[]");
        mapping.put(-4, "byte[]");
        mapping.put(91, "java.util.Date");
        mapping.put(92, "java.util.Date");
        mapping.put(93, "java.util.Date");
        mapping.put(2005, STRING_TYPE);
        mapping.put(2004, STRING_TYPE);
        mapping.put(2003, "String[]");
        mapping.put(2006, "java.lang.Object");
        mapping.put(2002, "java.lang.Object");
        mapping.put(2000, "java.lang.Object");
    }
}

