/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.houtu.config;

public enum JdbcType {
    BIT(-7),
    TINYINT(-6),
    SMALLINT(5),
    INTEGER(4),
    BIGINT(-5),
    FLOAT(6),
    REAL(7),
    DOUBLE(8),
    NUMERIC(2),
    DECIMAL(3),
    CHAR(1),
    VARCHAR(12),
    LONGVARCHAR(-1),
    DATE(91),
    DATETIME(91),
    TIME(92),
    TIMESTAMP(93),
    BINARY(-2),
    VARBINARY(-3),
    LONGVARBINARY(-4),
    NULL(0),
    OTHER(1111),
    BLOB(2004),
    CLOB(2005),
    BOOLEAN(16),
    CURSOR(-10),
    UNDEFINED(-2147482648),
    NVARCHAR(-9),
    NCHAR(-15),
    NCLOB(2011);

    public final int code;

    public static String getJdbcSqlTypeName(int code) {
        for (JdbcType type : JdbcType.values()) {
            if (type.getCode() != code) continue;
            return type.name();
        }
        return null;
    }

    public static JdbcType getJdbcTypeBySqlType(String sqlType) {
        if ("int".equalsIgnoreCase(sqlType)) {
            return INTEGER;
        }
        for (JdbcType type : JdbcType.values()) {
            if (!sqlType.equalsIgnoreCase(type.name())) continue;
            return type;
        }
        return VARCHAR;
    }

    public int getCode() {
        return this.code;
    }

    private JdbcType(int code) {
        this.code = code;
    }
}

