/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.houtu;

import cn.hutool.core.io.FileUtil;
import com.alibaba.fastjson.JSONObject;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import me.zhyd.houtu.config.Config;
import me.zhyd.houtu.core.GeneratorHelper;
import me.zhyd.houtu.entity.Table;
import me.zhyd.houtu.entity.Template;
import me.zhyd.houtu.util.FreemarkerUtil;
import me.zhyd.houtu.util.ListUtil;
import me.zhyd.houtu.util.StringUtils;
import me.zhyd.houtu.util.TemplateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Generator {
    private static final Logger log = LoggerFactory.getLogger(Generator.class);
    List<Template> templates = null;
    boolean generateAll = false;
    private GeneratorHelper helper;

    public Generator(Config config) {
        this.helper = new GeneratorHelper(config);
        this.templates = TemplateUtil.listTemplates(config.getTemplatePath());
    }

    private void printBeginProcess(String tableName) {
        log.info("---------------------------------------------------------------");
        log.info("- BEGIN generate by " + tableName);
        log.info("---------------------------------------------------------------");
    }

    public void printAllTableInfo() {
        log.info("----All Table Names Begin----");
        List<Table> tableList = this.helper.listAllTable();
        for (Table table : tableList) {
            log.info("  {} - \"{}\" - {}", new Object[]{table.getEngine(), table.getTableName(), table.getCoding()});
        }
        log.info("----All Table Names END----");
    }

    public void deleteOutRootDir() {
        String outRootDir = this.helper.getConfig().getOutRootDir();
        if (StringUtils.isEmpty(outRootDir)) {
            throw new IllegalStateException("'outRootDir' property must be not null.");
        }
        log.info("[delete dir]    " + outRootDir);
        FileUtil.del((String)outRootDir);
    }

    public void generate(String ... tableNames) {
        if (null == tableNames || tableNames.length == 0) {
            this.generateAll();
            return;
        }
        for (String tableName : tableNames) {
            this.printBeginProcess(tableName);
            Table table = this.helper.getTableInfo(tableName);
            this.generate(table);
        }
        if (!this.generateAll) {
            this.helper.destroy();
        }
    }

    private void generate(Table ... tables) {
        if (null == tables || tables.length == 0) {
            this.generateAll();
            return;
        }
        Config config = this.helper.getConfig();
        Map params = (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)config), Map.class);
        for (Table table : tables) {
            this.printBeginProcess(table.getTableName());
            params.put("table", table);
            List<Template> itemTemplate = ListUtil.deepClone(this.templates, Template.class);
            for (Template template : itemTemplate) {
                String filePath = FreemarkerUtil.template2String(template.getFilePath(), params, false);
                template.setFilePath(filePath);
                template.setFileContent(FreemarkerUtil.template2String(template.getFileContent(), params, false));
            }
            this.generateFiles(itemTemplate);
        }
    }

    public void generateAll() {
        this.generateAll = true;
        List<Table> tables = this.helper.listAllTable();
        for (Table table : tables) {
            this.generate(table);
        }
        this.helper.destroy();
        this.generateAll = false;
    }

    public void generateByPrefix(String prefix) {
        if (null == prefix) {
            this.generateAll();
            return;
        }
        List<Table> tables = this.helper.listAllTable();
        for (Table table : tables) {
            if (!table.getTableName().startsWith(prefix)) continue;
            this.generate(table);
        }
        this.helper.destroy();
    }

    private void generateFiles(List<Template> files) {
        Config config = this.helper.getConfig();
        for (Template file : files) {
            String finalOutPath = config.getOutRootDir() + file.getFilePath();
            log.info(finalOutPath);
            FileUtil.writeString((String)file.getFileContent(), (String)finalOutPath, (Charset)StandardCharsets.UTF_8);
        }
    }
}

