/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.braum.spring.boot.context;

import java.security.CodeSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BraumVersion {
    private static final Logger log = LoggerFactory.getLogger(BraumVersion.class);

    public static String getVersion(String defaultVersion) {
        try {
            Class<BraumVersion> clazz = BraumVersion.class;
            String version = clazz.getPackage().getImplementationVersion();
            if (version == null || version.length() == 0) {
                version = clazz.getPackage().getSpecificationVersion();
            }
            if (version == null || version.length() == 0) {
                CodeSource codeSource = clazz.getProtectionDomain().getCodeSource();
                if (codeSource == null) {
                    log.warn("No codeSource for class " + clazz.getName() + " when getVersion, use default version " + defaultVersion);
                } else {
                    String file = codeSource.getLocation().getFile();
                    if (file != null && file.length() > 0 && file.endsWith(".jar")) {
                        int i = (file = file.substring(0, file.length() - 4)).lastIndexOf(47);
                        if (i >= 0) {
                            file = file.substring(i + 1);
                        }
                        if ((i = file.indexOf("-")) >= 0) {
                            file = file.substring(i + 1);
                        }
                        while (file.length() > 0 && !Character.isDigit(file.charAt(0)) && (i = file.indexOf("-")) >= 0) {
                            file = file.substring(i + 1);
                        }
                        version = file;
                    }
                }
            }
            return version != null && version.length() != 0 ? version : defaultVersion;
        }
        catch (Throwable var6) {
            log.error("return default version, ignore exception " + var6.getMessage(), var6);
            return defaultVersion;
        }
    }
}

