/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.braum.spring.boot.cache;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public enum CacheScheduler {
    INSTANCE;

    private AtomicInteger cacheTaskNumber = new AtomicInteger(1);
    private ScheduledExecutorService scheduler;

    private CacheScheduler() {
        this.shutdown();
        this.scheduler = new ScheduledThreadPoolExecutor(10, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, String.format("Braum-Task-%s", CacheScheduler.this.cacheTaskNumber.getAndIncrement()));
            }
        });
    }

    private void shutdown() {
        if (null != this.scheduler) {
            this.scheduler.shutdown();
        }
    }

    public ScheduledFuture<?> schedule(Runnable task, long delay, TimeUnit unit) {
        return this.scheduler.schedule(task, delay, unit);
    }
}

