/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.braum.spring.boot;

import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import me.zhyd.braum.spring.boot.BraumProcessor;
import me.zhyd.braum.spring.boot.BraumResponse;
import me.zhyd.braum.spring.boot.cache.Cache;
import me.zhyd.braum.spring.boot.cache.CacheObj;
import me.zhyd.braum.spring.boot.property.BraumProperties;
import me.zhyd.braum.spring.boot.utils.GlobalBraumUtil;
import me.zhyd.braum.spring.boot.utils.RequestUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class BraumShieldProcessor
implements BraumProcessor {
    private static final Logger log = LoggerFactory.getLogger(BraumShieldProcessor.class);
    @Autowired
    private BraumProperties properties;
    @Autowired
    @Qualifier(value="braumCache")
    private Cache cache;

    @Override
    public BraumResponse process(HttpServletRequest request) {
        RequestUtil requestUtil = new RequestUtil(request);
        String ip = requestUtil.getIp();
        String key = GlobalBraumUtil.INSTANCE.formatKey(ip);
        String lockKey = GlobalBraumUtil.INSTANCE.getLockKey(key);
        String lockMsgTpl = "[%s]\u6d89\u5acc\u6076\u610f\u8bbf\u95ee\u5df2\u88ab\u4e34\u65f6\u9650\u5236\uff01\u5171\u88ab\u9650\u5236\u8fc7[%s]\u6b21\uff0c\u672c\u6b21\u5269\u4f59\u9650\u5236\u65f6\u95f4:%s ms";
        String accessMsgTpl = "[%s]\u5728%s\u6beb\u79d2\u5185\u5df2\u8fde\u7eed\u53d1\u8d77 %s \u6b21\u8bf7\u6c42";
        if (this.cache.hasKey(lockKey).booleanValue()) {
            int blocklistCount = this.getBlacklistCount(key);
            long expire = this.cache.getExpire(lockKey);
            String msg = String.format(lockMsgTpl, ip, blocklistCount, expire);
            log.debug(msg);
            return new BraumResponse().isError().setMsg(msg).setExpire(expire).setLimitCount(blocklistCount).setAccessInfo(request);
        }
        if (this.isLimitedAccess(key)) {
            this.save2Blacklist(key);
            this.cache.set(lockKey, 1, this.properties.getLimitedTime(), TimeUnit.MILLISECONDS);
            long expire = this.cache.getExpire(lockKey);
            int blocklistCount = this.getBlacklistCount(key);
            String msg = String.format(lockMsgTpl, ip, blocklistCount, expire);
            log.debug(msg);
            return new BraumResponse().isError().setMsg(msg).setExpire(expire).setLimitCount(blocklistCount).setAccessInfo(request);
        }
        String msg = String.format(accessMsgTpl, ip, this.properties.getInterval(), this.cache.get(key).getValue());
        log.debug(msg);
        return new BraumResponse().isSuccess().setMsg(msg).setAccessInfo(request);
    }

    private void save2Blacklist(String ip) {
        String blacklistKey = GlobalBraumUtil.INSTANCE.getBlacklistKey(ip);
        this.cache.set(blacklistKey, this.getBlacklistCount(ip) + 1, this.properties.getBlacklistTime(), TimeUnit.MILLISECONDS);
    }

    private int getBlacklistCount(String ip) {
        String blacklistKey = GlobalBraumUtil.INSTANCE.getBlacklistKey(ip);
        CacheObj blacklistCache = this.cache.get(blacklistKey);
        if (null == blacklistCache) {
            return 0;
        }
        return blacklistCache.getValue();
    }

    private boolean isLimitedAccess(String ip) {
        return this.cache.incrementAndGet(ip) > this.properties.getThreshold();
    }
}

