/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.braum.spring.boot;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import me.zhyd.braum.spring.boot.annotation.EnableBraumConfiguration;
import me.zhyd.braum.spring.boot.property.BraumProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.GenericJackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;

@Configuration
@ConditionalOnBean(annotation={EnableBraumConfiguration.class})
@EnableConfigurationProperties(value={BraumProperties.class})
@ConditionalOnProperty(name={"braum.limit.access.type"}, havingValue="redis")
public class BraumRedisAutoConfiguration {
    @Bean
    public RedisTemplate redisTemplate(RedisConnectionFactory factory) {
        RedisTemplate template = new RedisTemplate();
        template.setConnectionFactory(factory);
        ObjectMapper om = new ObjectMapper();
        om.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
        om.enableDefaultTyping(ObjectMapper.DefaultTyping.NON_FINAL);
        GenericJackson2JsonRedisSerializer jackson2JsonRedisSerializer = new GenericJackson2JsonRedisSerializer(om);
        template.setValueSerializer((RedisSerializer)jackson2JsonRedisSerializer);
        template.setKeySerializer((RedisSerializer)jackson2JsonRedisSerializer);
        template.afterPropertiesSet();
        return template;
    }
}

