/*
 * Decompiled with CFR 0.152.
 */
package me.ihxq.projects.pna;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import me.ihxq.projects.pna.PhoneNumberInfo;
import me.ihxq.projects.pna.algorithm.BinarySearchAlgorithmImpl;
import me.ihxq.projects.pna.algorithm.LookupAlgorithm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoneNumberLookup {
    private static final Logger log = LoggerFactory.getLogger(PhoneNumberLookup.class);
    private static final String PHONE_NUMBER_GEO_PHONE_DAT = "phone.dat";
    private final LookupAlgorithm lookupAlgorithm;
    private static final int DATA_HASH = 1990190400;

    private void init() {
        try {
            byte[] allBytes;
            try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(PHONE_NUMBER_GEO_PHONE_DAT);
                 ByteArrayOutputStream output = new ByteArrayOutputStream();){
                int n;
                byte[] buffer = new byte[4096];
                while (-1 != (n = Objects.requireNonNull(inputStream, "PhoneNumberLookup: Failed to get inputStream.").read(buffer))) {
                    output.write(buffer, 0, n);
                }
                allBytes = output.toByteArray();
            }
            int hashCode = Arrays.hashCode(allBytes);
            log.debug("loaded datasource, size: {}, hash: {}", (Object)allBytes.length, (Object)hashCode);
            if (hashCode != 1990190400) {
                throw new IllegalStateException("Hash of data not match, expect: 1990190400, actually: " + hashCode);
            }
            this.lookupAlgorithm.loadData(allBytes);
        }
        catch (Exception e) {
            log.error("failed to init PhoneNumberLookUp", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public PhoneNumberLookup() {
        this(new BinarySearchAlgorithmImpl());
    }

    public PhoneNumberLookup(LookupAlgorithm lookupAlgorithm) {
        this.lookupAlgorithm = lookupAlgorithm;
        this.init();
    }

    public Optional<PhoneNumberInfo> lookup(String phoneNumber) {
        return this.lookupAlgorithm.lookup(phoneNumber);
    }
}

