/*
 * Decompiled with CFR 0.152.
 */
package zipkin.storage.mysql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.jooq.Condition;
import org.jooq.Cursor;
import org.jooq.DSLContext;
import org.jooq.Record;
import org.jooq.Row3;
import org.jooq.SelectConditionStep;
import org.jooq.SelectOffsetStep;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.TableOnConditionStep;
import org.jooq.impl.DSL;
import zipkin.Annotation;
import zipkin.BinaryAnnotation;
import zipkin.DependencyLink;
import zipkin.Endpoint;
import zipkin.Span;
import zipkin.internal.DependencyLinker;
import zipkin.internal.GroupByTraceId;
import zipkin.internal.Nullable;
import zipkin.internal.Pair;
import zipkin.internal.Util;
import zipkin.storage.QueryRequest;
import zipkin.storage.SpanStore;
import zipkin.storage.mysql.DSLContexts;
import zipkin.storage.mysql.DependencyLinkV2SpanIterator;
import zipkin.storage.mysql.Schema;
import zipkin.storage.mysql.internal.generated.tables.ZipkinAnnotations;
import zipkin.storage.mysql.internal.generated.tables.ZipkinDependencies;
import zipkin.storage.mysql.internal.generated.tables.ZipkinSpans;

final class MySQLSpanStore
implements SpanStore {
    private final DataSource datasource;
    private final DSLContexts context;
    private final Schema schema;
    private final boolean strictTraceId;

    MySQLSpanStore(DataSource datasource, DSLContexts context, Schema schema, boolean strictTraceId) {
        this.datasource = datasource;
        this.context = context;
        this.schema = schema;
        this.strictTraceId = strictTraceId;
    }

    private Endpoint endpoint(Record a) {
        String serviceName = (String)a.getValue(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.ENDPOINT_SERVICE_NAME);
        if (serviceName == null) {
            return null;
        }
        return Endpoint.builder().serviceName(serviceName).port((Short)a.getValue(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.ENDPOINT_PORT)).ipv4(((Integer)a.getValue(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.ENDPOINT_IPV4)).intValue()).ipv6((byte[])MySQLSpanStore.maybeGet(a, ZipkinAnnotations.ZIPKIN_ANNOTATIONS.ENDPOINT_IPV6, null)).build();
    }

    SelectOffsetStep<? extends Record> toTraceIdQuery(DSLContext context, QueryRequest request) {
        ZipkinAnnotations aTable;
        long endTs = request.endTs > 0L && request.endTs != Long.MAX_VALUE ? request.endTs * 1000L : System.currentTimeMillis() * 1000L;
        TableOnConditionStep<?> table = ZipkinSpans.ZIPKIN_SPANS.join((TableLike)ZipkinAnnotations.ZIPKIN_ANNOTATIONS).on(new Condition[]{this.schema.joinCondition(ZipkinAnnotations.ZIPKIN_ANNOTATIONS)});
        int i = 0;
        for (String string : request.annotations) {
            aTable = ZipkinAnnotations.ZIPKIN_ANNOTATIONS.as("a" + i++);
            table = MySQLSpanStore.maybeOnService((TableOnConditionStep<Record>)table.join((TableLike)aTable).on(new Condition[]{this.schema.joinCondition(aTable)}).and(aTable.A_KEY.eq((Object)string)), aTable, request.serviceName);
        }
        for (Map.Entry entry : request.binaryAnnotations.entrySet()) {
            aTable = ZipkinAnnotations.ZIPKIN_ANNOTATIONS.as("a" + i++);
            table = MySQLSpanStore.maybeOnService((TableOnConditionStep<Record>)table.join((TableLike)aTable).on(new Condition[]{this.schema.joinCondition(aTable)}).and(aTable.A_TYPE.eq((Object)BinaryAnnotation.Type.STRING.value)).and(aTable.A_KEY.eq((Object)((String)entry.getKey()))).and(aTable.A_VALUE.eq((Object)((String)entry.getValue()).getBytes(Util.UTF_8))), aTable, request.serviceName);
        }
        ArrayList distinctFields = new ArrayList(this.schema.spanIdFields);
        distinctFields.add(ZipkinSpans.ZIPKIN_SPANS.START_TS.max());
        SelectConditionStep selectConditionStep = context.selectDistinct(distinctFields).from((TableLike)table).where(new Condition[]{ZipkinSpans.ZIPKIN_SPANS.START_TS.between((Object)(endTs - request.lookback * 1000L), (Object)endTs)});
        if (request.serviceName != null) {
            selectConditionStep.and(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.ENDPOINT_SERVICE_NAME.eq((Object)request.serviceName));
        }
        if (request.spanName != null) {
            selectConditionStep.and(ZipkinSpans.ZIPKIN_SPANS.NAME.eq((Object)request.spanName));
        }
        if (request.minDuration != null && request.maxDuration != null) {
            selectConditionStep.and(ZipkinSpans.ZIPKIN_SPANS.DURATION.between((Object)request.minDuration, (Object)request.maxDuration));
        } else if (request.minDuration != null) {
            selectConditionStep.and(ZipkinSpans.ZIPKIN_SPANS.DURATION.greaterOrEqual((Object)request.minDuration));
        }
        return selectConditionStep.groupBy(this.schema.spanIdFields).orderBy(ZipkinSpans.ZIPKIN_SPANS.START_TS.max().desc()).limit(request.limit);
    }

    static TableOnConditionStep<?> maybeOnService(TableOnConditionStep<Record> table, ZipkinAnnotations aTable, String serviceName) {
        if (serviceName == null) {
            return table;
        }
        return table.and(aTable.ENDPOINT_SERVICE_NAME.eq((Object)serviceName));
    }

    List<List<Span>> getTraces(@Nullable QueryRequest request, @Nullable Long traceIdHigh, @Nullable Long traceIdLow, boolean raw) {
        Map dbAnnotations;
        Map spansWithoutAnnotations;
        if (traceIdHigh != null && !this.strictTraceId) {
            traceIdHigh = null;
        }
        try {
            Connection conn = this.datasource.getConnection();
            Object object = null;
            try {
                Condition traceIdCondition = request != null ? this.schema.spanTraceIdCondition(this.toTraceIdQuery(this.context.get(conn), request)) : this.schema.spanTraceIdCondition(traceIdHigh, traceIdLow);
                spansWithoutAnnotations = this.context.get(conn).select(this.schema.spanFields).from((TableLike)ZipkinSpans.ZIPKIN_SPANS).where(new Condition[]{traceIdCondition}).stream().map(r -> Span.builder().traceIdHigh(MySQLSpanStore.maybeGet(r, ZipkinSpans.ZIPKIN_SPANS.TRACE_ID_HIGH, 0L).longValue()).traceId(((Long)r.getValue(ZipkinSpans.ZIPKIN_SPANS.TRACE_ID)).longValue()).name((String)r.getValue(ZipkinSpans.ZIPKIN_SPANS.NAME)).id(((Long)r.getValue(ZipkinSpans.ZIPKIN_SPANS.ID)).longValue()).parentId((Long)r.getValue(ZipkinSpans.ZIPKIN_SPANS.PARENT_ID)).timestamp((Long)r.getValue(ZipkinSpans.ZIPKIN_SPANS.START_TS)).duration((Long)r.getValue(ZipkinSpans.ZIPKIN_SPANS.DURATION)).debug((Boolean)r.getValue(ZipkinSpans.ZIPKIN_SPANS.DEBUG)).build()).collect(Collectors.groupingBy(s -> Pair.create((Object)s.traceIdHigh, (Object)s.traceId), LinkedHashMap::new, Collectors.toList()));
                dbAnnotations = this.context.get(conn).select(this.schema.annotationFields).from((TableLike)ZipkinAnnotations.ZIPKIN_ANNOTATIONS).where(new Condition[]{this.schema.annotationsTraceIdCondition(spansWithoutAnnotations.keySet())}).orderBy(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.A_TIMESTAMP.asc(), ZipkinAnnotations.ZIPKIN_ANNOTATIONS.A_KEY.asc()).stream().collect(Collectors.groupingBy(a -> DSL.row((Object)MySQLSpanStore.maybeGet(a, ZipkinAnnotations.ZIPKIN_ANNOTATIONS.TRACE_ID_HIGH, 0L), (Object)((Long)a.getValue(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.TRACE_ID)), (Object)((Long)a.getValue(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.SPAN_ID))), LinkedHashMap::new, Collectors.toList()));
            }
            catch (Throwable traceIdCondition) {
                object = traceIdCondition;
                throw traceIdCondition;
            }
            finally {
                if (conn != null) {
                    MySQLSpanStore.$closeResource((Throwable)object, conn);
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Error querying for " + request + ": " + e.getMessage());
        }
        ArrayList<Span> allSpans = new ArrayList<Span>(spansWithoutAnnotations.size());
        for (List spans : spansWithoutAnnotations.values()) {
            for (Span s2 : spans) {
                Span.Builder span = s2.toBuilder();
                Row3 key = DSL.row((Object)s2.traceIdHigh, (Object)s2.traceId, (Object)s2.id);
                if (dbAnnotations.containsKey(key)) {
                    for (Record a2 : (List)dbAnnotations.get(key)) {
                        Endpoint endpoint = this.endpoint(a2);
                        int type = (Integer)a2.getValue(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.A_TYPE);
                        if (type == -1) {
                            span.addAnnotation(Annotation.create((long)((Long)a2.getValue(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.A_TIMESTAMP)), (String)((String)a2.getValue(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.A_KEY)), (Endpoint)endpoint));
                            continue;
                        }
                        span.addBinaryAnnotation(BinaryAnnotation.create((String)((String)a2.getValue(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.A_KEY)), (byte[])((byte[])a2.getValue(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.A_VALUE)), (BinaryAnnotation.Type)BinaryAnnotation.Type.fromValue((int)type), (Endpoint)endpoint));
                    }
                }
                allSpans.add(span.build());
            }
        }
        return GroupByTraceId.apply(allSpans, (boolean)this.strictTraceId, (!raw ? 1 : 0) != 0);
    }

    static <T> T maybeGet(Record record, TableField<Record, T> field, T defaultValue) {
        if (record.fieldsRow().indexOf(field) < 0) {
            return defaultValue;
        }
        return (T)record.get(field);
    }

    public List<List<Span>> getTraces(QueryRequest request) {
        return this.getTraces(request, null, null, false);
    }

    public List<Span> getTrace(long traceId) {
        return this.getTrace(0L, traceId);
    }

    public List<Span> getTrace(long traceIdHigh, long traceIdLow) {
        List<List<Span>> result = this.getTraces(null, traceIdHigh, traceIdLow, false);
        return result.isEmpty() ? null : result.get(0);
    }

    public List<Span> getRawTrace(long traceId) {
        return this.getRawTrace(0L, traceId);
    }

    public List<Span> getRawTrace(long traceIdHigh, long traceIdLow) {
        List<List<Span>> result = this.getTraces(null, traceIdHigh, traceIdLow, true);
        return result.isEmpty() ? null : result.get(0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> getServiceNames() {
        try (Connection conn = this.datasource.getConnection();){
            List list = this.context.get(conn).selectDistinct(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.ENDPOINT_SERVICE_NAME).from((TableLike)ZipkinAnnotations.ZIPKIN_ANNOTATIONS).where(new Condition[]{ZipkinAnnotations.ZIPKIN_ANNOTATIONS.ENDPOINT_SERVICE_NAME.isNotNull().and(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.ENDPOINT_SERVICE_NAME.ne((Object)""))}).fetch(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.ENDPOINT_SERVICE_NAME);
            return list;
        }
        catch (SQLException e) {
            throw new RuntimeException("Error querying for " + e + ": " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> getSpanNames(String serviceName) {
        if (serviceName == null) {
            return Collections.emptyList();
        }
        serviceName = serviceName.toLowerCase();
        try (Connection conn = this.datasource.getConnection();){
            List list = this.context.get(conn).selectDistinct(ZipkinSpans.ZIPKIN_SPANS.NAME).from((TableLike)ZipkinSpans.ZIPKIN_SPANS).join((TableLike)ZipkinAnnotations.ZIPKIN_ANNOTATIONS).on(new Condition[]{this.schema.joinCondition(ZipkinAnnotations.ZIPKIN_ANNOTATIONS)}).where(new Condition[]{ZipkinAnnotations.ZIPKIN_ANNOTATIONS.ENDPOINT_SERVICE_NAME.eq((Object)serviceName)}).orderBy(ZipkinSpans.ZIPKIN_SPANS.NAME).fetch(ZipkinSpans.ZIPKIN_SPANS.NAME);
            return list;
        }
        catch (SQLException e) {
            throw new RuntimeException("Error querying for " + serviceName + ": " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<DependencyLink> getDependencies(long endTs, @Nullable Long lookback) {
        try (Connection conn = this.datasource.getConnection();){
            if (this.schema.hasPreAggregatedDependencies) {
                List days = Util.getDays((long)endTs, (Long)lookback);
                List unmerged = this.context.get(conn).select(this.schema.dependencyLinkFields).from((TableLike)ZipkinDependencies.ZIPKIN_DEPENDENCIES).where(new Condition[]{ZipkinDependencies.ZIPKIN_DEPENDENCIES.DAY.in((Collection)days)}).fetch(l -> DependencyLink.builder().parent((String)l.get(ZipkinDependencies.ZIPKIN_DEPENDENCIES.PARENT)).child((String)l.get(ZipkinDependencies.ZIPKIN_DEPENDENCIES.CHILD)).callCount(((Long)l.get(ZipkinDependencies.ZIPKIN_DEPENDENCIES.CALL_COUNT)).longValue()).errorCount(MySQLSpanStore.maybeGet(l, ZipkinDependencies.ZIPKIN_DEPENDENCIES.ERROR_COUNT, 0L).longValue()).build());
                List list = DependencyLinker.merge((Iterable)unmerged);
                return list;
            }
            List<DependencyLink> list = this.aggregateDependencies(endTs, lookback, conn);
            return list;
        }
        catch (SQLException e) {
            throw new RuntimeException("Error querying dependencies for endTs " + endTs + " and lookback " + lookback + ": " + e.getMessage());
        }
    }

    List<DependencyLink> aggregateDependencies(long endTs, @Nullable Long lookback, Connection conn) {
        Cursor cursor = this.context.get(conn).selectDistinct(this.schema.dependencyLinkerFields).from((TableLike)ZipkinSpans.ZIPKIN_SPANS.leftJoin((TableLike)ZipkinAnnotations.ZIPKIN_ANNOTATIONS).on(new Condition[]{ZipkinSpans.ZIPKIN_SPANS.TRACE_ID.eq(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.TRACE_ID).and(ZipkinSpans.ZIPKIN_SPANS.ID.eq(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.SPAN_ID))}).and(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.A_KEY.in((Object[])new String[]{"cs", "ca", "sr", "sa", "error"}))).where(new Condition[]{lookback == null ? ZipkinSpans.ZIPKIN_SPANS.START_TS.lessOrEqual((Object)endTs) : ZipkinSpans.ZIPKIN_SPANS.START_TS.between((Object)((endTs *= 1000L) - lookback * 1000L), (Object)endTs)}).groupBy(this.schema.dependencyLinkerGroupByFields).fetchLazy();
        DependencyLinkV2SpanIterator.ByTraceId traces = new DependencyLinkV2SpanIterator.ByTraceId(cursor.iterator(), this.schema.hasTraceIdHigh);
        if (!traces.hasNext()) {
            return Collections.emptyList();
        }
        DependencyLinker linker = new DependencyLinker();
        while (traces.hasNext()) {
            linker.putTrace((Iterator)traces.next());
        }
        return linker.link();
    }
}

