/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.server.internal;

import brave.Tracing;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.config.MeterFilter;
import io.undertow.server.HandlerWrapper;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.actuate.autoconfigure.metrics.MeterRegistryCustomizer;
import org.springframework.boot.actuate.health.HealthAggregator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.web.embedded.undertow.UndertowDeploymentInfoCustomizer;
import org.springframework.boot.web.embedded.undertow.UndertowServletWebServerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import zipkin2.collector.CollectorMetrics;
import zipkin2.collector.CollectorSampler;
import zipkin2.server.internal.ActuateCollectorMetrics;
import zipkin2.server.internal.ConditionalOnSelfTracing;
import zipkin2.server.internal.CorsHandler;
import zipkin2.server.internal.ZipkinHealthIndicator;
import zipkin2.server.internal.ZipkinHttpCollector;
import zipkin2.server.internal.brave.TracingStorageComponent;
import zipkin2.storage.InMemoryStorage;
import zipkin2.storage.StorageComponent;

@Configuration
public class ZipkinServerConfiguration
implements WebMvcConfigurer {
    @Autowired(required=false)
    @Qualifier(value="httpTracingCustomizer")
    UndertowDeploymentInfoCustomizer httpTracingCustomizer;
    @Autowired(required=false)
    @Qualifier(value="httpRequestDurationCustomizer")
    UndertowDeploymentInfoCustomizer httpRequestDurationCustomizer;
    @Autowired(required=false)
    ZipkinHttpCollector httpCollector;

    @Bean
    ZipkinHealthIndicator zipkinHealthIndicator(HealthAggregator healthAggregator) {
        return new ZipkinHealthIndicator(healthAggregator);
    }

    public void addViewControllers(ViewControllerRegistry registry) {
        registry.addRedirectViewController("/info", "/actuator/info");
    }

    @Bean
    public UndertowServletWebServerFactory embeddedServletContainerFactory(@Value(value="${zipkin.query.allowed-origins:*}") String allowedOrigins) {
        UndertowServletWebServerFactory factory = new UndertowServletWebServerFactory();
        CorsHandler cors = new CorsHandler(allowedOrigins);
        if (this.httpCollector != null) {
            factory.addDeploymentInfoCustomizers(new UndertowDeploymentInfoCustomizer[]{info -> info.addInitialHandlerChainWrapper((HandlerWrapper)this.httpCollector)});
        }
        factory.addDeploymentInfoCustomizers(new UndertowDeploymentInfoCustomizer[]{info -> info.addInitialHandlerChainWrapper((HandlerWrapper)cors)});
        if (this.httpTracingCustomizer != null) {
            factory.addDeploymentInfoCustomizers(new UndertowDeploymentInfoCustomizer[]{this.httpTracingCustomizer});
        }
        if (this.httpRequestDurationCustomizer != null) {
            factory.addDeploymentInfoCustomizers(new UndertowDeploymentInfoCustomizer[]{this.httpRequestDurationCustomizer});
        }
        return factory;
    }

    @Bean
    @ConditionalOnMissingBean(value={CollectorSampler.class})
    CollectorSampler traceIdSampler(@Value(value="${zipkin.collector.sample-rate:1.0}") float rate) {
        return CollectorSampler.create((float)rate);
    }

    @Bean
    @ConditionalOnMissingBean(value={CollectorMetrics.class})
    CollectorMetrics metrics(MeterRegistry registry) {
        return new ActuateCollectorMetrics(registry);
    }

    @Bean
    public MeterRegistryCustomizer meterRegistryCustomizer() {
        return registry -> registry.config().meterFilter(MeterFilter.deny(id -> {
            String uri = id.getTag("uri");
            return uri != null && (uri.startsWith("/actuator") || uri.startsWith("/metrics") || uri.startsWith("/health") || uri.startsWith("/favicon.ico") || uri.startsWith("/prometheus"));
        }));
    }

    static final class StorageTypeMemAbsentOrEmpty
    implements Condition {
        StorageTypeMemAbsentOrEmpty() {
        }

        public boolean matches(ConditionContext condition, AnnotatedTypeMetadata ignored) {
            String storageType = condition.getEnvironment().getProperty("zipkin.storage.type");
            if (storageType == null) {
                return true;
            }
            if ((storageType = storageType.trim()).isEmpty()) {
                return true;
            }
            return storageType.equals("mem");
        }
    }

    @Configuration
    @Conditional(value={StorageTypeMemAbsentOrEmpty.class})
    @ConditionalOnMissingBean(value={StorageComponent.class})
    static class InMemoryConfiguration {
        InMemoryConfiguration() {
        }

        @Bean
        StorageComponent storage(@Value(value="${zipkin.storage.strict-trace-id:true}") boolean strictTraceId, @Value(value="${zipkin.storage.search-enabled:true}") boolean searchEnabled, @Value(value="${zipkin.storage.mem.max-spans:500000}") int maxSpans, @Value(value="${zipkin.storage.autocomplete-keys:}") List<String> autocompleteKeys) {
            return InMemoryStorage.newBuilder().strictTraceId(strictTraceId).searchEnabled(searchEnabled).maxSpanCount(maxSpans).autocompleteKeys(autocompleteKeys).build();
        }
    }

    @Configuration
    @ConditionalOnSelfTracing
    static class TracingStorageComponentEnhancer
    implements BeanPostProcessor {
        @Autowired(required=false)
        Tracing tracing;

        TracingStorageComponentEnhancer() {
        }

        public Object postProcessBeforeInitialization(Object bean, String beanName) {
            return bean;
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) {
            if (this.tracing == null) {
                return bean;
            }
            if (bean instanceof StorageComponent) {
                return new TracingStorageComponent(this.tracing, (StorageComponent)bean);
            }
            return bean;
        }
    }
}

