/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.sql;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonArray;
import io.vertx.ext.sql.HandlerUtil;
import io.vertx.ext.sql.ResultSet;
import io.vertx.ext.sql.SQLConnection;
import io.vertx.ext.sql.SQLOperations;
import io.vertx.ext.sql.SQLRowStream;
import io.vertx.ext.sql.UpdateResult;
import io.vertx.ext.sql.impl.RowStreamWrapper;

@VertxGen
public interface SQLClient
extends SQLOperations {
    @Fluent
    public SQLClient getConnection(Handler<AsyncResult<SQLConnection>> var1);

    public void close(Handler<AsyncResult<Void>> var1);

    public void close();

    @Override
    @Fluent
    default public SQLClient query(String sql, Handler<AsyncResult<ResultSet>> handler) {
        this.getConnection((Handler<AsyncResult<SQLConnection>>)((Handler)getConnection -> {
            if (getConnection.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)getConnection.cause()));
            } else {
                SQLConnection conn = (SQLConnection)getConnection.result();
                conn.query(sql, query -> {
                    if (query.failed()) {
                        conn.close((Handler<AsyncResult<Void>>)((Handler)close -> {
                            if (close.failed()) {
                                handler.handle((Object)Future.failedFuture((Throwable)close.cause()));
                            } else {
                                handler.handle((Object)Future.failedFuture((Throwable)query.cause()));
                            }
                        }));
                    } else {
                        conn.close((Handler<AsyncResult<Void>>)((Handler)close -> {
                            if (close.failed()) {
                                handler.handle((Object)Future.failedFuture((Throwable)close.cause()));
                            } else {
                                handler.handle((Object)Future.succeededFuture((Object)query.result()));
                            }
                        }));
                    }
                });
            }
        }));
        return this;
    }

    @Override
    @Fluent
    default public SQLClient queryStream(String sql, Handler<AsyncResult<SQLRowStream>> handler) {
        this.getConnection((Handler<AsyncResult<SQLConnection>>)((Handler)getConnection -> {
            if (getConnection.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)getConnection.cause()));
            } else {
                SQLConnection conn = (SQLConnection)getConnection.result();
                conn.queryStream(sql, query -> {
                    if (query.failed()) {
                        conn.close((Handler<AsyncResult<Void>>)((Handler)close -> {
                            if (close.failed()) {
                                handler.handle((Object)Future.failedFuture((Throwable)close.cause()));
                            } else {
                                handler.handle((Object)Future.failedFuture((Throwable)query.cause()));
                            }
                        }));
                    } else {
                        RowStreamWrapper wrapped = new RowStreamWrapper(conn, (SQLRowStream)query.result());
                        handler.handle((Object)Future.succeededFuture((Object)wrapped));
                    }
                });
            }
        }));
        return this;
    }

    @Override
    @Fluent
    default public SQLClient queryStreamWithParams(String sql, JsonArray params, Handler<AsyncResult<SQLRowStream>> handler) {
        this.getConnection((Handler<AsyncResult<SQLConnection>>)((Handler)getConnection -> {
            if (getConnection.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)getConnection.cause()));
            } else {
                SQLConnection conn = (SQLConnection)getConnection.result();
                conn.queryStreamWithParams(sql, params, query -> {
                    if (query.failed()) {
                        conn.close((Handler<AsyncResult<Void>>)((Handler)close -> {
                            if (close.failed()) {
                                handler.handle((Object)Future.failedFuture((Throwable)close.cause()));
                            } else {
                                handler.handle((Object)Future.failedFuture((Throwable)query.cause()));
                            }
                        }));
                    } else {
                        RowStreamWrapper wrapped = new RowStreamWrapper(conn, (SQLRowStream)query.result());
                        handler.handle((Object)Future.succeededFuture((Object)wrapped));
                    }
                });
            }
        }));
        return this;
    }

    @Override
    @Fluent
    default public SQLClient queryWithParams(String sql, JsonArray arguments, Handler<AsyncResult<ResultSet>> handler) {
        this.getConnection((Handler<AsyncResult<SQLConnection>>)((Handler)getConnection -> {
            if (getConnection.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)getConnection.cause()));
            } else {
                SQLConnection conn = (SQLConnection)getConnection.result();
                conn.queryWithParams(sql, arguments, HandlerUtil.closeAndHandleResult(conn, handler));
            }
        }));
        return this;
    }

    @Override
    @Fluent
    default public SQLClient update(String sql, Handler<AsyncResult<UpdateResult>> handler) {
        this.getConnection((Handler<AsyncResult<SQLConnection>>)((Handler)getConnection -> {
            if (getConnection.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)getConnection.cause()));
            } else {
                SQLConnection conn = (SQLConnection)getConnection.result();
                conn.update(sql, HandlerUtil.closeAndHandleResult(conn, handler));
            }
        }));
        return this;
    }

    @Override
    @Fluent
    default public SQLClient updateWithParams(String sql, JsonArray params, Handler<AsyncResult<UpdateResult>> handler) {
        this.getConnection((Handler<AsyncResult<SQLConnection>>)((Handler)getConnection -> {
            if (getConnection.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)getConnection.cause()));
            } else {
                SQLConnection conn = (SQLConnection)getConnection.result();
                conn.updateWithParams(sql, params, HandlerUtil.closeAndHandleResult(conn, handler));
            }
        }));
        return this;
    }

    @Override
    @Fluent
    default public SQLClient call(String sql, Handler<AsyncResult<ResultSet>> handler) {
        this.getConnection((Handler<AsyncResult<SQLConnection>>)((Handler)getConnection -> {
            if (getConnection.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)getConnection.cause()));
            } else {
                SQLConnection conn = (SQLConnection)getConnection.result();
                conn.call(sql, HandlerUtil.closeAndHandleResult(conn, handler));
            }
        }));
        return this;
    }

    @Override
    @Fluent
    default public SQLClient callWithParams(String sql, JsonArray params, JsonArray outputs, Handler<AsyncResult<ResultSet>> handler) {
        this.getConnection((Handler<AsyncResult<SQLConnection>>)((Handler)getConnection -> {
            if (getConnection.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)getConnection.cause()));
            } else {
                SQLConnection conn = (SQLConnection)getConnection.result();
                conn.callWithParams(sql, params, outputs, HandlerUtil.closeAndHandleResult(conn, handler));
            }
        }));
        return this;
    }
}

