/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.spring.code.kotlin;

import io.spring.initializr.generator.buildsystem.gradle.GradleBuild;
import io.spring.initializr.generator.spring.build.BuildCustomizer;
import io.spring.initializr.generator.spring.code.kotlin.KotlinProjectSettings;
import java.util.List;
import org.springframework.util.CollectionUtils;

class KotlinGradleBuildCustomizer
implements BuildCustomizer<GradleBuild> {
    private final KotlinProjectSettings settings;
    private final char quote;

    KotlinGradleBuildCustomizer(KotlinProjectSettings kotlinProjectSettings, char quote) {
        this.settings = kotlinProjectSettings;
        this.quote = quote;
    }

    @Override
    public void customize(GradleBuild build) {
        build.plugins().add("org.jetbrains.kotlin.jvm", plugin -> plugin.setVersion(this.settings.getVersion()));
        build.plugins().add("org.jetbrains.kotlin.plugin.spring", plugin -> plugin.setVersion(this.settings.getVersion()));
        this.customizeCompilerOptions(build);
    }

    private void customizeCompilerOptions(GradleBuild build) {
        build.extensions().customize("kotlin", kotlin -> kotlin.nested("compilerOptions", compilerOptions -> {
            if (!CollectionUtils.isEmpty(this.settings.getCompilerArgs())) {
                compilerOptions.invoke("freeCompilerArgs.addAll", this.quote(this.settings.getCompilerArgs()));
            }
        }));
    }

    private List<String> quote(List<String> compilerArgs) {
        return compilerArgs.stream().map(element -> this.quote + element + this.quote).toList();
    }
}

