/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingjdbc.jdbc.core.statement;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.Collections2;
import io.shardingsphere.core.constant.SQLType;
import io.shardingsphere.core.executor.sql.execute.result.StreamQueryResult;
import io.shardingsphere.core.merger.MergeEngine;
import io.shardingsphere.core.merger.MergeEngineFactory;
import io.shardingsphere.core.metadata.table.ShardingTableMetaData;
import io.shardingsphere.core.metadata.table.executor.TableMetaDataConnectionManager;
import io.shardingsphere.core.metadata.table.executor.TableMetaDataLoader;
import io.shardingsphere.core.parsing.parser.sql.SQLStatement;
import io.shardingsphere.core.parsing.parser.sql.dal.DALStatement;
import io.shardingsphere.core.parsing.parser.sql.dml.insert.InsertStatement;
import io.shardingsphere.core.parsing.parser.sql.dql.DQLStatement;
import io.shardingsphere.core.parsing.parser.sql.dql.select.SelectStatement;
import io.shardingsphere.core.routing.PreparedStatementRoutingEngine;
import io.shardingsphere.core.routing.SQLRouteResult;
import io.shardingsphere.core.routing.router.sharding.GeneratedKey;
import io.shardingsphere.core.rule.ShardingRule;
import io.shardingsphere.shardingjdbc.executor.BatchPreparedStatementExecutor;
import io.shardingsphere.shardingjdbc.executor.PreparedStatementExecutor;
import io.shardingsphere.shardingjdbc.jdbc.adapter.AbstractShardingPreparedStatementAdapter;
import io.shardingsphere.shardingjdbc.jdbc.core.ShardingContext;
import io.shardingsphere.shardingjdbc.jdbc.core.connection.ShardingConnection;
import io.shardingsphere.shardingjdbc.jdbc.core.resultset.GeneratedKeysResultSet;
import io.shardingsphere.shardingjdbc.jdbc.core.resultset.ShardingResultSet;
import io.shardingsphere.shardingjdbc.jdbc.metadata.JDBCTableMetaDataConnectionManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class ShardingPreparedStatement
extends AbstractShardingPreparedStatementAdapter {
    private final ShardingConnection connection;
    private final PreparedStatementRoutingEngine routingEngine;
    private final PreparedStatementExecutor preparedStatementExecutor;
    private final BatchPreparedStatementExecutor batchPreparedStatementExecutor;
    private SQLRouteResult routeResult;
    private ResultSet currentResultSet;

    public ShardingPreparedStatement(ShardingConnection connection, String sql) {
        this(connection, sql, 1003, 1007, 1, false);
    }

    public ShardingPreparedStatement(ShardingConnection connection, String sql, int resultSetType, int resultSetConcurrency) {
        this(connection, sql, resultSetType, resultSetConcurrency, 1, false);
    }

    public ShardingPreparedStatement(ShardingConnection connection, String sql, int autoGeneratedKeys) {
        this(connection, sql, 1003, 1007, 1, 1 == autoGeneratedKeys);
    }

    public ShardingPreparedStatement(ShardingConnection connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        this(connection, sql, resultSetType, resultSetConcurrency, resultSetHoldability, false);
    }

    private ShardingPreparedStatement(ShardingConnection connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, boolean returnGeneratedKeys) {
        this.connection = connection;
        ShardingContext shardingContext = connection.getShardingContext();
        this.routingEngine = new PreparedStatementRoutingEngine(sql, shardingContext.getShardingRule(), shardingContext.getMetaData().getTable(), shardingContext.getDatabaseType(), shardingContext.isShowSQL(), shardingContext.getMetaData().getDataSource());
        this.preparedStatementExecutor = new PreparedStatementExecutor(resultSetType, resultSetConcurrency, resultSetHoldability, returnGeneratedKeys, connection);
        this.batchPreparedStatementExecutor = new BatchPreparedStatementExecutor(resultSetType, resultSetConcurrency, resultSetHoldability, returnGeneratedKeys, connection);
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        ShardingResultSet result;
        try {
            this.clearPrevious();
            this.sqlRoute();
            this.initPreparedStatementExecutor();
            MergeEngine mergeEngine = MergeEngineFactory.newInstance((ShardingRule)this.connection.getShardingContext().getShardingRule(), this.preparedStatementExecutor.executeQuery(), (SQLStatement)this.routeResult.getSqlStatement(), (ShardingTableMetaData)this.connection.getShardingContext().getMetaData().getTable());
            result = new ShardingResultSet(this.preparedStatementExecutor.getResultSets(), mergeEngine.merge(), this);
        }
        finally {
            this.clearBatch();
        }
        this.currentResultSet = result;
        return result;
    }

    @Override
    public int executeUpdate() throws SQLException {
        try {
            this.clearPrevious();
            this.sqlRoute();
            this.initPreparedStatementExecutor();
            int n = this.preparedStatementExecutor.executeUpdate();
            return n;
        }
        finally {
            this.refreshTableMetaData();
            this.clearBatch();
        }
    }

    @Override
    public boolean execute() throws SQLException {
        try {
            this.clearPrevious();
            this.sqlRoute();
            this.initPreparedStatementExecutor();
            boolean bl = this.preparedStatementExecutor.execute();
            return bl;
        }
        finally {
            this.refreshTableMetaData();
            this.clearBatch();
        }
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        Optional<GeneratedKey> generatedKey = this.getGeneratedKey();
        if (this.preparedStatementExecutor.isReturnGeneratedKeys() && generatedKey.isPresent()) {
            return new GeneratedKeysResultSet(this.routeResult.getGeneratedKey().getGeneratedKeys().iterator(), ((GeneratedKey)generatedKey.get()).getColumn().getName(), this);
        }
        if (1 == this.preparedStatementExecutor.getStatements().size()) {
            return this.preparedStatementExecutor.getStatements().iterator().next().getGeneratedKeys();
        }
        return new GeneratedKeysResultSet();
    }

    private Optional<GeneratedKey> getGeneratedKey() {
        if (null != this.routeResult && this.routeResult.getSqlStatement() instanceof InsertStatement) {
            return Optional.fromNullable((Object)this.routeResult.getGeneratedKey());
        }
        return Optional.absent();
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (null != this.currentResultSet) {
            return this.currentResultSet;
        }
        if (1 == this.preparedStatementExecutor.getStatements().size() && this.routeResult.getSqlStatement() instanceof DQLStatement) {
            this.currentResultSet = this.preparedStatementExecutor.getStatements().iterator().next().getResultSet();
            return this.currentResultSet;
        }
        ArrayList<ResultSet> resultSets = new ArrayList<ResultSet>(this.preparedStatementExecutor.getStatements().size());
        ArrayList<StreamQueryResult> queryResults = new ArrayList<StreamQueryResult>(this.preparedStatementExecutor.getStatements().size());
        for (Statement each : this.preparedStatementExecutor.getStatements()) {
            ResultSet resultSet = each.getResultSet();
            resultSets.add(resultSet);
            queryResults.add(new StreamQueryResult(resultSet));
        }
        if (this.routeResult.getSqlStatement() instanceof SelectStatement || this.routeResult.getSqlStatement() instanceof DALStatement) {
            MergeEngine mergeEngine = MergeEngineFactory.newInstance((ShardingRule)this.connection.getShardingContext().getShardingRule(), queryResults, (SQLStatement)this.routeResult.getSqlStatement(), (ShardingTableMetaData)this.connection.getShardingContext().getMetaData().getTable());
            this.currentResultSet = new ShardingResultSet(resultSets, mergeEngine.merge(), this);
        }
        return this.currentResultSet;
    }

    private void refreshTableMetaData() throws SQLException {
        if (null != this.routeResult && null != this.connection && SQLType.DDL == this.routeResult.getSqlStatement().getType() && !this.routeResult.getSqlStatement().getTables().isEmpty()) {
            String logicTableName = this.routeResult.getSqlStatement().getTables().getSingleTableName();
            TableMetaDataLoader tableMetaDataLoader = new TableMetaDataLoader(this.connection.getShardingContext().getMetaData().getDataSource(), this.connection.getShardingContext().getExecuteEngine(), (TableMetaDataConnectionManager)new JDBCTableMetaDataConnectionManager(this.connection.getDataSourceMap()), this.connection.getShardingContext().getMaxConnectionsSizePerQuery());
            this.connection.getShardingContext().getMetaData().getTable().put(logicTableName, tableMetaDataLoader.load(logicTableName, this.connection.getShardingContext().getShardingRule()));
        }
    }

    private void initPreparedStatementExecutor() throws SQLException {
        this.preparedStatementExecutor.init(this.routeResult);
        this.setParametersForStatements();
    }

    private void setParametersForStatements() {
        for (int i = 0; i < this.preparedStatementExecutor.getStatements().size(); ++i) {
            this.replaySetParameter((PreparedStatement)this.preparedStatementExecutor.getStatements().get(i), this.preparedStatementExecutor.getParameterSets().get(i));
        }
    }

    private void clearPrevious() throws SQLException {
        this.preparedStatementExecutor.clear();
    }

    @Override
    public void addBatch() {
        try {
            this.sqlRoute();
            this.batchPreparedStatementExecutor.addBatchForRouteUnits(this.routeResult);
        }
        finally {
            this.currentResultSet = null;
            this.clearParameters();
        }
    }

    private void sqlRoute() {
        this.routeResult = this.routingEngine.route(new ArrayList<Object>(this.getParameters()));
    }

    @Override
    public int[] executeBatch() throws SQLException {
        try {
            this.initBatchPreparedStatementExecutor();
            int[] nArray = this.batchPreparedStatementExecutor.executeBatch();
            return nArray;
        }
        finally {
            this.clearBatch();
        }
    }

    private void initBatchPreparedStatementExecutor() throws SQLException {
        this.batchPreparedStatementExecutor.init();
        this.setBatchParametersForStatements();
    }

    private void setBatchParametersForStatements() throws SQLException {
        for (Statement each : this.batchPreparedStatementExecutor.getStatements()) {
            List<List<Object>> parameterSet = this.batchPreparedStatementExecutor.getParameterSet(each);
            for (List<Object> parameters : parameterSet) {
                this.replaySetParameter((PreparedStatement)each, parameters);
                ((PreparedStatement)each).addBatch();
            }
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        this.currentResultSet = null;
        this.batchPreparedStatementExecutor.clear();
        this.clearParameters();
    }

    @Override
    public int getResultSetType() {
        return this.preparedStatementExecutor.getResultSetType();
    }

    @Override
    public int getResultSetConcurrency() {
        return this.preparedStatementExecutor.getResultSetConcurrency();
    }

    @Override
    public int getResultSetHoldability() {
        return this.preparedStatementExecutor.getResultSetHoldability();
    }

    public Collection<PreparedStatement> getRoutedStatements() {
        return Collections2.transform(this.preparedStatementExecutor.getStatements(), (Function)new Function<Statement, PreparedStatement>(){

            public PreparedStatement apply(Statement input) {
                return (PreparedStatement)input;
            }
        });
    }

    @Override
    public ShardingConnection getConnection() {
        return this.connection;
    }
}

