/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.undo;

import io.seata.common.exception.NotSupportYetException;
import io.seata.common.loader.EnhancedServiceLoader;
import io.seata.rm.datasource.undo.KeywordChecker;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class KeywordCheckerFactory {
    private static volatile Map<String, KeywordChecker> keywordCheckerMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static KeywordChecker getKeywordChecker(String dbType) {
        if (keywordCheckerMap == null) {
            Class<KeywordCheckerFactory> clazz = KeywordCheckerFactory.class;
            // MONITORENTER : io.seata.rm.datasource.undo.KeywordCheckerFactory.class
            if (keywordCheckerMap == null) {
                HashMap<String, KeywordChecker> initializedMap = new HashMap<String, KeywordChecker>();
                List<KeywordChecker> checkerList = EnhancedServiceLoader.loadAll(KeywordChecker.class);
                for (KeywordChecker checker : checkerList) {
                    initializedMap.put(checker.getDbType(), checker);
                }
                keywordCheckerMap = initializedMap;
            }
            // MONITOREXIT : clazz
        }
        if (!keywordCheckerMap.containsKey(dbType)) throw new NotSupportYetException(dbType);
        return keywordCheckerMap.get(dbType);
    }
}

