/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.exception;

import io.seata.config.Configuration;
import io.seata.config.ConfigurationFactory;
import io.seata.core.exception.TransactionException;
import io.seata.core.protocol.AbstractResultMessage;
import io.seata.core.protocol.ResultCode;
import io.seata.core.protocol.transaction.AbstractTransactionRequest;
import io.seata.core.protocol.transaction.AbstractTransactionResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExceptionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractExceptionHandler.class);
    protected static final Configuration CONFIG = ConfigurationFactory.getInstance();

    public void exceptionHandleTemplate(Callback callback, AbstractTransactionRequest request, AbstractTransactionResponse response) {
        try {
            callback.execute(request, response);
            callback.onSuccess(request, response);
        }
        catch (TransactionException tex) {
            LOGGER.error("Catch TransactionException while do RPC, request: {}", (Object)request, (Object)tex);
            callback.onTransactionException(request, response, tex);
        }
        catch (RuntimeException rex) {
            LOGGER.error("Catch RuntimeException while do RPC, request: {}", (Object)request, (Object)rex);
            callback.onException(request, response, rex);
        }
    }

    public static abstract class AbstractCallback<T extends AbstractTransactionRequest, S extends AbstractTransactionResponse>
    implements Callback<T, S> {
        @Override
        public void onSuccess(T request, S response) {
            ((AbstractResultMessage)response).setResultCode(ResultCode.Success);
        }

        @Override
        public void onTransactionException(T request, S response, TransactionException tex) {
            ((AbstractTransactionResponse)response).setTransactionExceptionCode(tex.getCode());
            ((AbstractResultMessage)response).setResultCode(ResultCode.Failed);
            ((AbstractResultMessage)response).setMsg("TransactionException[" + tex.getMessage() + "]");
        }

        @Override
        public void onException(T request, S response, Exception rex) {
            ((AbstractResultMessage)response).setResultCode(ResultCode.Failed);
            ((AbstractResultMessage)response).setMsg("RuntimeException[" + rex.getMessage() + "]");
        }
    }

    public static interface Callback<T extends AbstractTransactionRequest, S extends AbstractTransactionResponse> {
        public void execute(T var1, S var2) throws TransactionException;

        public void onSuccess(T var1, S var2);

        public void onTransactionException(T var1, S var2, TransactionException var3);

        public void onException(T var1, S var2, Exception var3);
    }
}

