/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.context;

import io.seata.common.exception.ShouldNeverHappenException;
import io.seata.common.util.StringUtils;
import io.seata.core.context.ContextCore;
import io.seata.core.context.ContextCoreLoader;
import io.seata.core.model.BranchType;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RootContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(RootContext.class);
    public static final String KEY_XID = "TX_XID";
    public static final String KEY_XID_INTERCEPTOR_TYPE = "tx-xid-interceptor-type";
    public static final String KEY_GLOBAL_LOCK_FLAG = "TX_LOCK";
    private static ContextCore CONTEXT_HOLDER = ContextCoreLoader.load();

    public static String getXID() {
        String xid = CONTEXT_HOLDER.get(KEY_XID);
        if (StringUtils.isNotBlank(xid)) {
            return xid;
        }
        String xidType = CONTEXT_HOLDER.get(KEY_XID_INTERCEPTOR_TYPE);
        if (StringUtils.isNotBlank(xidType) && xidType.indexOf("_") > -1) {
            return xidType.split("_")[0];
        }
        return null;
    }

    public static String getXIDInterceptorType() {
        return CONTEXT_HOLDER.get(KEY_XID_INTERCEPTOR_TYPE);
    }

    public static void bind(String xid) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("bind " + xid);
        }
        CONTEXT_HOLDER.put(KEY_XID, xid);
    }

    public static void bindInterceptorType(String xidType) {
        String[] xidTypes;
        if (StringUtils.isNotBlank(xidType) && (xidTypes = xidType.split("_")).length == 2) {
            RootContext.bindInterceptorType(xidTypes[0], BranchType.valueOf(xidTypes[1]));
        }
    }

    public static void bindInterceptorType(String xid, BranchType branchType) {
        String xidType = String.format("%s_%s", xid, branchType.name());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("bind interceptor type xid={} branchType={}", (Object)xid, (Object)branchType);
        }
        CONTEXT_HOLDER.put(KEY_XID_INTERCEPTOR_TYPE, xidType);
    }

    public static void bindGlobalLockFlag() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Local Transaction Global Lock support enabled");
        }
        CONTEXT_HOLDER.put(KEY_GLOBAL_LOCK_FLAG, KEY_GLOBAL_LOCK_FLAG);
    }

    public static String unbind() {
        String xid = CONTEXT_HOLDER.remove(KEY_XID);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("unbind {} ", (Object)xid);
        }
        return xid;
    }

    public static String unbindInterceptorType() {
        String xidType = CONTEXT_HOLDER.remove(KEY_XID_INTERCEPTOR_TYPE);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("unbind inteceptor type {}", (Object)xidType);
        }
        return xidType;
    }

    public static void unbindGlobalLockFlag() {
        String lockFlag = CONTEXT_HOLDER.remove(KEY_GLOBAL_LOCK_FLAG);
        if (LOGGER.isDebugEnabled() && lockFlag != null) {
            LOGGER.debug("unbind global lock flag");
        }
    }

    public static boolean inGlobalTransaction() {
        return CONTEXT_HOLDER.get(KEY_XID) != null;
    }

    public static boolean requireGlobalLock() {
        return CONTEXT_HOLDER.get(KEY_GLOBAL_LOCK_FLAG) != null;
    }

    public static void assertNotInGlobalTransaction() {
        if (RootContext.inGlobalTransaction()) {
            throw new ShouldNeverHappenException();
        }
    }

    public static Map<String, String> entries() {
        return CONTEXT_HOLDER.entries();
    }
}

